/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.db.migrations;

import in.gov.uidai.ec.db.migrations.IMigrationQuery;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddEmailIdColumnInPacketSummary
implements IMigrationQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddEmailIdColumnInPacketSummary.class);
    private String add_email_id = "ALTER TABLE APP.PACKET_SUMMARY ADD COLUMN EMAIL_ID VARCHAR(50)";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Execute(Connection connection) {
        Statement statement = null;
        try {
            DatabaseMetaData dataBaseMetaData = connection.getMetaData();
            ResultSet emailIdSet = dataBaseMetaData.getColumns(null, "APP", "PACKET_SUMMARY", "EMAIL_ID");
            if (emailIdSet != null && emailIdSet.next()) {
                LOGGER.info("skipping add_email_id_column and because the column already exists");
                return;
            }
            statement = connection.createStatement();
            connection.setAutoCommit(false);
            statement.addBatch(this.add_email_id);
            statement.executeBatch();
            connection.commit();
            connection.setAutoCommit(true);
            LOGGER.info("add_email_id_column migration ran successfully");
        }
        catch (Exception e) {
            LOGGER.error("add_email_id_column migration failed. " + e.toString());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception e) {
                    LOGGER.error("Error while closing the resource", (Throwable)e);
                }
            }
        }
    }
}

