/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.db.migrations;

import in.gov.uidai.ec.db.migrations.IMigrationQuery;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddIsAutoSyncUploadSkippedToPacketSummary
implements IMigrationQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddIsAutoSyncUploadSkippedToPacketSummary.class);

    @Override
    public void Execute(Connection connection) {
        try {
            this.addIsAutoSyncUploadSkippedColumnToPacketSummary(connection);
            this.addPacketSkipReasonCodeColumnToPacketSummary(connection);
            this.addPacketSkipReasonDescColumnToPacketSummary(connection);
        }
        catch (Exception e) {
            LOGGER.error("add_IsAutoSyncUploadSkipped_to_PacketSummary migration failed");
            LOGGER.error(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIsAutoSyncUploadSkippedColumnToPacketSummary(Connection connection) throws SQLException {
        ResultSet rs = null;
        try {
            rs = connection.getMetaData().getColumns(null, "APP", "PACKET_SUMMARY", "IS_AUTO_SYNC_UPLOAD_SKIPPED");
            if (rs != null && rs.next()) {
                LOGGER.info("skipping addIsAutoSyncUploadSkippedToPacketSummary migration because column IS_AUTO_SYNC_UPLOAD_SKIPPED already exists");
                return;
            }
            String addIsAutoSyncUploadSkippedToPacketSummary = "ALTER TABLE APP.PACKET_SUMMARY ADD IS_AUTO_SYNC_UPLOAD_SKIPPED SMALLINT DEFAULT 0";
            connection.createStatement().execute(addIsAutoSyncUploadSkippedToPacketSummary);
        }
        catch (Exception e) {
            LOGGER.error("Error while update Packet Summary" + e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    LOGGER.error("Error while closing the resource", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPacketSkipReasonCodeColumnToPacketSummary(Connection connection) throws SQLException {
        ResultSet rs = null;
        try {
            rs = connection.getMetaData().getColumns(null, "APP", "PACKET_SUMMARY", "SKIP_REASON_CODE");
            if (rs != null && rs.next()) {
                LOGGER.info("skipping addPacketSkipReasonCodeColumnToPacketSummary migration because column SKIP_REASON_CODE already exists");
                return;
            }
            String addSkipReasonCodeToPacketSummary = "ALTER TABLE APP.PACKET_SUMMARY ADD SKIP_REASON_CODE VARCHAR(50) DEFAULT NULL";
            connection.createStatement().execute(addSkipReasonCodeToPacketSummary);
        }
        catch (Exception e) {
            LOGGER.error("Error while update Packet Summary" + e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    LOGGER.error("Error while closing the resource", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPacketSkipReasonDescColumnToPacketSummary(Connection connection) throws SQLException {
        ResultSet rs = null;
        try {
            rs = connection.getMetaData().getColumns(null, "APP", "PACKET_SUMMARY", "SKIP_REASON_DESCRIPTION");
            if (rs != null && rs.next()) {
                LOGGER.info("skipping addPacketSkipReasonDescColumnToPacketSummary migration because column SKIP_REASON_DESCRIPTION already exists");
                return;
            }
            String addSkipReasonDescToPacketSummary = "ALTER TABLE APP.PACKET_SUMMARY ADD SKIP_REASON_DESCRIPTION VARCHAR(100) DEFAULT NULL";
            connection.createStatement().execute(addSkipReasonDescToPacketSummary);
        }
        catch (Exception e) {
            LOGGER.error("Error while update Packet Summary" + e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    LOGGER.error("Error while closing the resource", (Throwable)e);
                }
            }
        }
    }
}

