/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.db.migrations;

import in.gov.uidai.ec.db.migrations.IMigrationQuery;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddIsNriAndIsdCodeColumnsAndUpdateMobileColumnInPacketSummary
implements IMigrationQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddIsNriAndIsdCodeColumnsAndUpdateMobileColumnInPacketSummary.class);
    private String add_is_nri_status = "ALTER TABLE APP.PACKET_SUMMARY ADD COLUMN IS_NRI VARCHAR(6)";
    private String add_isd_code = "ALTER TABLE APP.PACKET_SUMMARY ADD COLUMN ISD_CODE VARCHAR(4)";
    private String update_mobile_data_type = "ALTER TABLE APP.PACKET_SUMMARY ALTER MOBILE SET DATA TYPE VARCHAR(15)";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Execute(Connection connection) {
        Statement statement = null;
        try {
            DatabaseMetaData dataBaseMetaData = connection.getMetaData();
            ResultSet isNriStatusSet = dataBaseMetaData.getColumns(null, "APP", "PACKET_SUMMARY", "IS_NRI");
            ResultSet isdCodeSet = dataBaseMetaData.getColumns(null, "APP", "PACKET_SUMMARY", "ISD_CODE");
            ResultSet mobileDatatypeUpdate = dataBaseMetaData.getColumns(null, "APP", "PACKET_SUMMARY", "MOBILE");
            if (isNriStatusSet != null && isNriStatusSet.next() || isdCodeSet != null && isdCodeSet.next() || mobileDatatypeUpdate != null && mobileDatatypeUpdate.next() && mobileDatatypeUpdate.getString("TYPE_NAME").equals("VARCHAR") && mobileDatatypeUpdate.getInt("COLUMN_SIZE") == 15) {
                LOGGER.info("skipping add_is_nri_and_isd_code_columns and because the columns already exists");
                LOGGER.info("skipping update_mobile_column_size and because the columns is already updated");
                return;
            }
            statement = connection.createStatement();
            connection.setAutoCommit(false);
            statement.addBatch(this.add_is_nri_status);
            statement.addBatch(this.add_isd_code);
            statement.addBatch(this.update_mobile_data_type);
            statement.executeBatch();
            connection.commit();
            connection.setAutoCommit(true);
            LOGGER.info("add_is_nri_and_isd_code_columns & update_mobile_column_size migration ran successfully");
        }
        catch (Exception e) {
            LOGGER.error("add_is_nri_and_isd_code_columns & update_mobile_column_size migration failed. " + e.toString());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception e) {
                    LOGGER.error("Error while closing the resource", (Throwable)e);
                }
            }
        }
    }
}

