/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.db.migrations;

import in.gov.uidai.ec.db.migrations.IMigrationQuery;
import java.sql.Connection;
import java.sql.ResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddMandatoryBiometricColumnToPacketSummary
implements IMigrationQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddMandatoryBiometricColumnToPacketSummary.class);
    private String create_is_biometric_mandatory_if_not_exists = "ALTER TABLE APP.PACKET_SUMMARY ADD IS_ONLY_MANDATORY_BIOMETRIC_UPDATE VARCHAR(3) DEFAULT 'No'";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Execute(Connection connection) {
        ResultSet rs = null;
        try {
            rs = connection.getMetaData().getColumns(null, "APP", "PACKET_SUMMARY", "IS_ONLY_MANDATORY_BIOMETRIC_UPDATE");
            if (rs != null && rs.next()) {
                LOGGER.info("skipping create_is_biometric_mandatory_if_not_exists migration because column IS_ONLY_MANDATORY_BIOMETRIC_UPDATE already exists");
                return;
            }
            connection.createStatement().execute(this.create_is_biometric_mandatory_if_not_exists);
            LOGGER.info("create_is_biometric_mandatory_if_not_exists migration ran successfully");
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    LOGGER.error("Error while closing the resource", (Throwable)e);
                }
            }
        }
    }
}

