/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.db.migrations;

import in.gov.uidai.ec.db.migrations.IMigrationQuery;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddProcessingAndPreProcessingStatusColumnsToPacketSummary
implements IMigrationQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddProcessingAndPreProcessingStatusColumnsToPacketSummary.class);
    private String add_processing_state = "ALTER TABLE APP.PACKET_SUMMARY ADD COLUMN PROCESSING_STATE VARCHAR(200) DEFAULT NULL";
    private String add_processing_state_desc = "ALTER TABLE APP.PACKET_SUMMARY ADD COLUMN PROCESSING_STATE_DESC VARCHAR(1000) DEFAULT NULL";
    private String add_hold_or_reject_reason_code = "ALTER TABLE APP.PACKET_SUMMARY ADD COLUMN HOLD_OR_REJECT_REASON_CODE VARCHAR(200) DEFAULT NULL";
    private String add_hold_or_reject_reason_desc = "ALTER TABLE APP.PACKET_SUMMARY ADD COLUMN HOLD_OR_REJECT_REASON_DESC VARCHAR(1000) DEFAULT NULL";
    private String add_last_processed_time = "ALTER TABLE APP.PACKET_SUMMARY ADD COLUMN LAST_PROCESSED_TIME BIGINT DEFAULT NULL";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Execute(Connection connection) {
        Statement statement = null;
        ResultSet processingStateResultSet = null;
        ResultSet processingStateDescResultSet = null;
        ResultSet holdOrRejectReasonCodeResultSet = null;
        ResultSet holdOrRejectReasonDescResultSet = null;
        ResultSet lastStatusUpdateTime = null;
        try {
            DatabaseMetaData dataBaseMetaData = connection.getMetaData();
            processingStateResultSet = dataBaseMetaData.getColumns(null, "APP", "PACKET_SUMMARY", "PROCESSING_STATE");
            processingStateDescResultSet = dataBaseMetaData.getColumns(null, "APP", "PACKET_SUMMARY", "PROCESSING_STATE_DESC");
            holdOrRejectReasonCodeResultSet = dataBaseMetaData.getColumns(null, "APP", "PACKET_SUMMARY", "HOLD_OR_REJECT_REASON_CODE");
            holdOrRejectReasonDescResultSet = dataBaseMetaData.getColumns(null, "APP", "PACKET_SUMMARY", "HOLD_OR_REJECT_REASON_DESC");
            lastStatusUpdateTime = dataBaseMetaData.getColumns(null, "APP", "PACKET_SUMMARY", "LAST_PROCESSED_TIME");
            if (processingStateResultSet != null && processingStateResultSet.next() || processingStateDescResultSet != null && processingStateDescResultSet.next() || holdOrRejectReasonCodeResultSet != null && holdOrRejectReasonCodeResultSet.next() || holdOrRejectReasonDescResultSet != null && holdOrRejectReasonDescResultSet.next() || lastStatusUpdateTime != null && lastStatusUpdateTime.next()) {
                LOGGER.info("skipping add_processing_and_pre_processing_status_columns because the columns already exists");
                return;
            }
            statement = connection.createStatement();
            connection.setAutoCommit(false);
            statement.addBatch(this.add_processing_state);
            statement.addBatch(this.add_processing_state_desc);
            statement.addBatch(this.add_hold_or_reject_reason_code);
            statement.addBatch(this.add_hold_or_reject_reason_desc);
            statement.addBatch(this.add_last_processed_time);
            statement.executeBatch();
            connection.commit();
            connection.setAutoCommit(true);
            LOGGER.info("add_processing_and_pre_processing_status_columns migration ran successfully");
        }
        catch (Exception e) {
            LOGGER.error("add_processing_and_pre_processing_status_columns migration failed" + e.toString());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception e) {
                    LOGGER.error("Error while closing the resource", (Throwable)e);
                }
            }
            if (processingStateResultSet != null) {
                try {
                    processingStateResultSet.close();
                }
                catch (Exception e) {
                    LOGGER.error("Error while closing the resource", (Throwable)e);
                }
            }
            if (processingStateDescResultSet != null) {
                try {
                    processingStateDescResultSet.close();
                }
                catch (Exception e) {
                    LOGGER.error("Error while closing the resource", (Throwable)e);
                }
            }
            if (holdOrRejectReasonCodeResultSet != null) {
                try {
                    holdOrRejectReasonCodeResultSet.close();
                }
                catch (Exception e) {
                    LOGGER.error("Error while closing the resource", (Throwable)e);
                }
            }
            if (holdOrRejectReasonDescResultSet != null) {
                try {
                    holdOrRejectReasonDescResultSet.close();
                }
                catch (Exception e) {
                    LOGGER.error("Error while closing the resource", (Throwable)e);
                }
            }
            if (lastStatusUpdateTime != null) {
                try {
                    lastStatusUpdateTime.close();
                }
                catch (Exception e) {
                    LOGGER.error("Error while closing the resource", (Throwable)e);
                }
            }
        }
    }
}

