/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.db.migrations;

import in.gov.uidai.ec.db.migrations.IMigrationQuery;
import java.sql.Connection;
import java.sql.ResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddSubRejectReasonColumnToPacketSummary
implements IMigrationQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddSubRejectReasonColumnToPacketSummary.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Execute(Connection connection) {
        ResultSet resultSetCode = null;
        ResultSet resultSetDesc = null;
        try {
            resultSetCode = connection.getMetaData().getColumns(null, "APP", "PACKET_SUMMARY", "SUB_REJECT_REASON_CODE");
            resultSetDesc = connection.getMetaData().getColumns(null, "APP", "PACKET_SUMMARY", "SUB_REJECT_REASON_DESC");
            if (resultSetCode != null && resultSetCode.next() || resultSetDesc != null && resultSetDesc.next()) {
                LOGGER.info("skipping subRejectReasonIfNotExists migration because column SUB_REJECT_REASON already exists");
                return;
            }
            String subRejectReasonCodeIfNotExists = "ALTER TABLE APP.PACKET_SUMMARY ADD SUB_REJECT_REASON_CODE VARCHAR(100) DEFAULT NULL";
            String subRejectReasonDescIfNotExists = "ALTER TABLE APP.PACKET_SUMMARY ADD SUB_REJECT_REASON_DESC VARCHAR(1000) DEFAULT NULL";
            connection.createStatement().execute(subRejectReasonCodeIfNotExists);
            connection.createStatement().execute(subRejectReasonDescIfNotExists);
            LOGGER.info("subRejectReasonIfNotExists migration ran successfully");
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
        }
        finally {
            if (resultSetCode != null) {
                try {
                    resultSetCode.close();
                }
                catch (Exception e) {
                    LOGGER.error("Error while closing the resource", (Throwable)e);
                }
            }
            if (resultSetDesc != null) {
                try {
                    resultSetDesc.close();
                }
                catch (Exception e) {
                    LOGGER.error("Error while closing the resource", (Throwable)e);
                }
            }
        }
    }
}

