/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.db.migrations;

import in.gov.uidai.ec.db.migrations.IMigrationQuery;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddUniqueConstraintToServerSyncDetailsActivityName
implements IMigrationQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddUniqueConstraintToServerSyncDetailsActivityName.class);
    private String keyName = "UQ_SERVER_SYNC_DETAILS_ACTIVITY_NAME";
    private String addUniqueConstraintToServerSyncDetailActivity = "ALTER TABLE APP.SERVER_SYNC_DETAILS ADD CONSTRAINT " + this.keyName + " UNIQUE (ACTIVITY_NAME)";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Execute(Connection connection) {
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = connection.createStatement();
            rs = statement.executeQuery("SELECT CONGLOMERATENAME FROM SYS.SYSCONGLOMERATES, SYS.SYSCONSTRAINTS WHERE SYS.SYSCONGLOMERATES.TABLEID = SYS.SYSCONSTRAINTS.TABLEID AND CONSTRAINTNAME = '" + this.keyName + "'");
            if (rs != null && rs.next()) {
                LOGGER.info("skipping add_unique_constraint_to_server_sync_details migration because unique constraint already exist");
                return;
            }
            connection.createStatement().execute(this.addUniqueConstraintToServerSyncDetailActivity);
            LOGGER.info("add_unique_constraint_to_server_sync_details migration ran successfully");
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception e) {
                    LOGGER.error("Error while closing the resource", (Throwable)e);
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    LOGGER.error("Error while closing the resource", (Throwable)e);
                }
            }
        }
    }
}

