/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.db.migrations;

import in.gov.uidai.ec.db.migrations.IMigrationQuery;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlterTablePacketSummaryIncreaseHoldAndRejectReasonDescSize
implements IMigrationQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlterTablePacketSummaryIncreaseHoldAndRejectReasonDescSize.class);
    private String query = "ALTER TABLE APP.PACKET_SUMMARY ALTER HOLD_OR_REJECT_REASON_DESC SET DATA TYPE VARCHAR(3000)";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Execute(Connection connection) {
        ResultSet requesterUIDUpdate = null;
        try {
            DatabaseMetaData dataBaseMetaData = connection.getMetaData();
            requesterUIDUpdate = dataBaseMetaData.getColumns(null, "APP", "PACKET_SUMMARY", "HOLD_OR_REJECT_REASON_DESC");
            if (!requesterUIDUpdate.next() || requesterUIDUpdate.getString("COLUMN_SIZE").equals("3000")) {
                LOGGER.info("Alter HOLD_OR_REJECT_REASON_DESC column from PACKET_SUMMARY table to increase column size: size is already updated");
                return;
            }
            connection.createStatement().execute(this.query);
            connection.commit();
            connection.setAutoCommit(true);
            LOGGER.info("Alter HOLD_OR_REJECT_REASON_DESC column from PACKET_SUMMARY table to increase column size: successfully executed");
        }
        catch (Exception e) {
            LOGGER.error("Alter column HOLD_OR_REJECT_REASON_DESC increase size:  Migration failed", (Throwable)e);
        }
        finally {
            if (requesterUIDUpdate != null) {
                try {
                    requesterUIDUpdate.close();
                }
                catch (Exception e) {
                    LOGGER.error("Error while closing the resource", (Throwable)e);
                }
            }
        }
    }
}

