/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.db.migrations;

import in.gov.uidai.ec.db.migrations.IMigrationQuery;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropObsoleteTables
implements IMigrationQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropObsoleteTables.class);

    @Override
    public void Execute(Connection connection) {
        this.dropTable(connection, "DMS_DATA");
        this.dropTable(connection, "GUARDIAN_DETAILS");
        this.dropTable(connection, "DOCUMENT_DETAILS");
        this.dropTable(connection, "CENROL_SUMMARY");
        this.dropTable(connection, "ENROL_EXPORT");
        this.dropTable(connection, "ENROL_REGISTRAR_EXPORT");
        this.dropTable(connection, "EXT_PRE_ENROL_MASTER");
        this.dropTable(connection, "PERSONAL_BANK_DETAILS");
        this.dropTable(connection, "LITE_PRE_ENROL_MASTER");
        this.dropTable(connection, "UID_BANK_DETAILS");
    }

    private void dropTable(Connection connection, String table) {
        String drop_table = "DROP TABLE APP." + table;
        try {
            connection.createStatement().execute(drop_table);
            LOGGER.info("Successfully Dropped " + table + " table");
        }
        catch (SQLException e) {
            if (!e.getMessage().toLowerCase().contains("does not exist")) {
                LOGGER.error("Migration to drop " + table + " table failed", (Throwable)e);
            }
        }
        catch (Exception e) {
            LOGGER.error("Migration to drop " + table + " table failed", (Throwable)e);
        }
    }
}

