/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.db.migrations;

import in.gov.uidai.ec.db.migrations.IMigrationQuery;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateFindAadhaarAttemptsTable
implements IMigrationQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateFindAadhaarAttemptsTable.class);
    private String drop_requester_uid = "ALTER TABLE APP.FIND_AADHAAR_ATTEMPTS DROP COLUMN REQUESTER_UID";

    @Override
    public void Execute(Connection connection) {
        try {
            DatabaseMetaData dataBaseMetaData = connection.getMetaData();
            ResultSet requesterUIDUpdate = dataBaseMetaData.getColumns(null, "APP", "FIND_AADHAAR_ATTEMPTS", "REQUESTER_UID");
            if (!requesterUIDUpdate.next()) {
                LOGGER.info("Drop REQUESTER_UID column from FIND_AADHAAR_ATTEMPTS table: skipping because the column is already removed");
                return;
            }
            connection.createStatement().execute(this.drop_requester_uid);
            connection.commit();
            connection.setAutoCommit(true);
        }
        catch (Exception e) {
            LOGGER.error("FIND_AADHAAR_ATTEMPTS table creation:  Migration failed", (Throwable)e);
        }
    }
}

