/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.db.migrations;

import in.gov.uidai.ec.db.migrations.IMigrationQuery;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdatePktSkippedReasonColumnLengthInPacketSummary
implements IMigrationQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdatePktSkippedReasonColumnLengthInPacketSummary.class);

    @Override
    public void Execute(Connection connection) {
        try {
            this.updateSkipReasonDescLength(connection);
        }
        catch (Exception e) {
            LOGGER.error("updatePkt_SkippedReason_ColumnLength migration failed");
            LOGGER.error(e.toString());
        }
    }

    private void updateSkipReasonDescLength(Connection connection) throws SQLException {
        ResultSet rs = connection.getMetaData().getColumns(null, "APP", "PACKET_SUMMARY", "SKIP_REASON_DESCRIPTION");
        if (rs != null && rs.next() && rs.getInt("COLUMN_SIZE") == 1000) {
            LOGGER.info("skipping updatePktSkippedReasonColumnLength migration because column length of SKIP_REASON_DESCRIPTION is already updated");
            return;
        }
        try {
            String updateSkipReasonDescLength = "ALTER TABLE APP.PACKET_SUMMARY ALTER SKIP_REASON_DESCRIPTION SET DATA TYPE VARCHAR(1000)";
            connection.createStatement().execute(updateSkipReasonDescLength);
        }
        catch (SQLException e) {
            LOGGER.error("updateSkipReasonDescLength execution failed");
        }
    }
}

