/*
 * Decompiled with CFR 0.152.
 */
package com.cognirel.osk;

import com.cognirel.osk.CTAksharaIndic;
import com.cognirel.osk.CTAksharaSeqBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CTAksharaSeqIndic
extends CTAksharaSeqBase {
    public ArrayList<CTAksharaIndic> m_arrAks = new ArrayList();
    private HashMap<String, CharTypePlusIndic> m_tblCharTypes = new HashMap();

    @Override
    public void init(String[][] tblLang, int iDigitStart) {
        this.m_tblLang = tblLang;
        this.m_iDigitStart = iDigitStart;
        HashMap<String, CharTypePlusIndic> tblTypes = new HashMap<String, CharTypePlusIndic>();
        tblTypes.put("cons", CharTypePlusIndic.ctConst);
        tblTypes.put("vowel", CharTypePlusIndic.ctVowel);
        tblTypes.put("mathra", CharTypePlusIndic.ctMatra);
        tblTypes.put("dot", CharTypePlusIndic.ctBindu);
        tblTypes.put("nukta", CharTypePlusIndic.ctNukta);
        int n = 0;
        while (n < this.m_tblLang.length) {
            this.m_tblCharTypes.put(this.m_tblLang[n][0], (CharTypePlusIndic)((Object)tblTypes.get(this.m_tblLang[n][1])));
            ++n;
        }
        this.addEngToRegOpts(CharTypePlusIndic.ctConst);
        this.addEngToRegOpts(CharTypePlusIndic.ctVowel);
        this.addEngToRegOpts(CharTypePlusIndic.ctMatra);
        this.addEngToRegOpts(CharTypePlusIndic.ctBindu);
        this.addEngToRegOpts(CharTypePlusIndic.ctNukta);
    }

    @Override
    public int del(CTAksharaSeqBase.DelDir dir) {
        switch (dir) {
            case ddLeft: {
                if (this.m_iCurPos <= 0) break;
                CTAksharaIndic aks = this.m_arrAks.get(this.m_iCurPos - 1);
                if (!aks.m_sBindu.isEmpty()) {
                    aks.m_sBindu = "";
                    break;
                }
                if (!aks.m_sMatra.isEmpty()) {
                    aks.m_sMatra = "";
                    break;
                }
                int n = aks.m_arrCons.size();
                if (n == 1 || !aks.m_sNonChar.isEmpty() || !aks.m_sVowel.isEmpty()) {
                    this.m_arrAks.remove(this.m_iCurPos - 1);
                    --this.m_iCurPos;
                    break;
                }
                aks.m_arrCons.remove(n - 1);
                aks.m_arrNuktas.remove(n - 1);
                break;
            }
            case ddRight: {
                if (this.m_iCurPos > this.m_arrAks.size() - 1) break;
                this.m_arrAks.remove(this.m_iCurPos);
            }
        }
        return this.m_iCurPos;
    }

    @Override
    public String getHighlightChar() {
        if (this.m_iCurPos > 0) {
            CTAksharaIndic aks = this.m_arrAks.get(this.m_iCurPos - 1);
            if (aks.m_sMatra != "") {
                return this.lookupQWERTY(aks.m_sMatra);
            }
            if (aks.m_sVowel != "") {
                return this.lookupQWERTY(aks.m_sVowel);
            }
            int nConst = aks.m_arrCons.size();
            if (nConst > 0) {
                return this.lookupQWERTY(aks.m_arrCons.get(nConst - 1));
            }
        }
        return "";
    }

    @Override
    public int take(String sKeyTyped, boolean bShift, boolean bRegional) {
        ArrayList<String> arrOpts = null;
        if (!bRegional && (arrOpts = (ArrayList<String>)this.m_tblEng2RegOpts.get(sKeyTyped.toLowerCase())) != null) {
            boolean bStartWord;
            boolean bl = bStartWord = this.m_iCurPos == 0 || !this.m_arrAks.get((int)(this.m_iCurPos - 1)).m_sNonChar.isEmpty();
            if (!bStartWord) {
                CTAksharaIndic aksPrev = this.m_arrAks.get(this.m_iCurPos - 1);
                if (!aksPrev.m_arrCons.isEmpty() && aksPrev.m_sMatra.equals(aksPrev.m_sDefMatra)) {
                    ArrayList<String> arrOptsNew = new ArrayList<String>();
                    for (String s : arrOpts) {
                        if (this.m_tblCharTypes.get(s).equals((Object)CharTypePlusIndic.ctVowel)) continue;
                        arrOptsNew.add(s);
                    }
                    arrOpts = arrOptsNew;
                }
            }
            sKeyTyped = (String)arrOpts.get(0);
        }
        if (sKeyTyped.matches("[0-9]")) {
            this.handleDigit(sKeyTyped);
        } else if (bRegional || arrOpts != null) {
            this.handleRegionalKey(sKeyTyped, bShift);
        } else if (bShift && sKeyTyped.equals(" ")) {
            if (this.m_iCurPos > 0) {
                CTAksharaIndic aks = this.m_arrAks.get(this.m_iCurPos - 1);
                int nConst = aks.m_arrCons.size();
                if (nConst == 1 && this.m_iCurPos > 1) {
                    CTAksharaIndic aksPrev = this.m_arrAks.get(this.m_iCurPos - 2);
                    aksPrev.mergeConst(aks);
                    this.m_arrAks.remove(this.m_iCurPos - 1);
                    --this.m_iCurPos;
                } else if (nConst > 1) {
                    CTAksharaIndic aksFirst = aks.splitFirst();
                    this.m_arrAks.add(this.m_iCurPos - 1, aksFirst);
                    ++this.m_iCurPos;
                }
            }
        } else if (!sKeyTyped.matches("[a-z]")) {
            this.handleMisc(sKeyTyped);
        }
        this.fixCurPos();
        return this.m_iCurPos;
    }

    @Override
    public int tab() {
        if (this.m_iCurPos > 0) {
            CTAksharaIndic aks = this.m_arrAks.get(this.m_iCurPos - 1);
            CTAksharaIndic aksPrev = null;
            if (this.m_iCurPos > 1) {
                aksPrev = this.m_arrAks.get(this.m_iCurPos - 2);
            }
            String sCurr = null;
            int nConst = aks.m_arrCons.size();
            sCurr = nConst > 0 ? aks.m_arrCons.get(nConst - 1) : aks.m_sVowel;
            if (!sCurr.isEmpty()) {
                boolean bHasBindu;
                boolean bHasMatra = aks.m_sMatra != "";
                boolean bl = bHasBindu = aks.m_sBindu != "";
                if (bHasMatra) {
                    sCurr = aks.m_sMatra;
                }
                if (bHasBindu) {
                    sCurr = aks.m_sBindu;
                }
                CharTypePlusIndic ctSeek = CharTypePlusIndic.ctAll;
                String sOpt = this.nextOpt(sCurr, this.getOptions(sCurr), ctSeek);
                CharTypePlusIndic ctOpt = this.m_tblCharTypes.get(sOpt);
                if (this.isVowelOrConst(ctOpt) || bHasBindu) {
                    this.del(CTAksharaSeqBase.DelDir.ddLeft);
                    this.handleRegionalKey(sOpt, nConst > 1);
                } else if (bHasMatra) {
                    aks.setMatra(sOpt);
                } else if (aksPrev != null && aksPrev.m_sNonChar.isEmpty()) {
                    if (ctOpt.equals((Object)CharTypePlusIndic.ctBindu)) {
                        aksPrev.setBindu(sOpt);
                    } else {
                        aksPrev.setMatra(sOpt);
                        aksPrev.setBindu("");
                    }
                    this.del(CTAksharaSeqBase.DelDir.ddLeft);
                }
            }
        }
        return this.getCurPos();
    }

    @Override
    protected void handleMisc(String sKey) {
        this.insertNewAks();
        this.m_arrAks.get(this.m_iCurPos).setNonChar(sKey);
        ++this.m_iCurPos;
    }

    @Override
    protected int getAksCount() {
        return this.m_arrAks.size();
    }

    @Override
    public ArrayList<String> compose() {
        ArrayList<String> sChars = new ArrayList<String>();
        for (CTAksharaIndic cc : this.m_arrAks) {
            String akshara = cc.compose();
            sChars.add(akshara);
        }
        return sChars;
    }

    private void handleMatra(String sKey) {
        if (this.m_iCurPos > 0) {
            CTAksharaIndic aks = this.m_arrAks.get(this.m_iCurPos - 1);
            aks.setMatra(sKey);
        }
    }

    private void handleBindu(String sKey) {
        if (this.m_iCurPos > 0) {
            CTAksharaIndic aks = this.m_arrAks.get(this.m_iCurPos - 1);
            aks.setBindu(sKey);
        }
    }

    private void handleNukta(String sKey) {
        if (this.m_iCurPos > 0) {
            this.m_arrAks.get(this.m_iCurPos - 1).toggleNukta(sKey);
        }
    }

    private void handleVowel(String sKey) {
        this.insertNewAks();
        this.m_arrAks.get(this.m_iCurPos).setVowel(sKey);
        ++this.m_iCurPos;
    }

    private boolean isVowelOrConst(CharTypePlusIndic ct) {
        return ct.equals((Object)CharTypePlusIndic.ctConst) || ct.equals((Object)CharTypePlusIndic.ctVowel);
    }

    private String nextOpt(String sCurr, ArrayList<String> arrOpts, CharTypePlusIndic ct) {
        int i = 0;
        while (i < arrOpts.size()) {
            if (sCurr.equals(arrOpts.get(i))) {
                int k = 1;
                while (k < arrOpts.size()) {
                    int j = (i + k) % arrOpts.size();
                    String sOpt = arrOpts.get(j);
                    if (ct.equals((Object)CharTypePlusIndic.ctAll) || ct.equals((Object)this.m_tblCharTypes.get(sOpt))) {
                        return sOpt;
                    }
                    ++k;
                }
                break;
            }
            ++i;
        }
        return sCurr;
    }

    private void handleConst(String sKey, boolean bHalf) {
        this.insertNewAks();
        CTAksharaIndic aks = this.m_arrAks.get(this.m_iCurPos);
        aks.setConst(sKey);
        ++this.m_iCurPos;
        if (bHalf && this.m_iCurPos > 1) {
            CTAksharaIndic aks1 = this.m_arrAks.get(this.m_iCurPos - 2);
            aks1.mergeConst(aks);
            this.del(CTAksharaSeqBase.DelDir.ddLeft);
        }
    }

    private void insertNewAks() {
        if (this.m_bInsertMode || this.m_arrAks.size() < this.m_iCurPos + 1) {
            CTAksharaIndic aks = new CTAksharaIndic("", this.m_tblLang[0][0]);
            this.m_arrAks.add(this.m_iCurPos, aks);
        }
    }

    private void handleRegionalKey(String sKey, boolean bShift) {
        CharTypePlusIndic ct = this.m_tblCharTypes.get(sKey);
        if (ct != null) {
            switch (ct) {
                case ctVowel: {
                    this.handleVowel(sKey);
                    break;
                }
                case ctConst: {
                    this.handleConst(sKey, bShift);
                    break;
                }
                case ctNukta: {
                    this.handleNukta(sKey);
                    break;
                }
                case ctBindu: {
                    this.handleBindu(sKey);
                    break;
                }
                case ctMatra: {
                    this.handleMatra(sKey);
                }
            }
        }
    }

    private void addEngToRegOpts(CharTypePlusIndic ctDesired) {
        HashMap tblOpts = new HashMap();
        int n = 0;
        while (n < this.m_tblLang.length) {
            String sQWERTY = this.m_tblLang[n][2];
            String sRegional = this.m_tblLang[n][0];
            ArrayList<String> arrRegionals = (ArrayList<String>)tblOpts.get(sQWERTY);
            if (arrRegionals == null) {
                arrRegionals = new ArrayList<String>();
            }
            CharTypePlusIndic ct = this.m_tblCharTypes.get(sRegional);
            boolean bToAdd = ctDesired.equals((Object)CharTypePlusIndic.ctExceptConstVowels) && !ct.equals((Object)CharTypePlusIndic.ctVowel) && !ct.equals((Object)CharTypePlusIndic.ctConst);
            boolean bl = bToAdd = bToAdd || ct.equals((Object)ctDesired);
            if (bToAdd) {
                arrRegionals.add(sRegional);
            }
            tblOpts.put(sQWERTY, arrRegionals);
            ++n;
        }
        CTAksharaSeqBase.CharFreqComparer cmp = new CTAksharaSeqBase.CharFreqComparer();
        for (Map.Entry entry : tblOpts.entrySet()) {
            String sQWERTY = (String)entry.getKey();
            ArrayList arrOpts = (ArrayList)entry.getValue();
            Collections.sort(arrOpts, cmp);
            ArrayList arrRegionals = (ArrayList)this.m_tblEng2RegOpts.get(sQWERTY);
            if (arrRegionals == null) {
                arrRegionals = new ArrayList();
            }
            arrRegionals.addAll(arrOpts);
            this.m_tblEng2RegOpts.put(sQWERTY, arrRegionals);
        }
    }

    @Override
    protected void clearAksSeq() {
        this.m_iCurPos = 0;
        this.m_arrAks.clear();
    }

    public static enum CharTypePlusIndic {
        ctVowel,
        ctConst,
        ctMatra,
        ctNukta,
        ctBindu,
        ctExceptConstVowels,
        ctAll;

    }
}

