/*
 * Decompiled with CFR 0.152.
 */
package com.cognirel.osk;

import com.cognirel.osk.CTAksharaSeqBase;
import com.cognirel.osk.CTAksharaUrdu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CTAksharaSeqUrdu
extends CTAksharaSeqBase {
    ArrayList<CTAksharaUrdu> m_arrAks = new ArrayList();
    boolean m_bCombine = true;
    private HashMap<String, CharTypePlusUrdu> m_tblCharTypes = new HashMap();

    @Override
    public void init(String[][] tblLang, int iDigitStart) {
        this.m_tblLang = tblLang;
        this.m_iDigitStart = iDigitStart;
        HashMap<String, CharTypePlusUrdu> tblTypes = new HashMap<String, CharTypePlusUrdu>();
        tblTypes.put("cons", CharTypePlusUrdu.ctConst);
        tblTypes.put("marker", CharTypePlusUrdu.ctMarker);
        tblTypes.put("vcarrier", CharTypePlusUrdu.ctVCarrier);
        int n = 0;
        while (n < this.m_tblLang.length) {
            this.m_tblCharTypes.put(this.m_tblLang[n][0], (CharTypePlusUrdu)((Object)tblTypes.get(this.m_tblLang[n][1])));
            ++n;
        }
        this.addEngToRegOpts(CharTypePlusUrdu.ctConst);
        this.addEngToRegOpts(CharTypePlusUrdu.ctVCarrier);
        this.addEngToRegOpts(CharTypePlusUrdu.ctMarker);
    }

    @Override
    public int del(CTAksharaSeqBase.DelDir dir) {
        switch (dir) {
            case ddLeft: {
                if (this.m_iCurPos <= 0) break;
                CTAksharaUrdu aks = this.m_arrAks.get(this.m_iCurPos - 1);
                int n = aks.m_arrCons.size();
                if (!aks.m_sVCarrier.isEmpty()) {
                    aks.m_sVCarrier = "";
                    break;
                }
                if (!aks.m_sMarker.isEmpty()) {
                    aks.m_sMarker = "";
                    break;
                }
                if (n == 1 || !aks.m_sNonChar.isEmpty()) {
                    this.m_arrAks.remove(this.m_iCurPos - 1);
                    --this.m_iCurPos;
                    break;
                }
                aks.m_arrCons.remove(n - 1);
                break;
            }
            case ddRight: {
                if (this.m_iCurPos > this.m_arrAks.size() - 1) break;
                this.m_arrAks.remove(this.m_iCurPos);
            }
        }
        return this.m_iCurPos;
    }

    @Override
    public String getHighlightChar() {
        if (this.m_iCurPos > 0) {
            CTAksharaUrdu aks = this.m_arrAks.get(this.m_iCurPos - 1);
            if (aks.m_sMarker != "") {
                return this.lookupQWERTY(aks.m_sMarker);
            }
            if (aks.m_sVCarrier != "") {
                return this.lookupQWERTY(aks.m_sVCarrier);
            }
            int nConst = aks.m_arrCons.size();
            if (nConst > 0) {
                return this.lookupQWERTY(aks.m_arrCons.get(nConst - 1));
            }
        }
        return "";
    }

    @Override
    public int take(String sKeyTyped, boolean bShift, boolean bRegional) {
        ArrayList arrOpts = null;
        if (!bRegional && (arrOpts = (ArrayList)this.m_tblEng2RegOpts.get(sKeyTyped.toLowerCase())) != null) {
            sKeyTyped = (String)arrOpts.get(0);
        }
        if (sKeyTyped.matches("[0-9]")) {
            this.handleDigit(sKeyTyped);
        } else if (bRegional || arrOpts != null) {
            this.handleRegionalKey(sKeyTyped, bShift);
        } else if (bShift && sKeyTyped.equals(" ")) {
            if (this.m_iCurPos > 1) {
                CTAksharaUrdu aks = this.m_arrAks.get(this.m_iCurPos - 1);
                int nConst = aks.m_arrCons.size();
                if (nConst == 1) {
                    CTAksharaUrdu aksPrev = this.m_arrAks.get(this.m_iCurPos - 2);
                    aksPrev.mergeConst(aks);
                    this.del(CTAksharaSeqBase.DelDir.ddLeft);
                } else if (nConst > 1) {
                    CTAksharaUrdu aksFirst = aks.splitFirst();
                    this.m_arrAks.add(this.m_iCurPos - 1, aksFirst);
                    ++this.m_iCurPos;
                }
            }
        } else if (!sKeyTyped.matches("[a-z]")) {
            this.handleMisc(sKeyTyped);
        }
        this.fixCurPos();
        return this.m_iCurPos;
    }

    @Override
    public int tab() {
        if (this.m_iCurPos > 0) {
            CharTypePlusUrdu ctOrig;
            String sOpt;
            CTAksharaUrdu aks = this.m_arrAks.get(this.m_iCurPos - 1);
            CTAksharaUrdu aksPrev = null;
            if (this.m_iCurPos > 1) {
                aksPrev = this.m_arrAks.get(this.m_iCurPos - 2);
            }
            if (!aks.m_sVCarrier.isEmpty()) {
                String sCurr = aks.m_sVCarrier;
                sOpt = this.nextOpt(sCurr, this.getOptions(sCurr), CharTypePlusUrdu.ctAll);
                ctOrig = CharTypePlusUrdu.ctVCarrier;
            } else if (!aks.m_sMarker.isEmpty()) {
                String sCurr = aks.m_sMarker;
                sOpt = this.nextOpt(sCurr, this.getOptions(sCurr), CharTypePlusUrdu.ctAll);
                ctOrig = CharTypePlusUrdu.ctMarker;
            } else {
                int n = aks.m_arrCons.size();
                String sCurr = aks.m_arrCons.get(n - 1);
                sOpt = this.nextOpt(sCurr, this.getOptions(sCurr), CharTypePlusUrdu.ctAll);
                ctOrig = CharTypePlusUrdu.ctConst;
            }
            CharTypePlusUrdu ctOpt = this.m_tblCharTypes.get(sOpt);
            if (ctOpt == CharTypePlusUrdu.ctMarker) {
                if (ctOrig == CharTypePlusUrdu.ctConst && aksPrev != null) {
                    this.move(-1);
                    this.del(CTAksharaSeqBase.DelDir.ddRight);
                    aks = aksPrev;
                }
                if (ctOrig == CharTypePlusUrdu.ctVCarrier) {
                    aks.setVCarrier("");
                }
                aks.setMarker(sOpt);
            } else if (ctOpt == CharTypePlusUrdu.ctVCarrier) {
                if (ctOrig == CharTypePlusUrdu.ctConst && aksPrev != null) {
                    this.move(-1);
                    this.del(CTAksharaSeqBase.DelDir.ddRight);
                    aks = aksPrev;
                }
                if (ctOrig == CharTypePlusUrdu.ctMarker) {
                    aks.setMarker("");
                }
                aks.setVCarrier(sOpt);
            } else {
                int nConst = aks.m_arrCons.size();
                if (ctOrig == CharTypePlusUrdu.ctMarker) {
                    aks.setMarker("");
                } else if (ctOrig == CharTypePlusUrdu.ctVCarrier) {
                    aks.setVCarrier("");
                } else {
                    this.m_bCombine = false;
                    this.del(CTAksharaSeqBase.DelDir.ddLeft);
                    this.handleRegionalKey(sOpt, nConst > 1);
                }
            }
        }
        return this.getCurPos();
    }

    @Override
    protected void handleMisc(String sKey) {
        this.insertNewAks();
        this.m_arrAks.get(this.m_iCurPos).setNonChar(sKey);
        ++this.m_iCurPos;
    }

    @Override
    protected int getAksCount() {
        return this.m_arrAks.size();
    }

    @Override
    public ArrayList<String> compose() {
        ArrayList<String> sChars = new ArrayList<String>();
        for (CTAksharaUrdu cc : this.m_arrAks) {
            String akshara = cc.compose();
            sChars.add(akshara);
        }
        return sChars;
    }

    private void handleMarker(String sKey) {
        if (this.m_iCurPos > 0) {
            this.m_arrAks.get(this.m_iCurPos - 1).setVCarrier(sKey);
            this.m_bCombine = false;
        }
    }

    private void handleVCarrier(String sKey) {
        if (this.m_iCurPos > 0) {
            this.m_arrAks.get(this.m_iCurPos - 1).setVCarrier(sKey);
            this.m_bCombine = false;
        }
    }

    private String nextOpt(String sCurr, ArrayList<String> arrOpts, CharTypePlusUrdu ct) {
        int i = 0;
        while (i < arrOpts.size()) {
            if (sCurr.equals(arrOpts.get(i))) {
                int k = 1;
                while (k < arrOpts.size()) {
                    int j = (i + k) % arrOpts.size();
                    String sOpt = arrOpts.get(j);
                    if (ct.equals((Object)CharTypePlusUrdu.ctAll) || ct.equals((Object)this.m_tblCharTypes.get(sOpt))) {
                        return sOpt;
                    }
                    ++k;
                }
                break;
            }
            ++i;
        }
        return sCurr;
    }

    private void handleConst(String sKey, boolean bHalf) {
        this.insertNewAks();
        CTAksharaUrdu aks = this.m_arrAks.get(this.m_iCurPos);
        aks.setConst(sKey);
        ++this.m_iCurPos;
        if (this.m_bCombine && this.m_iCurPos > 1) {
            CTAksharaUrdu aks1 = this.m_arrAks.get(this.m_iCurPos - 2);
            aks1.mergeConst(aks);
            this.del(CTAksharaSeqBase.DelDir.ddLeft);
        }
        this.m_bCombine = true;
    }

    private void insertNewAks() {
        if (this.m_bInsertMode || this.m_arrAks.size() < this.m_iCurPos + 1) {
            CTAksharaUrdu aks = new CTAksharaUrdu();
            this.m_arrAks.add(this.m_iCurPos, aks);
        }
    }

    private void handleRegionalKey(String sKey, boolean bShift) {
        CharTypePlusUrdu ct = this.m_tblCharTypes.get(sKey);
        if (ct != null) {
            switch (ct) {
                case ctConst: {
                    this.handleConst(sKey, !bShift);
                    break;
                }
                case ctMarker: {
                    this.handleMarker(sKey);
                    break;
                }
                case ctVCarrier: {
                    this.handleVCarrier(sKey);
                }
            }
        }
    }

    private void addEngToRegOpts(CharTypePlusUrdu ctDesired) {
        HashMap tblOpts = new HashMap();
        int n = 0;
        while (n < this.m_tblLang.length) {
            CharTypePlusUrdu ct;
            boolean bToAdd;
            String sQWERTY = this.m_tblLang[n][2];
            String sRegional = this.m_tblLang[n][0];
            ArrayList<String> arrRegionals = (ArrayList<String>)tblOpts.get(sQWERTY);
            if (arrRegionals == null) {
                arrRegionals = new ArrayList<String>();
            }
            if (bToAdd = (ct = this.m_tblCharTypes.get(sRegional)).equals((Object)ctDesired)) {
                arrRegionals.add(sRegional);
            }
            tblOpts.put(sQWERTY, arrRegionals);
            ++n;
        }
        CTAksharaSeqBase.CharFreqComparer cmp = new CTAksharaSeqBase.CharFreqComparer();
        for (Map.Entry entry : tblOpts.entrySet()) {
            String sQWERTY = (String)entry.getKey();
            ArrayList arrOpts = (ArrayList)entry.getValue();
            Collections.sort(arrOpts, cmp);
            ArrayList arrRegionals = (ArrayList)this.m_tblEng2RegOpts.get(sQWERTY);
            if (arrRegionals == null) {
                arrRegionals = new ArrayList();
            }
            arrRegionals.addAll(arrOpts);
            this.m_tblEng2RegOpts.put(sQWERTY, arrRegionals);
        }
    }

    @Override
    protected void clearAksSeq() {
        this.m_bCombine = true;
        this.m_iCurPos = 0;
        this.m_arrAks.clear();
    }

    public static enum CharTypePlusUrdu {
        ctConst,
        ctMarker,
        ctVCarrier,
        ctAll,
        ctExceptConstCMarker,
        ctExceptVCarriers;

    }
}

