/*
 * Decompiled with CFR 0.152.
 */
package com.cognirel.osk;

import com.cognirel.osk.CTOSKLanguage;
import com.cognirel.osk.CTOSKeyboard;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.Timer;

public class CTOSKEditBox
extends JPanel
implements ActionListener {
    ArrayList<String> m_sComposed = null;
    ArrayList<Boolean> m_bComplete = null;
    int m_iCursor = -1;
    int m_pxCaretPos = 0;
    int m_pxLastCaretPos = 0;
    int m_iFontH;
    int m_iTextY;
    int m_iCaretW = 4;
    boolean m_bCaretShown;
    boolean m_bRenderAll;
    Color m_clrComposing = new Color(0, 0, 255);
    public Font m_pFont;
    private CTOSKeyboard m_ctosKeyboard;
    private boolean m_keyboardFocused = false;

    public void setBigFont(Font pFont) {
        this.m_pFont = pFont;
    }

    public void startCaret() {
        Timer timer = new Timer(300, this);
        timer.start();
    }

    public void render(ArrayList<String> sComposed, int iCursor) {
        this.m_iCursor = iCursor;
        this.m_sComposed = sComposed;
        this.m_bRenderAll = true;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g1) {
        super.paintComponent(g1);
        int w = this.getWidth() - 2;
        int h = this.getHeight() - 2;
        if (this.m_ctosKeyboard.lang == CTOSKLanguage.URDU) {
            this.paintRTL(g1, w, h);
        } else {
            this.paintLTR(g1, w, h);
        }
    }

    private void paintRTL(Graphics g1, int w, int h) {
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setColor(this.getBackground());
        g.clearRect(0, 0, w, h);
        super.paintBorder(g);
        FontMetrics fm = this.getFontMetrics(this.getFont());
        LineMetrics lm = fm.getLineMetrics("X", g);
        this.m_iFontH = (int)(lm.getAscent() + lm.getDescent());
        this.m_iTextY = (h - this.m_iFontH) / 2;
        this.m_iCaretW = fm.charWidth('X') / 4;
        int iTextX = w - this.m_iCaretW * 2;
        if (this.m_sComposed != null) {
            this.m_bCaretShown = false;
            int iCurPosWidth = w;
            int iCurPosX = w;
            int i = 0;
            while (i < this.m_sComposed.size()) {
                String s = this.m_sComposed.get(i);
                Rectangle2D rcTextBig = fm.getStringBounds(s, g);
                int iWidth = (int)rcTextBig.getWidth();
                g.setColor(SystemColor.textText);
                g.drawString(s, (float)(iTextX - iWidth), (float)this.m_iTextY + lm.getAscent());
                if (this.m_iCursor == i) {
                    this.m_pxCaretPos = iTextX;
                } else if (this.m_iCursor - 1 == i) {
                    iCurPosWidth = iWidth;
                    iCurPosX = iTextX;
                }
                iTextX -= iWidth;
                ++i;
            }
            if (this.m_iCursor > 0) {
                g.setXORMode(Color.BLACK);
                g.setColor(this.m_clrComposing);
                g.fillRect(iCurPosX - iCurPosWidth, this.m_iTextY, iCurPosWidth, this.m_iFontH);
            }
            if (i == this.m_iCursor) {
                this.m_pxCaretPos = iTextX;
            }
        }
    }

    private void paintLTR(Graphics g1, int w, int h) {
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setColor(this.getBackground());
        g.clearRect(0, 0, w, h);
        super.paintBorder(g);
        FontMetrics fm = this.getFontMetrics(this.getFont());
        LineMetrics lm = fm.getLineMetrics("X", g);
        this.m_iFontH = (int)(lm.getAscent() + lm.getDescent());
        this.m_iTextY = (h - this.m_iFontH) / 2;
        this.m_iCaretW = fm.charWidth('X') / 4;
        int iTextX = this.m_iCaretW * 2;
        if (this.m_sComposed != null) {
            this.m_bCaretShown = false;
            int iCurPosWidth = 0;
            int iCurPosX = 0;
            int i = 0;
            while (i < this.m_sComposed.size()) {
                String s = this.m_sComposed.get(i);
                Rectangle2D rcTextBig = fm.getStringBounds(s, g);
                g.setColor(SystemColor.textText);
                g.drawString(s, (float)iTextX, (float)this.m_iTextY + lm.getAscent());
                int iWidth = (int)rcTextBig.getWidth();
                if (this.m_iCursor == i) {
                    this.m_pxCaretPos = iTextX;
                } else if (this.m_iCursor - 1 == i) {
                    iCurPosWidth = iWidth;
                    iCurPosX = iTextX;
                }
                iTextX += iWidth;
                ++i;
            }
            if (this.m_iCursor > 0) {
                g.setXORMode(Color.BLACK);
                g.setColor(this.m_clrComposing);
                g.fillRect(iCurPosX, this.m_iTextY, iCurPosWidth, this.m_iFontH);
            }
            if (i == this.m_iCursor) {
                this.m_pxCaretPos = iTextX;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Graphics g = this.getGraphics();
        if (g != null) {
            g.setXORMode(SystemColor.textText);
            if (!this.m_bCaretShown) {
                g.setColor(SystemColor.text);
                this.m_pxLastCaretPos = this.m_pxCaretPos;
                g.fillRect(this.m_pxCaretPos, 4, this.m_iCaretW, this.getHeight() - 8);
            } else {
                g.setColor(SystemColor.text);
                g.fillRect(this.m_pxLastCaretPos, 4, this.m_iCaretW, this.getHeight() - 8);
            }
            boolean bl = this.m_bCaretShown = !this.m_bCaretShown;
            if (this.m_keyboardFocused) {
                return;
            }
            if (this.m_ctosKeyboard.isFocusOwner()) {
                this.m_ctosKeyboard.requestFocus();
                this.m_keyboardFocused = true;
            } else {
                this.m_ctosKeyboard.requestFocus();
            }
        }
    }

    public void setKeyboard(CTOSKeyboard ctosKeyboardPlus) {
        this.m_ctosKeyboard = ctosKeyboardPlus;
        if (this.m_ctosKeyboard.lang == CTOSKLanguage.URDU) {
            this.m_pxCaretPos = this.getWidth() - this.m_iCaretW * 2;
        }
    }
}

