/*
 * Decompiled with CFR 0.152.
 */
package com.cognirel.osk;

import com.cognirel.osk.CTOSKeyboard;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import javax.swing.JButton;

public class CTOSKKey
extends JButton
implements ActionListener {
    public String m_sBig;
    public String m_sSml;
    Color m_clrHilite = new Color(209, 255, 128);
    Color m_clrSml = new Color(200, 127, 0);
    Font m_pFontBig;
    Font m_pFontSml;
    int m_iKey;
    CTOSKeyboard m_pParent;
    boolean m_bFocused = false;
    boolean m_bHilited = false;

    public CTOSKKey(String sSml, String sBig, CTOSKeyboard pParent, int iKey) {
        this.m_sBig = sBig;
        this.m_sSml = sSml;
        this.m_pParent = pParent;
        this.m_iKey = iKey;
        this.setFocusTraversalKeysEnabled(false);
        this.setActionCommand("Click");
        this.addActionListener(this);
    }

    public void setHighlight(boolean bHilite) {
        if (this.m_bHilited != bHilite) {
            this.m_bHilited = bHilite;
            this.repaint();
        }
    }

    public void setFocused(boolean bFocused) {
        if (this.m_bFocused != bFocused) {
            this.m_bFocused = bFocused;
            this.repaint();
        }
    }

    public void setFonts(Font pFontSml, Font pFontBig) {
        this.m_pFontSml = pFontSml;
        this.m_pFontBig = pFontBig;
    }

    public void setColors(Color clrHilite, Color clrSml) {
        if (clrSml != null) {
            this.m_clrSml = clrSml;
        }
        if (clrHilite != null) {
            this.m_clrHilite = clrHilite;
        }
    }

    @Override
    protected void paintComponent(Graphics g1) {
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int w = this.getWidth();
        int h = this.getHeight();
        Color c = this.getBackground();
        if (this.m_bHilited) {
            c = c.darker();
        }
        g.setColor(c);
        g.fillRect(0, 0, w, h);
        if (this.m_bFocused) {
            g.setColor(Color.BLUE);
            g.setStroke(new BasicStroke(2.0f));
            g.drawRoundRect(2, 2, w - 4, h - 4, 4, 4);
        }
        super.paintBorder(g);
        FontMetrics fm = this.getFontMetrics(this.m_pFontBig);
        Rectangle2D rcTextBig = fm.getStringBounds(this.m_sBig, g);
        LineMetrics lm = fm.getLineMetrics(this.m_sBig, g);
        int w1 = (int)rcTextBig.getWidth();
        int h1 = (int)(lm.getAscent() + lm.getDescent());
        int xBig = (w - w1) / 2;
        int yBig = (h - h1) / 4;
        g.setColor(SystemColor.textText);
        g.setFont(this.m_pFontBig);
        g.drawString(this.m_sBig, (float)xBig, lm.getAscent() + (float)yBig);
        fm = this.getFontMetrics(this.m_pFontSml);
        Rectangle2D rcTextSml = fm.getStringBounds(this.m_sSml, g);
        lm = fm.getLineMetrics(this.m_sSml, g);
        int x1 = xBig + w1;
        int y1 = yBig + h1;
        w1 = w - x1;
        h1 = h - y1;
        int w2 = (int)rcTextSml.getWidth();
        int xSml = x1 + (w1 - w2) / 2;
        int ySml = y1;
        g.setFont(this.m_pFontSml);
        g.setColor(this.m_clrSml);
        g.drawString(this.m_sSml, xSml, ySml);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (this.m_pParent != null) {
            this.m_pParent.processKeyEvent(e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.m_pParent.processClick(this.m_iKey, (e.getModifiers() & 1) == 1);
    }
}

