/*
 * Decompiled with CFR 0.152.
 */
package com.cognirel.osk;

import java.util.HashMap;

public enum CTOSKLanguage {
    ASSAMESE,
    BENGALI,
    GUJARATI,
    HINDI,
    KANNADA,
    KONKANI,
    MALAYALAM,
    MANIPURI,
    MARATHI,
    NEPALI,
    ORIYA,
    PUNJABI,
    TAMIL,
    TELUGU,
    URDU,
    ENGLISH;

    private static String[][] m_MapAssamese;
    private static String[][] m_MapBengali;
    private static String[][] m_MapGujarati;
    private static String[][] m_MapHindi;
    private static String[][] m_MapKannada;
    private static String[][] m_MapKonkani;
    private static String[][] m_MapMalayalam;
    private static String[][] m_MapManipuri;
    private static String[][] m_MapMarathi;
    private static String[][] m_MapNepali;
    private static String[][] m_MapOriya;
    private static String[][] m_MapPunjabi;
    private static String[][] m_MapTamil;
    private static String[][] m_MapTelugu;
    private static String[][] m_MapUrdu;
    private static String[][] m_MapEnglish;
    public static HashMap<String, Integer> m_MapCharFreq;

    /*
     * Opcode count of 17878 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        m_MapAssamese = new String[][]{{"\u09cd", "mathra", ","}, {"\u09be", "mathra", "a"}, {"\u09bf", "mathra", "i"}, {"\u09c0", "mathra", "i"}, {"\u09c1", "mathra", "u"}, {"\u09c2", "mathra", "u"}, {"\u09c3", "mathra", "r"}, {"\u09c4", "mathra", "r"}, {"\u09c7", "mathra", "e"}, {"\u09c8", "mathra", "a"}, {"\u09cb", "mathra", "o"}, {"\u09cc", "mathra", "a"}, {"\u09bc", "nukta", "."}, {"\u0981", "dot", "n"}, {"\u0982", "dot", "n"}, {"\u0983", "dot", "h"}, {"\u0985", "vowel", "a"}, {"\u0986", "vowel", "a"}, {"\u0987", "vowel", "i"}, {"\u0988", "vowel", "i"}, {"\u0989", "vowel", "u"}, {"\u098a", "vowel", "u"}, {"\u098b", "vowel", "r"}, {"\u09e0", "vowel", "r"}, {"\u098c", "vowel", "l"}, {"\u09e1", "vowel", "l"}, {"\u098f", "vowel", "e"}, {"\u0990", "vowel", "a"}, {"\u0993", "vowel", "o"}, {"\u0994", "vowel", "a"}, {"\u0995", "cons", "k"}, {"\u0996", "cons", "k"}, {"\u0997", "cons", "g"}, {"\u0998", "cons", "g"}, {"\u0999", "cons", "n"}, {"\u099a", "cons", "c"}, {"\u099b", "cons", "c"}, {"\u099c", "cons", "j"}, {"\u099d", "cons", "j"}, {"\u099e", "cons", "n"}, {"\u099f", "cons", "t"}, {"\u09a0", "cons", "t"}, {"\u09a1", "cons", "d"}, {"\u09a2", "cons", "d"}, {"\u09a3", "cons", "n"}, {"\u09a4", "cons", "t"}, {"\u09a5", "cons", "t"}, {"\u09a6", "cons", "d"}, {"\u09a7", "cons", "d"}, {"\u09a8", "cons", "n"}, {"\u09aa", "cons", "p"}, {"\u09ab", "cons", "p"}, {"\u09ac", "cons", "b"}, {"\u09ad", "cons", "b"}, {"\u09ae", "cons", "m"}, {"\u09af", "cons", "y"}, {"\u09b0", "cons", "r"}, {"\u09b2", "cons", "l"}, {"\u09b6", "cons", "s"}, {"\u09b7", "cons", "s"}, {"\u09b8", "cons", "s"}, {"\u09b9", "cons", "h"}};
        m_MapBengali = new String[][]{{"\u09cd", "mathra", ","}, {"\u09be", "mathra", "a"}, {"\u09bf", "mathra", "i"}, {"\u09c0", "mathra", "i"}, {"\u09c1", "mathra", "u"}, {"\u09c2", "mathra", "u"}, {"\u09c3", "mathra", "r"}, {"\u09c4", "mathra", "r"}, {"\u09c7", "mathra", "e"}, {"\u09c8", "mathra", "a"}, {"\u09cb", "mathra", "o"}, {"\u09cc", "mathra", "a"}, {"\u09bc", "nukta", "."}, {"\u0981", "dot", "n"}, {"\u0982", "dot", "n"}, {"\u0983", "dot", "h"}, {"\u0985", "vowel", "a"}, {"\u0986", "vowel", "a"}, {"\u0987", "vowel", "i"}, {"\u0988", "vowel", "i"}, {"\u0989", "vowel", "u"}, {"\u098a", "vowel", "u"}, {"\u098b", "vowel", "r"}, {"\u09e0", "vowel", "r"}, {"\u098c", "vowel", "l"}, {"\u09e1", "vowel", "l"}, {"\u098f", "vowel", "e"}, {"\u0990", "vowel", "a"}, {"\u0993", "vowel", "o"}, {"\u0994", "vowel", "a"}, {"\u0995", "cons", "k"}, {"\u0996", "cons", "k"}, {"\u0997", "cons", "g"}, {"\u0998", "cons", "g"}, {"\u0999", "cons", "n"}, {"\u099a", "cons", "c"}, {"\u099b", "cons", "c"}, {"\u099c", "cons", "j"}, {"\u099d", "cons", "j"}, {"\u099e", "cons", "n"}, {"\u099f", "cons", "t"}, {"\u09a0", "cons", "t"}, {"\u09a1", "cons", "d"}, {"\u09a2", "cons", "d"}, {"\u09a3", "cons", "n"}, {"\u09a4", "cons", "t"}, {"\u09a5", "cons", "t"}, {"\u09a6", "cons", "d"}, {"\u09a7", "cons", "d"}, {"\u09a8", "cons", "n"}, {"\u09aa", "cons", "p"}, {"\u09ab", "cons", "p"}, {"\u09ac", "cons", "b"}, {"\u09ad", "cons", "b"}, {"\u09ae", "cons", "m"}, {"\u09af", "cons", "y"}, {"\u09b0", "cons", "r"}, {"\u09b2", "cons", "l"}, {"\u09b6", "cons", "s"}, {"\u09b7", "cons", "s"}, {"\u09b8", "cons", "s"}, {"\u09b9", "cons", "h"}};
        m_MapGujarati = new String[][]{{"\u0acd", "mathra", ","}, {"\u0abe", "mathra", "a"}, {"\u0abf", "mathra", "i"}, {"\u0ac0", "mathra", "i"}, {"\u0ac1", "mathra", "u"}, {"\u0ac2", "mathra", "u"}, {"\u0ac3", "mathra", "r"}, {"\u0ac4", "mathra", "r"}, {"\u0ac5", "mathra", "e"}, {"\u0ac7", "mathra", "e"}, {"\u0ac8", "mathra", "a"}, {"\u0ac9", "mathra", "o"}, {"\u0acb", "mathra", "o"}, {"\u0acc", "mathra", "a"}, {"\u0ae2", "vowel", "l"}, {"\u0ae3", "vowel", "l"}, {"\u0abc", "nukta", "."}, {"\u0a81", "dot", "n"}, {"\u0a82", "dot", "n"}, {"\u0a83", "dot", "h"}, {"\u0a85", "vowel", "a"}, {"\u0a86", "vowel", "a"}, {"\u0a87", "vowel", "i"}, {"\u0a88", "vowel", "i"}, {"\u0a89", "vowel", "u"}, {"\u0a8a", "vowel", "u"}, {"\u0a8b", "vowel", "r"}, {"\u0ae0", "vowel", "r"}, {"\u0a8c", "vowel", "l"}, {"\u0ae1", "vowel", "l"}, {"\u0a8d", "vowel", "e"}, {"\u0a8f", "vowel", "e"}, {"\u0a90", "vowel", "a"}, {"\u0a91", "vowel", "o"}, {"\u0a93", "vowel", "o"}, {"\u0a94", "vowel", "a"}, {"\u0a95", "cons", "k"}, {"\u0a96", "cons", "k"}, {"\u0a97", "cons", "g"}, {"\u0a98", "cons", "g"}, {"\u0a99", "cons", "n"}, {"\u0a9a", "cons", "c"}, {"\u0a9b", "cons", "c"}, {"\u0a9c", "cons", "j"}, {"\u0a9d", "cons", "j"}, {"\u0a9e", "cons", "n"}, {"\u0a9f", "cons", "t"}, {"\u0aa0", "cons", "t"}, {"\u0aa1", "cons", "d"}, {"\u0aa2", "cons", "d"}, {"\u0aa3", "cons", "n"}, {"\u0aa4", "cons", "t"}, {"\u0aa5", "cons", "t"}, {"\u0aa6", "cons", "d"}, {"\u0aa7", "cons", "d"}, {"\u0aa8", "cons", "n"}, {"\u0aaa", "cons", "p"}, {"\u0aab", "cons", "p"}, {"\u0aac", "cons", "b"}, {"\u0aad", "cons", "b"}, {"\u0aae", "cons", "m"}, {"\u0aaf", "cons", "y"}, {"\u0ab0", "cons", "r"}, {"\u0ab2", "cons", "l"}, {"\u0ab3", "cons", "l"}, {"\u0ab5", "cons", "v"}, {"\u0ab6", "cons", "s"}, {"\u0ab7", "cons", "s"}, {"\u0ab8", "cons", "s"}, {"\u0ab9", "cons", "h"}};
        m_MapHindi = new String[][]{{"\u094d", "mathra", ","}, {"\u093e", "mathra", "a"}, {"\u093f", "mathra", "i"}, {"\u0940", "mathra", "i"}, {"\u0941", "mathra", "u"}, {"\u0942", "mathra", "u"}, {"\u0943", "mathra", "r"}, {"\u0944", "mathra", "r"}, {"\u0945", "mathra", "e"}, {"\u0947", "mathra", "e"}, {"\u0948", "mathra", "a"}, {"\u0949", "mathra", "c"}, {"\u094b", "mathra", "o"}, {"\u094c", "mathra", "a"}, {"\u094f", "mathra", "a"}, {"\u093c", "nukta", "."}, {"\u0901", "dot", "n"}, {"\u0902", "dot", "n"}, {"\u0903", "dot", "h"}, {"\u0904", "vowel", "a"}, {"\u0905", "vowel", "a"}, {"\u0906", "vowel", "a"}, {"\u0907", "vowel", "i"}, {"\u0908", "vowel", "i"}, {"\u0909", "vowel", "u"}, {"\u090a", "vowel", "u"}, {"\u090b", "vowel", "r"}, {"\u0960", "vowel", "r"}, {"\u090c", "vowel", "l"}, {"\u0961", "vowel", "l"}, {"\u090d", "vowel", "e"}, {"\u090e", "vowel", "e"}, {"\u090f", "vowel", "e"}, {"\u0910", "vowel", "a"}, {"\u0911", "vowel", "o"}, {"\u0913", "vowel", "o"}, {"\u0914", "vowel", "a"}, {"\u0950", "vowel", "o"}, {"\u0915", "cons", "k"}, {"\u0916", "cons", "k"}, {"\u0917", "cons", "g"}, {"\u0918", "cons", "g"}, {"\u0919", "cons", "n"}, {"\u091a", "cons", "c"}, {"\u091b", "cons", "c"}, {"\u091c", "cons", "j"}, {"\u091d", "cons", "j"}, {"\u091e", "cons", "n"}, {"\u091f", "cons", "t"}, {"\u0920", "cons", "t"}, {"\u0921", "cons", "d"}, {"\u0922", "cons", "d"}, {"\u0923", "cons", "n"}, {"\u0924", "cons", "t"}, {"\u0925", "cons", "t"}, {"\u0926", "cons", "d"}, {"\u0927", "cons", "d"}, {"\u0928", "cons", "n"}, {"\u0929", "cons", "n"}, {"\u092a", "cons", "p"}, {"\u092b", "cons", "p"}, {"\u092c", "cons", "b"}, {"\u092d", "cons", "b"}, {"\u092e", "cons", "m"}, {"\u092f", "cons", "y"}, {"\u0930", "cons", "r"}, {"\u0931", "cons", "r"}, {"\u0932", "cons", "l"}, {"\u0933", "cons", "l"}, {"\u0935", "cons", "v"}, {"\u0936", "cons", "s"}, {"\u0937", "cons", "s"}, {"\u0938", "cons", "s"}, {"\u0939", "cons", "h"}};
        m_MapKannada = new String[][]{{"\u0ccd", "mathra", ","}, {"\u0cbe", "mathra", "a"}, {"\u0cbf", "mathra", "i"}, {"\u0cc0", "mathra", "i"}, {"\u0cc1", "mathra", "u"}, {"\u0cc2", "mathra", "u"}, {"\u0cc3", "mathra", "r"}, {"\u0cc4", "mathra", "r"}, {"\u0cc6", "mathra", "e"}, {"\u0cc7", "mathra", "e"}, {"\u0cc8", "mathra", "a"}, {"\u0cca", "mathra", "o"}, {"\u0ccb", "mathra", "o"}, {"\u0ccc", "mathra", "a"}, {"\u0ce2", "mathra", "l"}, {"\u0ce3", "mathra", "l"}, {"\u0cbc", "nukta", "."}, {"\u0c82", "dot", "n"}, {"\u0c83", "dot", "h"}, {"\u0cbd", "dot", "a"}, {"\u0c85", "vowel", "a"}, {"\u0c86", "vowel", "a"}, {"\u0c87", "vowel", "i"}, {"\u0c88", "vowel", "i"}, {"\u0c89", "vowel", "u"}, {"\u0c8a", "vowel", "u"}, {"\u0c8b", "vowel", "r"}, {"\u0ce0", "vowel", "r"}, {"\u0c8c", "vowel", "l"}, {"\u0ce1", "vowel", "l"}, {"\u0c8e", "vowel", "e"}, {"\u0c8f", "vowel", "e"}, {"\u0c90", "vowel", "a"}, {"\u0c92", "vowel", "o"}, {"\u0c93", "vowel", "o"}, {"\u0c94", "vowel", "a"}, {"\u0c95", "cons", "k"}, {"\u0c96", "cons", "k"}, {"\u0c97", "cons", "g"}, {"\u0c98", "cons", "g"}, {"\u0c99", "cons", "n"}, {"\u0c9a", "cons", "c"}, {"\u0c9b", "cons", "c"}, {"\u0c9c", "cons", "j"}, {"\u0c9d", "cons", "j"}, {"\u0c9e", "cons", "n"}, {"\u0c9f", "cons", "t"}, {"\u0ca0", "cons", "t"}, {"\u0ca1", "cons", "d"}, {"\u0ca2", "cons", "d"}, {"\u0ca3", "cons", "n"}, {"\u0ca4", "cons", "t"}, {"\u0ca5", "cons", "t"}, {"\u0ca6", "cons", "d"}, {"\u0ca7", "cons", "d"}, {"\u0ca8", "cons", "n"}, {"\u0caa", "cons", "p"}, {"\u0cab", "cons", "p"}, {"\u0cac", "cons", "b"}, {"\u0cad", "cons", "b"}, {"\u0cae", "cons", "m"}, {"\u0caf", "cons", "y"}, {"\u0cb0", "cons", "r"}, {"\u0cb1", "cons", "r"}, {"\u0cb2", "cons", "l"}, {"\u0cb3", "cons", "l"}, {"\u0cb5", "cons", "v"}, {"\u0cb6", "cons", "s"}, {"\u0cb7", "cons", "s"}, {"\u0cb8", "cons", "s"}, {"\u0cb9", "cons", "h"}};
        m_MapKonkani = new String[][]{{"\u094d", "mathra", ","}, {"\u093e", "mathra", "a"}, {"\u093f", "mathra", "i"}, {"\u0940", "mathra", "i"}, {"\u0941", "mathra", "u"}, {"\u0942", "mathra", "u"}, {"\u0943", "mathra", "r"}, {"\u0944", "mathra", "r"}, {"\u0945", "mathra", "e"}, {"\u0947", "mathra", "e"}, {"\u0948", "mathra", "a"}, {"\u0949", "mathra", "c"}, {"\u094b", "mathra", "o"}, {"\u094c", "mathra", "a"}, {"\u094f", "mathra", "a"}, {"\u093c", "nukta", "."}, {"\u0901", "dot", "n"}, {"\u0902", "dot", "n"}, {"\u0903", "dot", "h"}, {"\u0904", "vowel", "a"}, {"\u0905", "vowel", "a"}, {"\u0906", "vowel", "a"}, {"\u0907", "vowel", "i"}, {"\u0908", "vowel", "i"}, {"\u0909", "vowel", "u"}, {"\u090a", "vowel", "u"}, {"\u090b", "vowel", "r"}, {"\u0960", "vowel", "r"}, {"\u090c", "vowel", "l"}, {"\u0961", "vowel", "l"}, {"\u090d", "vowel", "e"}, {"\u090e", "vowel", "e"}, {"\u090f", "vowel", "e"}, {"\u0910", "vowel", "a"}, {"\u0911", "vowel", "o"}, {"\u0913", "vowel", "o"}, {"\u0914", "vowel", "a"}, {"\u0950", "vowel", "o"}, {"\u0915", "cons", "k"}, {"\u0916", "cons", "k"}, {"\u0917", "cons", "g"}, {"\u0918", "cons", "g"}, {"\u0919", "cons", "n"}, {"\u091a", "cons", "c"}, {"\u091b", "cons", "c"}, {"\u091c", "cons", "j"}, {"\u091d", "cons", "j"}, {"\u091e", "cons", "n"}, {"\u091f", "cons", "t"}, {"\u0920", "cons", "t"}, {"\u0921", "cons", "d"}, {"\u0922", "cons", "d"}, {"\u0923", "cons", "n"}, {"\u0924", "cons", "t"}, {"\u0925", "cons", "t"}, {"\u0926", "cons", "d"}, {"\u0927", "cons", "d"}, {"\u0928", "cons", "n"}, {"\u0929", "cons", "n"}, {"\u092a", "cons", "p"}, {"\u092b", "cons", "p"}, {"\u092c", "cons", "b"}, {"\u092d", "cons", "b"}, {"\u092e", "cons", "m"}, {"\u092f", "cons", "y"}, {"\u0930", "cons", "r"}, {"\u0931", "cons", "r"}, {"\u0932", "cons", "l"}, {"\u0933", "cons", "l"}, {"\u0935", "cons", "v"}, {"\u0936", "cons", "s"}, {"\u0937", "cons", "s"}, {"\u0938", "cons", "s"}, {"\u0939", "cons", "h"}};
        m_MapMalayalam = new String[][]{{"\u0d4d", "mathra", ","}, {"\u0d3e", "mathra", "a"}, {"\u0d3f", "mathra", "i"}, {"\u0d40", "mathra", "i"}, {"\u0d41", "mathra", "u"}, {"\u0d42", "mathra", "u"}, {"\u0d43", "mathra", "r"}, {"\u0d44", "mathra", "r"}, {"\u0d46", "mathra", "e"}, {"\u0d47", "mathra", "e"}, {"\u0d48", "mathra", "a"}, {"\u0d4a", "mathra", "o"}, {"\u0d4b", "mathra", "o"}, {"\u0d4c", "mathra", "a"}, {"\u0d02", "dot", "n"}, {"\u0d03", "dot", "h"}, {"\u0d05", "vowel", "a"}, {"\u0d06", "vowel", "a"}, {"\u0d07", "vowel", "i"}, {"\u0d08", "vowel", "i"}, {"\u0d09", "vowel", "u"}, {"\u0d0a", "vowel", "u"}, {"\u0d0b", "vowel", "r"}, {"\u0d60", "vowel", "r"}, {"\u0d0c", "vowel", "l"}, {"\u0d61", "vowel", "l"}, {"\u0d0e", "vowel", "e"}, {"\u0d0f", "vowel", "e"}, {"\u0d10", "vowel", "a"}, {"\u0d12", "vowel", "o"}, {"\u0d13", "vowel", "o"}, {"\u0d14", "vowel", "a"}, {"\u0d15", "cons", "k"}, {"\u0d16", "cons", "k"}, {"\u0d17", "cons", "g"}, {"\u0d18", "cons", "g"}, {"\u0d19", "cons", "n"}, {"\u0d1a", "cons", "c"}, {"\u0d1b", "cons", "c"}, {"\u0d1c", "cons", "j"}, {"\u0d1d", "cons", "j"}, {"\u0d1e", "cons", "n"}, {"\u0d1f", "cons", "t"}, {"\u0d20", "cons", "t"}, {"\u0d21", "cons", "d"}, {"\u0d22", "cons", "d"}, {"\u0d23", "cons", "n"}, {"\u0d24", "cons", "t"}, {"\u0d25", "cons", "t"}, {"\u0d26", "cons", "d"}, {"\u0d27", "cons", "d"}, {"\u0d28", "cons", "n"}, {"\u0d29", "cons", "n"}, {"\u0d2a", "cons", "p"}, {"\u0d2b", "cons", "p"}, {"\u0d2c", "cons", "b"}, {"\u0d2d", "cons", "b"}, {"\u0d2e", "cons", "m"}, {"\u0d2f", "cons", "y"}, {"\u0d30", "cons", "r"}, {"\u0d31", "cons", "r"}, {"\u0d32", "cons", "l"}, {"\u0d33", "cons", "l"}, {"\u0d34", "cons", "z"}, {"\u0d35", "cons", "v"}, {"\u0d36", "cons", "s"}, {"\u0d37", "cons", "s"}, {"\u0d38", "cons", "s"}, {"\u0d39", "cons", "h"}, {"\u0d3a", "cons", "t"}, {"\u0d7a", "cons", "n"}, {"\u0d7b", "cons", "n"}, {"\u0d7c", "cons", "r"}, {"\u0d7d", "cons", "l"}, {"\u0d7e", "cons", "l"}, {"\u0d7f", "cons", "k"}};
        m_MapManipuri = new String[][]{{"\u09cd", "mathra", ","}, {"\u09be", "mathra", "a"}, {"\u09bf", "mathra", "i"}, {"\u09c0", "mathra", "i"}, {"\u09c1", "mathra", "u"}, {"\u09c2", "mathra", "u"}, {"\u09c3", "mathra", "r"}, {"\u09c4", "mathra", "r"}, {"\u09c7", "mathra", "e"}, {"\u09c8", "mathra", "a"}, {"\u09cb", "mathra", "o"}, {"\u09cc", "mathra", "a"}, {"\u09bc", "nukta", "."}, {"\u0981", "dot", "n"}, {"\u0982", "dot", "n"}, {"\u0983", "dot", "h"}, {"\u0985", "vowel", "a"}, {"\u0986", "vowel", "a"}, {"\u0987", "vowel", "i"}, {"\u0988", "vowel", "i"}, {"\u0989", "vowel", "u"}, {"\u098a", "vowel", "u"}, {"\u098b", "vowel", "r"}, {"\u09e0", "vowel", "r"}, {"\u098c", "vowel", "l"}, {"\u09e1", "vowel", "l"}, {"\u098f", "vowel", "e"}, {"\u0990", "vowel", "a"}, {"\u0993", "vowel", "o"}, {"\u0994", "vowel", "a"}, {"\u0995", "cons", "k"}, {"\u0996", "cons", "k"}, {"\u0997", "cons", "g"}, {"\u0998", "cons", "g"}, {"\u0999", "cons", "n"}, {"\u099a", "cons", "c"}, {"\u099b", "cons", "c"}, {"\u099c", "cons", "j"}, {"\u099d", "cons", "j"}, {"\u099e", "cons", "n"}, {"\u099f", "cons", "t"}, {"\u09a0", "cons", "t"}, {"\u09a1", "cons", "d"}, {"\u09a2", "cons", "d"}, {"\u09a3", "cons", "n"}, {"\u09a4", "cons", "t"}, {"\u09a5", "cons", "t"}, {"\u09a6", "cons", "d"}, {"\u09a7", "cons", "d"}, {"\u09a8", "cons", "n"}, {"\u09aa", "cons", "p"}, {"\u09ab", "cons", "p"}, {"\u09ac", "cons", "b"}, {"\u09ad", "cons", "b"}, {"\u09ae", "cons", "m"}, {"\u09af", "cons", "y"}, {"\u09b0", "cons", "r"}, {"\u09b2", "cons", "l"}, {"\u09b6", "cons", "s"}, {"\u09b7", "cons", "s"}, {"\u09b8", "cons", "s"}, {"\u09b9", "cons", "h"}};
        m_MapMarathi = new String[][]{{"\u094d", "mathra", ","}, {"\u093e", "mathra", "a"}, {"\u093f", "mathra", "i"}, {"\u0940", "mathra", "i"}, {"\u0941", "mathra", "u"}, {"\u0942", "mathra", "u"}, {"\u0943", "mathra", "r"}, {"\u0944", "mathra", "r"}, {"\u0945", "mathra", "e"}, {"\u0947", "mathra", "e"}, {"\u0948", "mathra", "a"}, {"\u0949", "mathra", "c"}, {"\u094b", "mathra", "o"}, {"\u094c", "mathra", "a"}, {"\u094f", "mathra", "a"}, {"\u093c", "nukta", "."}, {"\u0901", "dot", "n"}, {"\u0902", "dot", "n"}, {"\u0903", "dot", "h"}, {"\u0904", "vowel", "a"}, {"\u0905", "vowel", "a"}, {"\u0906", "vowel", "a"}, {"\u0907", "vowel", "i"}, {"\u0908", "vowel", "i"}, {"\u0909", "vowel", "u"}, {"\u090a", "vowel", "u"}, {"\u090b", "vowel", "r"}, {"\u0960", "vowel", "r"}, {"\u090c", "vowel", "l"}, {"\u0961", "vowel", "l"}, {"\u090d", "vowel", "e"}, {"\u090e", "vowel", "e"}, {"\u090f", "vowel", "e"}, {"\u0910", "vowel", "a"}, {"\u0911", "vowel", "o"}, {"\u0913", "vowel", "o"}, {"\u0914", "vowel", "a"}, {"\u0950", "vowel", "o"}, {"\u0915", "cons", "k"}, {"\u0916", "cons", "k"}, {"\u0917", "cons", "g"}, {"\u0918", "cons", "g"}, {"\u0919", "cons", "n"}, {"\u091a", "cons", "c"}, {"\u091b", "cons", "c"}, {"\u091c", "cons", "j"}, {"\u091d", "cons", "j"}, {"\u091e", "cons", "n"}, {"\u091f", "cons", "t"}, {"\u0920", "cons", "t"}, {"\u0921", "cons", "d"}, {"\u0922", "cons", "d"}, {"\u0923", "cons", "n"}, {"\u0924", "cons", "t"}, {"\u0925", "cons", "t"}, {"\u0926", "cons", "d"}, {"\u0927", "cons", "d"}, {"\u0928", "cons", "n"}, {"\u0929", "cons", "n"}, {"\u092a", "cons", "p"}, {"\u092b", "cons", "p"}, {"\u092c", "cons", "b"}, {"\u092d", "cons", "b"}, {"\u092e", "cons", "m"}, {"\u092f", "cons", "y"}, {"\u0930", "cons", "r"}, {"\u0931", "cons", "r"}, {"\u0932", "cons", "l"}, {"\u0933", "cons", "l"}, {"\u0935", "cons", "v"}, {"\u0936", "cons", "s"}, {"\u0937", "cons", "s"}, {"\u0938", "cons", "s"}, {"\u0939", "cons", "h"}};
        m_MapNepali = new String[][]{{"\u094d", "mathra", ","}, {"\u093e", "mathra", "a"}, {"\u093f", "mathra", "i"}, {"\u0940", "mathra", "i"}, {"\u0941", "mathra", "u"}, {"\u0942", "mathra", "u"}, {"\u0943", "mathra", "r"}, {"\u0944", "mathra", "r"}, {"\u0945", "mathra", "e"}, {"\u0947", "mathra", "e"}, {"\u0948", "mathra", "a"}, {"\u0949", "mathra", "c"}, {"\u094b", "mathra", "o"}, {"\u094c", "mathra", "a"}, {"\u094f", "mathra", "a"}, {"\u093c", "nukta", "."}, {"\u0901", "dot", "n"}, {"\u0902", "dot", "n"}, {"\u0903", "dot", "h"}, {"\u0904", "vowel", "a"}, {"\u0905", "vowel", "a"}, {"\u0906", "vowel", "a"}, {"\u0907", "vowel", "i"}, {"\u0908", "vowel", "i"}, {"\u0909", "vowel", "u"}, {"\u090a", "vowel", "u"}, {"\u090b", "vowel", "r"}, {"\u0960", "vowel", "r"}, {"\u090c", "vowel", "l"}, {"\u0961", "vowel", "l"}, {"\u090d", "vowel", "e"}, {"\u090e", "vowel", "e"}, {"\u090f", "vowel", "e"}, {"\u0910", "vowel", "a"}, {"\u0911", "vowel", "o"}, {"\u0913", "vowel", "o"}, {"\u0914", "vowel", "a"}, {"\u0950", "vowel", "o"}, {"\u0915", "cons", "k"}, {"\u0916", "cons", "k"}, {"\u0917", "cons", "g"}, {"\u0918", "cons", "g"}, {"\u0919", "cons", "n"}, {"\u091a", "cons", "c"}, {"\u091b", "cons", "c"}, {"\u091c", "cons", "j"}, {"\u091d", "cons", "j"}, {"\u091e", "cons", "n"}, {"\u091f", "cons", "t"}, {"\u0920", "cons", "t"}, {"\u0921", "cons", "d"}, {"\u0922", "cons", "d"}, {"\u0923", "cons", "n"}, {"\u0924", "cons", "t"}, {"\u0925", "cons", "t"}, {"\u0926", "cons", "d"}, {"\u0927", "cons", "d"}, {"\u0928", "cons", "n"}, {"\u0929", "cons", "n"}, {"\u092a", "cons", "p"}, {"\u092b", "cons", "p"}, {"\u092c", "cons", "b"}, {"\u092d", "cons", "b"}, {"\u092e", "cons", "m"}, {"\u092f", "cons", "y"}, {"\u0930", "cons", "r"}, {"\u0931", "cons", "r"}, {"\u0932", "cons", "l"}, {"\u0933", "cons", "l"}, {"\u0935", "cons", "v"}, {"\u0936", "cons", "s"}, {"\u0937", "cons", "s"}, {"\u0938", "cons", "s"}, {"\u0939", "cons", "h"}};
        m_MapOriya = new String[][]{{"\u0b4d", "mathra", ","}, {"\u0b3e", "mathra", "a"}, {"\u0b3f", "mathra", "i"}, {"\u0b40", "mathra", "i"}, {"\u0b41", "mathra", "u"}, {"\u0b42", "mathra", "u"}, {"\u0b43", "mathra", "r"}, {"\u0b47", "mathra", "e"}, {"\u0b48", "mathra", "a"}, {"\u0b4b", "mathra", "o"}, {"\u0b4c", "mathra", "a"}, {"\u0b3c", "nukta", "."}, {"\u0b01", "dot", "n"}, {"\u0b02", "dot", "n"}, {"\u0b03", "dot", "h"}, {"\u0b05", "vowel", "a"}, {"\u0b06", "vowel", "a"}, {"\u0b07", "vowel", "i"}, {"\u0b08", "vowel", "i"}, {"\u0b09", "vowel", "u"}, {"\u0b0a", "vowel", "u"}, {"\u0b0b", "vowel", "r"}, {"\u0b60", "vowel", "r"}, {"\u0b0c", "vowel", "l"}, {"\u0b61", "vowel", "l"}, {"\u0b0f", "vowel", "e"}, {"\u0b10", "vowel", "a"}, {"\u0b13", "vowel", "o"}, {"\u0b14", "vowel", "a"}, {"\u0b70", "vowel", "i"}, {"\u0b15", "cons", "k"}, {"\u0b16", "cons", "k"}, {"\u0b17", "cons", "g"}, {"\u0b18", "cons", "g"}, {"\u0b19", "cons", "n"}, {"\u0b1a", "cons", "c"}, {"\u0b1b", "cons", "c"}, {"\u0b1c", "cons", "j"}, {"\u0b1d", "cons", "j"}, {"\u0b1e", "cons", "n"}, {"\u0b1f", "cons", "t"}, {"\u0b20", "cons", "t"}, {"\u0b21", "cons", "d"}, {"\u0b22", "cons", "d"}, {"\u0b23", "cons", "n"}, {"\u0b24", "cons", "t"}, {"\u0b25", "cons", "t"}, {"\u0b26", "cons", "d"}, {"\u0b27", "cons", "d"}, {"\u0b28", "cons", "n"}, {"\u0b2a", "cons", "p"}, {"\u0b2b", "cons", "p"}, {"\u0b2c", "cons", "b"}, {"\u0b2d", "cons", "b"}, {"\u0b2e", "cons", "m"}, {"\u0b2f", "cons", "j"}, {"\u0b30", "cons", "r"}, {"\u0b32", "cons", "l"}, {"\u0b33", "cons", "l"}, {"\u0b35", "cons", "v"}, {"\u0b36", "cons", "s"}, {"\u0b37", "cons", "s"}, {"\u0b38", "cons", "s"}, {"\u0b39", "cons", "h"}, {"\u0b5c", "cons", "y"}, {"\u0b5d", "cons", "y"}, {"\u0b5f", "cons", "y"}, {"\u0b71", "cons", "w"}};
        m_MapPunjabi = new String[][]{{"\u0a4d", "mathra", "a"}, {"\u0a3e", "mathra", "a"}, {"\u0a3f", "mathra", "i"}, {"\u0a40", "mathra", "i"}, {"\u0a41", "mathra", "u"}, {"\u0a42", "mathra", "u"}, {"\u0a47", "mathra", "e"}, {"\u0a48", "mathra", "a"}, {"\u0a4b", "mathra", "o"}, {"\u0a4c", "mathra", "a"}, {"\u0a70", "mathra", "t"}, {"\u0a71", "mathra", "a"}, {"\u0a3c", "nukta", "."}, {"\u0a01", "dot", "n"}, {"\u0a02", "dot", "n"}, {"\u0a03", "dot", "h"}, {"\u0a05", "vowel", "a"}, {"\u0a06", "vowel", "a"}, {"\u0a07", "vowel", "i"}, {"\u0a08", "vowel", "i"}, {"\u0a09", "vowel", "u"}, {"\u0a0a", "vowel", "u"}, {"\u0a0f", "vowel", "e"}, {"\u0a10", "vowel", "a"}, {"\u0a13", "vowel", "o"}, {"\u0a14", "vowel", "a"}, {"\u0a72", "vowel", "i"}, {"\u0a73", "vowel", "u"}, {"\u0a73", "vowel", "e"}, {"\u0a15", "cons", "k"}, {"\u0a16", "cons", "k"}, {"\u0a17", "cons", "g"}, {"\u0a18", "cons", "g"}, {"\u0a19", "cons", "n"}, {"\u0a1a", "cons", "c"}, {"\u0a1b", "cons", "c"}, {"\u0a1c", "cons", "j"}, {"\u0a1d", "cons", "j"}, {"\u0a1e", "cons", "n"}, {"\u0a1f", "cons", "t"}, {"\u0a20", "cons", "t"}, {"\u0a21", "cons", "d"}, {"\u0a22", "cons", "d"}, {"\u0a23", "cons", "n"}, {"\u0a24", "cons", "t"}, {"\u0a25", "cons", "t"}, {"\u0a26", "cons", "d"}, {"\u0a27", "cons", "d"}, {"\u0a28", "cons", "n"}, {"\u0a2a", "cons", "p"}, {"\u0a2b", "cons", "p"}, {"\u0a2c", "cons", "b"}, {"\u0a2d", "cons", "b"}, {"\u0a2e", "cons", "m"}, {"\u0a2f", "cons", "y"}, {"\u0a30", "cons", "r"}, {"\u0a32", "cons", "l"}, {"\u0a33", "cons", "l"}, {"\u0a35", "cons", "v"}, {"\u0a36", "cons", "s"}, {"\u0a38", "cons", "s"}, {"\u0a39", "cons", "h"}, {"\u0a59", "cons", "k"}, {"\u0a5a", "cons", "g"}, {"\u0a5b", "cons", "z"}, {"\u0a5c", "cons", "r"}, {"\u0a5e", "cons", "f"}};
        m_MapTamil = new String[][]{{"\u0bcd", "mathra", ","}, {"\u0bbe", "mathra", "a"}, {"\u0bbf", "mathra", "i"}, {"\u0bc0", "mathra", "i"}, {"\u0bc1", "mathra", "u"}, {"\u0bc2", "mathra", "u"}, {"\u0bc6", "mathra", "e"}, {"\u0bc7", "mathra", "e"}, {"\u0bc8", "mathra", "a"}, {"\u0bca", "mathra", "o"}, {"\u0bcb", "mathra", "o"}, {"\u0bcc", "mathra", "a"}, {"\u0b82", "dot", "n"}, {"\u0b83", "dot", "h"}, {"\u0b85", "vowel", "a"}, {"\u0b86", "vowel", "a"}, {"\u0b87", "vowel", "i"}, {"\u0b88", "vowel", "i"}, {"\u0b89", "vowel", "u"}, {"\u0b8a", "vowel", "u"}, {"\u0b8e", "vowel", "e"}, {"\u0b8f", "vowel", "e"}, {"\u0b90", "vowel", "a"}, {"\u0b92", "vowel", "o"}, {"\u0b93", "vowel", "o"}, {"\u0b94", "vowel", "a"}, {"\u0b95", "cons", "k"}, {"\u0b99", "cons", "n"}, {"\u0b9a", "cons", "c"}, {"\u0b9c", "cons", "j"}, {"\u0b9e", "cons", "n"}, {"\u0b9f", "cons", "t"}, {"\u0ba3", "cons", "n"}, {"\u0ba4", "cons", "t"}, {"\u0ba8", "cons", "n"}, {"\u0ba9", "cons", "n"}, {"\u0baa", "cons", "p"}, {"\u0bae", "cons", "m"}, {"\u0baf", "cons", "y"}, {"\u0bb0", "cons", "r"}, {"\u0bb1", "cons", "r"}, {"\u0bb2", "cons", "l"}, {"\u0bb3", "cons", "l"}, {"\u0bb4", "cons", "z"}, {"\u0bb5", "cons", "v"}, {"\u0bb6", "cons", "s"}, {"\u0bb7", "cons", "s"}, {"\u0bb8", "cons", "s"}, {"\u0bb9", "cons", "h"}, {"\u0b9c", "cons", "j"}, {"\u0bf9", "vowel", "r"}};
        m_MapTelugu = new String[][]{{"\u0c4d", "mathra", ","}, {"\u0c3e", "mathra", "a"}, {"\u0c3f", "mathra", "i"}, {"\u0c40", "mathra", "i"}, {"\u0c41", "mathra", "u"}, {"\u0c42", "mathra", "u"}, {"\u0c43", "mathra", "r"}, {"\u0c44", "mathra", "r"}, {"\u0c46", "mathra", "e"}, {"\u0c47", "mathra", "e"}, {"\u0c48", "mathra", "a"}, {"\u0c4a", "mathra", "o"}, {"\u0c4b", "mathra", "o"}, {"\u0c4c", "mathra", "a"}, {"\u0c01", "dot", "n"}, {"\u0c02", "dot", "n"}, {"\u0c03", "dot", "h"}, {"\u0c05", "vowel", "a"}, {"\u0c06", "vowel", "a"}, {"\u0c07", "vowel", "i"}, {"\u0c08", "vowel", "i"}, {"\u0c09", "vowel", "u"}, {"\u0c0a", "vowel", "u"}, {"\u0c0b", "vowel", "r"}, {"\u0c60", "vowel", "r"}, {"\u0c0c", "vowel", "l"}, {"\u0c0e", "vowel", "e"}, {"\u0c0f", "vowel", "e"}, {"\u0c10", "vowel", "a"}, {"\u0c12", "vowel", "o"}, {"\u0c13", "vowel", "o"}, {"\u0c14", "vowel", "a"}, {"\u0c15", "cons", "k"}, {"\u0c16", "cons", "k"}, {"\u0c17", "cons", "g"}, {"\u0c18", "cons", "g"}, {"\u0c19", "cons", "n"}, {"\u0c1a", "cons", "c"}, {"\u0c1b", "cons", "c"}, {"\u0c1c", "cons", "j"}, {"\u0c1d", "cons", "j"}, {"\u0c1e", "cons", "n"}, {"\u0c1f", "cons", "t"}, {"\u0c20", "cons", "t"}, {"\u0c21", "cons", "d"}, {"\u0c22", "cons", "d"}, {"\u0c23", "cons", "n"}, {"\u0c24", "cons", "t"}, {"\u0c25", "cons", "t"}, {"\u0c26", "cons", "d"}, {"\u0c27", "cons", "d"}, {"\u0c28", "cons", "n"}, {"\u0c2a", "cons", "p"}, {"\u0c2b", "cons", "p"}, {"\u0c2c", "cons", "b"}, {"\u0c2d", "cons", "b"}, {"\u0c2e", "cons", "m"}, {"\u0c2f", "cons", "y"}, {"\u0c30", "cons", "r"}, {"\u0c31", "cons", "r"}, {"\u0c32", "cons", "l"}, {"\u0c33", "cons", "l"}, {"\u0c35", "cons", "v"}, {"\u0c36", "cons", "s"}, {"\u0c37", "cons", "s"}, {"\u0c38", "cons", "s"}, {"\u0c39", "cons", "h"}};
        m_MapUrdu = new String[][]{{"\u0621", "marker", "h"}, {"\u0622", "vcarrier", "m"}, {"\u0624", "marker", "h"}, {"\u0626", "marker", "h"}, {"\u0627", "vcarrier", "a"}, {"\u0628", "cons", "b"}, {"\u062a", "cons", "t"}, {"\u062b", "cons", "s"}, {"\u062c", "cons", "j"}, {"\u062d", "cons", "h"}, {"\u062e", "cons", "k"}, {"\u062f", "cons", "d"}, {"\u0630", "cons", "t"}, {"\u0631", "cons", "r"}, {"\u0632", "cons", "z"}, {"\u0633", "cons", "s"}, {"\u0634", "cons", "s"}, {"\u0635", "cons", "s"}, {"\u0636", "cons", "d"}, {"\u0637", "cons", "t"}, {"\u0638", "cons", "z"}, {"\u0639", "marker", "a"}, {"\u063a", "cons", "g"}, {"\u0641", "cons", "f"}, {"\u0642", "cons", "q"}, {"\u0643", "cons", "k"}, {"\u0644", "cons", "l"}, {"\u0645", "cons", "m"}, {"\u0646", "cons", "n"}, {"\u0648", "vcarrier", "w"}, {"\u064b", "marker", "f"}, {"\u064c", "marker", "d"}, {"\u064d", "marker", "k"}, {"\u064e", "marker", "f"}, {"\u064f", "marker", "d"}, {"\u0650", "marker", "e"}, {"\u0651", "marker", "s"}, {"\u0652", "marker", "s"}, {"\u0653", "marker", "m"}, {"\u0654", "marker", "h"}, {"\u0655", "marker", "h"}, {"\u0656", "marker", "a"}, {"\u0657", "marker", "d"}, {"\u0658", "marker", "g"}, {"\u065d", "cons", "d"}, {"\u0670", "marker", "a"}, {"\u0679", "cons", "t"}, {"\u067e", "cons", "p"}, {"\u0686", "cons", "c"}, {"\u0688", "cons", "d"}, {"\u0691", "cons", "r"}, {"\u0698", "cons", "j"}, {"\u06a9", "cons", "k"}, {"\u06af", "cons", "g"}, {"\u06ba", "cons", "n"}, {"\u06be", "marker", "d"}, {"\u06c1", "marker", "h"}, {"\u06c2", "marker", "h"}, {"\u06cc", "vcarrier", "y"}, {"\u06d2", "marker", "y"}, {"\u06d3", "marker", "y"}};
        m_MapEnglish = new String[][]{{"a", "vowel", "a"}, {"b", "vowel", "b"}, {"c", "vowel", "c"}, {"d", "vowel", "d"}, {"e", "vowel", "e"}, {"f", "vowel", "f"}, {"g", "vowel", "g"}, {"h", "vowel", "h"}, {"i", "vowel", "i"}, {"j", "vowel", "j"}, {"k", "vowel", "k"}, {"l", "vowel", "l"}, {"m", "vowel", "m"}, {"n", "vowel", "n"}, {"o", "vowel", "o"}, {"p", "vowel", "p"}, {"q", "vowel", "q"}, {"r", "vowel", "r"}, {"s", "vowel", "s"}, {"t", "vowel", "t"}, {"u", "vowel", "u"}, {"v", "vowel", "v"}, {"w", "vowel", "w"}, {"x", "vowel", "x"}, {"y", "vowel", "y"}, {"z", "vowel", "z"}};
        m_MapCharFreq = null;
    }

    public static String getLanguageName(CTOSKLanguage l) {
        switch (l) {
            case ASSAMESE: {
                return "assamese";
            }
            case BENGALI: {
                return "bengali";
            }
            case GUJARATI: {
                return "gujarati";
            }
            case HINDI: {
                return "hindi";
            }
            case KANNADA: {
                return "kannada";
            }
            case KONKANI: {
                return "konkani";
            }
            case MALAYALAM: {
                return "malayalam";
            }
            case MANIPURI: {
                return "manipuri";
            }
            case MARATHI: {
                return "marathi";
            }
            case NEPALI: {
                return "nepali";
            }
            case ORIYA: {
                return "oriya";
            }
            case PUNJABI: {
                return "punjabi";
            }
            case TAMIL: {
                return "tamil";
            }
            case TELUGU: {
                return "telugu";
            }
            case URDU: {
                return "urdu";
            }
            case ENGLISH: {
                return "english";
            }
        }
        return null;
    }

    public static String getLanguageFont(CTOSKLanguage l) {
        switch (l) {
            case ASSAMESE: {
                return "lohit_bn_osk.ttf";
            }
            case BENGALI: {
                return "lohit_bn_osk.ttf";
            }
            case GUJARATI: {
                return "lohit_gu_osk.ttf";
            }
            case HINDI: {
                return "gargi.ttf";
            }
            case KANNADA: {
                return "lohit_kn_osk.ttf";
            }
            case KONKANI: {
                return "gargi.ttf";
            }
            case MALAYALAM: {
                return "Rachana_osk.ttf";
            }
            case MANIPURI: {
                return "lohit_bn_osk.ttf";
            }
            case MARATHI: {
                return "gargi.ttf";
            }
            case NEPALI: {
                return "gargi.ttf";
            }
            case ORIYA: {
                return "samyak_or_osk.ttf";
            }
            case PUNJABI: {
                return "lohit_pa_osk.ttf";
            }
            case TAMIL: {
                return "lohit_ta_uid.ttf";
            }
            case TELUGU: {
                return "lohit_te_osk.ttf";
            }
            case URDU: {
                return "NafeesWebOSK.ttf";
            }
            case ENGLISH: {
                return "arial.ttf";
            }
        }
        return null;
    }

    public static int getDigitStart(CTOSKLanguage l) {
        return 48;
    }

    public static String[] getAliases(CTOSKLanguage l) {
        switch (l) {
            case ASSAMESE: {
                String[] ret = new String[]{"as_in", "Assamese", "Asm", "01"};
                return ret;
            }
            case BENGALI: {
                String[] ret = new String[]{"bn_in", "Bengali", "Ben", "02"};
                return ret;
            }
            case GUJARATI: {
                String[] ret = new String[]{"gu_in", "Gujarati", "Guj", "05"};
                return ret;
            }
            case HINDI: {
                String[] ret = new String[]{"hi_in", "Hindi", "Hin", "06"};
                return ret;
            }
            case KANNADA: {
                String[] ret = new String[]{"kn_in", "Kannada", "Kan", "07"};
                return ret;
            }
            case KONKANI: {
                String[] ret = new String[]{"kok_in", "Konkani", "Kok", "09"};
                return ret;
            }
            case MALAYALAM: {
                String[] ret = new String[]{"ml_in", "Malayalam", "Mal", "11"};
                return ret;
            }
            case MANIPURI: {
                String[] ret = new String[]{"mni_in", "Manipuri", "Man", "12"};
                return ret;
            }
            case MARATHI: {
                String[] ret = new String[]{"mr_in", "Marathi", "Mar", "13"};
                return ret;
            }
            case NEPALI: {
                String[] ret = new String[]{"ne_in", "Nepali", "Nep", "14"};
                return ret;
            }
            case ORIYA: {
                String[] ret = new String[]{"or_in", "Oriya", "Ori", "15"};
                return ret;
            }
            case PUNJABI: {
                String[] ret = new String[]{"pa_in", "Punjabi", "Pan", "16"};
                return ret;
            }
            case TAMIL: {
                String[] ret = new String[]{"ta_in", "Tamil", "Tnd", "20"};
                return ret;
            }
            case TELUGU: {
                String[] ret = new String[]{"te_in", "Telugu", "Tel", "21"};
                return ret;
            }
            case URDU: {
                String[] ret = new String[]{"ur_in", "Urdu", "Urd", "22"};
                return ret;
            }
            case ENGLISH: {
                String[] ret = new String[]{"en_in", "en_gb", "English", "Eng", "23"};
                return ret;
            }
        }
        return null;
    }

    public static String[][] getKeyMap(CTOSKLanguage lang) {
        switch (lang) {
            case ASSAMESE: {
                return m_MapAssamese;
            }
            case BENGALI: {
                return m_MapBengali;
            }
            case GUJARATI: {
                return m_MapGujarati;
            }
            case HINDI: {
                return m_MapHindi;
            }
            case KANNADA: {
                return m_MapKannada;
            }
            case KONKANI: {
                return m_MapKonkani;
            }
            case MALAYALAM: {
                return m_MapMalayalam;
            }
            case MANIPURI: {
                return m_MapManipuri;
            }
            case MARATHI: {
                return m_MapMarathi;
            }
            case NEPALI: {
                return m_MapNepali;
            }
            case ORIYA: {
                return m_MapOriya;
            }
            case PUNJABI: {
                return m_MapPunjabi;
            }
            case TAMIL: {
                return m_MapTamil;
            }
            case TELUGU: {
                return m_MapTelugu;
            }
            case URDU: {
                return m_MapUrdu;
            }
            case ENGLISH: {
                return m_MapEnglish;
            }
        }
        return null;
    }

    public static int getCharCount(String sChar) {
        Integer i;
        if (m_MapCharFreq == null) {
            m_MapCharFreq = new HashMap();
            CTOSKLanguage.initCharFreq_Devanagari();
            CTOSKLanguage.initCharFreq_Oriya();
            CTOSKLanguage.initCharFreq_Malayalam();
            CTOSKLanguage.initCharFreq_Kannada();
            CTOSKLanguage.initCharFreq_Gujurati();
            CTOSKLanguage.initCharFreq_Tamil();
            CTOSKLanguage.initCharFreq_Bengali();
            CTOSKLanguage.initCharFreq_Telugu();
            CTOSKLanguage.initCharFreq_Punjabi();
            CTOSKLanguage.initCharFreq_Urdu();
        }
        if ((i = m_MapCharFreq.get(sChar)) != null) {
            return i;
        }
        return 0;
    }

    private static void initCharFreq_Malayalam() {
        m_MapCharFreq.put("\u0d60", 1);
        m_MapCharFreq.put("\u0d1d", 7);
        m_MapCharFreq.put("\u0d0b", 15);
        m_MapCharFreq.put("\u0d14", 43);
        m_MapCharFreq.put("\u0d22", 53);
        m_MapCharFreq.put("\u0d03", 64);
        m_MapCharFreq.put("\u0d10", 118);
        m_MapCharFreq.put("\u0d0a", 135);
        m_MapCharFreq.put("\u0d08", 153);
        m_MapCharFreq.put("\u0d1b", 194);
        m_MapCharFreq.put("\u0d20", 375);
        m_MapCharFreq.put("\u0d0f", 390);
        m_MapCharFreq.put("\u0d18", 428);
        m_MapCharFreq.put("\u0d4c", 495);
        m_MapCharFreq.put("\u0d13", 665);
        m_MapCharFreq.put("\u0d16", 1008);
        m_MapCharFreq.put("\u0d43", 1061);
        m_MapCharFreq.put("\u0d12", 1158);
        m_MapCharFreq.put("\u0d2b", 1303);
        m_MapCharFreq.put("\u0d48", 1610);
        m_MapCharFreq.put("\u0d25", 1718);
        m_MapCharFreq.put("\u0d09", 1851);
        m_MapCharFreq.put("\u0d21", 2151);
        m_MapCharFreq.put("\u0d07", 2523);
        m_MapCharFreq.put("\u0d0e", 2638);
        m_MapCharFreq.put("\u0d06", 2645);
        m_MapCharFreq.put("\u0d2d", 2936);
        m_MapCharFreq.put("\u0d27", 3006);
        m_MapCharFreq.put("\u0d39", 3221);
        m_MapCharFreq.put("\u0d1c", 3304);
        m_MapCharFreq.put("\u0d2c", 3614);
        m_MapCharFreq.put("\u0d34", 3917);
        m_MapCharFreq.put("\u0d17", 4749);
        m_MapCharFreq.put("\u0d1e", 5027);
        m_MapCharFreq.put("\u0d37", 5080);
        m_MapCharFreq.put("\u0d36", 5262);
        m_MapCharFreq.put("\u0d42", 5726);
        m_MapCharFreq.put("\u0d40", 5794);
        m_MapCharFreq.put("\u0d4a", 5854);
        m_MapCharFreq.put("\u0d05", 6042);
        m_MapCharFreq.put("\u0d26", 6286);
        m_MapCharFreq.put("\u200c", 7696);
        m_MapCharFreq.put("\u0d47", 12288);
        m_MapCharFreq.put("\u0d19", 13184);
        m_MapCharFreq.put("\u0d4b", 15032);
        m_MapCharFreq.put("\u0d38", 15706);
        m_MapCharFreq.put("\u0d23", 17626);
        m_MapCharFreq.put("\u0d1a", 18210);
        m_MapCharFreq.put("\u0d31", 18909);
        m_MapCharFreq.put("\u0d02", 19094);
        m_MapCharFreq.put("\u0d33", 19339);
        m_MapCharFreq.put("\u200d", 21056);
        m_MapCharFreq.put("\u0d46", 24274);
        m_MapCharFreq.put("\u0d35", 24308);
        m_MapCharFreq.put("\u0d2e", 25994);
        m_MapCharFreq.put("\u0d2a", 31504);
        m_MapCharFreq.put("\u0d32", 33352);
        m_MapCharFreq.put("\u0d1f", 35170);
        m_MapCharFreq.put("\u0d30", 37110);
        m_MapCharFreq.put("\u0d2f", 37640);
        m_MapCharFreq.put("\u0d24", 48940);
        m_MapCharFreq.put("\u0d3e", 49787);
        m_MapCharFreq.put("\u0d41", 59045);
        m_MapCharFreq.put("\u0d28", 62592);
        m_MapCharFreq.put("\u0d15", 68721);
        m_MapCharFreq.put("\u0d3f", 74276);
        m_MapCharFreq.put("\u0d4d", 172324);
    }

    private static void initCharFreq_Kannada() {
        m_MapCharFreq.put("\u0cbc", 1);
        m_MapCharFreq.put("\u0cea", 1);
        m_MapCharFreq.put("\u0ceb", 1);
        m_MapCharFreq.put(";", 1);
        m_MapCharFreq.put("\u0cee", 1);
        m_MapCharFreq.put("\u0cec", 1);
        m_MapCharFreq.put("\u0ce0", 1);
        m_MapCharFreq.put("\u0ce7", 2);
        m_MapCharFreq.put("\u0cc4", 3);
        m_MapCharFreq.put("\u0ce6", 5);
        m_MapCharFreq.put(".", 16);
        m_MapCharFreq.put("\u0c8b", 28);
        m_MapCharFreq.put("\u200d", 34);
        m_MapCharFreq.put("\u0c94", 36);
        m_MapCharFreq.put("\u0c83", 55);
        m_MapCharFreq.put("\u0c9d", 57);
        m_MapCharFreq.put("\u0c8a", 57);
        m_MapCharFreq.put("\u0ca2", 63);
        m_MapCharFreq.put("\u0c90", 91);
        m_MapCharFreq.put("\u0c9b", 101);
        m_MapCharFreq.put("\u0c9e", 118);
        m_MapCharFreq.put("\u0c88", 131);
        m_MapCharFreq.put("\u0c93", 159);
        m_MapCharFreq.put("\u0c8f", 190);
        m_MapCharFreq.put("\u200c", 240);
        m_MapCharFreq.put("\u0ca0", 252);
        m_MapCharFreq.put("\u0c98", 320);
        m_MapCharFreq.put("\u0c92", 357);
        m_MapCharFreq.put("\u0cc3", 572);
        m_MapCharFreq.put("\u0c8e", 724);
        m_MapCharFreq.put("\u0c89", 761);
        m_MapCharFreq.put("\u0c96", 861);
        m_MapCharFreq.put("\u0c87", 948);
        m_MapCharFreq.put("\u0ccc", 964);
        m_MapCharFreq.put("\u0ca5", 1012);
        m_MapCharFreq.put("\u0c86", 1025);
        m_MapCharFreq.put("\u0cc8", 1067);
        m_MapCharFreq.put("\u0cab", 1192);
        m_MapCharFreq.put("\u0cad", 1555);
        m_MapCharFreq.put("\u0ca7", 1783);
        m_MapCharFreq.put("\u0cb7", 2471);
        m_MapCharFreq.put("\u0cc2", 2978);
        m_MapCharFreq.put("\u0cca", 3089);
        m_MapCharFreq.put("\u0c85", 3294);
        m_MapCharFreq.put("\u0ccb", 3347);
        m_MapCharFreq.put("\u0c9a", 3495);
        m_MapCharFreq.put("\u0ca3", 3640);
        m_MapCharFreq.put("\u0cc0", 4152);
        m_MapCharFreq.put("\u0cb6", 4795);
        m_MapCharFreq.put("\u0c9c", 5061);
        m_MapCharFreq.put("\u0c9f", 5673);
        m_MapCharFreq.put("\u0cc7", 5752);
        m_MapCharFreq.put("\u0ca1", 5767);
        m_MapCharFreq.put("\u0cb3", 6252);
        m_MapCharFreq.put("\u0cb9", 6285);
        m_MapCharFreq.put("\u0cac", 6642);
        m_MapCharFreq.put("\u0caa", 9347);
        m_MapCharFreq.put("\u0c82", 9400);
        m_MapCharFreq.put("\u0cc6", 10903);
        m_MapCharFreq.put("\u0cb5", 11638);
        m_MapCharFreq.put("\u0ca4", 11713);
        m_MapCharFreq.put("\u0c97", 11809);
        m_MapCharFreq.put("\u0caf", 11954);
        m_MapCharFreq.put("\u0cb8", 12367);
        m_MapCharFreq.put("\u0cb2", 12607);
        m_MapCharFreq.put("\u0cae", 13479);
        m_MapCharFreq.put("\u0c95", 14946);
        m_MapCharFreq.put("\u0ca6", 15163);
        m_MapCharFreq.put("\u0ca8", 17744);
        m_MapCharFreq.put("\u0cc1", 18216);
        m_MapCharFreq.put("\u0cbe", 22104);
        m_MapCharFreq.put("\u0cb0", 25925);
        m_MapCharFreq.put("\u0cbf", 27935);
        m_MapCharFreq.put("\u0ccd", 44462);
    }

    private static void initCharFreq_Gujurati() {
        m_MapCharFreq.put("\u0a8d", 17);
        m_MapCharFreq.put("\u0abc", 20);
        m_MapCharFreq.put("\u0a90", 40);
        m_MapCharFreq.put("\u0a8b", 64);
        m_MapCharFreq.put("\u0a94", 70);
        m_MapCharFreq.put("\u0ac5", 78);
        m_MapCharFreq.put("\u200d", 89);
        m_MapCharFreq.put("\u0a91", 117);
        m_MapCharFreq.put("\u0a83", 127);
        m_MapCharFreq.put("\u0a81", 221);
        m_MapCharFreq.put("\u0a9e", 284);
        m_MapCharFreq.put("\u0a8a", 336);
        m_MapCharFreq.put("\u0ac9", 716);
        m_MapCharFreq.put("\u0acc", 720);
        m_MapCharFreq.put("\u0aa2", 731);
        m_MapCharFreq.put("\u0ac3", 1262);
        m_MapCharFreq.put("\u0aa0", 1541);
        m_MapCharFreq.put("\u0a9b", 1625);
        m_MapCharFreq.put("\u0ac8", 1626);
        m_MapCharFreq.put("\u0a87", 1740);
        m_MapCharFreq.put("\u0a98", 1830);
        m_MapCharFreq.put("\u0a9d", 2504);
        m_MapCharFreq.put("\u0a89", 2605);
        m_MapCharFreq.put("\u0ab7", 3824);
        m_MapCharFreq.put("\u0a86", 4209);
        m_MapCharFreq.put("\u0ab3", 4713);
        m_MapCharFreq.put("\u0a93", 4841);
        m_MapCharFreq.put("\u0a96", 4858);
        m_MapCharFreq.put("\u0a88", 4892);
        m_MapCharFreq.put("\u0aab", 5070);
        m_MapCharFreq.put("\u0aad", 5757);
        m_MapCharFreq.put("\u0ac2", 5836);
        m_MapCharFreq.put("\u0a85", 5918);
        m_MapCharFreq.put("\u0aa7", 6099);
        m_MapCharFreq.put("\u0aa3", 6353);
        m_MapCharFreq.put("\u0a8f", 7148);
        m_MapCharFreq.put("\u0a9a", 7565);
        m_MapCharFreq.put("\u0aa5", 7837);
        m_MapCharFreq.put("\u0ab6", 10522);
        m_MapCharFreq.put("\u0ab9", 10926);
        m_MapCharFreq.put("\u0aa1", 12081);
        m_MapCharFreq.put("\u0aac", 12277);
        m_MapCharFreq.put("\u0a9c", 13121);
        m_MapCharFreq.put("\u0a97", 13485);
        m_MapCharFreq.put("\u0a9f", 13941);
        m_MapCharFreq.put("\u0aa6", 14495);
        m_MapCharFreq.put("\u0aaf", 19911);
        m_MapCharFreq.put("\u0aaa", 20264);
        m_MapCharFreq.put("\u0ac1", 21313);
        m_MapCharFreq.put("\u0ab2", 23591);
        m_MapCharFreq.put("\u0aa4", 24400);
        m_MapCharFreq.put("\u0abf", 25544);
        m_MapCharFreq.put("\u0ab5", 28674);
        m_MapCharFreq.put("\u0ab8", 29425);
        m_MapCharFreq.put("\u0acb", 30499);
        m_MapCharFreq.put("\u0a95", 30601);
        m_MapCharFreq.put("\u0aae", 34333);
        m_MapCharFreq.put("\u0ac7", 36218);
        m_MapCharFreq.put("\u0a82", 37590);
        m_MapCharFreq.put("\u0ac0", 47795);
        m_MapCharFreq.put("\u0acd", 53420);
        m_MapCharFreq.put("\u0ab0", 55650);
        m_MapCharFreq.put("\u0aa8", 65861);
        m_MapCharFreq.put("\u0abe", 97822);
    }

    private static void initCharFreq_Tamil() {
        m_MapCharFreq.put("\u0b94", 4);
        m_MapCharFreq.put("\u0b83", 33);
        m_MapCharFreq.put("\u0bcc", 92);
        m_MapCharFreq.put("\u0b90", 158);
        m_MapCharFreq.put("\u0bb9", 191);
        m_MapCharFreq.put("\u0b88", 204);
        m_MapCharFreq.put("\u0b8a", 280);
        m_MapCharFreq.put("\u0b93", 425);
        m_MapCharFreq.put("\u0b8f", 546);
        m_MapCharFreq.put("\u0bb7", 555);
        m_MapCharFreq.put("\u0bb8", 646);
        m_MapCharFreq.put("\u0b9c", 681);
        m_MapCharFreq.put("\u0b92", 815);
        m_MapCharFreq.put("\u0b9e", 1162);
        m_MapCharFreq.put("\u0b86", 1729);
        m_MapCharFreq.put("\u0b89", 2203);
        m_MapCharFreq.put("\u0b8e", 2268);
        m_MapCharFreq.put("\u0bc2", 2770);
        m_MapCharFreq.put("\u0bc0", 2851);
        m_MapCharFreq.put("\u0b87", 3328);
        m_MapCharFreq.put("\u0b99", 4415);
        m_MapCharFreq.put("\u0bb4", 4821);
        m_MapCharFreq.put("\u0bca", 4870);
        m_MapCharFreq.put("\u0b85", 5313);
        m_MapCharFreq.put("\u0bcb", 5380);
        m_MapCharFreq.put("\u0bc6", 6716);
        m_MapCharFreq.put("\u0ba3", 8030);
        m_MapCharFreq.put("\u0bc7", 9768);
        m_MapCharFreq.put("\u0bb3", 11643);
        m_MapCharFreq.put("\u0ba8", 12432);
        m_MapCharFreq.put("\u0bb1", 14265);
        m_MapCharFreq.put("\u0b9a", 14468);
        m_MapCharFreq.put("\u0bc8", 17798);
        m_MapCharFreq.put("\u0baf", 19046);
        m_MapCharFreq.put("\u0bb2", 19791);
        m_MapCharFreq.put("\u0bb5", 21610);
        m_MapCharFreq.put("\u0b9f", 22446);
        m_MapCharFreq.put("\u0ba9", 23128);
        m_MapCharFreq.put("\u0bb0", 27169);
        m_MapCharFreq.put("\u0baa", 27306);
        m_MapCharFreq.put("\u0bbe", 28333);
        m_MapCharFreq.put("\u0bae", 28884);
        m_MapCharFreq.put("\u0bc1", 42304);
        m_MapCharFreq.put("\u0bbf", 43941);
        m_MapCharFreq.put("\u0ba4", 45016);
        m_MapCharFreq.put("\u0b95", 46921);
        m_MapCharFreq.put("\u0bcd", 105149);
    }

    private static void initCharFreq_Bengali() {
        m_MapCharFreq.put("\u098c", 1);
        m_MapCharFreq.put("\u09c4", 1);
        m_MapCharFreq.put("\u09f0", 3);
        m_MapCharFreq.put("\u09f1", 13);
        m_MapCharFreq.put("\u200d", 19);
        m_MapCharFreq.put("\u09dd", 24);
        m_MapCharFreq.put("\u0994", 37);
        m_MapCharFreq.put("\u098b", 60);
        m_MapCharFreq.put("\u0990", 67);
        m_MapCharFreq.put("\u0988", 83);
        m_MapCharFreq.put("\u098a", 85);
        m_MapCharFreq.put("\u09a2", 207);
        m_MapCharFreq.put("\u099d", 542);
        m_MapCharFreq.put("\u09ce", 559);
        m_MapCharFreq.put("\u09c8", 566);
        m_MapCharFreq.put("\u0983", 587);
        m_MapCharFreq.put("\u09cc", 692);
        m_MapCharFreq.put("\u09dc", 988);
        m_MapCharFreq.put("\u0998", 1111);
        m_MapCharFreq.put("\u09a0", 1201);
        m_MapCharFreq.put("\u099e", 1418);
        m_MapCharFreq.put("\u0999", 1536);
        m_MapCharFreq.put("\u200c", 1636);
        m_MapCharFreq.put("\u09c3", 1666);
        m_MapCharFreq.put("\u0981", 1734);
        m_MapCharFreq.put("\u098f", 2434);
        m_MapCharFreq.put("\u0982", 2588);
        m_MapCharFreq.put("\u099b", 2811);
        m_MapCharFreq.put("\u09c2", 2827);
        m_MapCharFreq.put("\u09a5", 2975);
        m_MapCharFreq.put("\u09df", 2994);
        m_MapCharFreq.put("\u0996", 3094);
        m_MapCharFreq.put("\u0993", 3246);
        m_MapCharFreq.put("\u0989", 3383);
        m_MapCharFreq.put("\u09ab", 3697);
        m_MapCharFreq.put("\u0986", 3778);
        m_MapCharFreq.put("\u0985", 3879);
        m_MapCharFreq.put("\u09a3", 4014);
        m_MapCharFreq.put("\u09a7", 4261);
        m_MapCharFreq.put("\u09b7", 4819);
        m_MapCharFreq.put("\u099a", 5649);
        m_MapCharFreq.put("\u09ad", 6020);
        m_MapCharFreq.put("\u09a1", 6414);
        m_MapCharFreq.put("\u0987", 7253);
        m_MapCharFreq.put("\u09b9", 7980);
        m_MapCharFreq.put("\u09b6", 8248);
        m_MapCharFreq.put("\u099c", 8951);
        m_MapCharFreq.put("\u09c0", 9169);
        m_MapCharFreq.put("\u0997", 10037);
        m_MapCharFreq.put("\u09bc", 11087);
        m_MapCharFreq.put("\u09cb", 11482);
        m_MapCharFreq.put("\u099f", 12063);
        m_MapCharFreq.put("\u09a6", 12560);
        m_MapCharFreq.put("\u09c1", 14897);
        m_MapCharFreq.put("\u09aa", 15861);
        m_MapCharFreq.put("\u09af", 19857);
        m_MapCharFreq.put("\u09ae", 20061);
        m_MapCharFreq.put("\u09b2", 21402);
        m_MapCharFreq.put("\u09a4", 21795);
        m_MapCharFreq.put("\u09b8", 23281);
        m_MapCharFreq.put("\u09ac", 23326);
        m_MapCharFreq.put("\u0995", 26479);
        m_MapCharFreq.put("\u09a8", 32629);
        m_MapCharFreq.put("\u09c7", 36130);
        m_MapCharFreq.put("\u09bf", 40226);
        m_MapCharFreq.put("\u09b0", 51872);
        m_MapCharFreq.put("\u09cd", 55190);
        m_MapCharFreq.put("\u09be", 65968);
    }

    private static void initCharFreq_Telugu() {
        m_MapCharFreq.put("\u0c60", 1);
        m_MapCharFreq.put("\u0c44", 3);
        m_MapCharFreq.put("\u0c14", 17);
        m_MapCharFreq.put("\u0c31", 20);
        m_MapCharFreq.put("\u0c0b", 20);
        m_MapCharFreq.put("\u0c1d", 32);
        m_MapCharFreq.put("\u0c22", 42);
        m_MapCharFreq.put("\u0c1b", 76);
        m_MapCharFreq.put("\u0c1e", 77);
        m_MapCharFreq.put("\u0c0a", 86);
        m_MapCharFreq.put("\u0c13", 91);
        m_MapCharFreq.put("\u0c10", 101);
        m_MapCharFreq.put("\u0c03", 130);
        m_MapCharFreq.put("\u0c08", 130);
        m_MapCharFreq.put("\u0c20", 143);
        m_MapCharFreq.put("\u200c", 194);
        m_MapCharFreq.put("\u0c12", 209);
        m_MapCharFreq.put("\u0c18", 271);
        m_MapCharFreq.put("\u0c0f", 310);
        m_MapCharFreq.put("\u0c4c", 432);
        m_MapCharFreq.put("\u0c43", 458);
        m_MapCharFreq.put("\u0c25", 578);
        m_MapCharFreq.put("\u0c16", 665);
        m_MapCharFreq.put("\u0c09", 782);
        m_MapCharFreq.put("\u0c07", 801);
        m_MapCharFreq.put("\u0c0e", 809);
        m_MapCharFreq.put("\u0c2b", 968);
        m_MapCharFreq.put("\u0c06", 1091);
        m_MapCharFreq.put("\u0c33", 1212);
        m_MapCharFreq.put("\u0c23", 1473);
        m_MapCharFreq.put("\u0c27", 1527);
        m_MapCharFreq.put("\u0c2d", 1576);
        m_MapCharFreq.put("\u0c48", 1655);
        m_MapCharFreq.put("\u0c4a", 1945);
        m_MapCharFreq.put("\u0c37", 2455);
        m_MapCharFreq.put("\u0c39", 2820);
        m_MapCharFreq.put("\u0c42", 2897);
        m_MapCharFreq.put("\u0c05", 3160);
        m_MapCharFreq.put("\u0c36", 3355);
        m_MapCharFreq.put("\u0c46", 4153);
        m_MapCharFreq.put("\u0c1c", 4284);
        m_MapCharFreq.put("\u0c2c", 4524);
        m_MapCharFreq.put("\u0c40", 4555);
        m_MapCharFreq.put("\u0c1a", 5954);
        m_MapCharFreq.put("\u0c1f", 6024);
        m_MapCharFreq.put("\u0c4b", 6193);
        m_MapCharFreq.put("\u0c21", 6807);
        m_MapCharFreq.put("\u0c47", 7323);
        m_MapCharFreq.put("\u0c17", 7876);
        m_MapCharFreq.put("\u0c2f", 8211);
        m_MapCharFreq.put("\u0c26", 9655);
        m_MapCharFreq.put("\u0c38", 9755);
        m_MapCharFreq.put("\u0c35", 10203);
        m_MapCharFreq.put("\u0c24", 10367);
        m_MapCharFreq.put("\u0c2a", 10817);
        m_MapCharFreq.put("\u0c2e", 13303);
        m_MapCharFreq.put("\u0c02", 13714);
        m_MapCharFreq.put("\u0c15", 13780);
        m_MapCharFreq.put("\u0c28", 18340);
        m_MapCharFreq.put("\u0c32", 18461);
        m_MapCharFreq.put("\u0c30", 21369);
        m_MapCharFreq.put("\u0c41", 21958);
        m_MapCharFreq.put("\u0c3e", 22310);
        m_MapCharFreq.put("\u0c3f", 25323);
        m_MapCharFreq.put("\u0c4d", 36141);
    }

    private static void initCharFreq_Punjabi() {
        m_MapCharFreq.put("\u200d", 1);
        m_MapCharFreq.put("\u0a03", 2);
        m_MapCharFreq.put("\u200c", 2);
        m_MapCharFreq.put("\u0a19", 7);
        m_MapCharFreq.put("\u0a1e", 9);
        m_MapCharFreq.put("\u0a14", 137);
        m_MapCharFreq.put("\u0a33", 162);
        m_MapCharFreq.put("\u0a22", 403);
        m_MapCharFreq.put("\u0a0a", 499);
        m_MapCharFreq.put("\u0a13", 693);
        m_MapCharFreq.put("\u0a20", 706);
        m_MapCharFreq.put("\u0a1d", 775);
        m_MapCharFreq.put("\u0a18", 865);
        m_MapCharFreq.put("\u0a1b", 873);
        m_MapCharFreq.put("\u0a4c", 1114);
        m_MapCharFreq.put("\u0a25", 1399);
        m_MapCharFreq.put("\u0a10", 1484);
        m_MapCharFreq.put("\u0a0f", 1498);
        m_MapCharFreq.put("\u0a3c", 1691);
        m_MapCharFreq.put("\u0a2d", 2016);
        m_MapCharFreq.put("\u0a08", 2030);
        m_MapCharFreq.put("\u0a27", 2258);
        m_MapCharFreq.put("\u0a2f", 2425);
        m_MapCharFreq.put("\u0a07", 2538);
        m_MapCharFreq.put("\u0a5c", 2582);
        m_MapCharFreq.put("\u0a2b", 2801);
        m_MapCharFreq.put("\u0a09", 2815);
        m_MapCharFreq.put("\u0a16", 3343);
        m_MapCharFreq.put("\u0a42", 3723);
        m_MapCharFreq.put("\u0a1a", 3885);
        m_MapCharFreq.put("\u0a48", 4065);
        m_MapCharFreq.put("\u0a05", 4118);
        m_MapCharFreq.put("\u0a23", 4162);
        m_MapCharFreq.put("\u0a21", 4476);
        m_MapCharFreq.put("\u0a36", 4746);
        m_MapCharFreq.put("\u0a71", 5971);
        m_MapCharFreq.put("\u0a70", 6574);
        m_MapCharFreq.put("\u0a1c", 6850);
        m_MapCharFreq.put("\u0a1f", 6928);
        m_MapCharFreq.put("\u0a4d", 7175);
        m_MapCharFreq.put("\u0a39", 7226);
        m_MapCharFreq.put("\u0a2c", 7465);
        m_MapCharFreq.put("\u0a4b", 7538);
        m_MapCharFreq.put("\u0a17", 7569);
        m_MapCharFreq.put("\u0a06", 7661);
        m_MapCharFreq.put("\u0a41", 7853);
        m_MapCharFreq.put("\u0a26", 9115);
        m_MapCharFreq.put("\u0a2a", 9325);
        m_MapCharFreq.put("\u0a35", 9473);
        m_MapCharFreq.put("\u0a24", 10286);
        m_MapCharFreq.put("\u0a02", 11238);
        m_MapCharFreq.put("\u0a2e", 11592);
        m_MapCharFreq.put("\u0a47", 11684);
        m_MapCharFreq.put("\u0a32", 13473);
        m_MapCharFreq.put("\u0a28", 14271);
        m_MapCharFreq.put("\u0a15", 14388);
        m_MapCharFreq.put("\u0a38", 15648);
        m_MapCharFreq.put("\u0a3f", 17271);
        m_MapCharFreq.put("\u0a40", 17593);
        m_MapCharFreq.put("\u0a30", 26518);
        m_MapCharFreq.put("\u0a3e", 35001);
    }

    private static void initCharFreq_Urdu() {
        m_MapCharFreq.put("\u0657 ", 1);
        m_MapCharFreq.put("\u0658", 1);
        m_MapCharFreq.put("\u0656", 2);
        m_MapCharFreq.put("\u0654", 13);
        m_MapCharFreq.put("\u064c", 15);
        m_MapCharFreq.put("\u064d", 16);
        m_MapCharFreq.put("\u0698", 75);
        m_MapCharFreq.put("\u0653", 81);
        m_MapCharFreq.put("\u064b", 95);
        m_MapCharFreq.put("\u06d3", 110);
        m_MapCharFreq.put("\u06c2", 142);
        m_MapCharFreq.put("\u0670", 202);
        m_MapCharFreq.put("\u0652", 261);
        m_MapCharFreq.put("\u0651", 307);
        m_MapCharFreq.put("\u0624", 324);
        m_MapCharFreq.put("\u0621", 376);
        m_MapCharFreq.put("\u0638", 414);
        m_MapCharFreq.put("\u062b", 452);
        m_MapCharFreq.put("\u0630", 471);
        m_MapCharFreq.put("\u0636", 603);
        m_MapCharFreq.put("\u064f", 688);
        m_MapCharFreq.put("\u063a", 736);
        m_MapCharFreq.put("\u064e", 823);
        m_MapCharFreq.put("\u0691", 901);
        m_MapCharFreq.put("\u0622", 1060);
        m_MapCharFreq.put("\u0650", 1069);
        m_MapCharFreq.put("\u0637", 1205);
        m_MapCharFreq.put("\u0635", 1326);
        m_MapCharFreq.put("\u062e", 1689);
        m_MapCharFreq.put("\u0686", 1831);
        m_MapCharFreq.put("\u0688", 1877);
        m_MapCharFreq.put("\u0639", 1882);
        m_MapCharFreq.put("\u062d", 2122);
        m_MapCharFreq.put("\u0642", 2471);
        m_MapCharFreq.put("\u0626", 2760);
        m_MapCharFreq.put("\u0632", 2877);
        m_MapCharFreq.put("\u0634", 2969);
        m_MapCharFreq.put("\u06af", 3173);
        m_MapCharFreq.put("\u0641", 3203);
        m_MapCharFreq.put("\u062c", 3415);
        m_MapCharFreq.put("\u06be", 3441);
        m_MapCharFreq.put("\u06d2", 3486);
        m_MapCharFreq.put("\u06ba", 3492);
        m_MapCharFreq.put("\u0679", 3494);
        m_MapCharFreq.put("\u067e", 3499);
        m_MapCharFreq.put("\u06c1", 5585);
        m_MapCharFreq.put("\u062f", 6243);
        m_MapCharFreq.put("\u0628", 7142);
        m_MapCharFreq.put("\u0633", 7451);
        m_MapCharFreq.put("\u06a9", 7588);
        m_MapCharFreq.put("\u062a", 8306);
        m_MapCharFreq.put("\u0645", 10052);
        m_MapCharFreq.put("\u0644", 11042);
        m_MapCharFreq.put("\u0646", 13422);
        m_MapCharFreq.put("\u0648", 14985);
        m_MapCharFreq.put("\u0631", 15865);
        m_MapCharFreq.put("\u06cc", 21336);
        m_MapCharFreq.put("\u0627", 30176);
    }

    private static void initCharFreq_Oriya() {
        m_MapCharFreq.put("\u0b0c", 1);
        m_MapCharFreq.put("\u0b03", 6);
        m_MapCharFreq.put("\u0b0b", 15);
        m_MapCharFreq.put("\u200d", 17);
        m_MapCharFreq.put("\u0b14", 34);
        m_MapCharFreq.put("\u0b10", 39);
        m_MapCharFreq.put("\u0b5d", 41);
        m_MapCharFreq.put("\u0b35", 62);
        m_MapCharFreq.put("\u0b0a", 68);
        m_MapCharFreq.put("\u0b13", 135);
        m_MapCharFreq.put("\u0b01", 150);
        m_MapCharFreq.put("\u0b08", 160);
        m_MapCharFreq.put("\u0b1d", 166);
        m_MapCharFreq.put("\u0b22", 178);
        m_MapCharFreq.put("\u0b02", 184);
        m_MapCharFreq.put("\u0b5c", 194);
        m_MapCharFreq.put("\u0b18", 214);
        m_MapCharFreq.put("\u0b1e", 246);
        m_MapCharFreq.put("\u0b20", 285);
        m_MapCharFreq.put("\u0b1b", 290);
        m_MapCharFreq.put("\u200c", 357);
        m_MapCharFreq.put("\u0b0f", 395);
        m_MapCharFreq.put("\u0b16", 409);
        m_MapCharFreq.put("\u0b3c", 425);
        m_MapCharFreq.put("\u0b2b", 430);
        m_MapCharFreq.put("\u0b25", 434);
        m_MapCharFreq.put("\u0b2d", 483);
        m_MapCharFreq.put("\u0b27", 534);
        m_MapCharFreq.put("\u0b33", 538);
        m_MapCharFreq.put("\u0b37", 582);
        m_MapCharFreq.put("\u0b09", 582);
        m_MapCharFreq.put("\u0b07", 614);
        m_MapCharFreq.put("\u0b06", 659);
        m_MapCharFreq.put("\u0b36", 705);
        m_MapCharFreq.put("\u0b5f", 735);
        m_MapCharFreq.put("\u0b2f", 745);
        m_MapCharFreq.put("\u0b1a", 766);
        m_MapCharFreq.put("\u0b39", 802);
        m_MapCharFreq.put("\u0b21", 805);
        m_MapCharFreq.put("\u0b23", 809);
        m_MapCharFreq.put("\u0b05", 821);
        m_MapCharFreq.put("\u0b1c", 1015);
        m_MapCharFreq.put("\u0b17", 1050);
        m_MapCharFreq.put("\u0b1f", 1083);
        m_MapCharFreq.put("\u0b26", 1263);
        m_MapCharFreq.put("\u0b32", 1368);
        m_MapCharFreq.put("\u0b2a", 1671);
        m_MapCharFreq.put("\u0b2e", 1979);
        m_MapCharFreq.put("\u0b38", 2115);
        m_MapCharFreq.put("\u0b2c", 2266);
        m_MapCharFreq.put("\u0b24", 2356);
        m_MapCharFreq.put("\u0b15", 2440);
        m_MapCharFreq.put("\u0b28", 2528);
        m_MapCharFreq.put("\u0b30", 4789);
        m_MapCharFreq.put("\u0b4d", 8383);
    }

    private static void initCharFreq_Devanagari() {
        m_MapCharFreq.put("\u095e", 1);
        m_MapCharFreq.put("\u095a", 1);
        m_MapCharFreq.put("-", 1);
        m_MapCharFreq.put("\u0919", 3);
        m_MapCharFreq.put("\u200c", 3);
        m_MapCharFreq.put(".", 6);
        m_MapCharFreq.put("\u0945", 7);
        m_MapCharFreq.put("\u0933", 9);
        m_MapCharFreq.put("\u090b", 24);
        m_MapCharFreq.put("\u0914", 41);
        m_MapCharFreq.put("\u091e", 58);
        m_MapCharFreq.put("\u0910", 76);
        m_MapCharFreq.put("\u0903", 100);
        m_MapCharFreq.put("\u090a", 172);
        m_MapCharFreq.put("\u0943", 271);
        m_MapCharFreq.put("\u0913", 416);
        m_MapCharFreq.put("\u0922", 455);
        m_MapCharFreq.put("\u0949", 462);
        m_MapCharFreq.put("\u0920", 534);
        m_MapCharFreq.put("\u091d", 577);
        m_MapCharFreq.put("\u200d", 582);
        m_MapCharFreq.put("\u0918", 687);
        m_MapCharFreq.put("\u091b", 737);
        m_MapCharFreq.put("\u094c", 748);
        m_MapCharFreq.put("\u0937", 808);
        m_MapCharFreq.put("\u0925", 915);
        m_MapCharFreq.put("\u0909", 985);
        m_MapCharFreq.put("\u0906", 1073);
        m_MapCharFreq.put("\u0907", 1181);
        m_MapCharFreq.put("\u090f", 1233);
        m_MapCharFreq.put("\u0948", 1320);
        m_MapCharFreq.put("\u0901", 1332);
        m_MapCharFreq.put("\u0908", 1351);
        m_MapCharFreq.put("\u0927", 1566);
        m_MapCharFreq.put("\u092d", 1591);
        m_MapCharFreq.put("\u092b", 2264);
        m_MapCharFreq.put("\u0916", 2378);
        m_MapCharFreq.put("\u0905", 2446);
        m_MapCharFreq.put("\u091a", 2955);
        m_MapCharFreq.put("\u093c", 3048);
        m_MapCharFreq.put("\u0921", 3196);
        m_MapCharFreq.put("\u0942", 3313);
        m_MapCharFreq.put("\u091f", 3643);
        m_MapCharFreq.put("\u0936", 4255);
        m_MapCharFreq.put("\u0939", 5389);
        m_MapCharFreq.put("\u092f", 5395);
        m_MapCharFreq.put("\u0935", 5882);
        m_MapCharFreq.put("\u0917", 6144);
        m_MapCharFreq.put("\u091c", 6621);
        m_MapCharFreq.put("\u092a", 6689);
        m_MapCharFreq.put("\u094b", 7697);
        m_MapCharFreq.put("\u092c", 8187);
        m_MapCharFreq.put("\u0902", 8755);
        m_MapCharFreq.put("\u0924", 8767);
        m_MapCharFreq.put("\u0926", 8785);
        m_MapCharFreq.put("\u0941", 10260);
        m_MapCharFreq.put("\u0915", 10338);
        m_MapCharFreq.put("\u0947", 10438);
        m_MapCharFreq.put("\u0938", 11365);
        m_MapCharFreq.put("\u0940", 11544);
        m_MapCharFreq.put("\u092e", 11729);
        m_MapCharFreq.put("\u0932", 12171);
        m_MapCharFreq.put("\u093f", 12469);
        m_MapCharFreq.put("\u0923", 13838);
        m_MapCharFreq.put("\u0928", 15156);
        m_MapCharFreq.put("\u094d", 16477);
        m_MapCharFreq.put("\u0930", 22039);
        m_MapCharFreq.put("\u093e", 30996);
    }
}

