/*
 * Decompiled with CFR 0.152.
 */
package com.cognirel.osk;

import com.cognirel.osk.CTAksharaSeqBase;
import com.cognirel.osk.CTAksharaSeqIndic;
import com.cognirel.osk.CTAksharaSeqUrdu;
import com.cognirel.osk.CTOSKEditBox;
import com.cognirel.osk.CTOSKKey;
import com.cognirel.osk.CTOSKLanguage;
import com.cognirel.osk.CTOSKScreenUtil;
import in.gov.uidai.translit.events.ISoftKeyboardListener;
import in.gov.uidai.translit.events.SoftKeyStroke;
import in.gov.uidai.translit.spi.ISoftKeyboard;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

public class CTOSKeyboard
extends JPanel
implements ISoftKeyboard {
    private static double m_fDPIScale = CTOSKScreenUtil.getScreenDPIScale();
    private int m_iFontBig;
    private int m_iFontSml;
    private int m_pxSpace;
    private int m_iDefFontSize = 12;
    private int m_nEditChars = 16;
    private int m_iMaxRows = 4;
    private int m_nCols;
    private int m_nRows;
    private int m_pxBtnW;
    private int m_pxBtnH;
    private int m_pxEditW;
    private int m_pxEditH;
    private Font m_pFontBig;
    private Font m_pFontSml;
    private int m_nKeypadKeys = 12;
    private int m_iKeypadStart;
    private int m_iKeyEnter;
    private int m_iKeySpace;
    private int m_iKeyZero;
    private CTOSKEditBox m_pEdit = new CTOSKEditBox();
    private String[][] m_tblLang = null;
    private CTOSKKey[] m_arrKeys = null;
    private int m_iCurPos = -1;
    private int[] m_iHilited;
    private CTAksharaSeqBase m_AksSeq;
    int m_iCurrKey = 0;
    int m_iTabIndex = 0;
    private HashMap<Integer, Integer> m_pMapUpKey = new HashMap();
    private HashMap<Integer, Integer> m_pMapDnKey = new HashMap();
    private HashMap<Integer, Integer> m_pMapLtKey = new HashMap();
    private HashMap<Integer, Integer> m_pMapRtKey = new HashMap();
    CTOSKLanguage lang;
    protected EventListenerList listenerList = new EventListenerList();
    private SoftKeyStroke m_pSoftKS = new SoftKeyStroke();

    public CTOSKeyboard(CTOSKLanguage lang) {
        this.m_AksSeq = lang == CTOSKLanguage.URDU ? new CTAksharaSeqUrdu() : new CTAksharaSeqIndic();
        this.lang = lang;
        this.setLayout(null);
        this.initKeyMaps(lang);
        this.calcRowsCols();
        this.createKeysAndEditBox();
        this.setFontSize(this.m_iDefFontSize);
        this.m_pEdit.setKeyboard(this);
    }

    public void setFontSize(int iSizePt) {
        iSizePt = Math.max(iSizePt, 10);
        this.m_iFontBig = (int)((double)iSizePt * m_fDPIScale);
        this.m_iFontSml = (int)((double)iSizePt * m_fDPIScale / 1.5);
        Graphics g = this.getGraphics();
        try {
            String fontFileName = "/res/" + CTOSKLanguage.getLanguageFont(this.lang);
            InputStream is = this.getClass().getResourceAsStream(fontFileName);
            this.m_pFontBig = Font.createFont(0, is).deriveFont(0, this.m_iFontBig);
        }
        catch (FontFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_pFontSml = new Font("sans-serif", 0, this.m_iFontSml);
        this.m_pEdit.setFont(this.m_pFontBig);
        FontMetrics fm = this.getFontMetrics(this.m_pFontBig);
        this.layItOut(g, fm);
    }

    private void initKeyMaps(CTOSKLanguage lang) {
        this.m_tblLang = CTOSKLanguage.getKeyMap(lang);
        this.m_AksSeq.init(this.m_tblLang, CTOSKLanguage.getDigitStart(lang));
    }

    private void calcRowsCols() {
        int nAlphaKeys = this.m_tblLang.length;
        this.m_nCols = nAlphaKeys / this.m_iMaxRows;
        if (nAlphaKeys % this.m_iMaxRows > 0) {
            ++this.m_nCols;
        }
        this.m_nRows = this.m_iMaxRows;
    }

    private void createKeysAndEditBox() {
        this.m_arrKeys = new CTOSKKey[this.m_tblLang.length + this.m_nKeypadKeys];
        int n = 0;
        while (n < this.m_tblLang.length) {
            String sQWERTY = this.m_tblLang[n][2];
            String sRegional = this.m_tblLang[n][0];
            this.m_arrKeys[n] = new CTOSKKey(sQWERTY, sRegional, this, n);
            this.add(this.m_arrKeys[n]);
            ++n;
        }
        this.m_iKeypadStart = this.m_tblLang.length;
        this.m_iKeyZero = this.m_tblLang.length;
        this.m_iKeySpace = this.m_iKeyZero + 10;
        this.m_iKeyEnter = this.m_iKeySpace + 1;
        n = 0;
        while (n < 10) {
            int i = this.m_iKeyZero + n;
            this.m_arrKeys[i] = new CTOSKKey(String.valueOf(n), String.valueOf(n), this, i);
            this.add(this.m_arrKeys[i]);
            ++n;
        }
        this.m_arrKeys[this.m_iKeyEnter] = new CTOSKKey("", "Enter", this, this.m_iKeyEnter);
        this.m_arrKeys[this.m_iKeySpace] = new CTOSKKey("", "Space", this, this.m_iKeySpace);
        this.add(this.m_arrKeys[this.m_iKeyEnter]);
        this.add(this.m_arrKeys[this.m_iKeySpace]);
        this.add(this.m_pEdit);
        this.m_pEdit.startCaret();
        this.m_iHilited = new int[this.m_tblLang.length + 1];
    }

    private void layItOut(Graphics g, FontMetrics fm) {
        int iCharW = this.m_iFontBig;
        int iCharH = this.m_iFontBig;
        this.m_pxBtnW = iCharW * 5 / 2;
        this.m_pxBtnH = iCharH * 2;
        this.m_pxSpace = this.m_iFontBig / 6;
        this.m_pxEditH = iCharW * 5 / 3;
        this.m_pxEditW = iCharW * this.m_nEditChars;
        int pxTop = this.m_pxSpace * 4 + this.m_pxEditH;
        int pxLt = this.m_pxSpace * 2;
        int pxRt = this.m_pxSpace * 2;
        int pxKeyPad = this.m_pxSpace * 2;
        this.placeKeys(pxTop, pxLt, pxKeyPad);
        int iMaxW = pxLt + (this.m_pxBtnW + this.m_pxSpace) * this.m_nCols + pxKeyPad + (this.m_pxBtnW + this.m_pxSpace) * 3 + pxRt;
        int iMaxH = pxTop + (this.m_pxBtnH + this.m_pxSpace) * this.m_nRows;
        this.placeEditBox(iMaxW);
        this.fixFrameDims(iMaxW, iMaxH);
    }

    private void placeKeys(int pxUp, int pxLt, int pxKeyPad) {
        int x = 0;
        while (x < this.m_nCols) {
            int iKey = x;
            int y = 0;
            while (y < this.m_nRows) {
                int iKeyBelow;
                if (iKey < this.m_tblLang.length) {
                    int pxX = pxLt + x * (this.m_pxBtnW + this.m_pxSpace);
                    int pxY = pxUp + y * (this.m_pxBtnH + this.m_pxSpace);
                    this.m_arrKeys[iKey].setBounds(pxX, pxY, this.m_pxBtnW, this.m_pxBtnH);
                }
                if ((iKeyBelow = iKey + this.m_nCols) >= this.m_iKeyZero) {
                    iKeyBelow = x;
                }
                this.m_pMapDnKey.put(iKey, iKeyBelow);
                this.m_pMapUpKey.put(iKeyBelow, iKey);
                iKey += this.m_nCols;
                ++y;
            }
            ++x;
        }
        int pxKPLt = pxLt + this.m_nCols * (this.m_pxBtnW + this.m_pxSpace) + pxKeyPad;
        int pxKPDn = pxUp + (this.m_nRows - 1) * (this.m_pxBtnH + this.m_pxSpace);
        int x2 = pxKPLt;
        int y = pxKPDn;
        this.m_arrKeys[this.m_iKeyZero].setBounds(x2, y, this.m_pxBtnW, this.m_pxBtnH);
        this.m_arrKeys[this.m_iKeySpace].setBounds(x2 += this.m_pxBtnW + this.m_pxSpace, y, this.m_pxBtnW, this.m_pxBtnH);
        this.m_arrKeys[this.m_iKeyEnter].setBounds(x2 += this.m_pxBtnW + this.m_pxSpace, y, this.m_pxBtnW, this.m_pxBtnH);
        int n = 1;
        int i = 0;
        while (i < 3) {
            y -= this.m_pxBtnH + this.m_pxSpace;
            int j = 0;
            while (j < 3) {
                x2 = pxKPLt + j * (this.m_pxBtnW + this.m_pxSpace);
                this.m_arrKeys[this.m_iKeyZero + n].setBounds(x2, y, this.m_pxBtnW, this.m_pxBtnH);
                int iKeyBelow = (n - 3) % 9 + this.m_iKeyZero;
                if (iKeyBelow <= this.m_iKeyZero) {
                    iKeyBelow += 9;
                }
                this.m_pMapDnKey.put(this.m_iKeyZero + n, iKeyBelow);
                ++n;
                ++j;
            }
            ++i;
        }
        this.setNavigationMaps();
        this.initKeysUI();
    }

    private void setNavigationMaps() {
        int k = 1;
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                int iKeyBelow = (k - 3) % 9 + this.m_iKeyZero;
                if (iKeyBelow <= this.m_iKeyZero) {
                    iKeyBelow += 9;
                }
                this.m_pMapDnKey.put(this.m_iKeyZero + k, iKeyBelow);
                ++k;
                ++j;
            }
            ++i;
        }
        this.m_pMapDnKey.put(this.m_iKeyZero + 1, this.m_iKeyZero);
        this.m_pMapDnKey.put(this.m_iKeyZero, this.m_iKeyZero + 7);
        this.m_pMapRtKey.put(this.m_iKeyZero + 9, this.m_nCols * 0);
        this.m_pMapRtKey.put(this.m_iKeyZero + 6, this.m_nCols * 1);
        this.m_pMapRtKey.put(this.m_iKeyZero + 3, this.m_nCols * 2);
        this.m_pMapRtKey.put(this.m_iKeyZero + 0, this.m_nCols * 3);
        this.m_pMapRtKey.put(this.m_nCols * 1 - 1, this.m_iKeyZero + 7);
        this.m_pMapRtKey.put(this.m_nCols * 2 - 1, this.m_iKeyZero + 4);
        this.m_pMapRtKey.put(this.m_nCols * 3 - 1, this.m_iKeyZero + 1);
        this.m_pMapRtKey.put(this.m_iKeypadStart - 1, this.m_iKeyZero + 0);
        for (Map.Entry<Integer, Integer> i2 : this.m_pMapRtKey.entrySet()) {
            this.m_pMapLtKey.put(i2.getValue(), i2.getKey());
        }
        for (Map.Entry<Integer, Integer> i3 : this.m_pMapDnKey.entrySet()) {
            this.m_pMapUpKey.put(i3.getValue(), i3.getKey());
        }
    }

    private void initKeysUI() {
        CTOSKKey[] cTOSKKeyArray = this.m_arrKeys;
        int n = this.m_arrKeys.length;
        int n2 = 0;
        while (n2 < n) {
            CTOSKKey key = cTOSKKeyArray[n2];
            key.setFonts(this.m_pFontSml, this.m_pFontBig);
            key.setVisible(true);
            ++n2;
        }
        this.m_arrKeys[this.m_iKeyEnter].setFonts(new Font("sans-serif", 0, 2), this.m_pFontSml);
        this.m_arrKeys[this.m_iKeySpace].setFonts(new Font("sans-serif", 0, 2), this.m_pFontSml);
    }

    private void fixFrameDims(int iMaxW, int iMaxH) {
        Dimension dimMin = new Dimension(iMaxW, iMaxH);
        this.setMinimumSize(dimMin);
        this.setMaximumSize(dimMin);
        this.setPreferredSize(dimMin);
        this.setSize(dimMin);
    }

    private void placeEditBox(int iMaxW) {
        int pxEditX = (iMaxW - this.m_pxEditW) / 2;
        int pxEditY = this.m_pxSpace * 2;
        this.m_pEdit.setBounds(pxEditX, pxEditY, this.m_pxEditW, this.m_pxEditH);
        this.m_pEdit.setVisible(true);
    }

    private void refreshEditBox() {
        ArrayList<String> sChars = this.m_AksSeq.compose();
        this.m_pEdit.render(sChars, this.m_iCurPos);
        StringBuilder sb = new StringBuilder();
        for (String s : sChars) {
            sb.append(s);
        }
        this.m_pSoftKS.setDisplayChars(sb.toString().toCharArray());
    }

    private void handleCtrlKey(int iCode, int iModifier) {
        if (iCode == 10 && this.m_iCurrKey != -1) {
            char ch = this.m_arrKeys[this.m_iCurrKey].m_sBig.charAt(0);
            this.doChar(ch, (iModifier & 0x40) != 0, true);
        } else {
            Integer intCurrKey = this.m_iCurrKey;
            if (iCode == 37 && (intCurrKey = this.m_pMapLtKey.get(this.m_iCurrKey)) == null) {
                intCurrKey = this.m_iCurrKey - 1;
            }
            if (iCode == 39 && (intCurrKey = this.m_pMapRtKey.get(this.m_iCurrKey)) == null) {
                intCurrKey = this.m_iCurrKey + 1;
            }
            if (iCode == 38) {
                intCurrKey = this.m_pMapUpKey.get(this.m_iCurrKey);
            }
            if (iCode == 40) {
                intCurrKey = this.m_pMapDnKey.get(this.m_iCurrKey);
            }
            int iCurrKey = intCurrKey;
            iCurrKey = Math.max(iCurrKey, 0);
            if (this.m_iCurrKey != (iCurrKey %= this.m_iKeyZero + 10)) {
                this.m_arrKeys[this.m_iCurrKey].setFocused(false);
                this.m_arrKeys[iCurrKey].setFocused(true);
                this.m_iCurrKey = iCurrKey;
            }
        }
    }

    private void handleSpecialKey(KeyEvent e) {
        int iCode = e.getKeyCode();
        int iModifier = e.getModifiersEx();
        if ((iModifier & 0x80) != 0) {
            this.handleCtrlKey(iCode, iModifier);
        } else {
            switch (iCode) {
                case 37: {
                    this.m_iCurPos = this.m_AksSeq.move(-1);
                    break;
                }
                case 39: {
                    this.m_iCurPos = this.m_AksSeq.move(1);
                    break;
                }
                case 35: {
                    this.m_iCurPos = this.m_AksSeq.move(999);
                    break;
                }
                case 36: {
                    this.m_iCurPos = this.m_AksSeq.move(-999);
                    break;
                }
                case 8: {
                    this.m_iCurPos = this.m_AksSeq.del(CTAksharaSeqBase.DelDir.ddLeft);
                    break;
                }
                case 127: {
                    this.m_iCurPos = this.m_AksSeq.del(CTAksharaSeqBase.DelDir.ddRight);
                    break;
                }
                case 9: {
                    this.m_iCurPos = this.m_AksSeq.tab();
                    break;
                }
                case 10: {
                    this.doDismiss(true);
                    break;
                }
                case 27: {
                    this.doDismiss(false);
                }
            }
        }
        this.refreshEditBox();
    }

    private void highlightKeys() {
        String sKey = this.m_AksSeq.getHighlightChar();
        int n = 0;
        int i = 0;
        while (i < this.m_tblLang.length) {
            boolean bHilite = sKey.equals(this.m_tblLang[i][2]);
            this.m_arrKeys[i].setHighlight(bHilite);
            this.m_iHilited[n] = i;
            if (bHilite) {
                ++n;
            }
            ++i;
        }
        this.m_iHilited[n] = -1;
        this.m_iTabIndex = -1;
    }

    private void doChar(char ch, boolean bShift, boolean bRegional) {
        String sKey = String.valueOf(ch);
        this.m_iCurPos = this.m_AksSeq.take(sKey, bShift, bRegional);
        this.refreshEditBox();
    }

    private void handleCharKey(KeyEvent e) {
        char ch = e.getKeyChar();
        if (!Character.isISOControl(ch)) {
            this.doChar(ch, (e.getModifiersEx() & 0x40) != 0, false);
        }
        this.highlightKeys();
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        try {
            switch (e.getID()) {
                case 401: {
                    this.handleSpecialKey(e);
                    e.consume();
                    break;
                }
                case 400: {
                    this.handleCharKey(e);
                    e.consume();
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private void doDismiss(boolean bOk) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] == ISoftKeyboardListener.class) {
                ((ISoftKeyboardListener)listeners[i + 1]).keyTyped(this.m_pSoftKS);
            }
            i += 2;
        }
        this.m_AksSeq.clearAksSeq();
        this.m_iCurPos = 0;
        this.refreshEditBox();
        String s = bOk ? "\n" : "\u001b";
        this.m_pSoftKS.setDisplayChars(s.toCharArray());
        listeners = this.listenerList.getListenerList();
        int i2 = 0;
        while (i2 < listeners.length) {
            if (listeners[i2] == ISoftKeyboardListener.class) {
                ((ISoftKeyboardListener)listeners[i2 + 1]).keyTyped(this.m_pSoftKS);
            }
            i2 += 2;
        }
    }

    public void addListener(ISoftKeyboardListener listener) {
        this.listenerList.add(ISoftKeyboardListener.class, listener);
    }

    public Component getRenderer() {
        return this;
    }

    public void removeListener(ISoftKeyboardListener listener) {
        this.listenerList.remove(ISoftKeyboardListener.class, listener);
    }

    public void processClick(int i, boolean shiftPress) {
        if (this.m_iCurrKey != -1) {
            this.m_arrKeys[this.m_iCurrKey].setFocused(false);
        }
        this.m_arrKeys[i].setFocused(true);
        this.m_iCurrKey = i;
        if (this.m_iCurrKey == this.m_iKeyEnter) {
            this.doDismiss(true);
        } else if (this.m_iCurrKey == this.m_iKeySpace) {
            this.doChar(' ', false, false);
        } else {
            this.doChar(this.m_arrKeys[i].m_sBig.charAt(0), shiftPress, true);
        }
    }
}

