/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration.cameras;

import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import boofcv.alg.geo.bundle.cameras.BundlePinholeBrown;
import boofcv.alg.geo.calibration.cameras.Zhang99Camera;
import boofcv.struct.calib.CameraModel;
import boofcv.struct.calib.CameraPinholeBrown;
import org.ejml.data.DMatrixRMaj;

public class Zhang99CameraBrown
implements Zhang99Camera {
    boolean assumeZeroSkew;
    boolean includeTangential;
    int numRadial;

    public Zhang99CameraBrown(boolean assumeZeroSkew, boolean includeTangential, int numRadial) {
        this.assumeZeroSkew = assumeZeroSkew;
        this.includeTangential = includeTangential;
        this.numRadial = numRadial;
    }

    @Override
    public BundleAdjustmentCamera initalizeCamera(DMatrixRMaj K, double[] radial) {
        BundlePinholeBrown cam = new BundlePinholeBrown(this.assumeZeroSkew, this.includeTangential);
        cam.radial = (double[])radial.clone();
        if (cam.radial.length != this.numRadial) {
            throw new RuntimeException("BUGW!");
        }
        cam.setK(K);
        return cam;
    }

    @Override
    public CameraModel getCameraModel(BundleAdjustmentCamera bundleCam) {
        BundlePinholeBrown cam = (BundlePinholeBrown)bundleCam;
        CameraPinholeBrown out = new CameraPinholeBrown();
        cam.convert(out);
        return out;
    }

    @Override
    public boolean isZeroSkew() {
        return this.assumeZeroSkew;
    }

    @Override
    public int numRadial() {
        return this.numRadial;
    }
}

