/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.cellprocessor;

import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.LongCellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.NullInputException;
import org.supercsv.exception.SuperCSVException;
import org.supercsv.util.CSVContext;

public class ParseInt
extends CellProcessorAdaptor
implements StringCellProcessor {
    public ParseInt() {
    }

    public ParseInt(LongCellProcessor longCellProcessor) {
        super(longCellProcessor);
    }

    public Object execute(Object object, CSVContext cSVContext) throws SuperCSVException {
        Integer n;
        if (object == null) {
            throw new NullInputException("Input cannot be null on line " + cSVContext.lineNumber + " at column " + cSVContext.columnNumber, cSVContext, this);
        }
        if (object instanceof Integer) {
            n = (Integer)object;
        } else if (object instanceof String) {
            try {
                n = new Integer((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SuperCSVException("Parser error", cSVContext, this, numberFormatException);
            }
        } else {
            throw new SuperCSVException("Can't convert \"" + object + "\" to integer. Input is not of type Integer nor type String but of type " + object.getClass().getName(), cSVContext, this);
        }
        return this.next.execute(n, cSVContext);
    }
}

