/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.cellprocessor;

import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.BoolCellProcessor;
import org.supercsv.cellprocessor.ift.DateCellProcessor;
import org.supercsv.cellprocessor.ift.DoubleCellProcessor;
import org.supercsv.cellprocessor.ift.LongCellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.NullInputException;
import org.supercsv.exception.SuperCSVException;
import org.supercsv.util.CSVContext;

public class StrReplace
extends CellProcessorAdaptor
implements BoolCellProcessor,
DateCellProcessor,
DoubleCellProcessor,
LongCellProcessor,
StringCellProcessor {
    private String searchText;
    private String replaceText;

    public StrReplace(String string, String string2) {
        this.handleArguments(string, string2);
    }

    public StrReplace(String string, String string2, StringCellProcessor stringCellProcessor) {
        super(stringCellProcessor);
        this.handleArguments(string, string2);
    }

    public Object execute(Object object, CSVContext cSVContext) throws SuperCSVException {
        if (object == null) {
            throw new NullInputException("Input cannot be null", cSVContext, this);
        }
        String string = object.toString().replaceAll(this.searchText, this.replaceText);
        return this.next.execute(string, cSVContext);
    }

    private void handleArguments(String string, String string2) throws IllegalArgumentException {
        if (string == null) {
            throw new NullInputException("searchtext cannot be null", this);
        }
        if (string2 == null) {
            throw new NullInputException("replacettext cannot be null", this);
        }
        if (string.equals("")) {
            throw new SuperCSVException("argument searchText cannot be \"\" as this has no effect", this);
        }
        this.searchText = string;
        this.replaceText = string2;
    }
}

