/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.cellprocessor.constraint;

import java.util.HashSet;
import java.util.Set;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.BoolCellProcessor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.DateCellProcessor;
import org.supercsv.cellprocessor.ift.DoubleCellProcessor;
import org.supercsv.cellprocessor.ift.LongCellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.NullInputException;
import org.supercsv.exception.SuperCSVException;
import org.supercsv.util.CSVContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsIncludedIn
extends CellProcessorAdaptor
implements BoolCellProcessor,
DateCellProcessor,
DoubleCellProcessor,
LongCellProcessor,
StringCellProcessor {
    protected Set<Object> possibleValues;

    public IsIncludedIn(Set<Object> set) {
        this.possibleValues = set;
    }

    public IsIncludedIn(Set<Object> set, CellProcessor cellProcessor) {
        super(cellProcessor);
        this.possibleValues = set;
    }

    public IsIncludedIn(Object[] objectArray) {
        this.possibleValues = IsIncludedIn.createSet(objectArray);
    }

    public IsIncludedIn(Object[] objectArray, CellProcessor cellProcessor) {
        super(cellProcessor);
        this.possibleValues = IsIncludedIn.createSet(objectArray);
    }

    private static Set<Object> createSet(Object[] objectArray) {
        int n;
        int n2 = n = objectArray == null ? 0 : objectArray.length;
        if (n == 0) {
            return new HashSet<Object>();
        }
        HashSet<Object> hashSet = new HashSet<Object>(4 * n / 3 + 1);
        for (int i = 0; i < objectArray.length; ++i) {
            hashSet.add(objectArray[i]);
        }
        return hashSet;
    }

    @Override
    public Object execute(Object object, CSVContext cSVContext) throws SuperCSVException, ClassCastException {
        if (object == null) {
            throw new NullInputException("Input cannot be null on line " + cSVContext.lineNumber + " at column " + cSVContext.columnNumber, cSVContext, this);
        }
        if (!this.possibleValues.contains(object)) {
            throw new SuperCSVException("Entry \"" + object + "\" on line " + cSVContext.lineNumber + " column " + cSVContext.columnNumber + " is not accepted as a possible value", cSVContext, this);
        }
        return this.next.execute(object, cSVContext);
    }
}

