/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.util;

import java.lang.reflect.Method;
import java.util.HashMap;
import org.supercsv.exception.SuperCSVException;
import org.supercsv.exception.SuperCSVReflectionException;
import spiffy.core.util.HashMapBuilder;
import spiffy.core.util.ThreeDHashMap;
import spiffy.core.util.TwoDHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodCache {
    private final HashMap<Class, Class> autoboxingConverter = new HashMapBuilder().add(Long.TYPE, Long.class).add(Long.class, Long.TYPE).add(Integer.TYPE, Integer.class).add(Integer.class, Integer.TYPE).add(Character.TYPE, Character.class).add(Character.class, Character.TYPE).add(Byte.TYPE, Byte.class).add(Byte.class, Byte.TYPE).add(Short.TYPE, Short.class).add(Short.class, Short.TYPE).add(Boolean.TYPE, Boolean.class).add(Boolean.class, Boolean.TYPE).add(Double.TYPE, Double.class).add(Double.class, Double.TYPE).add(Float.TYPE, Float.class).add(Float.class, Float.TYPE).build();
    private final ThreeDHashMap<Class, Class, String, Method> setMethodsCache = new ThreeDHashMap();
    private final TwoDHashMap<String, String, Method> getCache = new TwoDHashMap();

    public Method getGetMethod(Object object, String string) {
        return this.getMethod(this.getCache, object, "get", string);
    }

    Method getMethod(TwoDHashMap<String, String, Method> twoDHashMap, Object object, String string, String string2) {
        Method method = (Method)twoDHashMap.get((Object)object.getClass().getName(), (Object)string2);
        if (method == null) {
            method = this.inspectClass(object, string, string2, 0);
            twoDHashMap.set((Object)object.getClass().getName(), (Object)string2, (Object)method);
        }
        return method;
    }

    public <T> Method getSetMethod(Object object, String string, Class<?> clazz) {
        Method method = (Method)this.setMethodsCache.get(object.getClass(), clazz, (Object)string);
        if (method == null) {
            method = clazz == null ? this.findSetMethodWithNonPrimitiveParameter(object, string) : this.inspectClassForSetMethods(object, clazz, string);
            this.setMethodsCache.set(object.getClass(), clazz, (Object)string, (Object)method);
        }
        return method;
    }

    private Method inspectClass(Object object, String string, String string2, int n) {
        String string3 = string + string2.substring(0, 1).toUpperCase() + string2.substring(1);
        for (Method method : object.getClass().getMethods()) {
            if (!method.getName().equals(string3) || method.getParameterTypes().length != n) continue;
            return method;
        }
        throw new SuperCSVReflectionException(String.format("Can't find method '%s' in class '%s'", string3, object.getClass().getName()));
    }

    private Method findSetMethodWithNonPrimitiveParameter(Object object, String string) {
        String string2 = "set" + string.substring(0, 1).toUpperCase() + string.substring(1);
        for (Method method : object.getClass().getMethods()) {
            if (!method.getName().equals(string2) || method.getParameterTypes().length != 1 || method.getParameterTypes()[0].isPrimitive()) continue;
            return method;
        }
        throw new SuperCSVReflectionException(String.format("Can't find method '%s' in class '%s'", string2, object.getClass().getName()));
    }

    Method inspectClassForSetMethods(Object object, Class clazz, String string) {
        String string2 = "set" + string.substring(0, 1).toUpperCase() + string.substring(1);
        try {
            return object.getClass().getMethod(string2, clazz);
        }
        catch (SecurityException securityException) {
            this.throwException(object, clazz, string2, securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                if (!this.autoboxingConverter.containsKey(clazz)) {
                    this.throwException(object, clazz, string2, noSuchMethodException);
                }
                return object.getClass().getMethod(string2, this.autoboxingConverter.get(clazz));
            }
            catch (SecurityException securityException) {
                this.throwException(object, clazz, string2, securityException);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                this.throwException(object, clazz, string2, noSuchMethodException2);
            }
        }
        throw new SuperCSVException("This can never happen!");
    }

    private void throwException(Object object, Class clazz, String string, Exception exception) throws SuperCSVReflectionException {
        exception.printStackTrace();
        throw new SuperCSVReflectionException(String.format("Can't find method '%s(%s)' in class '%s'. Is the name correctly spelled in the NameMapping? Have you forgot to convert the data so that a wrong set method is called?", string, clazz, object.getClass().getName()), exception);
    }
}

