/*
 * Decompiled with CFR 0.152.
 */
package com.l1id.uid.iso19794_2005;

import helper.UtilHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class IIR {
    public Header header = new Header();
    public List<SubHeader> irisList = new ArrayList<SubHeader>();

    public String toString() {
        String nl = System.getProperty("line.separator", "\n");
        StringBuilder sb = new StringBuilder();
        sb.append("IIR-HEADER:").append(nl);
        sb.append(this.header);
        sb.append("SubHeaderIIR-LIST (").append(this.irisList.size()).append(")").append(nl);
        for (SubHeader subHeader : this.irisList) {
            sb.append(subHeader);
        }
        return sb.toString();
    }

    public static IIR readFromStream(InputStream inputStream) throws IOException {
        IIR iir = new IIR();
        iir.header.FormatIdentifier = new String(IIR.getBytes(4, inputStream));
        iir.header.VersionNumber = new String(IIR.getBytes(4, inputStream));
        iir.header.RecordLength = UtilHelper.byteArrayToUnsignedInt(IIR.getBytes(4, inputStream));
        iir.header.CaptureDeviceID = UtilHelper.NUMERIC(IIR.getBytes(2, inputStream));
        iir.header.NumberOfSubtypes = UtilHelper.NUMERIC(IIR.getBytes(1, inputStream));
        iir.header.RecordHeaderLength = UtilHelper.NUMERIC(IIR.getBytes(2, inputStream));
        int[] bitproperties = UtilHelper.byteArrayToBitArray(IIR.getBytes(2, inputStream));
        iir.header.HorizontalOrientation = UtilHelper.bitArrayToInt(bitproperties[14], bitproperties[15]);
        iir.header.VerticalOrientation = UtilHelper.bitArrayToInt(bitproperties[12], bitproperties[13]);
        iir.header.ScanType = UtilHelper.bitArrayToInt(bitproperties[10], bitproperties[11]);
        iir.header.Occlusions = UtilHelper.bitArrayToInt(bitproperties[9]);
        iir.header.OcclusionFilling = UtilHelper.bitArrayToInt(bitproperties[8]);
        iir.header.BoundaryExtraction = UtilHelper.bitArrayToInt(bitproperties[7]);
        iir.header.IrisDiameter = UtilHelper.NUMERIC(IIR.getBytes(2, inputStream));
        iir.header.ImageFormat = UtilHelper.NUMERIC(IIR.getBytes(2, inputStream));
        iir.header.RawImageWidth = UtilHelper.NUMERIC(IIR.getBytes(2, inputStream));
        iir.header.RawImageHeight = UtilHelper.NUMERIC(IIR.getBytes(2, inputStream));
        iir.header.IntensityDepth = UtilHelper.NUMERIC(IIR.getBytes(1, inputStream));
        iir.header.ImageTransformation = UtilHelper.NUMERIC(IIR.getBytes(1, inputStream));
        iir.header.DeviceUniqueIdentifier = new String(IIR.getBytes(16, inputStream));
        int headerSum = 45;
        for (int s = 0; s < iir.header.NumberOfSubtypes; ++s) {
            SubHeader subHeader = new SubHeader();
            iir.irisList.add(subHeader);
            subHeader.BiometricSubtype = UtilHelper.NUMERIC(IIR.getBytes(1, inputStream));
            subHeader.NumberOfImages = UtilHelper.NUMERIC(IIR.getBytes(2, inputStream));
            headerSum += 3;
            for (int i = 0; i < subHeader.NumberOfImages; ++i) {
                Image image = new Image();
                subHeader.imageList.add(image);
                image.ImageNumber = UtilHelper.NUMERIC(IIR.getBytes(2, inputStream));
                image.Quality = UtilHelper.NUMERIC(IIR.getBytes(1, inputStream));
                image.RotationAngle = UtilHelper.byteArrayToUnsignedInt(IIR.getBytes(2, inputStream));
                image.RotationUncertainty = UtilHelper.byteArrayToUnsignedInt(IIR.getBytes(2, inputStream));
                image.ImageLength = UtilHelper.byteArrayToUnsignedLong(IIR.getBytes(4, inputStream));
                if (iir.header.RecordLength - (long)(headerSum += 11) < image.ImageLength) {
                    image.ImageLength = iir.header.RecordLength - (long)headerSum;
                }
                image.ImageData = IIR.getBytes(image.ImageLength, inputStream);
            }
        }
        return iir;
    }

    public static void writeToStream(OutputStream os, IIR iir) throws IOException {
        iir.header.RecordLength = 0L;
        iir.header.RecordHeaderLength = 45;
        iir.header.RecordLength += (long)iir.header.RecordHeaderLength;
        iir.header.NumberOfSubtypes = iir.irisList.size();
        for (int s = 0; s < iir.header.NumberOfSubtypes; ++s) {
            SubHeader subHeader = iir.irisList.get(s);
            iir.header.RecordLength += 3L;
            subHeader.NumberOfImages = subHeader.imageList.size();
            for (int i = 0; i < subHeader.NumberOfImages; ++i) {
                Image image = subHeader.imageList.get(i);
                iir.header.RecordLength += 11L;
                image.ImageLength = image.ImageLength + (image.ImageData == null ? 0L : (long)image.ImageData.length);
                iir.header.RecordLength += image.ImageLength;
            }
        }
        os.write(iir.header.FormatIdentifier.getBytes());
        os.write(iir.header.VersionNumber.getBytes());
        os.write(UtilHelper.longToByteArray(iir.header.RecordLength, 4));
        os.write(UtilHelper.intToByteArray(iir.header.CaptureDeviceID, 2));
        os.write(UtilHelper.intToByteArray(iir.header.NumberOfSubtypes, 1));
        os.write(UtilHelper.intToByteArray(iir.header.RecordHeaderLength, 2));
        int[] ho = UtilHelper.intToBitArray(iir.header.HorizontalOrientation, 2);
        int[] vo = UtilHelper.intToBitArray(iir.header.VerticalOrientation, 2);
        int[] st = UtilHelper.intToBitArray(iir.header.ScanType, 2);
        int[] oc = UtilHelper.intToBitArray(iir.header.Occlusions, 1);
        int[] of = UtilHelper.intToBitArray(iir.header.OcclusionFilling, 1);
        int[] be = UtilHelper.intToBitArray(iir.header.BoundaryExtraction, 1);
        int[] bitproperties = new int[]{0, 0, 0, 0, 0, 0, 0, be[0], of[0], oc[0], st[0], st[1], vo[0], vo[1], ho[0], ho[1]};
        os.write(UtilHelper.bitArrayToByteArray(bitproperties));
        os.write(UtilHelper.intToByteArray(iir.header.IrisDiameter, 2));
        os.write(UtilHelper.intToByteArray(iir.header.ImageFormat, 2));
        os.write(UtilHelper.intToByteArray(iir.header.RawImageWidth, 2));
        os.write(UtilHelper.intToByteArray(iir.header.RawImageHeight, 2));
        os.write(UtilHelper.intToByteArray(iir.header.IntensityDepth, 1));
        os.write(UtilHelper.intToByteArray(iir.header.ImageTransformation, 1));
        if (iir.header.DeviceUniqueIdentifier == null || iir.header.DeviceUniqueIdentifier.isEmpty()) {
            iir.header.DeviceUniqueIdentifier = "0000000000000000";
        } else {
            byte[] duid = iir.header.DeviceUniqueIdentifier.getBytes();
            if (duid.length < 16) {
                byte[] empty = new byte[16];
                Arrays.fill(empty, (byte)0);
                System.arraycopy(duid, 0, empty, 0, duid.length);
                iir.header.DeviceUniqueIdentifier = new String(empty);
            }
        }
        os.write(iir.header.DeviceUniqueIdentifier.getBytes(), 0, 16);
        for (int s = 0; s < iir.header.NumberOfSubtypes; ++s) {
            SubHeader subHeader = iir.irisList.get(s);
            os.write(UtilHelper.intToByteArray(subHeader.BiometricSubtype, 1));
            os.write(UtilHelper.intToByteArray(subHeader.NumberOfImages, 2));
            for (int i = 0; i < subHeader.NumberOfImages; ++i) {
                Image image = subHeader.imageList.get(i);
                os.write(UtilHelper.intToByteArray(image.ImageNumber, 2));
                os.write(UtilHelper.intToByteArray(image.Quality, 1));
                os.write(UtilHelper.intToByteArray(image.RotationAngle, 2));
                os.write(UtilHelper.intToByteArray(image.RotationUncertainty, 2));
                os.write(UtilHelper.longToByteArray(image.ImageLength, 4));
                os.write(image.ImageData);
            }
        }
    }

    private static byte[] getBytes(int nb, InputStream is) throws IOException {
        byte[] data = new byte[nb];
        int r = is.read(data);
        if (r != nb) {
            throw new IOException("read less bytes than expected");
        }
        return data;
    }

    private static byte[] getBytes(long nb, InputStream is) throws IOException {
        if (nb < Integer.MAX_VALUE) {
            return IIR.getBytes((int)nb, is);
        }
        throw new RuntimeException("not implemented yet");
    }

    public static class Image {
        public int ImageNumber;
        public int Quality;
        public int RotationAngle;
        public int RotationUncertainty;
        public long ImageLength;
        public byte[] ImageData = new byte[0];

        public String toString() {
            String nl = System.getProperty("line.separator", "\n");
            StringBuilder sb = new StringBuilder();
            sb.append("ImageNumber : ").append(this.ImageNumber).append(nl);
            sb.append("Quality : ").append(this.Quality).append(nl);
            sb.append("RotationAngle : ").append(this.RotationAngle).append(nl);
            sb.append("RotationUncertainty : ").append(this.RotationUncertainty).append(nl);
            sb.append("ImageLength : ").append(this.ImageLength).append(nl);
            sb.append("ImageData : ").append(this.ImageData.length).append(" bytes").append(nl);
            return sb.toString();
        }
    }

    public static class SubHeader {
        public int BiometricSubtype;
        public int NumberOfImages;
        public List<Image> imageList = new ArrayList<Image>();

        public String toString() {
            String nl = System.getProperty("line.separator", "\n");
            StringBuilder sb = new StringBuilder();
            sb.append("BiometricSubtype : ").append(this.BiometricSubtype).append(nl);
            sb.append("IIR-IMAGE-LIST (").append(this.imageList.size()).append(")").append(nl);
            for (Image imageIIR : this.imageList) {
                sb.append(imageIIR);
            }
            return sb.toString();
        }
    }

    public static class Header {
        public String FormatIdentifier = "IIR\u0000";
        public String VersionNumber = "010\u0000";
        public long RecordLength;
        public int CaptureDeviceID;
        public int NumberOfSubtypes;
        public int RecordHeaderLength;
        public int HorizontalOrientation;
        public int VerticalOrientation;
        public int ScanType;
        public int Occlusions;
        public int OcclusionFilling;
        public int BoundaryExtraction;
        public int IrisDiameter;
        public int ImageFormat;
        public int RawImageWidth;
        public int RawImageHeight;
        public int IntensityDepth;
        public int ImageTransformation;
        public String DeviceUniqueIdentifier = "0000000000000000";

        public String toString() {
            String nl = System.getProperty("line.separator", "\n");
            StringBuilder sb = new StringBuilder();
            sb.append("FormatIdentifier : ").append(this.FormatIdentifier).append(nl);
            sb.append("VersionNumber : ").append(this.VersionNumber).append(nl);
            sb.append("RecordLength : ").append(this.RecordLength).append(nl);
            sb.append("CaptureDeviceID : ").append(this.CaptureDeviceID).append(nl);
            sb.append("NumberOfSubtypes : ").append(this.NumberOfSubtypes).append(nl);
            sb.append("RecordHeaderLength : ").append(this.RecordHeaderLength).append(nl);
            sb.append("HorizontalOrientation : ").append(this.HorizontalOrientation).append(nl);
            sb.append("VerticalOrientation : ").append(this.VerticalOrientation).append(nl);
            sb.append("ScanType : ").append(this.ScanType).append(nl);
            sb.append("Occlusions : ").append(this.Occlusions).append(nl);
            sb.append("OcclusionFilling : ").append(this.OcclusionFilling).append(nl);
            sb.append("BoundaryExtraction : ").append(this.BoundaryExtraction).append(nl);
            sb.append("IrisDiameter : ").append(this.IrisDiameter).append(nl);
            sb.append("ImageFormat : ").append(this.ImageFormat).append(nl);
            sb.append("RawImageWidth : ").append(this.RawImageWidth).append(nl);
            sb.append("RawImageHeight : ").append(this.RawImageHeight).append(nl);
            sb.append("IntensityDepth : ").append(this.IntensityDepth).append(nl);
            sb.append("ImageTransformation : ").append(this.ImageTransformation).append(nl);
            sb.append("DeviceUniqueIdentifier : ").append(this.DeviceUniqueIdentifier).append(nl);
            return sb.toString();
        }
    }
}

