/*
 * Decompiled with CFR 0.152.
 */
package com.l1id.uid.iso19794_2011;

import helper.UtilHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class IIR_2011 {
    public Header header = new Header();
    public List<RepresentationHeader> irisList = new ArrayList<RepresentationHeader>();

    public String toString() {
        String nl = System.getProperty("line.separator", "\n");
        StringBuilder sb = new StringBuilder();
        sb.append("IIR-HEADER:").append(nl);
        sb.append(this.header);
        sb.append("RepresentationHeaderIIR-LIST (").append(this.irisList.size()).append(")").append(nl);
        for (RepresentationHeader representationHeader : this.irisList) {
            sb.append(representationHeader);
        }
        return sb.toString();
    }

    public static IIR_2011 readFromStream(InputStream is, boolean iso_parsing_strict) throws IOException {
        IIR_2011 iir = new IIR_2011();
        iir.header.formatIdentifier = new String(IIR_2011.getBytes(4, is));
        iir.header.versionNumber = new String(IIR_2011.getBytes(4, is));
        iir.header.recordLength = UtilHelper.byteArrayToUnsignedInt(IIR_2011.getBytes(4, is));
        iir.header.numberOfIrisRepresentations = UtilHelper.NUMERIC(IIR_2011.getBytes(2, is));
        IIR_2011.getBytes(1, is);
        iir.header.numberOfEyesRepresented = UtilHelper.NUMERIC(IIR_2011.getBytes(1, is));
        for (int i = 0; i < iir.header.numberOfIrisRepresentations; ++i) {
            int expectedImageLength;
            RepresentationHeader representationHeader = new RepresentationHeader();
            iir.irisList.add(representationHeader);
            representationHeader.representationLength = UtilHelper.byteArrayToUnsignedLong(IIR_2011.getBytes(4, is));
            IIR_2011.getBytes(9, is);
            representationHeader.captureDeviceTechnologyIdentifier = UtilHelper.NUMERIC(IIR_2011.getBytes(1, is));
            representationHeader.captureDeviceVendorId = UtilHelper.NUMERIC(IIR_2011.getBytes(2, is));
            representationHeader.captureDeviceTypeId = UtilHelper.NUMERIC(IIR_2011.getBytes(2, is));
            representationHeader.qualityBlockList = new ArrayList<QualityBlock>();
            int lengthOfQualityBlock = UtilHelper.NUMERIC(IIR_2011.getBytes(1, is));
            if (lengthOfQualityBlock != 0) {
                for (int j = 0; j < lengthOfQualityBlock; ++j) {
                    QualityBlock qualityBlock = new QualityBlock();
                    representationHeader.qualityBlockList.add(qualityBlock);
                    qualityBlock.qualityScore = UtilHelper.NUMERIC(IIR_2011.getBytes(1, is));
                    qualityBlock.qualityAlgorithmVendorIdentifier = UtilHelper.NUMERIC(IIR_2011.getBytes(2, is));
                    qualityBlock.qualityAlgorithmIdentifier = UtilHelper.NUMERIC(IIR_2011.getBytes(2, is));
                }
            }
            representationHeader.representationNumber = UtilHelper.NUMERIC(IIR_2011.getBytes(2, is));
            representationHeader.eyeLabel = UtilHelper.NUMERIC(IIR_2011.getBytes(1, is));
            representationHeader.imageType = UtilHelper.NUMERIC(IIR_2011.getBytes(1, is));
            representationHeader.imageFormat = UtilHelper.NUMERIC(IIR_2011.getBytes(1, is));
            int[] bitproperties = UtilHelper.byteArrayToBitArray(IIR_2011.getBytes(1, is));
            representationHeader.horizontalOrientation = UtilHelper.bitArrayToInt(bitproperties[7], bitproperties[6]);
            representationHeader.verticalOrientation = UtilHelper.bitArrayToInt(bitproperties[5], bitproperties[4]);
            representationHeader.compressionHistory = UtilHelper.bitArrayToInt(bitproperties[1], bitproperties[0]);
            representationHeader.imageWidth = UtilHelper.NUMERIC(IIR_2011.getBytes(2, is));
            representationHeader.imageHeight = UtilHelper.NUMERIC(IIR_2011.getBytes(2, is));
            representationHeader.bitDepth = UtilHelper.NUMERIC(IIR_2011.getBytes(1, is));
            representationHeader.range = UtilHelper.NUMERIC(IIR_2011.getBytes(2, is));
            representationHeader.rollAngleOfEye = UtilHelper.byteArrayToUnsignedInt(IIR_2011.getBytes(2, is));
            if (representationHeader.rollAngleOfEye == 0) {
                byte[] defaultRollAngleOfEye = new byte[]{-1, -1};
                representationHeader.rollAngleOfEye = UtilHelper.NUMERIC(defaultRollAngleOfEye);
            }
            representationHeader.rollAngleUncertainty = UtilHelper.byteArrayToUnsignedInt(IIR_2011.getBytes(2, is));
            if (representationHeader.rollAngleUncertainty == 0) {
                byte[] defaultRollAngleUncertainty = new byte[]{-1, -1};
                representationHeader.rollAngleUncertainty = UtilHelper.NUMERIC(defaultRollAngleUncertainty);
            }
            representationHeader.irisCentreSmallestX = UtilHelper.NUMERIC(IIR_2011.getBytes(2, is));
            representationHeader.irisCentreLargestX = UtilHelper.NUMERIC(IIR_2011.getBytes(2, is));
            representationHeader.irisCentreSmallestY = UtilHelper.NUMERIC(IIR_2011.getBytes(2, is));
            representationHeader.irisCentreLargestY = UtilHelper.NUMERIC(IIR_2011.getBytes(2, is));
            representationHeader.irisDiameterSmallest = UtilHelper.NUMERIC(IIR_2011.getBytes(2, is));
            representationHeader.irisDiameterLargest = UtilHelper.NUMERIC(IIR_2011.getBytes(2, is));
            representationHeader.imageLength = UtilHelper.byteArrayToUnsignedInt(IIR_2011.getBytes(4, is));
            if (iso_parsing_strict && (expectedImageLength = (int)representationHeader.representationLength - 52 - lengthOfQualityBlock * 5) != representationHeader.imageLength) {
                throw new IOException("Image Length Mismatch");
            }
            representationHeader.imageData = IIR_2011.getBytes(representationHeader.imageLength, is);
        }
        return iir;
    }

    private static byte[] getBytes(int nb, InputStream is) throws IOException {
        byte[] data = new byte[nb];
        int r = is.read(data);
        if (r != nb) {
            throw new IOException("read less bytes than expected");
        }
        return data;
    }

    private static byte[] getBytes(long nb, InputStream is) throws IOException {
        if (nb < Integer.MAX_VALUE) {
            return IIR_2011.getBytes((int)nb, is);
        }
        throw new RuntimeException("not implemented yet");
    }

    public static class RepresentationHeader {
        public long representationLength;
        public int captureDeviceTechnologyIdentifier;
        public int captureDeviceVendorId;
        public int captureDeviceTypeId;
        public int representationNumber;
        public int eyeLabel;
        public int imageType;
        public int imageFormat;
        public int horizontalOrientation;
        public int verticalOrientation;
        public int compressionHistory;
        public int imageWidth;
        public int imageHeight;
        public int bitDepth;
        public int range;
        public int rollAngleOfEye;
        public int rollAngleUncertainty;
        public int irisCentreSmallestX;
        public int irisCentreLargestX;
        public int irisCentreSmallestY;
        public int irisCentreLargestY;
        public int irisDiameterSmallest;
        public int irisDiameterLargest;
        public int imageLength;
        public byte[] imageData;
        public List<QualityBlock> qualityBlockList;

        public String toString() {
            String nl = System.getProperty("line.separator", "\n");
            StringBuilder sb = new StringBuilder();
            sb.append("RepresentationLength : ").append(this.representationLength).append(nl);
            sb.append("CaptureDeviceTechnologyIdentifier : ").append(this.captureDeviceTechnologyIdentifier).append(nl);
            sb.append("CaptureDeviceVendorId : ").append(this.captureDeviceVendorId).append(nl);
            sb.append("CaptureDeviceTypeId : ").append(this.captureDeviceTypeId).append(nl);
            sb.append("RepresentationNumber : ").append(this.representationNumber).append(nl);
            sb.append("EyeLabel : ").append(this.eyeLabel).append(nl);
            sb.append("ImageType : ").append(this.imageType).append(nl);
            sb.append("ImageFormat : ").append(this.imageFormat).append(nl);
            sb.append("HorizontalOrientation : ").append(this.horizontalOrientation).append(nl);
            sb.append("VerticalOrientation : ").append(this.verticalOrientation).append(nl);
            sb.append("CompressionHistory : ").append(this.compressionHistory).append(nl);
            sb.append("ImageWidth : ").append(this.imageWidth).append(nl);
            sb.append("ImageHeight : ").append(this.imageHeight).append(nl);
            sb.append("BitDepth : ").append(this.bitDepth).append(nl);
            sb.append("Range : ").append(this.range).append(nl);
            sb.append("RollAngleOfEye : ").append(this.rollAngleOfEye).append(nl);
            sb.append("RollAngleUncertainty : ").append(this.rollAngleUncertainty).append(nl);
            sb.append("IrisCentreSmallestX : ").append(this.irisCentreSmallestX).append(nl);
            sb.append("IrisCentreLargestX : ").append(this.irisCentreLargestX).append(nl);
            sb.append("IrisCentreSmallestY : ").append(this.irisCentreSmallestY).append(nl);
            sb.append("IrisCentreLargestY : ").append(this.irisCentreLargestY).append(nl);
            sb.append("IrisDiameterSmallest : ").append(this.irisDiameterSmallest).append(nl);
            sb.append("IrisDiameterLargest : ").append(this.irisDiameterLargest).append(nl);
            sb.append("ImageLength : ").append(this.imageLength).append(nl);
            sb.append("ImageData : ").append(this.imageData.length).append(" bytes").append(nl);
            if (this.qualityBlockList != null) {
                sb.append("QualityBlock-LIST (").append(this.qualityBlockList.size()).append(")").append(nl);
                for (QualityBlock qualityBlock : this.qualityBlockList) {
                    sb.append(qualityBlock);
                }
            } else {
                sb.append("QualityBlock-LIST: ").append("No Quality Block present").append(nl);
            }
            return sb.toString();
        }
    }

    public static class QualityBlock {
        public int qualityScore;
        public int qualityAlgorithmVendorIdentifier;
        public int qualityAlgorithmIdentifier;

        public String toString() {
            String nl = System.getProperty("line.separator", "\n");
            StringBuilder sb = new StringBuilder();
            sb.append("QualityScore : ").append(this.qualityScore).append(nl);
            sb.append("QualityAlgorithmVendorIdentifier : ").append(this.qualityAlgorithmVendorIdentifier).append(nl);
            sb.append("QualityAlgorithmIdentifier : ").append(this.qualityAlgorithmIdentifier).append(nl);
            return sb.toString();
        }
    }

    public static class Header {
        public String formatIdentifier = "IIR\u0000";
        public String versionNumber = "010\u0000";
        public long recordLength;
        public int numberOfIrisRepresentations;
        public final int certificationFlag = 0;
        public int numberOfEyesRepresented;

        public String toString() {
            String nl = System.getProperty("line.separator", "\n");
            StringBuilder sb = new StringBuilder();
            sb.append("FormatIdentifier : ").append(this.formatIdentifier).append(nl);
            sb.append("VersionNumber : ").append(this.versionNumber).append(nl);
            sb.append("RecordLength : ").append(this.recordLength).append(nl);
            sb.append("NumberOfIrisRepresentations : ").append(this.numberOfIrisRepresentations).append(nl);
            sb.append("CertificationFlag : ").append(0).append(nl);
            sb.append("NumberOfEyesRepresented : ").append(this.numberOfEyesRepresented).append(nl);
            return sb.toString();
        }
    }
}

