/*
 * Decompiled with CFR 0.152.
 */
package com.l1id.uid.iso19794_2011;

import com.l1id.uid.iso19794_2011.IIR_2011;
import java.util.List;

public class ValidateHeaders {
    public static void basicCheck(IIR_2011 iir, int actualRecordLength) throws Exception {
        if (!iir.header.formatIdentifier.equals("IIR\u0000")) {
            throw new Exception("Not a valid ISO record");
        }
        if (!iir.header.versionNumber.equals("020\u0000")) {
            throw new Exception("Not a valid IRIS 2011 ISO record");
        }
        if (iir.header.recordLength != (long)actualRecordLength) {
            throw new Exception("Record length mismatch encoded length:" + iir.header.recordLength + " vs Real " + actualRecordLength);
        }
    }

    public static void validateIrisHeaders(IIR_2011 iir) throws Exception {
        if (iir.header.certificationFlag != 0) {
            throw new Exception("Certification flag other than 0 is unsupported in this part of ISO/IEC 19794");
        }
        if (iir.header.numberOfEyesRepresented != 0 && iir.header.numberOfEyesRepresented != 1 && iir.header.numberOfEyesRepresented != 2) {
            throw new Exception("Not a valid ISO record");
        }
        List<IIR_2011.RepresentationHeader> representationHeaders = iir.irisList;
        for (IIR_2011.RepresentationHeader representationHeader : representationHeaders) {
            if (representationHeader.representationNumber < 1 || representationHeader.representationNumber > 65536) {
                throw new Exception("Not a valid IRIS 2011 ISO record. Representation Number should be in the range of 1 and 65536");
            }
            if (representationHeader.eyeLabel != 0 && representationHeader.eyeLabel != 1 && representationHeader.eyeLabel != 2) {
                throw new Exception("Not a valid IRIS 2011 ISO record. Eye Label should be either of 0,1 or 2");
            }
            if (representationHeader.imageType != 1 && representationHeader.imageType != 2 && representationHeader.imageType != 3 && representationHeader.imageType != 7) {
                throw new Exception("Not a valid IRIS 2011 ISO record. Image type should be either of 1,2 3 or 7");
            }
            if (representationHeader.imageFormat == 2 || representationHeader.imageFormat == 10 || representationHeader.imageFormat == 14) continue;
            throw new Exception("Not a valid IRIS 2011 ISO record. Image format should be either of 2, 10 or 14.");
        }
    }
}

