/*
 * Decompiled with CFR 0.152.
 */
package com.l1id.uid.qssitv;

import com.identix.uidai.cbeff.FacialISO;
import com.identix.uidai.cbeff.FingerISO;
import com.identix.uidai.cbeff.ImageStruct;
import com.identix.uidai.cbeff.IrisISO;
import com.identix.uidai.cbeff.IrisImageStruct;
import com.l1id.sdk.foundation.Blob;
import com.l1id.sdk.foundation.Image;
import com.l1id.sdk.foundation.Types;
import com.l1id.sdk.foundation.WriteImageDescriptor;
import com.l1id.uid.iso19794_2011.IIR_2011;
import com.l1id.uid.iso19794_2011.ValidateHeaders;
import com.l1id.uid.qssitv.L1QAModule;
import helper.UtilHelper;
import in.gov.uidai.qssitv.model.FormatType;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ImageConverter {
    ImageConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] convertTo(Logger L1_LOGGER, byte[] inputA, FormatType outputTypeA, boolean iso_parsing_strict) {
        WriteImageDescriptor writeImageDescL = new WriteImageDescriptor();
        List<Object> representationHeaders = new ArrayList();
        try {
            Object i$;
            Vector<IrisImageStruct> irisImageStructVectorL;
            boolean isFinger = false;
            boolean isIris = false;
            boolean isFace = false;
            boolean isIris2011 = false;
            Types.Modality modalityL = Types.Modality.Unknown;
            if (inputA == null) {
                L1_LOGGER.error((Object)"Input image data null, FIR or IIR expected.");
                byte[] byArray = null;
                return byArray;
            }
            if (inputA[0] == 70 && inputA[1] == 73 && inputA[2] == 82) {
                isFinger = true;
                modalityL = Types.Modality.Fingerprint;
            } else if (inputA[0] == 73 && inputA[1] == 73 && inputA[2] == 82) {
                isIris = true;
                modalityL = Types.Modality.Iris;
            } else if (inputA[0] == 70 && inputA[1] == 65 && inputA[2] == 67) {
                isFace = true;
                modalityL = Types.Modality.Face;
            } else {
                L1_LOGGER.error((Object)"Unsupported image data format, FIR or IIR expected.");
                byte[] byArray = null;
                return byArray;
            }
            Vector<IrisImageStruct> dataVec = null;
            byte[] data = null;
            if (isFinger) {
                dataVec = FingerISO.getImagesFromPackage((byte[])inputA, (boolean)iso_parsing_strict);
            } else if (isIris) {
                irisImageStructVectorL = new Vector<IrisImageStruct>();
                char c = UtilHelper.byteToChar(inputA[4]);
                char j = UtilHelper.byteToChar(inputA[5]);
                char k = UtilHelper.byteToChar(inputA[6]);
                char l = UtilHelper.byteToChar(inputA[7]);
                if (c == '0' && j == '2' && k == '0' && l == '\u0000') {
                    isIris2011 = true;
                    ByteArrayInputStream is = new ByteArrayInputStream(inputA);
                    IIR_2011 iir = IIR_2011.readFromStream(is, iso_parsing_strict);
                    L1_LOGGER.info((Object)"Basic header check in place for IRIS 2011 image record.");
                    ValidateHeaders.basicCheck(iir, inputA.length);
                    if (iso_parsing_strict) {
                        L1_LOGGER.info((Object)"More rigorous header check in place for IRIS 2011 image record.");
                        ValidateHeaders.validateIrisHeaders(iir);
                    }
                    representationHeaders = iir.irisList;
                    irisImageStructVectorL = L1QAModule.getImagesFromPackage(iir);
                } else {
                    irisImageStructVectorL = IrisISO.getImagesFromPackage((byte[])inputA, (boolean)iso_parsing_strict);
                }
                dataVec = new Vector<IrisImageStruct>(irisImageStructVectorL.size());
                i$ = irisImageStructVectorL.iterator();
                while (i$.hasNext()) {
                    IrisImageStruct irisImageStruct = (IrisImageStruct)i$.next();
                    dataVec.add(irisImageStruct);
                }
            } else {
                dataVec = FacialISO.getImagesFromPackage((byte[])inputA, (boolean)iso_parsing_strict);
            }
            if (dataVec.size() > 1) {
                L1_LOGGER.error((Object)"Failed to convert ISO record. Multiple images in one ISO record not supported");
                irisImageStructVectorL = null;
                return irisImageStructVectorL;
            }
            for (ImageStruct imageStruct : dataVec) {
                Image l1Image = null;
                Blob blobL = null;
                try {
                    boolean noRecompressionNeededL = false;
                    switch (imageStruct.getImageType()) {
                        case 2: {
                            if (outputTypeA != FormatType.JPEG) break;
                            noRecompressionNeededL = true;
                            break;
                        }
                        case 0: {
                            if (outputTypeA != FormatType.JPEG2) break;
                            noRecompressionNeededL = true;
                            break;
                        }
                        case 1: {
                            if (outputTypeA != FormatType.JPEG2) break;
                            noRecompressionNeededL = true;
                            break;
                        }
                        case 3: {
                            if (outputTypeA != FormatType.JPEG) break;
                            noRecompressionNeededL = true;
                            break;
                        }
                        case 4: {
                            if (outputTypeA != FormatType.JPEG) break;
                            noRecompressionNeededL = true;
                            break;
                        }
                        case 5: {
                            if (outputTypeA != FormatType.JPEG) break;
                            noRecompressionNeededL = true;
                            break;
                        }
                        case 7: {
                            if (outputTypeA != FormatType.PNG) break;
                            noRecompressionNeededL = true;
                            break;
                        }
                        case 6: {
                            if (outputTypeA != FormatType.WSQ) break;
                            noRecompressionNeededL = true;
                            break;
                        }
                    }
                    if (noRecompressionNeededL) {
                        i$ = inputA;
                        return i$;
                    }
                    if (isIris) {
                        int imageType = !isIris2011 ? L1QAModule.getImageFormatFromIIR(L1_LOGGER, inputA) : imageStruct.getImageType();
                        l1Image = L1QAModule.createFoundationImage(L1_LOGGER, imageStruct.getImage(), imageStruct.getWidth(), imageStruct.getHeight(), imageType, modalityL);
                    } else {
                        l1Image = L1QAModule.createFoundationImage(L1_LOGGER, imageStruct, modalityL);
                    }
                    if (l1Image == null) {
                        L1_LOGGER.error((Object)"ISO Parsing Failed: no image data present.");
                        byte[] imageType = null;
                        return imageType;
                    }
                    Types.ImageFormat outputTypeL = Types.ImageFormat.Jpeg;
                    byte fingerImageFormatL = 0;
                    byte irisImageFormatL = 0;
                    byte faceImageFormatL = 0;
                    switch (outputTypeA) {
                        case JPEG: {
                            outputTypeL = Types.ImageFormat.Jpeg;
                            fingerImageFormatL = 3;
                            faceImageFormatL = 0;
                            if (isIris2011) {
                                L1_LOGGER.error((Object)"Output type JPEG not supported for iris 2011 images.");
                                byte[] byArray = null;
                                return byArray;
                            }
                            if (l1Image.getBitCount() == 8) {
                                irisImageFormatL = 6;
                                break;
                            }
                            irisImageFormatL = 8;
                            break;
                        }
                        case JPEG2: {
                            outputTypeL = Types.ImageFormat.Jpeg2000;
                            fingerImageFormatL = 4;
                            faceImageFormatL = 1;
                            if (!isIris2011) {
                                if (l1Image.getBitCount() == 8) {
                                    irisImageFormatL = 14;
                                    break;
                                }
                                irisImageFormatL = 16;
                                break;
                            }
                            irisImageFormatL = 10;
                            break;
                        }
                        case PNG: {
                            outputTypeL = Types.ImageFormat.Png;
                            fingerImageFormatL = 5;
                            if (isIris && !isIris2011) {
                                L1_LOGGER.error((Object)"Output type PNG not supported for iris.");
                                byte[] byArray = null;
                                return byArray;
                            }
                            if (isIris && isIris2011) {
                                irisImageFormatL = 14;
                            }
                            if (!isFace) break;
                            L1_LOGGER.error((Object)"Output type PNG not supported for face.");
                            byte[] byArray = null;
                            return byArray;
                        }
                        case BMP: {
                            outputTypeL = Types.ImageFormat.Bmp;
                            if (isFinger) {
                                L1_LOGGER.error((Object)"Output type BMP not supported for finger.");
                                byte[] byArray = null;
                                return byArray;
                            }
                            if (isIris) {
                                L1_LOGGER.error((Object)"Output type BMP not supported for iris.");
                                byte[] byArray = null;
                                return byArray;
                            }
                            if (!isFace) break;
                            L1_LOGGER.error((Object)"Output type BMP not supported for face.");
                            byte[] byArray = null;
                            return byArray;
                        }
                        case WSQ: {
                            outputTypeL = Types.ImageFormat.Wsq;
                            fingerImageFormatL = 2;
                            if (isIris) {
                                L1_LOGGER.error((Object)"Output type WSQ not supported for iris.");
                                byte[] byArray = null;
                                return byArray;
                            }
                            if (!isFace) break;
                            L1_LOGGER.error((Object)"Output type WSQ not supported for face.");
                            byte[] byArray = null;
                            return byArray;
                        }
                        default: {
                            L1_LOGGER.error((Object)("Unsupported output type: " + outputTypeA));
                            byte[] byArray = null;
                            return byArray;
                        }
                    }
                    blobL = l1Image.writeToBlob(outputTypeL, writeImageDescL);
                    data = blobL.getData();
                    if (isFinger) {
                        data = L1QAModule.replaceImageDataInFIR(L1_LOGGER, inputA, data, fingerImageFormatL);
                        continue;
                    }
                    if (isIris) {
                        int i = imageStruct.getViewNumber();
                        if (isIris2011) {
                            data = L1QAModule.replaceImageDataIn2011IIR(L1_LOGGER, inputA, data, irisImageFormatL, (IIR_2011.RepresentationHeader)representationHeaders.get(i - 1));
                            continue;
                        }
                        data = L1QAModule.replaceImageDataInIIR(L1_LOGGER, inputA, data, irisImageFormatL);
                        continue;
                    }
                    data = L1QAModule.replaceImageDataInFAC(L1_LOGGER, inputA, data, faceImageFormatL);
                }
                finally {
                    if (l1Image != null) {
                        l1Image.dispose();
                    }
                    if (blobL == null) continue;
                    blobL.dispose();
                }
            }
            byte[] byArray = data;
            return byArray;
        }
        catch (Exception ce) {
            L1_LOGGER.fatal((Object)"Failed to convert image.", (Throwable)ce);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            writeImageDescL.dispose();
        }
    }
}

