/*
 * Decompiled with CFR 0.152.
 */
package com.l1id.uid.qssitv;

import com.l1id.sdk.foundation.Blob;
import com.l1id.sdk.foundation.Common;
import com.l1id.sdk.foundation.CustomException;
import com.l1id.sdk.foundation.IdRecord;
import com.l1id.sdk.foundation.ProbeDescriptor;
import com.l1id.sdk.foundation.ResultList;
import com.l1id.sdk.foundation.TemplateMatcher;
import com.l1id.sdk.foundation.Types;
import com.l1id.sdk.foundation.Verifier;
import com.l1id.uid.qssitv.L1QAModule;
import com.l1id.uid.qssitv.L1QSSEngine;
import com.l1id.uid.qssitv.Version;
import in.gov.uidai.qssitv.model.BiometricError;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.qssitv.model.BiometricTemplate;
import in.gov.uidai.qssitv.spi.IITVEngine;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class L1ITVEngine
implements IITVEngine {
    private static final String CONFIG_FILE_NAME = "/conf/l1itvengine.properties";
    private TemplateMatcher _faceMatcher = null;
    private TemplateMatcher _irisMatcher = null;
    private TemplateMatcher _fingerMatcher = null;
    private String _faceCachePath = "/cache/Face";
    private String _fingerCachePath = "/cache/Finger";
    private String _irisCachePath = "/cache/Iris";
    private static long _faceMaxTransactionID = 0L;
    private static long _fingerMaxTransactionID = 0L;
    private static long _irisMaxTransactionID = 0L;
    private static ReentrantLock WL_LOCK = null;
    private static BlockingQueue<L1QSSEngine> _faceTemplateCreatorHandlePool = null;
    private static BlockingQueue<L1QSSEngine> _fingerTemplateCreatorHandlePool = null;
    private static BlockingQueue<L1QSSEngine> _irisTemplateCreatorHandlePool = null;
    private static BlockingQueue<Verifier> _faceVerificationHandlePool = null;
    private static BlockingQueue<Verifier> _fingerVerificationHandlePool = null;
    private static BlockingQueue<Verifier> _irisVerificationHandlePool = null;
    private static boolean _faceTemplateCreation = false;
    private static boolean _fingerTemplateCreation = false;
    private static boolean _irisTemplateCreation = false;
    private static boolean _faceVerification = false;
    private static boolean _fingerVerification = false;
    private static boolean _irisVerification = false;
    private static boolean _faceIdentification = false;
    private static boolean _fingerIdentification = false;
    private static boolean _irisIdentification = false;
    private static boolean _irisVerificationRotate180 = false;
    private static boolean _fingerVerificationEnableScoreCorrection = false;
    private static int _faceTemplateCreationThreads = 1;
    private static int _fingerTemplateCreationThreads = 1;
    private static int _irisTemplateCreationThreads = 1;
    private static int _faceVerificationThreads = 1;
    private static int _fingerVerificationThreads = 1;
    private static int _irisVerificationThreads = 1;
    private static double _fingerVerificationScoreScale = 1.0;
    private static double _fingerVerificationScoreShift = 0.0;
    private static double _fingerIdentificationScoreScale = 1.0;
    private static double _fingerIdentificationScoreShift = 0.0;
    private static double _fingerVerificationNumberOfMatchesFactor = 1.0;
    private static double _irisScoreScale = 1.0;
    private static double _irisScoreShift = 0.0;
    private static double _faceScoreScale = 1.0;
    private static double _faceScoreShift = 0.0;
    private static final Logger L1_LOGGER = Logger.getLogger(L1ITVEngine.class);
    private static final String newLine = System.getProperty("line.separator");
    static String homeFolderS;

    static synchronized String getHomeFolder() {
        if (homeFolderS == null) {
            String homeFolder = System.getenv("L1_HOME");
            if (homeFolder == null) {
                homeFolder = System.getProperty("L1_HOME");
            }
            L1_LOGGER.info((Object)("'L1_HOME' is set to : " + homeFolder));
            if (homeFolder == null) {
                L1_LOGGER.fatal((Object)"'L1_HOME' is not set");
                throw new RuntimeException("'L1_HOME' is not set");
            }
            if (!new File(homeFolder + "/conf").canRead()) {
                L1_LOGGER.fatal((Object)"not able to find/read 'conf' folder inside 'L1_HOME'");
                throw new RuntimeException("not able to find/read 'conf' folder inside 'L1_HOME'");
            }
            try {
                L1_LOGGER.info((Object)("setting foundation folder to : " + homeFolder));
                Common.setGlobalConfigurationPath((String)homeFolder);
                if (!new File(homeFolder + "/config").canRead()) {
                    L1_LOGGER.fatal((Object)"not able to find/read 'config' folder inside 'L1_HOME'");
                    throw new RuntimeException("not able to find 'config' folder inside 'L1_HOME'");
                }
            }
            catch (CustomException ex) {
                L1_LOGGER.fatal((Object)"failed to resolve foundation folder", (Throwable)ex);
                throw new RuntimeException("failed to resolve foundation folder", ex);
            }
            L1_LOGGER.info((Object)"'L1_HOME' check ok");
            homeFolderS = homeFolder;
        }
        return homeFolderS;
    }

    public L1ITVEngine() {
        WL_LOCK = new ReentrantLock(true);
        try {
            int i;
            this.loadConfig(L1ITVEngine.getHomeFolder() + CONFIG_FILE_NAME);
            if (_faceTemplateCreation) {
                _faceTemplateCreatorHandlePool = new ArrayBlockingQueue<L1QSSEngine>(_faceTemplateCreationThreads, true);
                for (i = 0; i < _faceTemplateCreationThreads; ++i) {
                    L1_LOGGER.info((Object)("Intializing the Face Template Creator : " + i));
                    _faceTemplateCreatorHandlePool.add(new L1QSSEngine(true, false, false));
                }
            }
            if (_fingerTemplateCreation) {
                _fingerTemplateCreatorHandlePool = new ArrayBlockingQueue<L1QSSEngine>(_fingerTemplateCreationThreads, true);
                for (i = 0; i < _fingerTemplateCreationThreads; ++i) {
                    L1_LOGGER.info((Object)("Intializing the Finger Template Creator : " + i));
                    _fingerTemplateCreatorHandlePool.add(new L1QSSEngine(false, true, false));
                }
            }
            if (_irisTemplateCreation) {
                _irisTemplateCreatorHandlePool = new ArrayBlockingQueue<L1QSSEngine>(_irisTemplateCreationThreads, true);
                for (i = 0; i < _irisTemplateCreationThreads; ++i) {
                    L1_LOGGER.info((Object)("Intializing the Iris Template Creator : " + i));
                    _irisTemplateCreatorHandlePool.add(new L1QSSEngine(false, false, true));
                }
            }
            if (_faceVerification) {
                _faceVerificationHandlePool = new ArrayBlockingQueue<Verifier>(_faceVerificationThreads, true);
                for (i = 0; i < _faceVerificationThreads; ++i) {
                    L1_LOGGER.info((Object)("Intializing the Face Verifier : " + i));
                    _faceVerificationHandlePool.add(new Verifier("verify_engine_face"));
                }
            }
            if (_fingerVerification) {
                _fingerVerificationHandlePool = new ArrayBlockingQueue<Verifier>(_fingerVerificationThreads, true);
                for (i = 0; i < _fingerVerificationThreads; ++i) {
                    L1_LOGGER.info((Object)("Intializing the Finger Verifier : " + i));
                    _fingerVerificationHandlePool.add(new Verifier("verify_engine_finger"));
                }
            }
            if (_irisVerification) {
                _irisVerificationHandlePool = new ArrayBlockingQueue<Verifier>(_irisVerificationThreads, true);
                for (i = 0; i < _irisVerificationThreads; ++i) {
                    L1_LOGGER.info((Object)("Intializing the Iris Verifier : " + i));
                    _irisVerificationHandlePool.add(new Verifier("verify_engine_iris"));
                }
            }
            L1_LOGGER.info((Object)"Intializing the Galleries");
            this.initializeGallery();
        }
        catch (CustomException ex) {
            L1_LOGGER.error(null, (Throwable)ex);
        }
    }

    public static String getVersion() {
        return Version.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BiometricTemplate> getFingerTemplate(byte[] input, List<BiometricPosition> missingfingers, int age, boolean iso) {
        if (!_fingerTemplateCreation) {
            L1_LOGGER.warn((Object)"ITVEngine is not initialized to create finger templates - check your config");
            return null;
        }
        L1QSSEngine _qssEngine = null;
        try {
            _qssEngine = _fingerTemplateCreatorHandlePool.take();
            L1_LOGGER.info((Object)"Creating Finger Templates");
            List<BiometricTemplate> proprietaryTemplates = _qssEngine.getTemplatesForFinger(input, missingfingers, iso);
            if (iso) {
                L1_LOGGER.info((Object)"Converting to ISO");
                List<BiometricTemplate> list = _qssEngine.convertProprietaryTemplateToISO(proprietaryTemplates, iso);
                return list;
            }
            L1_LOGGER.info((Object)"Done Creating Finger Templates");
            List<BiometricTemplate> list = proprietaryTemplates;
            return list;
        }
        catch (Exception ex) {
            L1_LOGGER.error((Object)"Failed to retrieve QSSEngine(finger) / Error during get Finger Template", (Throwable)ex);
            List<BiometricTemplate> list = null;
            return list;
        }
        finally {
            L1_LOGGER.info((Object)"Releasing QSSEngine(finger)");
            _fingerTemplateCreatorHandlePool.offer(_qssEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BiometricTemplate> getFaceTemplate(byte[] input, boolean iso) {
        if (!_faceTemplateCreation) {
            L1_LOGGER.warn((Object)"ITVEngine is not initialized to create face templates - check your config");
            return null;
        }
        L1QSSEngine _qssEngine = null;
        try {
            _qssEngine = _faceTemplateCreatorHandlePool.take();
            L1_LOGGER.info((Object)"Creating Face Templates");
            List<BiometricTemplate> list = _qssEngine.getTemplatesForFace(input, true);
            return list;
        }
        catch (Exception ex) {
            L1_LOGGER.error((Object)"Failed to retrieve QSSEngine(face) / Error during get Face Template", (Throwable)ex);
            List<BiometricTemplate> list = null;
            return list;
        }
        finally {
            L1_LOGGER.info((Object)"Releasing QSSEngine(face)");
            _faceTemplateCreatorHandlePool.offer(_qssEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BiometricTemplate> getIrisTemplate(byte[] input, boolean iso) {
        if (!_irisTemplateCreation) {
            L1_LOGGER.warn((Object)"ITVEngine is not initialized to create iris templates - check your config");
            return null;
        }
        L1QSSEngine _qssEngine = null;
        try {
            _qssEngine = _irisTemplateCreatorHandlePool.take();
            L1_LOGGER.info((Object)"Creating Iris Templates");
            List<BiometricTemplate> list = _qssEngine.getTemplatesForIris(input);
            return list;
        }
        catch (Exception ex) {
            L1_LOGGER.error((Object)"Failed to retrieve QSSEngine(iris) / Error during get Iris Template", (Throwable)ex);
            List<BiometricTemplate> list = null;
            return list;
        }
        finally {
            L1_LOGGER.info((Object)"Releasing QSSEngine(iris)");
            _irisTemplateCreatorHandlePool.offer(_qssEngine);
        }
    }

    public BiometricError insertFaceRecord(String encounterId, List<BiometricTemplate> faceRecords) {
        return this.insertRecord(Types.Modality.Face, encounterId, faceRecords);
    }

    public BiometricError insertFingerRecord(String encounterId, List<BiometricTemplate> fingerRecords) {
        return this.insertRecord(Types.Modality.Fingerprint, encounterId, fingerRecords);
    }

    public BiometricError insertIrisRecord(String encounterId, List<BiometricTemplate> irisRecords) {
        return this.insertRecord(Types.Modality.Iris, encounterId, irisRecords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BiometricError insertRecord(Types.Modality modalityA, String encounterIdA, List<BiometricTemplate> recordsA) {
        boolean modAvailableL = false;
        String modNameL = "";
        switch (modalityA) {
            case Fingerprint: {
                modAvailableL = _fingerIdentification;
                modNameL = "fingerprint";
                break;
            }
            case Iris: {
                modAvailableL = _irisIdentification;
                modNameL = "iris";
                break;
            }
            case Face: {
                modAvailableL = _faceIdentification;
                modNameL = "face";
                break;
            }
        }
        BiometricError error = new BiometricError();
        error.setErrorMessage("");
        if (recordsA == null) {
            String errorMessageL = "Incoming record is null.";
            error.setErrorMessage(errorMessageL);
            L1_LOGGER.error((Object)errorMessageL);
            return error;
        }
        if (!modAvailableL) {
            String errorMessageL = "ITVEngine is not initialized to identify " + modNameL + " templates - check your config.";
            error.setErrorMessage(errorMessageL);
            L1_LOGGER.error((Object)errorMessageL);
            return error;
        }
        if (encounterIdA.length() != encounterIdA.getBytes().length) {
            String errorMessageL = "Encounter Id contains special characters, only ASCII characters supported.";
            error.setErrorMessage(errorMessageL);
            L1_LOGGER.error((Object)errorMessageL);
            return error;
        }
        int maxEncounterIdSize = 0;
        try {
            switch (modalityA) {
                case Fingerprint: {
                    maxEncounterIdSize = this._fingerMatcher.getSIDSize();
                    break;
                }
                case Iris: {
                    maxEncounterIdSize = this._irisMatcher.getSIDSize();
                    break;
                }
                case Face: {
                    maxEncounterIdSize = this._faceMatcher.getSIDSize();
                    break;
                }
            }
            if (encounterIdA.length() > maxEncounterIdSize) {
                String errorMessageL = "Encounter Id too long. Maximum length is " + maxEncounterIdSize + ".";
                error.setErrorMessage(errorMessageL);
                L1_LOGGER.error((Object)errorMessageL);
                return error;
            }
        }
        catch (CustomException ex) {
            String errorMessageL = "Get maximum length of Encounter Id failed";
            error.setErrorMessage(errorMessageL);
            L1_LOGGER.error((Object)errorMessageL);
            return error;
        }
        try {
            switch (modalityA) {
                case Fingerprint: {
                    this._fingerMatcher.getTransactionIDFromSID(encounterIdA.getBytes());
                    break;
                }
                case Iris: {
                    this._irisMatcher.getTransactionIDFromSID(encounterIdA.getBytes());
                    break;
                }
                case Face: {
                    this._faceMatcher.getTransactionIDFromSID(encounterIdA.getBytes());
                    break;
                }
            }
            String errorMessageL = "Encounter with id: '" + encounterIdA + "' already exists in database.";
            error.setErrorMessage(errorMessageL);
            L1_LOGGER.error((Object)errorMessageL);
            return error;
        }
        catch (CustomException ex) {
            BiometricError biometricError;
            L1QSSEngine _qssEngine;
            Blob galleryBlobL;
            IdRecord tmpIDRecordL;
            IdRecord galleryIDRecordL;
            block83: {
                BiometricError biometricError2;
                block82: {
                    BiometricError biometricError3;
                    block81: {
                        BiometricError biometricError4;
                        block80: {
                            BiometricError biometricError5;
                            block78: {
                                block79: {
                                    galleryIDRecordL = null;
                                    tmpIDRecordL = null;
                                    galleryBlobL = null;
                                    String executionStepL = "";
                                    _qssEngine = null;
                                    try {
                                        executionStepL = "Try to get WL_LOCK.";
                                        WL_LOCK.lock();
                                        galleryIDRecordL = new IdRecord();
                                        executionStepL = "Set IDs on " + modNameL + " gallery IdRecord.";
                                        galleryIDRecordL.setSID(encounterIdA.getBytes());
                                        switch (modalityA) {
                                            case Fingerprint: {
                                                galleryIDRecordL.setPersonId(++_fingerMaxTransactionID);
                                                galleryIDRecordL.setTransactionId(_fingerMaxTransactionID);
                                                break;
                                            }
                                            case Iris: {
                                                galleryIDRecordL.setPersonId(++_irisMaxTransactionID);
                                                galleryIDRecordL.setTransactionId(_irisMaxTransactionID);
                                                break;
                                            }
                                            case Face: {
                                                galleryIDRecordL.setPersonId(++_faceMaxTransactionID);
                                                galleryIDRecordL.setTransactionId(_faceMaxTransactionID);
                                                break;
                                            }
                                        }
                                        int index = 0;
                                        executionStepL = "Perform best shot analysis (" + modNameL + ").";
                                        HashMap<Types.Instance, byte[]> bestShotMapL = new HashMap<Types.Instance, byte[]>();
                                        HashMap<Types.Instance, Float> bestQualityMapL = new HashMap<Types.Instance, Float>();
                                        for (BiometricTemplate gallery : recordsA) {
                                            byte[] galleryTemplateL;
                                            Types.Instance instanceL = Types.Instance.Unknown;
                                            switch (modalityA) {
                                                case Fingerprint: {
                                                    instanceL = L1QAModule.convertToFingerInstance(L1_LOGGER, gallery.getBiometricPosition());
                                                    break;
                                                }
                                                case Iris: {
                                                    instanceL = L1QAModule.convertToIrisInstance(L1_LOGGER, gallery.getBiometricPosition());
                                                    break;
                                                }
                                                case Face: {
                                                    instanceL = L1QAModule.convertToFaceInstance(L1_LOGGER, gallery.getBiometricPosition());
                                                    break;
                                                }
                                            }
                                            if (instanceL == Types.Instance.Unknown) {
                                                String errorMessageL = "Execution step: " + executionStepL + ": Biometric position of gallery template is Unknown.";
                                                error.setErrorMessage(errorMessageL);
                                                L1_LOGGER.error((Object)errorMessageL);
                                                biometricError5 = error;
                                                WL_LOCK.unlock();
                                                if (galleryIDRecordL == null) break block78;
                                                break block79;
                                            }
                                            if (bestShotMapL.containsKey(instanceL)) {
                                                galleryTemplateL = gallery.getGalleryTemplate();
                                                if (galleryTemplateL == null) {
                                                    String errorMessageL = "Execution step: " + executionStepL + ": gallery template is null.";
                                                    error.setErrorMessage(errorMessageL);
                                                    L1_LOGGER.error((Object)errorMessageL);
                                                    biometricError4 = error;
                                                    WL_LOCK.unlock();
                                                    break block80;
                                                } else {
                                                    float currentBestQualityL = ((Float)bestQualityMapL.get(instanceL)).floatValue();
                                                    float qualityL = 0.0f;
                                                    if (modalityA == Types.Modality.Fingerprint && L1QAModule.isFMR(galleryTemplateL)) {
                                                        qualityL = galleryTemplateL[26];
                                                    } else {
                                                        executionStepL = "Extract quality from proprietary " + modNameL + " template.";
                                                        galleryBlobL = new Blob();
                                                        galleryBlobL.setData(galleryTemplateL);
                                                        tmpIDRecordL = new IdRecord();
                                                        tmpIDRecordL.addSerializedSample(modalityA, instanceL, 1L, galleryBlobL);
                                                        qualityL = tmpIDRecordL.getSampleQuality(modalityA, instanceL, 1L).floatValue();
                                                        galleryBlobL.dispose();
                                                        galleryBlobL = null;
                                                        tmpIDRecordL.dispose();
                                                        tmpIDRecordL = null;
                                                    }
                                                    if (!(qualityL > currentBestQualityL)) continue;
                                                    bestShotMapL.put(instanceL, galleryTemplateL);
                                                    bestQualityMapL.put(instanceL, Float.valueOf(qualityL));
                                                    continue;
                                                }
                                            }
                                            galleryTemplateL = gallery.getGalleryTemplate();
                                            if (galleryTemplateL == null) {
                                                String errorMessageL = "Execution step: " + executionStepL + ": gallery template is null.";
                                                error.setErrorMessage(errorMessageL);
                                                L1_LOGGER.error((Object)errorMessageL);
                                                biometricError3 = error;
                                                WL_LOCK.unlock();
                                                break block81;
                                            }
                                            float qualityL = 0.0f;
                                            if (modalityA == Types.Modality.Fingerprint && L1QAModule.isFMR(galleryTemplateL)) {
                                                qualityL = galleryTemplateL[26];
                                            } else {
                                                executionStepL = "Extract quality from proprietary " + modNameL + " template.";
                                                galleryBlobL = new Blob();
                                                galleryBlobL.setData(galleryTemplateL);
                                                tmpIDRecordL = new IdRecord();
                                                tmpIDRecordL.addSerializedSample(modalityA, instanceL, 1L, galleryBlobL);
                                                qualityL = tmpIDRecordL.getSampleQuality(modalityA, instanceL, 1L).floatValue();
                                                galleryBlobL.dispose();
                                                galleryBlobL = null;
                                                tmpIDRecordL.dispose();
                                                tmpIDRecordL = null;
                                            }
                                            bestShotMapL.put(instanceL, galleryTemplateL);
                                            bestQualityMapL.put(instanceL, Float.valueOf(qualityL));
                                        }
                                        executionStepL = "Assemble gallery " + modNameL + " IdRecord.";
                                        for (Map.Entry galleryEntryL : bestShotMapL.entrySet()) {
                                            byte[] galleryTemplate = (byte[])galleryEntryL.getValue();
                                            galleryBlobL = new Blob();
                                            Types.Instance instanceL = (Types.Instance)galleryEntryL.getKey();
                                            if (L1QAModule.isFMR(galleryTemplate)) {
                                                executionStepL = "Taking QSSEngine(finger).";
                                                _qssEngine = _fingerTemplateCreatorHandlePool.take();
                                                executionStepL = "Convert ISO to proprietary template.";
                                                if ((galleryTemplate = _qssEngine.convertIsoToProprietaryTemplate(galleryTemplate, instanceL, Types.TemplateCreationType.Gallery)) == null) {
                                                    String errorMessageL = "Execution step: " + executionStepL + ": gallery template is null.";
                                                    error.setErrorMessage(errorMessageL);
                                                    L1_LOGGER.error((Object)errorMessageL);
                                                    biometricError2 = error;
                                                    WL_LOCK.unlock();
                                                    break block82;
                                                }
                                                executionStepL = "Releasing QSSEngine(finger).";
                                                _fingerTemplateCreatorHandlePool.offer(_qssEngine);
                                                _qssEngine = null;
                                            }
                                            galleryBlobL.setData(galleryTemplate);
                                            executionStepL = "Add serialized Sample to IdRecord.";
                                            galleryIDRecordL.addSerializedSample(modalityA, instanceL, (long)(++index), galleryBlobL);
                                            galleryBlobL.dispose();
                                            galleryBlobL = null;
                                        }
                                        executionStepL = "Add IdRecord to " + modNameL + " gallery.";
                                        switch (modalityA) {
                                            case Fingerprint: {
                                                this._fingerMatcher.add(galleryIDRecordL);
                                                break;
                                            }
                                            case Iris: {
                                                this._irisMatcher.add(galleryIDRecordL);
                                                break;
                                            }
                                            case Face: {
                                                this._faceMatcher.add(galleryIDRecordL);
                                                break;
                                            }
                                        }
                                        biometricError = null;
                                        WL_LOCK.unlock();
                                        break block83;
                                    }
                                    catch (Exception ex2) {
                                        String errorMessageL = "Execution step: " + executionStepL + ": Exception caught: " + ex2;
                                        error.setErrorMessage(errorMessageL);
                                        L1_LOGGER.error((Object)errorMessageL);
                                        BiometricError biometricError6 = error;
                                        return biometricError6;
                                    }
                                }
                                galleryIDRecordL.dispose();
                            }
                            if (tmpIDRecordL != null) {
                                tmpIDRecordL.dispose();
                            }
                            if (galleryBlobL != null) {
                                galleryBlobL.dispose();
                            }
                            if (_qssEngine == null) return biometricError5;
                            _fingerTemplateCreatorHandlePool.offer(_qssEngine);
                            return biometricError5;
                        }
                        if (galleryIDRecordL != null) {
                            galleryIDRecordL.dispose();
                        }
                        if (tmpIDRecordL != null) {
                            tmpIDRecordL.dispose();
                        }
                        if (galleryBlobL != null) {
                            galleryBlobL.dispose();
                        }
                        if (_qssEngine == null) return biometricError4;
                        _fingerTemplateCreatorHandlePool.offer(_qssEngine);
                        return biometricError4;
                    }
                    if (galleryIDRecordL != null) {
                        galleryIDRecordL.dispose();
                    }
                    if (tmpIDRecordL != null) {
                        tmpIDRecordL.dispose();
                    }
                    if (galleryBlobL != null) {
                        galleryBlobL.dispose();
                    }
                    if (_qssEngine == null) return biometricError3;
                    _fingerTemplateCreatorHandlePool.offer(_qssEngine);
                    return biometricError3;
                }
                if (galleryIDRecordL != null) {
                    galleryIDRecordL.dispose();
                }
                if (tmpIDRecordL != null) {
                    tmpIDRecordL.dispose();
                }
                if (galleryBlobL != null) {
                    galleryBlobL.dispose();
                }
                if (_qssEngine == null) return biometricError2;
                _fingerTemplateCreatorHandlePool.offer(_qssEngine);
                return biometricError2;
            }
            if (galleryIDRecordL != null) {
                galleryIDRecordL.dispose();
            }
            if (tmpIDRecordL != null) {
                tmpIDRecordL.dispose();
            }
            if (galleryBlobL != null) {
                galleryBlobL.dispose();
            }
            if (_qssEngine == null) return biometricError;
            _fingerTemplateCreatorHandlePool.offer(_qssEngine);
            return biometricError;
            finally {
                WL_LOCK.unlock();
                if (galleryIDRecordL != null) {
                    galleryIDRecordL.dispose();
                }
                if (tmpIDRecordL != null) {
                    tmpIDRecordL.dispose();
                }
                if (galleryBlobL != null) {
                    galleryBlobL.dispose();
                }
                if (_qssEngine != null) {
                    _fingerTemplateCreatorHandlePool.offer(_qssEngine);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRecords() {
        try {
            WL_LOCK.lock();
            if (this._faceMatcher != null) {
                this._faceMatcher.dispose();
                L1ITVEngine.DBClear(L1ITVEngine.getHomeFolder() + this._faceCachePath);
            }
            if (this._irisMatcher != null) {
                this._irisMatcher.dispose();
                L1ITVEngine.DBClear(L1ITVEngine.getHomeFolder() + this._irisCachePath);
            }
            if (this._fingerMatcher != null) {
                this._fingerMatcher.dispose();
                L1ITVEngine.DBClear(L1ITVEngine.getHomeFolder() + this._fingerCachePath);
            }
            this.initializeGallery();
        }
        catch (Exception ex) {
            L1_LOGGER.error((Object)"Failed to get Lock / Failed to clear DB", (Throwable)ex);
        }
        finally {
            WL_LOCK.unlock();
        }
    }

    public Map<String, Double> identifyFace(List<BiometricTemplate> faceRecords, double threshold) {
        return this.identify(Types.Modality.Face, faceRecords, 0, threshold);
    }

    public Map<String, Double> identifyIris(List<BiometricTemplate> irisRecords, double threshold) {
        return this.identify(Types.Modality.Iris, irisRecords, 0, threshold);
    }

    public Map<String, Double> identifyFinger(List<BiometricTemplate> fingerRecords, int age, double threshold) {
        return this.identify(Types.Modality.Fingerprint, fingerRecords, 0, threshold);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Double> identify(Types.Modality modalityA, List<BiometricTemplate> probeRecordsA, int ageA, double thresholdA) {
        HashMap<String, Double> hashMap;
        ProbeDescriptor probeDescriptorL;
        ResultList resultListL;
        L1QSSEngine _qssEngine;
        Blob probeBlobL;
        IdRecord tmpIDRecordL;
        IdRecord probeIDRecordL;
        block68: {
            HashMap<String, Double> hashMap2;
            block67: {
                HashMap<String, Double> hashMap3;
                block65: {
                    block66: {
                        boolean modAvailableL = false;
                        String modNameL = "";
                        switch (modalityA) {
                            case Fingerprint: {
                                modAvailableL = _fingerIdentification;
                                modNameL = "fingerprint";
                                if (this._fingerMatcher != null) break;
                                modAvailableL = false;
                                break;
                            }
                            case Iris: {
                                modAvailableL = _irisIdentification;
                                modNameL = "iris";
                                if (this._irisMatcher != null) break;
                                modAvailableL = false;
                                break;
                            }
                            case Face: {
                                modAvailableL = _faceIdentification;
                                modNameL = "face";
                                if (this._faceMatcher != null) break;
                                modAvailableL = false;
                                break;
                            }
                        }
                        if (!modAvailableL) {
                            L1_LOGGER.error((Object)("ITVEngine is not initialized to identify " + modNameL + " templates - check your config"));
                            return null;
                        }
                        probeIDRecordL = null;
                        tmpIDRecordL = null;
                        probeBlobL = null;
                        String executionStepL = "identify " + modNameL + " start.";
                        _qssEngine = null;
                        resultListL = null;
                        probeDescriptorL = null;
                        HashMap<String, Double> scores = new HashMap<String, Double>();
                        try {
                            executionStepL = "Try to get WL_LOCK.";
                            WL_LOCK.lock();
                            probeIDRecordL = new IdRecord();
                            executionStepL = "Set IDs on probe " + modNameL + "IdRecord.";
                            probeIDRecordL.setPersonId(0L);
                            probeIDRecordL.setTransactionId(0L);
                            int index = 0;
                            executionStepL = "Perform best shot analysis (" + modNameL + ").";
                            HashMap<Types.Instance, byte[]> bestShotMapL = new HashMap<Types.Instance, byte[]>();
                            HashMap<Types.Instance, Float> bestQualityMapL = new HashMap<Types.Instance, Float>();
                            for (BiometricTemplate probe : probeRecordsA) {
                                byte[] probeTemplateL;
                                Types.Instance instanceL = Types.Instance.Unknown;
                                switch (modalityA) {
                                    case Fingerprint: {
                                        instanceL = L1QAModule.convertToFingerInstance(L1_LOGGER, probe.getBiometricPosition());
                                        break;
                                    }
                                    case Iris: {
                                        instanceL = L1QAModule.convertToIrisInstance(L1_LOGGER, probe.getBiometricPosition());
                                        break;
                                    }
                                    case Face: {
                                        instanceL = L1QAModule.convertToFaceInstance(L1_LOGGER, probe.getBiometricPosition());
                                        break;
                                    }
                                }
                                if (instanceL == Types.Instance.Unknown) {
                                    String errorMessageL = "Execution step: " + executionStepL + ": Biometric position of probe template is Unknown.";
                                    L1_LOGGER.error((Object)errorMessageL);
                                    HashMap<String, Double> hashMap4 = scores;
                                    return hashMap4;
                                }
                                if (bestShotMapL.containsKey(instanceL)) {
                                    probeTemplateL = probe.getProbeTemplate();
                                    if (probeTemplateL == null) {
                                        String errorMessageL = "Execution step: " + executionStepL + ": probe template is null.";
                                        L1_LOGGER.error((Object)errorMessageL);
                                        hashMap3 = scores;
                                        WL_LOCK.unlock();
                                        if (probeIDRecordL == null) break block65;
                                        break block66;
                                    }
                                    float currentBestQualityL = ((Float)bestQualityMapL.get(instanceL)).floatValue();
                                    float qualityL = 0.0f;
                                    if (modalityA == Types.Modality.Fingerprint && L1QAModule.isFMR(probeTemplateL)) {
                                        qualityL = probeTemplateL[26];
                                    } else {
                                        executionStepL = "Extract quality from proprietary " + modNameL + "template.";
                                        probeBlobL = new Blob();
                                        probeBlobL.setData(probeTemplateL);
                                        tmpIDRecordL = new IdRecord();
                                        tmpIDRecordL.addSerializedSample(modalityA, instanceL, 1L, probeBlobL);
                                        qualityL = tmpIDRecordL.getSampleQuality(modalityA, instanceL, 1L).floatValue();
                                        probeBlobL.dispose();
                                        probeBlobL = null;
                                        tmpIDRecordL.dispose();
                                        tmpIDRecordL = null;
                                    }
                                    if (!(qualityL > currentBestQualityL)) continue;
                                    bestShotMapL.put(instanceL, probeTemplateL);
                                    bestQualityMapL.put(instanceL, Float.valueOf(qualityL));
                                    continue;
                                }
                                probeTemplateL = probe.getProbeTemplate();
                                if (probeTemplateL == null) {
                                    String errorMessageL = "Execution step: " + executionStepL + ": probe template is null.";
                                    L1_LOGGER.error((Object)errorMessageL);
                                    hashMap2 = scores;
                                    WL_LOCK.unlock();
                                    break block67;
                                }
                                float qualityL = 0.0f;
                                if (modalityA == Types.Modality.Fingerprint && L1QAModule.isFMR(probeTemplateL)) {
                                    qualityL = probeTemplateL[26];
                                } else {
                                    probeBlobL = new Blob();
                                    executionStepL = "Extract quality from proprietary " + modNameL + " template.";
                                    probeBlobL.setData(probeTemplateL);
                                    tmpIDRecordL = new IdRecord();
                                    tmpIDRecordL.addSerializedSample(modalityA, instanceL, 1L, probeBlobL);
                                    qualityL = tmpIDRecordL.getSampleQuality(modalityA, instanceL, 1L).floatValue();
                                    probeBlobL.dispose();
                                    probeBlobL = null;
                                    tmpIDRecordL.dispose();
                                    tmpIDRecordL = null;
                                }
                                bestShotMapL.put(instanceL, probeTemplateL);
                                bestQualityMapL.put(instanceL, Float.valueOf(qualityL));
                            }
                            executionStepL = "Assemble probe " + modNameL + " IdRecord.";
                            for (Map.Entry probeEntryL : bestShotMapL.entrySet()) {
                                byte[] probeTemplateL = (byte[])probeEntryL.getValue();
                                probeBlobL = new Blob();
                                Types.Instance instanceL = (Types.Instance)probeEntryL.getKey();
                                if (modalityA == Types.Modality.Fingerprint && L1QAModule.isFMR(probeTemplateL)) {
                                    executionStepL = "Convert ISO " + modNameL + " to proprietary template. Taking QSSEngine(finger).";
                                    _qssEngine = _fingerTemplateCreatorHandlePool.take();
                                    executionStepL = "Convert ISO to proprietary template.";
                                    if ((probeTemplateL = _qssEngine.convertIsoToProprietaryTemplate(probeTemplateL, instanceL, Types.TemplateCreationType.Gallery)) == null) {
                                        String errorMessageL = "Execution step: " + executionStepL + ": converted probe template is null.";
                                        L1_LOGGER.error((Object)errorMessageL);
                                        hashMap = scores;
                                        WL_LOCK.unlock();
                                        break block68;
                                    }
                                    executionStepL = "Convert ISO to proprietary template. Releasing QSSEngine(finger).";
                                    _fingerTemplateCreatorHandlePool.offer(_qssEngine);
                                    _qssEngine = null;
                                }
                                probeBlobL.setData(probeTemplateL);
                                executionStepL = "Add serialized Sample to IdRecord.";
                                probeIDRecordL.addSerializedSample(modalityA, instanceL, (long)(++index), probeBlobL);
                                probeBlobL.dispose();
                                probeBlobL = null;
                            }
                            executionStepL = "Perform identify.";
                            probeDescriptorL = new ProbeDescriptor();
                            switch (modalityA) {
                                case Fingerprint: {
                                    resultListL = this._fingerMatcher.identify(probeIDRecordL, probeDescriptorL);
                                    break;
                                }
                                case Iris: {
                                    resultListL = this._irisMatcher.identify(probeIDRecordL, probeDescriptorL);
                                    break;
                                }
                                case Face: {
                                    resultListL = this._faceMatcher.identify(probeIDRecordL, probeDescriptorL);
                                    break;
                                }
                            }
                            switch (modalityA) {
                                case Fingerprint: {
                                    for (int i = 0; i < resultListL.length(); ++i) {
                                        double tempScore = L1ITVEngine.mapFingerIdentificationScore((double)resultListL.getScore(i, Types.Modality.Unknown) * 10.0);
                                        if (!(tempScore > thresholdA)) continue;
                                        scores.put(new String(resultListL.getSID(i)), new Double(tempScore));
                                    }
                                    break;
                                }
                                case Iris: {
                                    for (int i = 0; i < resultListL.length(); ++i) {
                                        double tempScore = L1ITVEngine.mapIrisScore((double)resultListL.getScore(i, Types.Modality.Unknown) * 10.0);
                                        if (!(tempScore > thresholdA)) continue;
                                        scores.put(new String(resultListL.getSID(i)), new Double(tempScore));
                                    }
                                    break;
                                }
                                case Face: {
                                    for (int i = 0; i < resultListL.length(); ++i) {
                                        double tempScore = L1ITVEngine.mapFaceScore(resultListL.getScore(i, Types.Modality.Unknown) * 10.0f);
                                        if (!(tempScore > thresholdA)) continue;
                                        scores.put(new String(resultListL.getSID(i)), new Double(tempScore));
                                    }
                                    break;
                                }
                            }
                            HashMap<String, Double> hashMap5 = scores;
                            return hashMap5;
                        }
                        catch (Exception ex) {
                            String errorMessageL = "Execution step: " + executionStepL + ": Exception caught: " + ex;
                            L1_LOGGER.error((Object)errorMessageL);
                            HashMap<String, Double> hashMap6 = scores;
                            return hashMap6;
                        }
                    }
                    probeIDRecordL.dispose();
                }
                if (tmpIDRecordL != null) {
                    tmpIDRecordL.dispose();
                }
                if (probeBlobL != null) {
                    probeBlobL.dispose();
                }
                if (probeDescriptorL != null) {
                    probeDescriptorL.dispose();
                }
                if (resultListL != null) {
                    resultListL.dispose();
                }
                if (_qssEngine == null) return hashMap3;
                _fingerTemplateCreatorHandlePool.offer(_qssEngine);
                return hashMap3;
            }
            if (probeIDRecordL != null) {
                probeIDRecordL.dispose();
            }
            if (tmpIDRecordL != null) {
                tmpIDRecordL.dispose();
            }
            if (probeBlobL != null) {
                probeBlobL.dispose();
            }
            if (probeDescriptorL != null) {
                probeDescriptorL.dispose();
            }
            if (resultListL != null) {
                resultListL.dispose();
            }
            if (_qssEngine == null) return hashMap2;
            _fingerTemplateCreatorHandlePool.offer(_qssEngine);
            return hashMap2;
        }
        if (probeIDRecordL != null) {
            probeIDRecordL.dispose();
        }
        if (tmpIDRecordL != null) {
            tmpIDRecordL.dispose();
        }
        if (probeBlobL != null) {
            probeBlobL.dispose();
        }
        if (probeDescriptorL != null) {
            probeDescriptorL.dispose();
        }
        if (resultListL != null) {
            resultListL.dispose();
        }
        if (_qssEngine == null) return hashMap;
        _fingerTemplateCreatorHandlePool.offer(_qssEngine);
        return hashMap;
        finally {
            WL_LOCK.unlock();
            if (probeIDRecordL != null) {
                probeIDRecordL.dispose();
            }
            if (tmpIDRecordL != null) {
                tmpIDRecordL.dispose();
            }
            if (probeBlobL != null) {
                probeBlobL.dispose();
            }
            if (probeDescriptorL != null) {
                probeDescriptorL.dispose();
            }
            if (resultListL != null) {
                resultListL.dispose();
            }
            if (_qssEngine != null) {
                _fingerTemplateCreatorHandlePool.offer(_qssEngine);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public double verifyFinger(List<BiometricTemplate> probeRecord, List<BiometricTemplate> galleryRecord) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 74[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double verifyIris(List<BiometricTemplate> probeRecord, List<BiometricTemplate> galleryRecord) {
        Iterator<BiometricTemplate> i$;
        double mappedVerificationScoreL;
        double verificationScore;
        if (!_irisVerification) {
            L1_LOGGER.error((Object)"ITVEngine is not initialized to verify iris templates - check your config");
            return BiometricError.SDK_ERROR;
        }
        Verifier _irisVerify = null;
        IdRecord galleryIDRecord = null;
        IdRecord galleryIDRecordRotated = null;
        Blob galleryBlob = null;
        IdRecord probeIDRecord = null;
        Blob probeBlob = null;
        ResultList result = null;
        ResultList resultRotated = null;
        try {
            _irisVerify = _irisVerificationHandlePool.take();
            verificationScore = 0.0;
            mappedVerificationScoreL = L1ITVEngine.mapIrisScore(verificationScore * 10.0);
            if (_irisVerify == null) return mappedVerificationScoreL;
            i$ = probeRecord.iterator();
        }
        catch (Exception ex) {
            L1_LOGGER.error((Object)"Exception caught: ", (Throwable)ex);
            double d = BiometricError.SDK_ERROR;
            return d;
        }
        while (i$.hasNext()) {
            BiometricTemplate probe = i$.next();
            Types.Instance probeInstanceL = L1QAModule.convertToIrisInstance(L1_LOGGER, probe.getBiometricPosition());
            L1_LOGGER.info((Object)("Setting Iris Probe data" + probe));
            byte[] probeTemplate = probe.getProbeTemplate();
            if (probeTemplate == null) {
                L1_LOGGER.error((Object)"Probe template is null.");
                return BiometricError.SDK_ERROR;
            }
            Types.Modality modality = L1QAModule.getModality(L1_LOGGER, probeTemplate);
            if (modality != Types.Modality.Iris) {
                L1_LOGGER.error((Object)("Wrong modality found on probe-template : " + modality + ", expected Iris - skipping template"));
                continue;
            }
            probeBlob = new Blob();
            probeBlob.setData(probeTemplate);
            for (BiometricTemplate gallery : galleryRecord) {
                Types.Instance galleryInstanceL = L1QAModule.convertToIrisInstance(L1_LOGGER, gallery.getBiometricPosition());
                if (probeInstanceL != Types.Instance.Unknown && probeInstanceL != galleryInstanceL) continue;
                try {
                    float tempScore;
                    int i;
                    L1_LOGGER.info((Object)("Setting Iris Gallery data : " + gallery));
                    byte[] galleryTemplate = gallery.getGalleryTemplate();
                    if (galleryTemplate == null) {
                        L1_LOGGER.warn((Object)"Gallery template is null. Trying next.");
                        continue;
                    }
                    Types.Modality modality2 = L1QAModule.getModality(L1_LOGGER, galleryTemplate);
                    if (modality2 != Types.Modality.Iris) {
                        L1_LOGGER.error((Object)("Wrong modality found on gallery-template : " + modality2 + ", expected Iris - skipping template"));
                        continue;
                    }
                    galleryBlob = new Blob();
                    galleryBlob.setData(galleryTemplate);
                    Types.Instance irisInstanceL = Types.Instance.IrisLeft;
                    if (galleryInstanceL != Types.Instance.Unknown) {
                        irisInstanceL = galleryInstanceL;
                    }
                    galleryIDRecord = new IdRecord();
                    probeIDRecord = new IdRecord();
                    galleryIDRecord.addSerializedSample(Types.Modality.Iris, irisInstanceL, 1L, galleryBlob);
                    probeIDRecord.addSerializedSample(Types.Modality.Iris, irisInstanceL, 1L, probeBlob);
                    result = _irisVerify.verify(probeIDRecord, galleryIDRecord);
                    for (i = 0; i < result.length(); ++i) {
                        tempScore = result.getScore(i, Types.Modality.Unknown);
                        if (!((double)tempScore > verificationScore)) continue;
                        verificationScore = tempScore;
                    }
                    if (!_irisVerificationRotate180) continue;
                    galleryIDRecordRotated = L1QAModule.rotate180IrisTemplate(L1_LOGGER, galleryIDRecord, irisInstanceL, 1L);
                    resultRotated = _irisVerify.verify(probeIDRecord, galleryIDRecordRotated);
                    for (i = 0; i < resultRotated.length(); ++i) {
                        tempScore = resultRotated.getScore(i, Types.Modality.Unknown);
                        if (!((double)tempScore > verificationScore)) continue;
                        verificationScore = tempScore;
                    }
                }
                catch (Exception ex) {
                    L1_LOGGER.error((Object)"Exception caught: ", (Throwable)ex);
                    double d = BiometricError.SDK_ERROR;
                    _irisVerificationHandlePool.offer(_irisVerify);
                    if (galleryBlob != null) {
                        galleryBlob.dispose();
                    }
                    if (galleryIDRecord != null) {
                        galleryIDRecord.dispose();
                    }
                    if (galleryIDRecordRotated != null) {
                        galleryIDRecordRotated.dispose();
                    }
                    if (probeIDRecord != null) {
                        probeIDRecord.dispose();
                    }
                    if (result != null) {
                        result.dispose();
                    }
                    if (resultRotated != null) {
                        resultRotated.dispose();
                    }
                    if (probeBlob == null) return d;
                    probeBlob.dispose();
                    return d;
                }
                finally {
                    if (galleryBlob != null) {
                        galleryBlob.dispose();
                    }
                    if (galleryIDRecord != null) {
                        galleryIDRecord.dispose();
                    }
                    if (galleryIDRecordRotated != null) {
                        galleryIDRecordRotated.dispose();
                    }
                    if (probeIDRecord != null) {
                        probeIDRecord.dispose();
                    }
                    if (result != null) {
                        result.dispose();
                    }
                    if (resultRotated == null) continue;
                    resultRotated.dispose();
                }
            }
            if (probeBlob == null) continue;
            probeBlob.dispose();
        }
        return mappedVerificationScoreL;
        finally {
            _irisVerificationHandlePool.offer(_irisVerify);
            if (galleryBlob != null) {
                galleryBlob.dispose();
            }
            if (galleryIDRecord != null) {
                galleryIDRecord.dispose();
            }
            if (galleryIDRecordRotated != null) {
                galleryIDRecordRotated.dispose();
            }
            if (probeIDRecord != null) {
                probeIDRecord.dispose();
            }
            if (result != null) {
                result.dispose();
            }
            if (resultRotated != null) {
                resultRotated.dispose();
            }
            if (probeBlob != null) {
                probeBlob.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double verifyFace(List<BiometricTemplate> probeRecord, List<BiometricTemplate> galleryRecord) {
        Iterator<BiometricTemplate> i$;
        double mappedVerificationScoreL;
        double verificationScore;
        if (!_faceVerification) {
            L1_LOGGER.error((Object)"ITVEngine is not initialized to verify face templates - check your config");
            return BiometricError.SDK_ERROR;
        }
        Verifier _faceVerify = null;
        IdRecord galleryIDRecord = null;
        Blob galleryBlob = null;
        IdRecord probeIDRecord = null;
        Blob probeBlob = null;
        ResultList result = null;
        try {
            _faceVerify = _faceVerificationHandlePool.take();
            verificationScore = 0.0;
            mappedVerificationScoreL = L1ITVEngine.mapFaceScore(verificationScore * 10.0);
            if (_faceVerify == null) return mappedVerificationScoreL;
            i$ = probeRecord.iterator();
        }
        catch (Exception ex) {
            L1_LOGGER.error((Object)"Exception caught: ", (Throwable)ex);
            double d = BiometricError.SDK_ERROR;
            return d;
        }
        while (i$.hasNext()) {
            BiometricTemplate probe = i$.next();
            Types.Instance probeInstanceL = L1QAModule.convertToFaceInstance(L1_LOGGER, probe.getBiometricPosition());
            L1_LOGGER.info((Object)("Setting Face Probe data" + probe));
            byte[] probeTemplate = probe.getProbeTemplate();
            if (probeTemplate == null) {
                L1_LOGGER.warn((Object)"Probe template is null. Trying next.");
                continue;
            }
            Types.Modality modality = L1QAModule.getModality(L1_LOGGER, probeTemplate);
            if (modality != Types.Modality.Face) {
                L1_LOGGER.error((Object)("Wrong modality found on probe-template : " + modality + ", expected Face - skipping template"));
                continue;
            }
            probeBlob = new Blob();
            probeBlob.setData(probeTemplate);
            for (BiometricTemplate gallery : galleryRecord) {
                Types.Instance galleryInstanceL = L1QAModule.convertToFaceInstance(L1_LOGGER, probe.getBiometricPosition());
                if (probeInstanceL != Types.Instance.Unknown && probeInstanceL != galleryInstanceL) continue;
                try {
                    L1_LOGGER.info((Object)("Setting Face Gallery data : " + gallery));
                    byte[] galleryTemplate = gallery.getGalleryTemplate();
                    if (galleryTemplate == null) {
                        L1_LOGGER.warn((Object)"Gallery template is null. Trying next.");
                        continue;
                    }
                    Types.Modality modality2 = L1QAModule.getModality(L1_LOGGER, galleryTemplate);
                    if (modality2 != Types.Modality.Face) {
                        L1_LOGGER.error((Object)("Wrong modality found on gallery-template : " + modality2 + ", expected Face - skipping template"));
                        continue;
                    }
                    galleryBlob = new Blob();
                    galleryBlob.setData(galleryTemplate);
                    Types.Instance faceInstance = Types.Instance.FaceFrontal;
                    galleryIDRecord = new IdRecord();
                    probeIDRecord = new IdRecord();
                    galleryIDRecord.addSerializedSample(Types.Modality.Face, faceInstance, 1L, galleryBlob);
                    probeIDRecord.addSerializedSample(Types.Modality.Face, faceInstance, 1L, probeBlob);
                    result = _faceVerify.verify(probeIDRecord, galleryIDRecord);
                    for (int i = 0; i < result.length(); ++i) {
                        float tempScore = result.getScore(i, Types.Modality.Unknown);
                        if (!((double)tempScore > verificationScore)) continue;
                        verificationScore = tempScore;
                    }
                }
                catch (Exception ex) {
                    L1_LOGGER.error((Object)"Exception caught: ", (Throwable)ex);
                    double d = BiometricError.SDK_ERROR;
                    _faceVerificationHandlePool.offer(_faceVerify);
                    if (galleryBlob != null) {
                        galleryBlob.dispose();
                    }
                    if (galleryIDRecord != null) {
                        galleryIDRecord.dispose();
                    }
                    if (probeIDRecord != null) {
                        probeIDRecord.dispose();
                    }
                    if (probeBlob != null) {
                        probeBlob.dispose();
                    }
                    if (result == null) return d;
                    result.dispose();
                    return d;
                }
                finally {
                    if (galleryBlob != null) {
                        galleryBlob.dispose();
                    }
                    if (galleryIDRecord != null) {
                        galleryIDRecord.dispose();
                    }
                    if (probeIDRecord != null) {
                        probeIDRecord.dispose();
                    }
                    if (result == null) continue;
                    result.dispose();
                }
            }
            if (probeBlob == null) continue;
            probeBlob.dispose();
        }
        return mappedVerificationScoreL;
        finally {
            _faceVerificationHandlePool.offer(_faceVerify);
            if (galleryBlob != null) {
                galleryBlob.dispose();
            }
            if (galleryIDRecord != null) {
                galleryIDRecord.dispose();
            }
            if (probeIDRecord != null) {
                probeIDRecord.dispose();
            }
            if (probeBlob != null) {
                probeBlob.dispose();
            }
            if (result != null) {
                result.dispose();
            }
        }
    }

    public boolean supportsFace() {
        return true;
    }

    public boolean supportsFinger() {
        return true;
    }

    public boolean supportsIris() {
        return true;
    }

    private void initializeGallery() throws CustomException {
        boolean recover = false;
        if (_faceIdentification) {
            recover = L1ITVEngine.DBExists(L1ITVEngine.getHomeFolder() + this._faceCachePath);
            if (!recover) {
                try {
                    new File(L1ITVEngine.getHomeFolder() + this._faceCachePath).mkdirs();
                }
                catch (Throwable t) {
                    L1_LOGGER.error((Object)"Failed to create cache folder for faces", t);
                }
            }
            this._faceMatcher = new TemplateMatcher("face_UID_local_deduplication", L1ITVEngine.getHomeFolder() + this._faceCachePath, recover);
            this._faceMatcher.addMatchingPipeline("search_engine_face_UID_local_deduplication");
            _faceMaxTransactionID = this._faceMatcher.getMaxTransactionId();
        }
        if (_irisIdentification) {
            recover = L1ITVEngine.DBExists(L1ITVEngine.getHomeFolder() + this._irisCachePath);
            if (!recover) {
                try {
                    new File(L1ITVEngine.getHomeFolder() + this._irisCachePath).mkdirs();
                }
                catch (Throwable t) {
                    L1_LOGGER.error((Object)"Failed to create cache folder for irides", t);
                }
            }
            this._irisMatcher = new TemplateMatcher("iris_UID_local_deduplication", L1ITVEngine.getHomeFolder() + this._irisCachePath, recover);
            this._irisMatcher.addMatchingPipeline("search_engine_iris_UID_local_deduplication");
            _irisMaxTransactionID = this._irisMatcher.getMaxTransactionId();
        }
        if (_fingerIdentification) {
            recover = L1ITVEngine.DBExists(L1ITVEngine.getHomeFolder() + this._fingerCachePath);
            if (!recover) {
                try {
                    new File(L1ITVEngine.getHomeFolder() + this._fingerCachePath).mkdirs();
                }
                catch (Throwable t) {
                    L1_LOGGER.error((Object)"Failed to create cache folder for fingers", t);
                }
            }
            this._fingerMatcher = new TemplateMatcher("finger_UID_local_deduplication", L1ITVEngine.getHomeFolder() + this._fingerCachePath, recover);
            this._fingerMatcher.addMatchingPipeline("search_engine_finger_UID_local_deduplication");
            _fingerMaxTransactionID = this._fingerMatcher.getMaxTransactionId();
        }
    }

    private void loadConfig(String configFileName) {
        try {
            Properties pro = new Properties();
            try {
                pro.load(new FileInputStream(configFileName));
            }
            catch (IOException e) {
                L1_LOGGER.error((Object)("unable to read config file : " + configFileName), (Throwable)e);
            }
            try {
                _faceTemplateCreation = Boolean.parseBoolean(pro.getProperty("face.template.creation", "false"));
                _fingerTemplateCreation = Boolean.parseBoolean(pro.getProperty("finger.template.creation", "false"));
                _irisTemplateCreation = Boolean.parseBoolean(pro.getProperty("iris.template.creation", "false"));
                _faceVerification = Boolean.parseBoolean(pro.getProperty("face.verification", "false"));
                _fingerVerification = Boolean.parseBoolean(pro.getProperty("finger.verification", "false"));
                _irisVerification = Boolean.parseBoolean(pro.getProperty("iris.verification", "false"));
                _faceIdentification = Boolean.parseBoolean(pro.getProperty("face.identification", "false"));
                _fingerIdentification = Boolean.parseBoolean(pro.getProperty("finger.identification", "false"));
                _irisIdentification = Boolean.parseBoolean(pro.getProperty("iris.identification", "false"));
                _faceTemplateCreationThreads = Integer.parseInt(pro.getProperty("face.template.creation.threads", "1"));
                _fingerTemplateCreationThreads = Integer.parseInt(pro.getProperty("finger.template.creation.threads", "1"));
                _irisTemplateCreationThreads = Integer.parseInt(pro.getProperty("iris.template.creation.threads", "1"));
                _faceVerificationThreads = Integer.parseInt(pro.getProperty("face.verification.threads", "1"));
                _fingerVerificationThreads = Integer.parseInt(pro.getProperty("finger.verification.threads", "1"));
                _irisVerificationThreads = Integer.parseInt(pro.getProperty("iris.verification.threads", "1"));
                _fingerVerificationScoreScale = Double.parseDouble(pro.getProperty("finger.verification.score_scale", "1"));
                _fingerVerificationScoreShift = Double.parseDouble(pro.getProperty("finger.verification.score_shift", "0"));
                _fingerVerificationNumberOfMatchesFactor = Double.parseDouble(pro.getProperty("finger.verification.numberOfMatchesFactor", "1"));
                _fingerVerificationEnableScoreCorrection = Boolean.parseBoolean(pro.getProperty("finger.verification.enableScoreCorrection", "false"));
                _fingerIdentificationScoreScale = Double.parseDouble(pro.getProperty("finger.identification.score_scale", "1"));
                _fingerIdentificationScoreShift = Double.parseDouble(pro.getProperty("finger.identification.score_shift", "0"));
                _irisScoreScale = Double.parseDouble(pro.getProperty("iris.score_scale", "1"));
                _irisScoreShift = Double.parseDouble(pro.getProperty("iris.score_shift", "0"));
                _faceScoreScale = Double.parseDouble(pro.getProperty("face.score_scale", "1"));
                _faceScoreShift = Double.parseDouble(pro.getProperty("face.score_shift", "0"));
                _irisVerificationRotate180 = Boolean.parseBoolean(pro.getProperty("iris.verification.enableRotation180", "false"));
            }
            catch (Exception excL) {
                L1_LOGGER.error((Object)("error during parsing the file : " + configFileName), (Throwable)excL);
            }
            StringBuilder sbL = new StringBuilder();
            sbL.append(newLine);
            sbL.append("L1ITVEngine-Configuration :");
            sbL.append(newLine);
            sbL.append(newLine);
            sbL.append("face.template.creation : ");
            sbL.append(_faceTemplateCreation);
            sbL.append(newLine);
            sbL.append("face.template.creation.threads : ");
            sbL.append(_faceTemplateCreationThreads);
            sbL.append(newLine);
            sbL.append("face.verification : ");
            sbL.append(_faceVerification);
            sbL.append(newLine);
            sbL.append("face.verification.threads : ");
            sbL.append(_faceVerificationThreads);
            sbL.append(newLine);
            sbL.append("finger.template.creation : ");
            sbL.append(_fingerTemplateCreation);
            sbL.append(newLine);
            sbL.append("finger.template.creation.threads : ");
            sbL.append(_fingerTemplateCreationThreads);
            sbL.append(newLine);
            sbL.append("finger.verification : ");
            sbL.append(_fingerVerification);
            sbL.append(newLine);
            sbL.append("finger.verification.threads : ");
            sbL.append(_fingerVerificationThreads);
            sbL.append(newLine);
            sbL.append("finger.identification : ");
            sbL.append(_fingerIdentification);
            sbL.append(newLine);
            sbL.append("iris.template.creation : ");
            sbL.append(_irisTemplateCreation);
            sbL.append(newLine);
            sbL.append("iris.template.creation.threads : ");
            sbL.append(_irisTemplateCreationThreads);
            sbL.append(newLine);
            sbL.append("iris.verification : ");
            sbL.append(_irisVerification);
            sbL.append(newLine);
            sbL.append("iris.verification.threads : ");
            sbL.append(_irisVerificationThreads);
            sbL.append(newLine);
            sbL.append("iris.identification : ");
            sbL.append(_irisIdentification);
            sbL.append(newLine);
            L1_LOGGER.info((Object)sbL.toString());
        }
        catch (Exception ex) {
            L1_LOGGER.error((Object)"Error loading Properties file.Please check if it exists/any property can be missing", (Throwable)ex);
        }
    }

    private static boolean DBExists(String cachePath) {
        String cacheDir = cachePath.replaceAll("\\\\", "/");
        int index = cacheDir.lastIndexOf(47);
        String name = cacheDir.substring(index + 1, cacheDir.length());
        cacheDir = cacheDir.substring(0, index);
        String foundationTemplatesDir = cacheDir + "/" + name;
        L1_LOGGER.info((Object)("foundationTemplatesDir  :  " + foundationTemplatesDir));
        File file = new File(foundationTemplatesDir + "/metaData.dat");
        return file.exists();
    }

    private static boolean DBClear(String cachePath) {
        String cacheDir = cachePath.replaceAll("\\\\", "/");
        int index = cacheDir.lastIndexOf(47);
        String name = cacheDir.substring(index + 1, cacheDir.length());
        cacheDir = cacheDir.substring(0, index);
        String foundationTemplatesDir = cacheDir + "/" + name;
        L1_LOGGER.info((Object)("Deleting foundationTemplatesDir  :  " + foundationTemplatesDir));
        File file = new File(foundationTemplatesDir + "/metaData.dat");
        return L1ITVEngine.deleteDir(file);
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = L1ITVEngine.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    private static double mapFingerVerificationScore(double scoreA, double nMatchesA) {
        double mappedScoreL = scoreA;
        if (_fingerVerificationEnableScoreCorrection && nMatchesA > 0.0) {
            mappedScoreL -= Math.log(nMatchesA * _fingerVerificationNumberOfMatchesFactor) / 2.30258509299 * 10.0;
        }
        if ((mappedScoreL = mappedScoreL * _fingerVerificationScoreScale + _fingerVerificationScoreShift) < 0.0) {
            return 0.0;
        }
        return mappedScoreL;
    }

    private static double mapFingerIdentificationScore(double scoreA) {
        double mappedScoreL = scoreA * _fingerIdentificationScoreScale + _fingerIdentificationScoreShift;
        if (mappedScoreL < 0.0) {
            return 0.0;
        }
        return mappedScoreL;
    }

    private static double mapIrisScore(double scoreA) {
        double mappedScoreL = scoreA * _irisScoreScale + _irisScoreShift;
        if (mappedScoreL < 0.0) {
            return 0.0;
        }
        return mappedScoreL;
    }

    private static double mapFaceScore(double scoreA) {
        double mappedScoreL = scoreA * _faceScoreScale + _faceScoreShift;
        if (mappedScoreL < 0.0) {
            return 0.0;
        }
        return mappedScoreL;
    }

    static {
        L1_LOGGER.info((Object)("Loading : " + Version.version));
        homeFolderS = null;
    }
}

