/*
 * Decompiled with CFR 0.152.
 */
package com.l1id.uid.qssitv;

import com.identix.uidai.cbeff.ImageStruct;
import com.identix.uidai.cbeff.IrisImageStruct;
import com.l1id.sdk.foundation.Blob;
import com.l1id.sdk.foundation.CustomException;
import com.l1id.sdk.foundation.FingerprintPosition;
import com.l1id.sdk.foundation.FingerprintSegmentor;
import com.l1id.sdk.foundation.IdRecord;
import com.l1id.sdk.foundation.Image;
import com.l1id.sdk.foundation.ImageCollection;
import com.l1id.sdk.foundation.ImageDescriptor;
import com.l1id.sdk.foundation.LandmarkList;
import com.l1id.sdk.foundation.Point;
import com.l1id.sdk.foundation.StandardFaceImageGenerator;
import com.l1id.sdk.foundation.TemplateGenerator;
import com.l1id.sdk.foundation.Types;
import com.l1id.sdk.foundation.WriteImageDescriptor;
import com.l1id.uid.iso19794_2011.IIR_2011;
import com.l1id.uid.qssitv.Minutia;
import com.l1id.uid.qssitv.util.Util;
import helper.UtilHelper;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.qssitv.model.FingerSegment;
import in.gov.uidai.qssitv.model.FingerprintQSS;
import in.gov.uidai.qssitv.model.FingerprintQualityAttribute;
import in.gov.uidai.qssitv.model.IrisImageFormat;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class L1QAModule {
    private Types.Modality modalityM = Types.Modality.Unknown;
    private Types.QualityProfile qProfileM = Types.QualityProfile.NoChecks;
    private TemplateGenerator templateCreation = null;
    private FingerprintSegmentor fpSeq = null;
    private StandardFaceImageGenerator faceSic = null;
    private Logger L1_LOGGER;
    private int qssInstanceNumberM;
    private String qssInstanceIdentifierM;

    public L1QAModule(Types.Modality modalityA, Types.QualityProfile qProfileA, Logger L1_LOGGER_A, int qssInstanceNumberA) {
        this.L1_LOGGER = L1_LOGGER_A;
        this.qssInstanceNumberM = qssInstanceNumberA;
        this.qssInstanceIdentifierM = "QSSEngine-" + this.qssInstanceNumberM;
        try {
            String templateCreationIdL;
            this.modalityM = modalityA;
            this.qProfileM = qProfileA;
            switch (modalityA) {
                case Fingerprint: {
                    templateCreationIdL = "finger_UID";
                    this.fpSeq = new FingerprintSegmentor();
                    break;
                }
                case Face: {
                    templateCreationIdL = "face_UID";
                    this.faceSic = new StandardFaceImageGenerator(Types.StandardFaceImageGenerationMode.FaceIso);
                    break;
                }
                case Iris: {
                    templateCreationIdL = "iris_default";
                    break;
                }
                default: {
                    this.L1_LOGGER.fatal((Object)(this.qssInstanceIdentifierM + ", Failed Initializing TC. Unsupported modality: " + modalityA.name() + "."));
                    return;
                }
            }
            this.templateCreation = new TemplateGenerator(templateCreationIdL);
        }
        catch (Exception e) {
            this.L1_LOGGER.fatal((Object)(this.qssInstanceIdentifierM + ", Failed Initializing TC for : " + modalityA.name()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Types.Instance, byte[]> segmentImage(Image imageA, Types.Instance instanceA, List<BiometricPosition> missingFingers) {
        HashMap<Types.Instance, byte[]> i3;
        ImageDescriptor descriptorL;
        Image[] segPosistions;
        Image[] segImages;
        Blob blobL;
        block35: {
            HashMap<Types.Instance, byte[]> segmentedImages = new HashMap<Types.Instance, byte[]>();
            WriteImageDescriptor writeImageDescL = new WriteImageDescriptor();
            blobL = null;
            segImages = null;
            segPosistions = null;
            descriptorL = null;
            try {
                this.L1_LOGGER.debug((Object)(this.qssInstanceIdentifierM + ", missingFingers : " + missingFingers));
                descriptorL = new ImageDescriptor(Types.Modality.Fingerprint);
                descriptorL.setDPI(500);
                descriptorL.setInstance(instanceA);
                descriptorL.setImpressionType(Types.FingerPalmImpressionType.FingerImpressionLivePlain);
                descriptorL.setFingerPalmRotationTolerance(45);
                descriptorL.setQualityProfile(Types.QualityProfile.FingerSlapChecks);
                int numFingersL = 4;
                if (instanceA == Types.Instance.FingerPlainThumbs) {
                    numFingersL = 2;
                }
                if (missingFingers != null && missingFingers.size() > 0) {
                    numFingersL -= missingFingers.size();
                }
                int outputDpiL = 500;
                Types.Instance[] missingPositions = null;
                missingPositions = new Types.Instance[]{};
                if (missingFingers != null && missingFingers.size() > 0) {
                    missingPositions = new Types.Instance[missingFingers.size()];
                    for (int i2 = 0; i2 < missingFingers.size(); ++i2) {
                        if (missingFingers.get(i2) == BiometricPosition.LEFT_INDEX) {
                            missingPositions[i2] = Types.Instance.FingerLeftIndex;
                            continue;
                        }
                        if (missingFingers.get(i2) == BiometricPosition.LEFT_MIDDLE) {
                            missingPositions[i2] = Types.Instance.FingerLeftMiddle;
                            continue;
                        }
                        if (missingFingers.get(i2) == BiometricPosition.LEFT_RING) {
                            missingPositions[i2] = Types.Instance.FingerLeftRing;
                            continue;
                        }
                        if (missingFingers.get(i2) == BiometricPosition.LEFT_LITTLE) {
                            missingPositions[i2] = Types.Instance.FingerLeftLittle;
                            continue;
                        }
                        if (missingFingers.get(i2) == BiometricPosition.LEFT_THUMB) {
                            missingPositions[i2] = Types.Instance.FingerLeftThumb;
                            continue;
                        }
                        if (missingFingers.get(i2) == BiometricPosition.RIGHT_INDEX) {
                            missingPositions[i2] = Types.Instance.FingerRightIndex;
                            continue;
                        }
                        if (missingFingers.get(i2) == BiometricPosition.RIGHT_MIDDLE) {
                            missingPositions[i2] = Types.Instance.FingerRightMiddle;
                            continue;
                        }
                        if (missingFingers.get(i2) == BiometricPosition.RIGHT_RING) {
                            missingPositions[i2] = Types.Instance.FingerRightRing;
                            continue;
                        }
                        if (missingFingers.get(i2) == BiometricPosition.RIGHT_LITTLE) {
                            missingPositions[i2] = Types.Instance.FingerRightLittle;
                            continue;
                        }
                        if (missingFingers.get(i2) != BiometricPosition.RIGHT_THUMB) continue;
                        missingPositions[i2] = Types.Instance.FingerRightThumb;
                    }
                    if (missingPositions[0] == null) {
                        missingPositions = new Types.Instance[]{};
                    }
                }
                this.L1_LOGGER.debug((Object)(this.qssInstanceIdentifierM + ", Segmenting the Slap : "));
                FingerprintSegmentor.FingerprintSegmentOutput segOutput = this.fpSeq.segment(imageA, descriptorL, outputDpiL, missingPositions);
                this.L1_LOGGER.debug((Object)(this.qssInstanceIdentifierM + ", Done Segmenting : "));
                segImages = segOutput.getSlapImages();
                this.L1_LOGGER.debug((Object)(this.qssInstanceIdentifierM + ", Number of segmented images : " + segImages.length));
                segPosistions = segOutput.getFingerprintPositions();
                descriptorL.dispose();
                descriptorL = null;
                for (int i3 = 0; i3 < segOutput.getNumFinger(); ++i3) {
                    try {
                        segImages[i3].getWidth();
                    }
                    catch (CustomException customException) {
                        this.L1_LOGGER.trace((Object)(this.qssInstanceIdentifierM + ", no segment-info for segment number " + i3));
                        continue;
                    }
                    blobL = segImages[i3].writeToBlob(Types.ImageFormat.Jpeg2000, writeImageDescL);
                    segmentedImages.put(segPosistions[i3].getInstance(), blobL.getData());
                    blobL.dispose();
                    blobL = null;
                    segImages[i3].dispose();
                    segPosistions[i3].dispose();
                }
                i3 = segmentedImages;
                if (writeImageDescL == null) break block35;
            }
            catch (CustomException ex) {
                this.L1_LOGGER.error((Object)"", (Throwable)ex);
                Map<Types.Instance, byte[]> map = null;
                return map;
            }
            finally {
                if (writeImageDescL != null) {
                    writeImageDescL.dispose();
                }
                if (blobL != null) {
                    blobL.dispose();
                }
                if (segImages != null) {
                    for (void var15_26 : segImages) {
                        if (var15_26 == null) continue;
                        var15_26.dispose();
                    }
                }
                if (segPosistions != null) {
                    for (void var15_28 : segPosistions) {
                        if (var15_28 == null) continue;
                        var15_28.dispose();
                    }
                }
                if (descriptorL != null) {
                    descriptorL.dispose();
                }
            }
            writeImageDescL.dispose();
        }
        if (blobL != null) {
            blobL.dispose();
        }
        if (segImages != null) {
            for (Image imageL : segImages) {
                if (imageL == null) continue;
                imageL.dispose();
            }
        }
        if (segPosistions != null) {
            for (Image posL : segPosistions) {
                if (posL == null) continue;
                posL.dispose();
            }
        }
        if (descriptorL != null) {
            descriptorL.dispose();
        }
        return i3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ImageDescriptor> processSingleFingerImage(Image imageA, Types.Instance instanceA, List<Integer> overallQuality, FingerprintQSS fingerprintQuality) {
        String executionStepL = "processSingleFingerImage begin.";
        ArrayList<ImageDescriptor> retList = new ArrayList<ImageDescriptor>();
        ArrayList<Types.Instance> missingList = new ArrayList<Types.Instance>();
        Types.Instance handInstance = Types.Instance.Unknown;
        if (instanceA == Types.Instance.FingerLeftThumb || instanceA == Types.Instance.FingerPlainLeftThumb) {
            missingList.add(Types.Instance.FingerRightThumb);
            handInstance = Types.Instance.FingerPlainThumbs;
        } else if (instanceA == Types.Instance.FingerRightThumb || instanceA == Types.Instance.FingerPlainRightThumb) {
            missingList.add(Types.Instance.FingerLeftThumb);
            handInstance = Types.Instance.FingerPlainThumbs;
        } else if (instanceA == Types.Instance.FingerLeftIndex || instanceA == Types.Instance.FingerLeftMiddle || instanceA == Types.Instance.FingerLeftRing || instanceA == Types.Instance.FingerLeftLittle) {
            missingList.add(Types.Instance.FingerLeftIndex);
            missingList.add(Types.Instance.FingerLeftMiddle);
            missingList.add(Types.Instance.FingerLeftRing);
            missingList.add(Types.Instance.FingerLeftLittle);
            missingList.remove(instanceA);
            handInstance = Types.Instance.FingerPlainLeftSlap;
        } else if (instanceA == Types.Instance.FingerRightIndex || instanceA == Types.Instance.FingerRightMiddle || instanceA == Types.Instance.FingerRightRing || instanceA == Types.Instance.FingerRightLittle) {
            missingList.add(Types.Instance.FingerRightIndex);
            missingList.add(Types.Instance.FingerRightMiddle);
            missingList.add(Types.Instance.FingerRightRing);
            missingList.add(Types.Instance.FingerRightLittle);
            missingList.remove(instanceA);
            handInstance = Types.Instance.FingerPlainRightSlap;
        }
        if (handInstance == Types.Instance.Unknown) {
            this.L1_LOGGER.warn((Object)(this.qssInstanceIdentifierM + ", segmentSingleImage called with non valid instance : " + instanceA));
            overallQuality.add(5);
            return null;
        }
        FingerSegment segment = null;
        ImageDescriptor descriptorL = null;
        ImageDescriptor singleDescriptorL = null;
        ImageDescriptor resultImageDesc = null;
        WriteImageDescriptor writeImageDescL = new WriteImageDescriptor();
        Image[] segImagesL = null;
        IdRecord idRecord = null;
        ImageCollection imageCollection = null;
        FingerprintPosition[] fingerPrintPositionArrayL = null;
        FingerprintSegmentor.FingerprintSegmentOutput segOutput = null;
        Blob blobL = null;
        try {
            executionStepL = "Prepare image descriptor for slap segmentation.";
            descriptorL = new ImageDescriptor(Types.Modality.Fingerprint);
            descriptorL.setDPI(500);
            descriptorL.setInstance(handInstance);
            descriptorL.setImpressionType(Types.FingerPalmImpressionType.FingerImpressionLivePlain);
            descriptorL.setFingerPalmRotationTolerance(45);
            descriptorL.setQualityProfile(Types.QualityProfile.FingerSlapChecks);
            int outputDpiL = 500;
            executionStepL = "Do slap segmentation.";
            segOutput = this.fpSeq.segment(imageA, descriptorL, outputDpiL, missingList.toArray(new Types.Instance[0]));
            executionStepL = "Get slap segmentation results.";
            fingerPrintPositionArrayL = segOutput.getFingerprintPositions();
            segImagesL = segOutput.getSlapImages();
            retList.add(descriptorL);
            if (fingerprintQuality != null) {
                fingerprintQuality.setHandedness(segOutput.getHandedness());
            }
            executionStepL = "Process segment info.";
            if (segOutput.getNumFinger() > 0) {
                int[] segQuality = segOutput.getFingerQuality();
                int bestIndex = 0;
                int bestNistClass = 1000;
                for (int idx = 0; idx < segQuality.length; ++idx) {
                    int q = segQuality[idx];
                    if (q == 0 || q >= bestNistClass) continue;
                    bestNistClass = q;
                    bestIndex = idx;
                }
                Point pLB = fingerPrintPositionArrayL[bestIndex].getLeftBottom();
                Point pRB = fingerPrintPositionArrayL[bestIndex].getRightBottom();
                Point pLT = fingerPrintPositionArrayL[bestIndex].getLeftTop();
                Point pRT = fingerPrintPositionArrayL[bestIndex].getRightTop();
                int minY = Math.min(pLT.getY(), pRT.getY());
                int maxY = Math.min(pLB.getY(), pRB.getY());
                int minX = Math.min(pLT.getX(), pLB.getX());
                int maxX = Math.min(pRT.getX(), pRB.getX());
                int segWidth = maxX - minX;
                int segHeight = maxY - minY;
                if (segWidth < 20 || segHeight < 20) {
                    overallQuality.add(5);
                } else {
                    overallQuality.add(segQuality[bestIndex]);
                    segment = new FingerSegment();
                    segment.setBottomLeft(new java.awt.Point(pLB.getX(), pLB.getY()));
                    segment.setBottomRight(new java.awt.Point(pRB.getX(), pRB.getY()));
                    segment.setTopLeft(new java.awt.Point(pLT.getX(), pLT.getY()));
                    segment.setTopRight(new java.awt.Point(pRT.getX(), pRT.getY()));
                    segment.setFingerPosition(L1QAModule.convertToBiometricPosition(instanceA));
                    blobL = segImagesL[bestIndex].writeToBlob(Types.ImageFormat.Jpeg2000, writeImageDescL);
                    segment.setImage(blobL.getData());
                    segment.setQuality((double)segQuality[bestIndex]);
                    fingerprintQuality.getFingerSegments().add(segment);
                    executionStepL = "Perform single finger quality checks.";
                    if (segQuality[bestIndex] != 0) {
                        singleDescriptorL = new ImageDescriptor(Types.Modality.Fingerprint);
                        singleDescriptorL.setDPI(500);
                        singleDescriptorL.setInstance(instanceA);
                        singleDescriptorL.setImpressionType(Types.FingerPalmImpressionType.FingerImpressionLivePlain);
                        singleDescriptorL.setFingerPalmRotationTolerance(45);
                        singleDescriptorL.setQualityProfile(Types.QualityProfile.FingerChecksA);
                        imageCollection = new ImageCollection();
                        long sampleId = 1L;
                        imageCollection.addImage(sampleId, segImagesL[bestIndex], singleDescriptorL);
                        idRecord = this.templateCreation.createTemplates(imageCollection, Types.TemplateCreationType.Gallery, 0L, 0L);
                        resultImageDesc = imageCollection.getImageDescriptor(this.modalityM, instanceA, sampleId);
                        retList.add(resultImageDesc);
                    }
                }
            } else {
                overallQuality.add(5);
            }
            ArrayList<ImageDescriptor> arrayList = retList;
            return arrayList;
        }
        catch (CustomException ex) {
            this.L1_LOGGER.error((Object)(this.qssInstanceIdentifierM + ", ExecutionStep: '" + executionStepL + "': Exception caught: " + (Object)((Object)ex)));
            if (descriptorL != null) {
                descriptorL.dispose();
            }
            if (resultImageDesc != null) {
                resultImageDesc.dispose();
            }
            overallQuality.add(5);
            List<ImageDescriptor> list = null;
            return list;
        }
        finally {
            int i;
            if (writeImageDescL != null) {
                writeImageDescL.dispose();
            }
            if (blobL != null) {
                blobL.dispose();
            }
            if (segImagesL != null) {
                for (i = 0; i < segImagesL.length; ++i) {
                    if (segImagesL[i] == null) continue;
                    segImagesL[i].dispose();
                }
            }
            if (fingerPrintPositionArrayL != null) {
                for (i = 0; i < fingerPrintPositionArrayL.length; ++i) {
                    if (fingerPrintPositionArrayL[i] == null) continue;
                    fingerPrintPositionArrayL[i].dispose();
                }
            }
            if (singleDescriptorL != null) {
                singleDescriptorL.dispose();
            }
            if (imageCollection != null) {
                imageCollection.dispose();
            }
            if (idRecord != null) {
                idRecord.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ImageDescriptor> processMultiImage(Image imageA, Types.Instance instanceA, Vector<Integer> overallQuality, FingerprintQSS fingerprintQuality, List<BiometricPosition> missingFingers) {
        ArrayList<ImageDescriptor> i2;
        ImageDescriptor singleDescriptorL;
        IdRecord idRecord;
        Image[] segImages;
        ImageCollection imageCollection;
        Image[] segPosistions;
        block41: {
            ArrayList<ImageDescriptor> retList = new ArrayList<ImageDescriptor>();
            WriteImageDescriptor writeImageDescL = new WriteImageDescriptor();
            ImageDescriptor descriptorL = null;
            segPosistions = null;
            imageCollection = null;
            segImages = null;
            idRecord = null;
            singleDescriptorL = null;
            String executionStepL = "processMultiImage begin.";
            try {
                this.L1_LOGGER.debug((Object)(this.qssInstanceIdentifierM + ", missingFingers : " + missingFingers));
                executionStepL = "Prepare image descriptor for slap segmentation.";
                descriptorL = new ImageDescriptor(Types.Modality.Fingerprint);
                descriptorL.setDPI(500);
                descriptorL.setInstance(instanceA);
                descriptorL.setImpressionType(Types.FingerPalmImpressionType.FingerImpressionLivePlain);
                descriptorL.setFingerPalmRotationTolerance(45);
                descriptorL.setQualityProfile(Types.QualityProfile.FingerSlapChecks);
                int outputDpiL = 500;
                Types.Instance[] missingPositions = null;
                missingPositions = new Types.Instance[]{};
                if (missingFingers != null && missingFingers.size() > 0) {
                    missingPositions = new Types.Instance[missingFingers.size()];
                    for (int i3 = 0; i3 < missingFingers.size(); ++i3) {
                        if (missingFingers.get(i3) == BiometricPosition.LEFT_INDEX) {
                            missingPositions[i3] = Types.Instance.FingerLeftIndex;
                            continue;
                        }
                        if (missingFingers.get(i3) == BiometricPosition.LEFT_MIDDLE) {
                            missingPositions[i3] = Types.Instance.FingerLeftMiddle;
                            continue;
                        }
                        if (missingFingers.get(i3) == BiometricPosition.LEFT_RING) {
                            missingPositions[i3] = Types.Instance.FingerLeftRing;
                            continue;
                        }
                        if (missingFingers.get(i3) == BiometricPosition.LEFT_LITTLE) {
                            missingPositions[i3] = Types.Instance.FingerLeftLittle;
                            continue;
                        }
                        if (missingFingers.get(i3) == BiometricPosition.LEFT_THUMB) {
                            missingPositions[i3] = Types.Instance.FingerRightThumb;
                            continue;
                        }
                        if (missingFingers.get(i3) == BiometricPosition.RIGHT_INDEX) {
                            missingPositions[i3] = Types.Instance.FingerRightIndex;
                            continue;
                        }
                        if (missingFingers.get(i3) == BiometricPosition.RIGHT_MIDDLE) {
                            missingPositions[i3] = Types.Instance.FingerRightMiddle;
                            continue;
                        }
                        if (missingFingers.get(i3) == BiometricPosition.RIGHT_RING) {
                            missingPositions[i3] = Types.Instance.FingerRightRing;
                            continue;
                        }
                        if (missingFingers.get(i3) == BiometricPosition.RIGHT_LITTLE) {
                            missingPositions[i3] = Types.Instance.FingerRightLittle;
                            continue;
                        }
                        if (missingFingers.get(i3) != BiometricPosition.RIGHT_THUMB) continue;
                        missingPositions[i3] = Types.Instance.FingerRightThumb;
                    }
                    if (missingPositions[0] == null) {
                        missingPositions = new Types.Instance[]{};
                    }
                }
                executionStepL = "Do slap segmentation.";
                this.L1_LOGGER.debug((Object)(this.qssInstanceIdentifierM + ", Segmenting the Slap :"));
                FingerprintSegmentor.FingerprintSegmentOutput segOutput = this.fpSeq.segment(imageA, descriptorL, outputDpiL, missingPositions);
                this.L1_LOGGER.debug((Object)(this.qssInstanceIdentifierM + ", Done Segmenting :"));
                executionStepL = "Get slap segmentation results.";
                segImages = segOutput.getSlapImages();
                this.L1_LOGGER.debug((Object)(this.qssInstanceIdentifierM + ", Number of segmented images : " + segImages.length));
                segPosistions = segOutput.getFingerprintPositions();
                int[] segQuality = segOutput.getFingerQuality();
                retList.add(descriptorL);
                for (int d : segQuality) {
                    overallQuality.add(d);
                }
                if (fingerprintQuality != null) {
                    fingerprintQuality.setHandedness(segOutput.getHandedness());
                }
                executionStepL = "Process segment info.";
                for (int i2 = 0; i2 < segOutput.getNumFinger(); ++i2) {
                    executionStepL = "Process segment info.";
                    Integer n = new Integer(0);
                    Integer leftTopY = new Integer(0);
                    Integer leftBottomX = new Integer(0);
                    Integer leftBottomY = new Integer(0);
                    Integer rightTopX = new Integer(0);
                    Integer rightTopY = new Integer(0);
                    Integer rightBottomX = new Integer(0);
                    Integer rightBottomY = new Integer(0);
                    Types.Instance instance = segPosistions[i2].getInstance();
                    Integer n2 = segPosistions[i2].getLeftTop().getX();
                    leftTopY = segPosistions[i2].getLeftTop().getY();
                    leftBottomX = segPosistions[i2].getLeftBottom().getX();
                    leftBottomY = segPosistions[i2].getLeftBottom().getY();
                    rightTopX = segPosistions[i2].getRightTop().getX();
                    rightTopY = segPosistions[i2].getRightTop().getY();
                    rightBottomX = segPosistions[i2].getRightBottom().getX();
                    rightBottomY = segPosistions[i2].getRightBottom().getY();
                    executionStepL = "Add segment info.";
                    if (fingerprintQuality != null) {
                        FingerSegment fingerSegmentL = new FingerSegment();
                        fingerSegmentL.setQuality((double)segQuality[i2]);
                        fingerSegmentL.setFingerPosition(L1QAModule.convertToBiometricPosition(instance));
                        fingerSegmentL.setTopLeft(new java.awt.Point(n2, leftTopY));
                        fingerSegmentL.setTopRight(new java.awt.Point(rightTopX, rightTopY));
                        fingerSegmentL.setBottomLeft(new java.awt.Point(leftBottomX, leftBottomY));
                        fingerSegmentL.setBottomRight(new java.awt.Point(rightBottomX, rightBottomY));
                        try {
                            segImages[i2].getHeight();
                        }
                        catch (CustomException cexcL) {
                            this.L1_LOGGER.trace((Object)(this.qssInstanceIdentifierM + ", no segment-info for segment number " + i2));
                            continue;
                        }
                        Blob blobL = segImages[i2].writeToBlob(Types.ImageFormat.Jpeg2000, writeImageDescL);
                        fingerSegmentL.setImage(blobL.getData());
                        blobL.dispose();
                        fingerprintQuality.getFingerSegments().add(fingerSegmentL);
                    }
                    executionStepL = "Perform single finger quality checks.";
                    if (segOutput.getNumFinger() == 1) {
                        singleDescriptorL = new ImageDescriptor(Types.Modality.Fingerprint);
                        singleDescriptorL.setDPI(500);
                        singleDescriptorL.setInstance(instance);
                        singleDescriptorL.setImpressionType(Types.FingerPalmImpressionType.FingerImpressionLivePlain);
                        singleDescriptorL.setFingerPalmRotationTolerance(45);
                        singleDescriptorL.setQualityProfile(Types.QualityProfile.FingerSlapChecks);
                        this.fpSeq.checkQuality(segImages[i2], singleDescriptorL);
                        ((ImageDescriptor)retList.get(0)).dispose();
                        retList.set(0, singleDescriptorL);
                    }
                    if (segQuality[i2] == 0) continue;
                    singleDescriptorL = new ImageDescriptor(Types.Modality.Fingerprint);
                    singleDescriptorL.setDPI(500);
                    singleDescriptorL.setInstance(instance);
                    singleDescriptorL.setImpressionType(Types.FingerPalmImpressionType.FingerImpressionLivePlain);
                    singleDescriptorL.setFingerPalmRotationTolerance(45);
                    singleDescriptorL.setQualityProfile(Types.QualityProfile.FingerChecksA);
                    imageCollection = new ImageCollection();
                    long sampleId = 1L;
                    imageCollection.addImage(sampleId, segImages[i2], singleDescriptorL);
                    idRecord = this.templateCreation.createTemplates(imageCollection, Types.TemplateCreationType.Gallery, 0L, 0L);
                    ImageDescriptor resultImageDesc = imageCollection.getImageDescriptor(this.modalityM, instance, sampleId);
                    retList.add(resultImageDesc);
                    singleDescriptorL.dispose();
                    imageCollection.dispose();
                    idRecord.dispose();
                }
                for (int i2 = 0; i2 < segImages.length; ++i2) {
                    segImages[i2].dispose();
                    segPosistions[i2].dispose();
                }
                i2 = retList;
                if (writeImageDescL == null) break block41;
            }
            catch (CustomException ex) {
                this.L1_LOGGER.error((Object)(this.qssInstanceIdentifierM + ", ExecutionStep: '" + executionStepL + "': Exception caught: " + (Object)((Object)ex)));
                for (ImageDescriptor descL : retList) {
                    if (descL == null) continue;
                    descL.dispose();
                }
                List<ImageDescriptor> list = null;
                return list;
            }
            finally {
                if (writeImageDescL != null) {
                    writeImageDescL.dispose();
                }
                if (segPosistions != null) {
                    for (void var20_33 : segPosistions) {
                        if (var20_33 == null) continue;
                        var20_33.dispose();
                    }
                }
                if (segImages != null) {
                    for (void var20_35 : segImages) {
                        if (var20_35 == null) continue;
                        var20_35.dispose();
                    }
                }
                if (imageCollection != null) {
                    imageCollection.dispose();
                }
                if (idRecord != null) {
                    idRecord.dispose();
                }
                if (singleDescriptorL != null) {
                    singleDescriptorL.dispose();
                }
            }
            writeImageDescL.dispose();
        }
        if (segPosistions != null) {
            for (Image posL : segPosistions) {
                if (posL == null) continue;
                posL.dispose();
            }
        }
        if (segImages != null) {
            for (Image imageL : segImages) {
                if (imageL == null) continue;
                imageL.dispose();
            }
        }
        if (imageCollection != null) {
            imageCollection.dispose();
        }
        if (idRecord != null) {
            idRecord.dispose();
        }
        if (singleDescriptorL != null) {
            singleDescriptorL.dispose();
        }
        return i2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageDescriptor processImage(Image imageA, Types.Instance instanceA, LandmarkList manualLandMarksA, Types.QualityProfile qProfileA) {
        ImageDescriptor imageDescriptor = null;
        ImageCollection imageCollection = null;
        IdRecord idRecord = null;
        ImageDescriptor resultImageDesc = null;
        try {
            imageDescriptor = new ImageDescriptor(this.modalityM);
            imageDescriptor.setInstance(instanceA);
            if (manualLandMarksA != null) {
                imageDescriptor.setManualLandmarkList(manualLandMarksA);
            }
            if (qProfileA != null) {
                imageDescriptor.setQualityProfile(qProfileA);
            } else {
                imageDescriptor.setQualityProfile(this.qProfileM);
            }
            imageDescriptor.setDPI(500);
            imageCollection = new ImageCollection();
            long sampleId = 1L;
            imageCollection.addImage(sampleId, imageA, imageDescriptor);
            long personId = 0L;
            long transactionId = 0L;
            idRecord = this.templateCreation.createTemplates(imageCollection, Types.TemplateCreationType.Gallery, personId, personId);
            ImageDescriptor imageDescriptor2 = resultImageDesc = imageCollection.getImageDescriptor(this.modalityM, instanceA, sampleId);
            return imageDescriptor2;
        }
        catch (Exception e) {
            this.L1_LOGGER.error((Object)(this.qssInstanceIdentifierM + ", error processing image"), (Throwable)e);
            if (resultImageDesc != null) {
                resultImageDesc.dispose();
            }
            ImageDescriptor imageDescriptor3 = null;
            return imageDescriptor3;
        }
        finally {
            if (imageDescriptor != null) {
                imageDescriptor.dispose();
            }
            if (imageCollection != null) {
                imageCollection.dispose();
            }
            if (idRecord != null) {
                idRecord.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] createTemplates(Image imageA, Types.Instance instanceA, Types.TemplateCreationType TCMode) {
        ImageDescriptor imageDescriptor = null;
        ImageCollection imageCollection = null;
        IdRecord idRecord = null;
        Blob blob = null;
        try {
            byte[] template;
            imageDescriptor = new ImageDescriptor(this.modalityM);
            imageDescriptor.setInstance(instanceA);
            imageDescriptor.setQualityProfile(this.qProfileM);
            imageDescriptor.setDPI(500);
            imageCollection = new ImageCollection();
            long sampleId = 1L;
            imageCollection.addImage(sampleId, imageA, imageDescriptor);
            long personId = 0L;
            idRecord = this.templateCreation.createTemplates(imageCollection, TCMode, personId, personId);
            blob = idRecord.getSerializedSample(this.modalityM, instanceA, sampleId);
            byte[] byArray = template = blob.getData();
            return byArray;
        }
        catch (Exception e) {
            this.L1_LOGGER.error((Object)(this.qssInstanceIdentifierM + ", error creating template"), (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (imageDescriptor != null) {
                imageDescriptor.dispose();
            }
            if (imageCollection != null) {
                imageCollection.dispose();
            }
            if (blob != null) {
                blob.dispose();
            }
            if (idRecord != null) {
                idRecord.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] convertIsoToProprietaryTemplate(byte[] isoTemplate, Types.Instance instanceA, Types.TemplateCreationType TCMode) {
        if (isoTemplate == null) {
            this.L1_LOGGER.warn((Object)"iso template data is null");
            return null;
        }
        ImageDescriptor imageDescriptor = null;
        Blob blob = null;
        ImageCollection imageCollection = null;
        IdRecord idRecord = null;
        Blob templateBlob = null;
        try {
            byte[] template;
            this.L1_LOGGER.debug((Object)(this.qssInstanceIdentifierM + ", Setting Template data for Proprietary Conversion from ISO"));
            imageDescriptor = new ImageDescriptor(this.modalityM);
            imageDescriptor.setInstance(instanceA);
            imageDescriptor.setQualityProfile(this.qProfileM);
            imageDescriptor.setDPI(500);
            blob = new Blob();
            blob.setData(isoTemplate);
            imageCollection = new ImageCollection();
            long sampleId = 1L;
            imageCollection.addStandardFingerTemplate(sampleId, blob, Types.StandardTemplateType.IsoRecord, imageDescriptor);
            long personId = 0L;
            idRecord = this.templateCreation.createTemplates(imageCollection, TCMode, personId, personId);
            templateBlob = idRecord.getSerializedSample(this.modalityM, instanceA, sampleId);
            byte[] byArray = template = templateBlob.getData();
            return byArray;
        }
        catch (Exception e) {
            this.L1_LOGGER.error((Object)(this.qssInstanceIdentifierM + ", error converting iso to proprietary template"), (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (imageDescriptor != null) {
                imageDescriptor.dispose();
            }
            if (imageCollection != null) {
                imageCollection.dispose();
            }
            if (blob != null) {
                blob.dispose();
            }
            if (templateBlob != null) {
                templateBlob.dispose();
            }
            if (idRecord != null) {
                idRecord.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] convertProprietaryTemplateToISO(byte[] proprietaryTemplate, Types.Instance fingerInstance) {
        if (proprietaryTemplate == null) {
            this.L1_LOGGER.warn((Object)"proprietary template data is null");
            return null;
        }
        IdRecord templateIDRecord = null;
        Blob templateBlob = null;
        Blob blob = null;
        try {
            byte[] shiftedToMin;
            this.L1_LOGGER.debug((Object)(this.qssInstanceIdentifierM + ", Setting Template data for ISO Conversion"));
            templateIDRecord = new IdRecord();
            templateBlob = new Blob();
            templateBlob.setData(proprietaryTemplate);
            Types.Instance fingerInstanceL = fingerInstance;
            if (fingerInstance == Types.Instance.Unknown || fingerInstance == Types.Instance.FingerUnknown) {
                fingerInstanceL = Types.Instance.FingerLeftIndex;
            }
            templateIDRecord.addSerializedSample(Types.Modality.Fingerprint, fingerInstanceL, 1L, templateBlob);
            blob = this.templateCreation.convertFingerPalmTemplate(templateIDRecord, fingerInstanceL, 1L, Types.StandardTemplateType.IsoRecordSimple);
            byte[] isoTemplate = blob.getData();
            byte[] fmrDataL = Arrays.copyOfRange(isoTemplate, 12, isoTemplate.length);
            if (fingerInstance == Types.Instance.Unknown || fingerInstance == Types.Instance.FingerUnknown) {
                fmrDataL[24] = 0;
            }
            byte[] byArray = shiftedToMin = L1QAModule.shiftFMR(this.L1_LOGGER, fmrDataL, 5);
            return byArray;
        }
        catch (CustomException ex) {
            this.L1_LOGGER.error((Object)(this.qssInstanceIdentifierM + ", error converting proprietary to iso template"), (Throwable)ex);
            byte[] byArray = null;
            return byArray;
        }
        catch (Exception excL) {
            this.L1_LOGGER.error((Object)(this.qssInstanceIdentifierM + ", error converting proprietary to iso template"), (Throwable)excL);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (templateIDRecord != null) {
                templateIDRecord.dispose();
            }
            if (templateBlob != null) {
                templateBlob.dispose();
            }
            if (blob != null) {
                blob.dispose();
            }
        }
    }

    public Image createFullFrontalImage(Image image, ImageDescriptor inputImageDescriptor, ImageDescriptor outputImageDescriptor) {
        if (this.faceSic == null) {
            this.L1_LOGGER.error((Object)(this.qssInstanceIdentifierM + ", Face standard image creator not initialized."));
            return null;
        }
        Image outStandardImage = null;
        try {
            inputImageDescriptor.setQualityProfile(Types.QualityProfile.FaceFullfrontalCandidateChecks);
            outputImageDescriptor.setQualityProfile(Types.QualityProfile.FaceFullfrontalGeometryChecks);
            outStandardImage = new Image();
            this.faceSic.createStandardImage(image, inputImageDescriptor, outStandardImage, outputImageDescriptor, Types.StandardFaceImageType.FaceFullFrontal);
            return outStandardImage;
        }
        catch (Exception e) {
            this.L1_LOGGER.error((Object)(this.qssInstanceIdentifierM + ", error creating full frontal image"), (Throwable)e);
            if (outStandardImage != null) {
                outStandardImage.dispose();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printLandmarks(ImageDescriptor imageDescriptor) {
        LandmarkList landmarkList = null;
        try {
            landmarkList = imageDescriptor.getAutoLandmarkList();
            for (int i = 0; i < landmarkList.length(); ++i) {
                Integer x = new Integer(0);
                Integer y = new Integer(0);
                Types.LandmarkType landmarkType = landmarkList.getType(i);
                Point point = landmarkList.getPosition(i);
                x = point.getX();
                y = point.getY();
                if (landmarkType != Types.LandmarkType.IrisCenter) continue;
                System.out.println("Radius              : " + landmarkList.getIrisRadius(i));
            }
        }
        catch (CustomException ex) {
            this.L1_LOGGER.error((Object)(this.qssInstanceIdentifierM + ", error printing landmarks"), (Throwable)ex);
        }
        finally {
            if (landmarkList != null) {
                landmarkList.dispose();
            }
        }
    }

    public void printQuality(ImageDescriptor imageDescriptor) {
    }

    static BiometricPosition convertToBiometricPosition(Types.Instance instanceA) {
        BiometricPosition positionL = BiometricPosition.UNKNOWN;
        if (instanceA == Types.Instance.FingerLeftIndex) {
            positionL = BiometricPosition.LEFT_INDEX;
        } else if (instanceA == Types.Instance.FingerLeftMiddle) {
            positionL = BiometricPosition.LEFT_MIDDLE;
        } else if (instanceA == Types.Instance.FingerLeftRing) {
            positionL = BiometricPosition.LEFT_RING;
        } else if (instanceA == Types.Instance.FingerLeftLittle) {
            positionL = BiometricPosition.LEFT_LITTLE;
        } else if (instanceA == Types.Instance.FingerLeftThumb) {
            positionL = BiometricPosition.LEFT_THUMB;
        } else if (instanceA == Types.Instance.FingerRightIndex) {
            positionL = BiometricPosition.RIGHT_INDEX;
        } else if (instanceA == Types.Instance.FingerRightMiddle) {
            positionL = BiometricPosition.RIGHT_MIDDLE;
        } else if (instanceA == Types.Instance.FingerRightRing) {
            positionL = BiometricPosition.RIGHT_RING;
        } else if (instanceA == Types.Instance.FingerRightLittle) {
            positionL = BiometricPosition.RIGHT_LITTLE;
        } else if (instanceA == Types.Instance.FingerRightThumb) {
            positionL = BiometricPosition.RIGHT_THUMB;
        }
        return positionL;
    }

    static Types.Instance convertToFingerInstance(Logger L1_LOGGER, BiometricPosition positionA) {
        Types.Instance instanceL = Types.Instance.Unknown;
        if (positionA == null) {
            L1_LOGGER.warn((Object)"Incoming biometric position (for modality fingerprint) is null. Setting biometric position to UNKNOWN.");
        } else {
            switch (positionA) {
                case LEFT_INDEX: {
                    instanceL = Types.Instance.FingerLeftIndex;
                    break;
                }
                case LEFT_MIDDLE: {
                    instanceL = Types.Instance.FingerLeftMiddle;
                    break;
                }
                case LEFT_RING: {
                    instanceL = Types.Instance.FingerLeftRing;
                    break;
                }
                case LEFT_LITTLE: {
                    instanceL = Types.Instance.FingerLeftLittle;
                    break;
                }
                case LEFT_THUMB: {
                    instanceL = Types.Instance.FingerLeftThumb;
                    break;
                }
                case RIGHT_INDEX: {
                    instanceL = Types.Instance.FingerRightIndex;
                    break;
                }
                case RIGHT_MIDDLE: {
                    instanceL = Types.Instance.FingerRightMiddle;
                    break;
                }
                case RIGHT_RING: {
                    instanceL = Types.Instance.FingerRightRing;
                    break;
                }
                case RIGHT_LITTLE: {
                    instanceL = Types.Instance.FingerRightLittle;
                    break;
                }
                case RIGHT_THUMB: {
                    instanceL = Types.Instance.FingerRightThumb;
                    break;
                }
                case UNKNOWN: {
                    instanceL = Types.Instance.Unknown;
                    L1_LOGGER.warn((Object)"Biometric position Unknown for modality fingerprint detected. Note: This can lead to worse performance in verification and identification.");
                    break;
                }
                default: {
                    L1_LOGGER.warn((Object)("Unsupported biometric position (for modality fingerprint): " + positionA + ". Finger position expected. Setting biometric position to UNKNOWN."));
                }
            }
        }
        return instanceL;
    }

    static Types.Instance convertToIrisInstance(Logger L1_LOGGER, BiometricPosition positionA) {
        Types.Instance instanceL = Types.Instance.Unknown;
        if (positionA == null) {
            L1_LOGGER.warn((Object)"Incoming biometric position (for modality iris) is null. Setting biometric position to UNKNOWN.");
        } else {
            switch (positionA) {
                case LEFT_IRIS: {
                    instanceL = Types.Instance.IrisLeft;
                    break;
                }
                case RIGHT_IRIS: {
                    instanceL = Types.Instance.IrisRight;
                    break;
                }
                default: {
                    L1_LOGGER.warn((Object)("Unsupported biometric position (for modality iris): " + positionA + ". Iris position expected. Setting biometric position to UNKNOWN."));
                }
            }
        }
        return instanceL;
    }

    static Types.Instance convertToFaceInstance(Logger L1_LOGGER, BiometricPosition positionA) {
        Types.Instance instanceL = Types.Instance.FaceFrontal;
        if (positionA == null) {
            L1_LOGGER.warn((Object)"Incoming biometric position (for modality face) is null. Setting biometric position to FACE.");
        } else {
            switch (positionA) {
                case FACE: {
                    instanceL = Types.Instance.FaceFrontal;
                    break;
                }
                default: {
                    L1_LOGGER.warn((Object)("Unsupported biometric position (for modality face): " + positionA + ". Face position expected. Setting biometric position to FACE."));
                }
            }
        }
        return instanceL;
    }

    static List<BiometricPosition> getMissingFingers(BiometricPosition positionA) {
        ArrayList<BiometricPosition> retListL = new ArrayList<BiometricPosition>();
        if (positionA != BiometricPosition.LEFT_SLAP && positionA != BiometricPosition.RIGHT_SLAP && positionA != BiometricPosition.BOTH_THUMBS) {
            if (positionA == BiometricPosition.LEFT_THUMB) {
                retListL.add(BiometricPosition.RIGHT_THUMB);
            } else if (positionA == BiometricPosition.RIGHT_THUMB) {
                retListL.add(BiometricPosition.LEFT_THUMB);
            } else if (positionA == BiometricPosition.LEFT_INDEX || positionA == BiometricPosition.LEFT_MIDDLE || positionA == BiometricPosition.LEFT_RING || positionA == BiometricPosition.LEFT_LITTLE) {
                retListL.add(BiometricPosition.LEFT_INDEX);
                retListL.add(BiometricPosition.LEFT_MIDDLE);
                retListL.add(BiometricPosition.LEFT_RING);
                retListL.add(BiometricPosition.LEFT_LITTLE);
                retListL.remove(positionA);
            } else if (positionA == BiometricPosition.RIGHT_INDEX || positionA == BiometricPosition.RIGHT_MIDDLE || positionA == BiometricPosition.RIGHT_RING || positionA == BiometricPosition.RIGHT_LITTLE) {
                retListL.add(BiometricPosition.RIGHT_INDEX);
                retListL.add(BiometricPosition.RIGHT_MIDDLE);
                retListL.add(BiometricPosition.RIGHT_RING);
                retListL.add(BiometricPosition.RIGHT_LITTLE);
                retListL.remove(positionA);
            }
        }
        return retListL;
    }

    static FingerprintQualityAttribute convertQuality(Types.QualityCheckType checktypeA) {
        switch (checktypeA) {
            case SlapPlacement: {
                return FingerprintQualityAttribute.SLAP_PLACEMENT;
            }
            case SlapCentering: {
                return FingerprintQualityAttribute.SLAP_CENTERING;
            }
            case SlapPressHeavy: {
                return FingerprintQualityAttribute.SLAP_PRESS_HEAVY;
            }
            case SlapWetness: {
                return FingerprintQualityAttribute.SLAP_WETNESS;
            }
            case SlapDryness: {
                return FingerprintQualityAttribute.SLAP_DRYNESS;
            }
            case SlapPressLight: {
                return FingerprintQualityAttribute.SLAP_PRESS_LIGHT;
            }
        }
        return null;
    }

    static byte[] shiftFMR(Logger L1_LOGGER, byte[] dataA, int marginA) throws Exception {
        L1_LOGGER.debug((Object)("shift FMR minutiae to upper-left corner, margin " + marginA + " px"));
        int minX = 999999;
        int minY = 999999;
        int widthL = Util.byte2int(Util.concat(new byte[]{dataA[15]}, new byte[]{dataA[14]}));
        int heightL = Util.byte2int(Util.concat(new byte[]{dataA[17]}, new byte[]{dataA[16]}));
        ByteArrayInputStream baisL = new ByteArrayInputStream(dataA);
        baisL.skip(27L);
        int r = baisL.read();
        ArrayList<Minutia> minutiaListL = new ArrayList<Minutia>();
        Minutia minutiaL = null;
        byte[] minutiaDataL = new byte[6];
        for (int i = 0; i < r; ++i) {
            baisL.read(minutiaDataL);
            minutiaL = new Minutia();
            minutiaL.setBytes(minutiaDataL);
            if (minutiaL.x < minX) {
                minX = minutiaL.x;
            }
            if (minutiaL.y < minY) {
                minY = minutiaL.y;
            }
            minutiaListL.add(minutiaL);
        }
        baisL.close();
        minX -= marginA;
        minY -= marginA;
        for (Minutia mL : minutiaListL) {
            mL.x -= minX;
            mL.y -= minY;
            if (mL.x > widthL) {
                mL.x = widthL - 1;
            }
            if (mL.y > heightL) {
                mL.y = heightL - 1;
            }
            if (mL.quality <= 99) continue;
            mL.quality = 99;
        }
        ByteArrayOutputStream baosL = new ByteArrayOutputStream(dataA.length);
        baosL.write(Arrays.copyOfRange(dataA, 0, 28));
        for (Minutia mL : minutiaListL) {
            baosL.write(mL.getBytes());
        }
        int minutiaCountInBytesL = minutiaListL.size() * 6;
        if (dataA.length > 28 + minutiaCountInBytesL) {
            baosL.write(Arrays.copyOfRange(dataA, 28 + minutiaCountInBytesL, dataA.length));
        }
        baosL.close();
        return baosL.toByteArray();
    }

    static byte[] rotate180FMR(byte[] dataA) throws Exception {
        int widthL = Util.byte2int(Util.concat(new byte[]{dataA[15]}, new byte[]{dataA[14]}));
        int heightL = Util.byte2int(Util.concat(new byte[]{dataA[17]}, new byte[]{dataA[16]}));
        ByteArrayInputStream baisL = new ByteArrayInputStream(dataA);
        baisL.skip(27L);
        int r = baisL.read();
        ArrayList<Minutia> minutiaListL = new ArrayList<Minutia>();
        Minutia minutiaL = null;
        byte[] minutiaDataL = new byte[6];
        int centerX = 0;
        int minX = 99999;
        int maxX = 0;
        int centerY = 0;
        int minY = 99999;
        int maxY = 0;
        for (int i = 0; i < r; ++i) {
            baisL.read(minutiaDataL);
            minutiaL = new Minutia();
            minutiaL.setBytes(minutiaDataL);
            if (minutiaL.x < minX) {
                minX = minutiaL.x;
            }
            if (minutiaL.x > maxX) {
                maxX = minutiaL.x;
            }
            if (minutiaL.y < minY) {
                minY = minutiaL.y;
            }
            if (minutiaL.y > maxY) {
                maxY = minutiaL.y;
            }
            minutiaListL.add(minutiaL);
        }
        baisL.close();
        centerX = (minX + maxX) / 2;
        centerY = (minY + maxY) / 2;
        for (Minutia mL : minutiaListL) {
            mL.x -= centerX;
            mL.y -= centerY;
            mL.x = -mL.x;
            mL.y = -mL.y;
            mL.angle = (mL.angle + 128) % 256;
            mL.x += centerX;
            mL.y += centerY;
        }
        ByteArrayOutputStream baosL = new ByteArrayOutputStream(dataA.length);
        baosL.write(Arrays.copyOfRange(dataA, 0, 28));
        for (Minutia mL : minutiaListL) {
            baosL.write(mL.getBytes());
        }
        int minutiaCountInBytesL = minutiaListL.size() * 6;
        if (dataA.length > 28 + minutiaCountInBytesL) {
            baosL.write(Arrays.copyOfRange(dataA, 28 + minutiaCountInBytesL, dataA.length));
        }
        baosL.close();
        return baosL.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IdRecord rotate180IrisTemplate(Logger L1_LOGGER, IdRecord idRecordA, Types.Instance instanceA, long sampleIdA) throws Exception {
        Blob rotatedFeatureBlobL = null;
        IdRecord rotatedIdRecordL = null;
        Blob rawFeatureBlobL = null;
        try {
            rawFeatureBlobL = idRecordA.getRawTemplateBlob(Types.Modality.Iris, instanceA, sampleIdA, Types.Algorithm.Iris2PiSdk, Types.TemplateCreationType.Gallery);
            byte[] rawFeaturesL = rawFeatureBlobL.getData();
            if (rawFeaturesL.length != 512) {
                L1_LOGGER.error((Object)("Unexpected iris feature size: " + rawFeaturesL.length + " (512 expected)."));
            }
            ByteArrayOutputStream baosL = new ByteArrayOutputStream(rawFeaturesL.length);
            int startIdxL = 128;
            int blockSizeL = 128;
            baosL.write(Arrays.copyOfRange(rawFeaturesL, startIdxL, startIdxL + blockSizeL));
            startIdxL = 0;
            baosL.write(Arrays.copyOfRange(rawFeaturesL, startIdxL, startIdxL + blockSizeL));
            startIdxL = 384;
            baosL.write(Arrays.copyOfRange(rawFeaturesL, startIdxL, startIdxL + blockSizeL));
            startIdxL = 256;
            baosL.write(Arrays.copyOfRange(rawFeaturesL, startIdxL, startIdxL + blockSizeL));
            rotatedFeatureBlobL = new Blob();
            rotatedFeatureBlobL.setData(baosL.toByteArray());
            rotatedIdRecordL = new IdRecord();
            rotatedIdRecordL.addRawTemplateBlob(Types.Modality.Iris, instanceA, sampleIdA, Types.Algorithm.Iris2PiSdk, Types.TemplateCreationType.Gallery, rotatedFeatureBlobL);
            IdRecord idRecord = rotatedIdRecordL;
            return idRecord;
        }
        catch (Exception ex) {
            if (rotatedIdRecordL != null) {
                rotatedIdRecordL.dispose();
            }
            L1_LOGGER.error((Object)"Exception caught: ", (Throwable)ex);
            IdRecord idRecord = null;
            return idRecord;
        }
        finally {
            if (rotatedFeatureBlobL != null) {
                rotatedFeatureBlobL.dispose();
            }
            if (rawFeatureBlobL != null) {
                rawFeatureBlobL.dispose();
            }
        }
    }

    static byte[] longToByteArray(long input, int width) {
        byte[] byteArray = new byte[width];
        for (int n = 0; n < width; ++n) {
            byteArray[width - 1 - n] = n > 7 ? (byte)0 : (byte)(input >>> n * 8);
        }
        return byteArray;
    }

    static int getImageFormatFromIIR(Logger L1_LOGGER, byte[] iirDataA) {
        byte[] irisImageFormatArrL = new byte[]{iirDataA[21], iirDataA[22]};
        int iirImageFormatL = new BigInteger(irisImageFormatArrL).intValue();
        int imageStructImageFormatL = -1;
        switch (iirImageFormatL) {
            case 2: {
                imageStructImageFormatL = 9;
                break;
            }
            case 4: {
                imageStructImageFormatL = 8;
                break;
            }
            case 6: {
                imageStructImageFormatL = 3;
                break;
            }
            case 8: {
                imageStructImageFormatL = 2;
                break;
            }
            case 10: {
                imageStructImageFormatL = 5;
                break;
            }
            case 12: {
                imageStructImageFormatL = 4;
                break;
            }
            case 14: {
                imageStructImageFormatL = 1;
                break;
            }
            case 16: {
                imageStructImageFormatL = 0;
                break;
            }
            default: {
                L1_LOGGER.error((Object)("Unsupported image format in Iris Image Record: " + iirImageFormatL));
            }
        }
        return imageStructImageFormatL;
    }

    static byte[] replaceImageDataInFIR(Logger L1_LOGGER, byte[] origFIRDataA, byte[] newImageDataA, byte imageCompressionAlgorithmByteA) throws Exception {
        byte[] generalRecordHeaderL = Arrays.copyOfRange(origFIRDataA, 0, 32);
        byte[] firstImageHeaderL = Arrays.copyOfRange(origFIRDataA, 32, 46);
        int overallSizeL = generalRecordHeaderL.length + firstImageHeaderL.length + newImageDataA.length;
        int imageRecordSizeL = firstImageHeaderL.length + newImageDataA.length;
        byte[] overallSizeArrL = L1QAModule.longToByteArray(overallSizeL, 6);
        generalRecordHeaderL[8] = overallSizeArrL[0];
        generalRecordHeaderL[9] = overallSizeArrL[1];
        generalRecordHeaderL[10] = overallSizeArrL[2];
        generalRecordHeaderL[11] = overallSizeArrL[3];
        generalRecordHeaderL[12] = overallSizeArrL[4];
        generalRecordHeaderL[13] = overallSizeArrL[5];
        generalRecordHeaderL[29] = imageCompressionAlgorithmByteA;
        byte[] imageRecordSizeArrL = L1QAModule.longToByteArray(imageRecordSizeL, 4);
        firstImageHeaderL[0] = imageRecordSizeArrL[0];
        firstImageHeaderL[1] = imageRecordSizeArrL[1];
        firstImageHeaderL[2] = imageRecordSizeArrL[2];
        firstImageHeaderL[3] = imageRecordSizeArrL[3];
        byte[] firDataL = Util.concat(generalRecordHeaderL, firstImageHeaderL);
        firDataL = Util.concat(firDataL, newImageDataA);
        return firDataL;
    }

    public static Vector<IrisImageStruct> getImagesFromPackage(IIR_2011 iir) {
        Vector<IrisImageStruct> irisImageStructVectorL = new Vector<IrisImageStruct>();
        List<IIR_2011.RepresentationHeader> representationHeaders = iir.irisList;
        int i = 0;
        int imageType = 0;
        for (IIR_2011.RepresentationHeader representationHeader : representationHeaders) {
            if (representationHeader.imageFormat == 14) {
                imageType = 7;
            }
            if (representationHeader.imageFormat == 10) {
                imageType = 0;
            }
            if (representationHeader.imageFormat == 2) {
                imageType = 8;
            }
            IrisImageStruct tmp_is = new IrisImageStruct(representationHeader.imageData, imageType, representationHeader.imageWidth, representationHeader.imageHeight, representationHeader.eyeLabel, iir.header.numberOfIrisRepresentations, ++i, representationHeader.horizontalOrientation, representationHeader.verticalOrientation, 0, 0, 0, 0);
            irisImageStructVectorL.add(tmp_is);
        }
        return irisImageStructVectorL;
    }

    static byte[] replaceImageDataIn2011IIR(Logger L1_LOGGER, byte[] origIIRDataA, byte[] newImageDataA, byte imageCompressionAlgorithmByteA, IIR_2011.RepresentationHeader representationHeaders) {
        int lengthOfQualityBlock = 1;
        byte[] generalRecordHeaderL = Arrays.copyOfRange(origIIRDataA, 0, 16);
        int range = (int)representationHeaders.representationLength - representationHeaders.imageData.length + 16;
        byte[] representationHeader = Arrays.copyOfRange(origIIRDataA, 16, range);
        int overallSizeL = generalRecordHeaderL.length + representationHeader.length + newImageDataA.length;
        int imageRecordSizeL = newImageDataA.length;
        int representationLength = representationHeader.length + newImageDataA.length;
        byte[] representationLengthInBytes = UtilHelper.intToByteArray(representationLength, 4);
        representationHeader[0] = representationLengthInBytes[0];
        representationHeader[1] = representationLengthInBytes[1];
        representationHeader[2] = representationLengthInBytes[2];
        representationHeader[3] = representationLengthInBytes[3];
        byte[] overallSizeArrL = L1QAModule.longToByteArray(overallSizeL, 4);
        generalRecordHeaderL[8] = overallSizeArrL[0];
        generalRecordHeaderL[9] = overallSizeArrL[1];
        generalRecordHeaderL[10] = overallSizeArrL[2];
        generalRecordHeaderL[11] = overallSizeArrL[3];
        List<IIR_2011.QualityBlock> listOfQualityBlock = representationHeaders.qualityBlockList;
        if (listOfQualityBlock == null) {
            lengthOfQualityBlock = 1;
        } else {
            for (IIR_2011.QualityBlock qualityBlock : listOfQualityBlock) {
                lengthOfQualityBlock += 5;
            }
        }
        byte[] imageFormatArrL = L1QAModule.longToByteArray(imageCompressionAlgorithmByteA, 1);
        representationHeader[22 + lengthOfQualityBlock] = imageFormatArrL[0];
        byte[] imageRecordSizeArrL = L1QAModule.longToByteArray(imageRecordSizeL, 4);
        representationHeader[lengthOfQualityBlock + 47] = imageRecordSizeArrL[0];
        representationHeader[lengthOfQualityBlock + 48] = imageRecordSizeArrL[1];
        representationHeader[lengthOfQualityBlock + 49] = imageRecordSizeArrL[2];
        representationHeader[lengthOfQualityBlock + 50] = imageRecordSizeArrL[3];
        byte[] iirDataL = Util.concat(generalRecordHeaderL, representationHeader);
        iirDataL = Util.concat(iirDataL, newImageDataA);
        return iirDataL;
    }

    static byte[] replaceImageDataInIIR(Logger L1_LOGGER, byte[] origIIRDataA, byte[] newImageDataA, byte imageCompressionAlgorithmByteA) throws Exception {
        byte[] generalRecordHeaderL = Arrays.copyOfRange(origIIRDataA, 0, 45);
        byte[] subHeaderL = Arrays.copyOfRange(origIIRDataA, 45, 48);
        byte[] firstImageHeaderL = Arrays.copyOfRange(origIIRDataA, 48, 59);
        int overallSizeL = generalRecordHeaderL.length + subHeaderL.length + firstImageHeaderL.length + newImageDataA.length;
        int imageRecordSizeL = newImageDataA.length;
        byte[] overallSizeArrL = L1QAModule.longToByteArray(overallSizeL, 4);
        generalRecordHeaderL[8] = overallSizeArrL[0];
        generalRecordHeaderL[9] = overallSizeArrL[1];
        generalRecordHeaderL[10] = overallSizeArrL[2];
        generalRecordHeaderL[11] = overallSizeArrL[3];
        byte[] imageFormatArrL = L1QAModule.longToByteArray(imageCompressionAlgorithmByteA, 2);
        generalRecordHeaderL[21] = imageFormatArrL[0];
        generalRecordHeaderL[22] = imageFormatArrL[1];
        byte[] imageRecordSizeArrL = L1QAModule.longToByteArray(imageRecordSizeL, 4);
        firstImageHeaderL[7] = imageRecordSizeArrL[0];
        firstImageHeaderL[8] = imageRecordSizeArrL[1];
        firstImageHeaderL[9] = imageRecordSizeArrL[2];
        firstImageHeaderL[10] = imageRecordSizeArrL[3];
        byte[] iirDataL = Util.concat(generalRecordHeaderL, subHeaderL);
        iirDataL = Util.concat(iirDataL, firstImageHeaderL);
        iirDataL = Util.concat(iirDataL, newImageDataA);
        return iirDataL;
    }

    static byte[] replaceImageDataInFAC(Logger L1_LOGGER, byte[] origFACDataA, byte[] newImageDataA, byte imageCompressionAlgorithmByteA) throws Exception {
        byte[] generalRecordHeaderL = Arrays.copyOfRange(origFACDataA, 0, 14);
        byte[] numberOfFeaturePointsArrL = new byte[]{origFACDataA[18], origFACDataA[19]};
        int numberOfFeaturePointsL = new BigInteger(numberOfFeaturePointsArrL).intValue();
        int firstImageHeaderSizeL = 20 + 8 * numberOfFeaturePointsL + 12;
        byte[] firstImageHeaderL = Arrays.copyOfRange(origFACDataA, 14, 14 + firstImageHeaderSizeL);
        int overallSizeL = generalRecordHeaderL.length + firstImageHeaderL.length + newImageDataA.length;
        int imageRecordSizeL = firstImageHeaderL.length + newImageDataA.length;
        byte[] overallSizeArrL = L1QAModule.longToByteArray(overallSizeL, 4);
        generalRecordHeaderL[8] = overallSizeArrL[0];
        generalRecordHeaderL[9] = overallSizeArrL[1];
        generalRecordHeaderL[10] = overallSizeArrL[2];
        generalRecordHeaderL[11] = overallSizeArrL[3];
        byte[] imageRecordSizeArrL = L1QAModule.longToByteArray(imageRecordSizeL, 4);
        firstImageHeaderL[0] = imageRecordSizeArrL[0];
        firstImageHeaderL[1] = imageRecordSizeArrL[1];
        firstImageHeaderL[2] = imageRecordSizeArrL[2];
        firstImageHeaderL[3] = imageRecordSizeArrL[3];
        firstImageHeaderL[20 + 8 * numberOfFeaturePointsL + 1] = imageCompressionAlgorithmByteA;
        byte[] facDataL = Util.concat(generalRecordHeaderL, firstImageHeaderL);
        facDataL = Util.concat(facDataL, newImageDataA);
        return facDataL;
    }

    static Image createFoundationImage(Logger L1_LOGGER, ImageStruct isoImageStructA, Types.Modality modalityA) throws CustomException {
        return L1QAModule.createFoundationImage(L1_LOGGER, isoImageStructA.getImage(), isoImageStructA.getWidth(), isoImageStructA.getHeight(), isoImageStructA.getImageType(), modalityA);
    }

    static Image createFoundationImage(Logger L1_LOGGER, byte[] imageDataA, int widthA, int heightA, int imageTypeA, Types.Modality modalityA) throws CustomException {
        if (imageDataA.length == 0) {
            L1_LOGGER.fatal((Object)"Failed to read image. No image data present.");
            return null;
        }
        Image fndImageL = new Image();
        try {
            switch (imageTypeA) {
                case 8: {
                    if (modalityA == Types.Modality.Iris) {
                        L1_LOGGER.trace((Object)"RAW: loadRaw RGB image blob.");
                        fndImageL.loadRaw(imageDataA, widthA, heightA, Types.ImageChannelSequence.Rgb, Types.ImageDataOrder.Pixel);
                        break;
                    }
                }
                case 9: {
                    L1_LOGGER.trace((Object)"RAW_MONO: loadRaw Gray image blob.");
                    fndImageL.loadRaw(imageDataA, widthA, heightA, Types.ImageChannelSequence.Gray, Types.ImageDataOrder.Plane);
                    break;
                }
                default: {
                    L1_LOGGER.trace((Object)"Compressed image: readBlob.");
                    fndImageL.readBlob(imageDataA, 0L);
                }
            }
            return fndImageL;
        }
        catch (Exception ce) {
            L1_LOGGER.fatal((Object)"Failed to read image.", (Throwable)ce);
            if (fndImageL != null) {
                fndImageL.dispose();
            }
            return null;
        }
    }

    static boolean isFMR(byte[] template) {
        return (char)template[0] == 'F' && (char)template[1] == 'M' && (char)template[2] == 'R';
    }

    static Types.Modality getModality(Logger L1_LOGGER, byte[] dataA) {
        if ((char)dataA[0] == 'T' && (char)dataA[1] == 'P') {
            int metaDataLengh = Util.byte2int(new byte[]{dataA[27], dataA[26], dataA[25], dataA[24]});
            int tbOffset = 30 + metaDataLengh;
            if (dataA[tbOffset + 5] == 0) {
                switch (dataA[tbOffset + 4]) {
                    case 9: 
                    case 21: 
                    case 23: 
                    case 25: {
                        return Types.Modality.Face;
                    }
                    case -106: 
                    case -105: 
                    case -104: 
                    case -103: 
                    case -102: {
                        return Types.Modality.Fingerprint;
                    }
                    case -56: 
                    case -55: {
                        return Types.Modality.Iris;
                    }
                }
            }
        } else {
            if ((char)dataA[0] == 'F' && (char)dataA[1] == 'M' && (char)dataA[2] == 'R' && (char)dataA[3] == '\u0000') {
                if (dataA[4] != 32 || dataA[5] != 50 || dataA[6] != 48 || dataA[7] != 0) {
                    L1_LOGGER.error((Object)"FMR, Version is other than '20'");
                    return Types.Modality.Unknown;
                }
                int len = Util.byte2int(new byte[]{dataA[11], dataA[10], dataA[9], dataA[8]});
                if (len != dataA.length) {
                    L1_LOGGER.error((Object)("FMR, Length information is '" + len + "', expected : '" + dataA.length + "'"));
                    return Types.Modality.Unknown;
                }
                return Types.Modality.Fingerprint;
            }
            if ((char)dataA[0] == 'F' && (char)dataA[1] == 'I' && (char)dataA[2] == 'R') {
                return Types.Modality.Fingerprint;
            }
            if ((char)dataA[0] == 'F' && (char)dataA[1] == 'A' && (char)dataA[2] == 'C') {
                return Types.Modality.Face;
            }
            if ((char)dataA[0] == 'I' && (char)dataA[1] == 'I' && (char)dataA[2] == 'R') {
                return Types.Modality.Iris;
            }
        }
        return Types.Modality.Unknown;
    }

    public Image createKindImages(Image l1Image, IrisImageFormat targetImageType, int targetSize, Types.Instance irisType, int sourceImageSize, int imageType) throws CustomException {
        ImageDescriptor imageDesc = new ImageDescriptor(this.modalityM);
        imageDesc.setInstance(irisType);
        imageDesc.setQualityProfile(Types.QualityProfile.MinChecks);
        if (targetImageType.equals((Object)IrisImageFormat.IMAGE_TYPE_UNCROPPED)) {
            imageDesc.setIrisOutputISOImageType(Types.StandardIrisImageType.UnCropped);
        }
        if (targetImageType.equals((Object)IrisImageFormat.IMAGE_TYPE_VGA)) {
            imageDesc.setIrisOutputISOImageType(Types.StandardIrisImageType.UnCropped);
        }
        if (targetImageType.equals((Object)IrisImageFormat.IMAGE_TYPE_CROPPED)) {
            imageDesc.setIrisOutputISOImageType(Types.StandardIrisImageType.Cropped);
        }
        if (targetImageType.equals((Object)IrisImageFormat.IMAGE_TYPE_CROPPED_AND_MASKED)) {
            imageDesc.setIrisOutputISOImageType(Types.StandardIrisImageType.CroppedAndMasked);
        }
        ImageCollection imageCollection = new ImageCollection();
        long sampleId = 0L;
        imageCollection.addImage(sampleId, l1Image, imageDesc);
        long personId = 1L;
        long transactionId = 2L;
        IdRecord idRecord = this.templateCreation.createTemplates(imageCollection, Types.TemplateCreationType.Gallery, personId, transactionId);
        ImageDescriptor outDesc = imageCollection.getImageDescriptor(this.modalityM, irisType, sampleId);
        Image isoImg = outDesc.getIrisOutputISOImage();
        return isoImg;
    }

    public Blob getBlob(int sourceImageSize, int targetSize, int imageType, IrisImageFormat targetImageType, Image isoImg) throws CustomException {
        WriteImageDescriptor wid = new WriteImageDescriptor();
        int compressionRatio = 10;
        float tempCompressionRatio = 0.0f;
        Blob blob = null;
        if (targetSize != 0) {
            tempCompressionRatio = (float)targetSize * 100.0f / (float)sourceImageSize;
            compressionRatio = (int)tempCompressionRatio;
        }
        if (compressionRatio < 2) {
            compressionRatio = 2;
        }
        if (targetImageType.equals((Object)IrisImageFormat.IMAGE_TYPE_CROPPED_AND_MASKED)) {
            if (imageType == 7) {
                wid.setPngCompressionLevel(compressionRatio /= 10);
            } else {
                wid.setJpeg2000CompressionQuality(compressionRatio);
            }
        }
        if (imageType == 7) {
            blob = isoImg.writeToBlob(Types.ImageFormat.Png, wid);
        } else if (imageType == 0 || imageType == 1) {
            blob = isoImg.writeToBlob(Types.ImageFormat.Jpeg2000, wid);
        } else if (imageType == 8 || imageType == 9) {
            if (targetImageType.equals((Object)IrisImageFormat.IMAGE_TYPE_CROPPED_AND_MASKED)) {
                blob = isoImg.writeToBlob(Types.ImageFormat.Jpeg2000, wid);
            } else {
                blob = new Blob();
                byte[] data = isoImg.getRawGrayScaleData();
                blob.setData(data);
            }
        }
        return blob;
    }

    public byte[] add2011HeaderTo2005IIRImage(List<Image> images, Vector<IrisImageStruct> dataVec, IrisImageFormat targetImageType, int targetSize) throws CustomException {
        byte[] fixed = new byte[]{73, 73, 82, 0, 48, 50, 48, 0, 48, 48, 48, 48, 48, 48, 0, 48};
        int representationCount = 1;
        boolean left = false;
        boolean right = false;
        boolean unknown = false;
        int numberOfEyes = 0;
        int representationHeaderSize = 52;
        byte[] generalRecordHeader = Arrays.copyOfRange(fixed, 0, fixed.length);
        byte[] numberOfIrisRepresentations = UtilHelper.intToByteArray(images.size(), 2);
        generalRecordHeader[12] = numberOfIrisRepresentations[0];
        generalRecordHeader[13] = numberOfIrisRepresentations[1];
        for (IrisImageStruct iis : dataVec) {
            if (iis.getPosition() == 0) {
                unknown = true;
            }
            if (iis.getPosition() == 1) {
                left = true;
            }
            if (iis.getPosition() != 2) continue;
            right = true;
        }
        if (unknown && !left && !right) {
            numberOfEyes = 0;
        } else {
            if (left && right && !unknown) {
                numberOfEyes = 2;
            }
            if (!left && right && !unknown) {
                numberOfEyes = 1;
            }
            if (left && !right && !unknown) {
                numberOfEyes = 1;
            }
        }
        byte[] numberOfEyesRepresented = UtilHelper.intToByteArray(numberOfEyes, 1);
        generalRecordHeader[15] = numberOfEyesRepresented[0];
        byte[] iirDataL = Arrays.copyOf(generalRecordHeader, generalRecordHeader.length);
        int i = 0;
        for (Image image1 : images) {
            int imageType;
            int sourceImageSize = dataVec.get(i).getImage().length;
            int imageType1 = dataVec.get(i).getImageType();
            Blob blob = this.getBlob(sourceImageSize, targetSize, imageType1, targetImageType, image1);
            byte[] representationHeader = new byte[52];
            byte[] imageData = blob.getData();
            int imageSize = imageData.length;
            int representationLength = representationHeaderSize + imageSize;
            byte[] representationLengthInBytes = UtilHelper.intToByteArray(representationLength, 4);
            representationHeader[0] = representationLengthInBytes[0];
            representationHeader[1] = representationLengthInBytes[1];
            representationHeader[2] = representationLengthInBytes[2];
            representationHeader[3] = representationLengthInBytes[3];
            Date date = new Date();
            SimpleDateFormat yyyy = new SimpleDateFormat("yyyy");
            String year = yyyy.format(date);
            int y = Integer.parseInt(year);
            byte[] yearInBytes = UtilHelper.intToByteArray(y, 2);
            representationHeader[4] = yearInBytes[0];
            representationHeader[5] = yearInBytes[1];
            SimpleDateFormat months = new SimpleDateFormat("MM");
            String month = months.format(date);
            int m = Integer.parseInt(month);
            byte[] monthInBytes = UtilHelper.intToByteArray(m, 1);
            representationHeader[6] = monthInBytes[0];
            SimpleDateFormat days = new SimpleDateFormat("dd");
            String day = days.format(date);
            int d = Integer.parseInt(day);
            byte[] dayInBytes = UtilHelper.intToByteArray(d, 1);
            representationHeader[7] = dayInBytes[0];
            SimpleDateFormat hours = new SimpleDateFormat("hh");
            String hour = hours.format(date);
            int h = Integer.parseInt(hour);
            byte[] hourInBytes = UtilHelper.intToByteArray(h, 1);
            representationHeader[8] = hourInBytes[0];
            SimpleDateFormat minutes = new SimpleDateFormat("mm");
            String minute = minutes.format(date);
            int min = Integer.parseInt(minute);
            byte[] minuteInBytes = UtilHelper.intToByteArray(min, 1);
            representationHeader[9] = minuteInBytes[0];
            SimpleDateFormat seconds = new SimpleDateFormat("ss");
            String second = seconds.format(date);
            int sec = Integer.parseInt(second);
            byte[] secondInBytes = UtilHelper.intToByteArray(sec, 1);
            representationHeader[10] = secondInBytes[0];
            representationHeader[11] = -1;
            representationHeader[12] = -1;
            byte[] representationCountInBytes = UtilHelper.intToByteArray(representationCount, 2);
            representationHeader[19] = representationCountInBytes[0];
            representationHeader[20] = representationCountInBytes[1];
            representationHeader[21] = UtilHelper.intToByteArray(dataVec.get(representationCount - 1).getPosition(), 1)[0];
            if (targetImageType.equals((Object)IrisImageFormat.IMAGE_TYPE_UNCROPPED)) {
                representationHeader[22] = 1;
            }
            if (targetImageType.equals((Object)IrisImageFormat.IMAGE_TYPE_VGA)) {
                representationHeader[22] = 2;
            }
            if (targetImageType.equals((Object)IrisImageFormat.IMAGE_TYPE_CROPPED)) {
                representationHeader[22] = 3;
            }
            if (targetImageType.equals((Object)IrisImageFormat.IMAGE_TYPE_CROPPED_AND_MASKED)) {
                representationHeader[22] = 7;
            }
            representationHeader[23] = (imageType = dataVec.get(representationCount - 1).getImageType()) == 8 || imageType == 9 ? (targetImageType.equals((Object)IrisImageFormat.IMAGE_TYPE_UNCROPPED) || targetImageType.equals((Object)IrisImageFormat.IMAGE_TYPE_VGA) || targetImageType.equals((Object)IrisImageFormat.IMAGE_TYPE_CROPPED) ? 2 : 10) : 10;
            byte[] width = UtilHelper.intToByteArray(image1.getWidth(), 2);
            representationHeader[25] = width[0];
            representationHeader[26] = width[1];
            byte[] height = UtilHelper.intToByteArray(image1.getHeight(), 2);
            representationHeader[27] = height[0];
            representationHeader[28] = height[1];
            byte[] bitDepth = UtilHelper.intToByteArray(image1.getBitCount(), 1);
            representationHeader[29] = bitDepth[0];
            byte[] imageSizeinbytes = UtilHelper.intToByteArray(imageSize, 4);
            representationHeader[48] = imageSizeinbytes[0];
            representationHeader[49] = imageSizeinbytes[1];
            representationHeader[50] = imageSizeinbytes[2];
            representationHeader[51] = imageSizeinbytes[3];
            iirDataL = Util.concat(iirDataL, representationHeader);
            iirDataL = Util.concat(iirDataL, imageData);
            ++representationCount;
            ++i;
        }
        int totalSizeOfRecord = iirDataL.length;
        byte[] totalSizeOfRecordInBytes = UtilHelper.intToByteArray(totalSizeOfRecord, 4);
        iirDataL[8] = totalSizeOfRecordInBytes[0];
        iirDataL[9] = totalSizeOfRecordInBytes[1];
        iirDataL[10] = totalSizeOfRecordInBytes[2];
        iirDataL[11] = totalSizeOfRecordInBytes[3];
        return iirDataL;
    }

    public byte[] add2011HeaderTo2011IIRImage(List<Image> images, byte[] inputIIR, List<IIR_2011.RepresentationHeader> representationHeaders, IrisImageFormat targetImageType, int targetSize, Vector<IrisImageStruct> dataVec) throws CustomException {
        int sizeOfRepresentation;
        byte[] generalRecordHeader = Arrays.copyOfRange(inputIIR, 0, 16);
        int sizeOfBlob = images.size();
        int i = sizeOfBlob >= (sizeOfRepresentation = representationHeaders.size()) ? sizeOfRepresentation : sizeOfBlob;
        byte[] iirDataL = Arrays.copyOf(generalRecordHeader, generalRecordHeader.length);
        int from = 16;
        int to = 0;
        for (int j = 0; j < i; ++j) {
            int repLength = (int)representationHeaders.get((int)j).representationLength - representationHeaders.get((int)j).imageData.length;
            to = from + repLength;
            byte[] representation = Arrays.copyOfRange(inputIIR, from, to);
            Blob blob = this.getBlob(representationHeaders.get((int)j).imageData.length, targetSize, dataVec.get(j).getImageType(), targetImageType, images.get(j));
            byte[] imageData = blob.getData();
            int representationLength = representation.length + imageData.length;
            byte[] representationLengthInBytes = UtilHelper.intToByteArray(representationLength, 4);
            representation[0] = representationLengthInBytes[0];
            representation[1] = representationLengthInBytes[1];
            representation[2] = representationLengthInBytes[2];
            representation[3] = representationLengthInBytes[3];
            int imageTypeIndex = repLength - 30;
            if (targetImageType.equals((Object)IrisImageFormat.IMAGE_TYPE_UNCROPPED)) {
                representation[imageTypeIndex] = 1;
            }
            if (targetImageType.equals((Object)IrisImageFormat.IMAGE_TYPE_VGA)) {
                representation[imageTypeIndex] = 2;
            }
            if (targetImageType.equals((Object)IrisImageFormat.IMAGE_TYPE_CROPPED)) {
                representation[imageTypeIndex] = 3;
            }
            if (targetImageType.equals((Object)IrisImageFormat.IMAGE_TYPE_CROPPED_AND_MASKED)) {
                representation[imageTypeIndex] = 7;
            }
            if (representationHeaders.get((int)j).imageFormat == 2 && targetImageType.equals((Object)IrisImageFormat.IMAGE_TYPE_CROPPED_AND_MASKED)) {
                int imageFormatIndex = repLength - 29;
                representation[imageFormatIndex] = 10;
            }
            int imageWidthIndex = repLength - 27;
            byte[] width = UtilHelper.intToByteArray(images.get(j).getWidth(), 2);
            representation[imageWidthIndex] = width[0];
            representation[imageWidthIndex + 1] = width[1];
            byte[] height = UtilHelper.intToByteArray(images.get(j).getHeight(), 2);
            representation[imageWidthIndex + 2] = height[0];
            representation[imageWidthIndex + 3] = height[1];
            int imageLengthIndex = repLength - 4;
            byte[] imageLengthInBytes = UtilHelper.intToByteArray(imageData.length, 4);
            representation[imageLengthIndex] = imageLengthInBytes[0];
            representation[imageLengthIndex + 1] = imageLengthInBytes[1];
            representation[imageLengthIndex + 2] = imageLengthInBytes[2];
            representation[imageLengthIndex + 3] = imageLengthInBytes[3];
            iirDataL = Util.concat(iirDataL, representation);
            iirDataL = Util.concat(iirDataL, imageData);
            from = to + representationHeaders.get((int)j).imageLength;
        }
        int totalSizeOfRecord = iirDataL.length;
        byte[] totalSizeOfRecordInBytes = UtilHelper.intToByteArray(totalSizeOfRecord, 4);
        iirDataL[8] = totalSizeOfRecordInBytes[0];
        iirDataL[9] = totalSizeOfRecordInBytes[1];
        iirDataL[10] = totalSizeOfRecordInBytes[2];
        iirDataL[11] = totalSizeOfRecordInBytes[3];
        return iirDataL;
    }
}

