/*
 * Decompiled with CFR 0.152.
 */
package com.l1id.uid.qssitv;

import com.identix.uidai.cbeff.FacialISO;
import com.identix.uidai.cbeff.FingerISO;
import com.identix.uidai.cbeff.ImageStruct;
import com.identix.uidai.cbeff.IrisISO;
import com.identix.uidai.cbeff.IrisImageStruct;
import com.l1id.sdk.foundation.Blob;
import com.l1id.sdk.foundation.CustomException;
import com.l1id.sdk.foundation.Image;
import com.l1id.sdk.foundation.ImageDescriptor;
import com.l1id.sdk.foundation.LandmarkList;
import com.l1id.sdk.foundation.Point;
import com.l1id.sdk.foundation.Quality;
import com.l1id.sdk.foundation.Types;
import com.l1id.sdk.foundation.WriteImageDescriptor;
import com.l1id.uid.iso19794_2011.IIR_2011;
import com.l1id.uid.iso19794_2011.ValidateHeaders;
import com.l1id.uid.qssitv.ImageConverter;
import com.l1id.uid.qssitv.L1ITVEngine;
import com.l1id.uid.qssitv.L1QAModule;
import com.l1id.uid.qssitv.Version;
import helper.UtilHelper;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.qssitv.model.BiometricTemplate;
import in.gov.uidai.qssitv.model.Compliance;
import in.gov.uidai.qssitv.model.FaceQSS;
import in.gov.uidai.qssitv.model.FaceQualityAttribute;
import in.gov.uidai.qssitv.model.FaceQualityFeedback;
import in.gov.uidai.qssitv.model.FingerprintQSS;
import in.gov.uidai.qssitv.model.FingerprintQualityAttribute;
import in.gov.uidai.qssitv.model.FingerprintQualityFeedback;
import in.gov.uidai.qssitv.model.FormatType;
import in.gov.uidai.qssitv.model.IrisImageFormat;
import in.gov.uidai.qssitv.model.IrisQSS;
import in.gov.uidai.qssitv.model.IrisQualityAttribute;
import in.gov.uidai.qssitv.model.IrisQualityFeedback;
import in.gov.uidai.qssitv.model.LandMark;
import in.gov.uidai.qssitv.model.LandMarkType;
import in.gov.uidai.qssitv.spi.IQSSEngine;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class L1QSSEngine
implements IQSSEngine {
    private static final String CONFIG_FILE_NAME = "/conf/l1qssengine.properties";
    private static final Logger L1_LOGGER = Logger.getLogger(L1QSSEngine.class);
    private static int instanceCounterM = -1;
    private String instanceIdentifierM = "QSSEngine-" + ++instanceCounterM;
    private static byte[] ISOHeader = new byte[12];
    private boolean iso_parsing_strict = true;
    private double face_FaceGrayValues_threshold = 35.0;
    private double face_Faceness_threshold = 40.0;
    private double face_PoseYaw_threshold = 40.0;
    private double face_PoseRoll_threshold = 10.0;
    private double face_EyeDistance_threshold = 90.0;
    private double face_EyeDistanceRatio_threshold = 0.333;
    private double face_Illumination_threshold = 40.0;
    private double face_Padding_threshold = 40.0;
    private double face_Scaling_threshold = 40.0;
    private double face_FacialAreaShadow_threshold = 40.0;
    private double face_BackgroundTexture_threshold = 40.0;
    private double face_GlassesHeavyFrame_threshold = 40.0;
    private double face_GlassesReflection_threshold = 40.0;
    private double face_HorizontallyCentered_threshold = -1.0;
    private double face_HeadPositionVertical_threshold = -1.0;
    private double face_WidthToHeightRatio_threshold = -1.0;
    private String face_FaceGrayValues_message = "Insufficient lighting (bad gray values in face area of output image)";
    private String face_Faceness_message = "Very low face confidence(faceness)";
    private String face_PoseYaw_message = "Pose (yaw angle in output image is gt 11.5 deg)";
    private String face_PoseRoll_message = "Pose (roll angle in input image is gt 10 deg)";
    private String face_EyeDistance_message = "Enrollee too far (eyedistance in input image is lt 90)";
    private String face_EyeDistanceRatio_message = "Enrollee too close (eyedistance in input image is gt one third of image width)";
    private String face_Illumination_message = "Insufficient lighting";
    private String face_Padding_message = "Enrollee too close or head not well placed ( padding needed for standard image creation )";
    private String face_Scaling_message = "Enrollee too far ( output image to be needed to be up-scaled )";
    private String face_FacialAreaShadow_message = "Non-uniform lighting (of face in output image)";
    private String face_BackgroundTexture_message = "Incorrect background in output image";
    private String face_GlassesHeavyFrame_message = "Enrollee wears heavy framed glasses";
    private String face_GlassesReflection_message = "Reflections on glasses detected";
    private String face_GlassesSunGlasses_message = "Enrollee wears sunglasses";
    private String face_HorizontallyCentered_message = "";
    private String face_HeadPositionVertical_message = "";
    private String face_WidthToHeightRatio_message = "";
    private double finger_NFIQ_threshold = 3.0;
    private double finger_GoodArea_threshold = 55.0;
    private double finger_ContactArea_threshold = 4.0;
    private double finger_MinutiaCount_threshold = 5.0;
    private double finger_L2mQuality_threshold = 40.0;
    private double finger_SlapPlacement_threshold = 60.0;
    private double finger_SlapPressHeavy_threshold = 30.0;
    private double finger_SlapPressLight_threshold = 50.0;
    private double finger_SlapCentering_threshold = 50.0;
    private double finger_SlapWetness_threshold = 40.0;
    private double finger_SlapDryness_threshold = 40.0;
    private double finger_FingerMissmatch_threshold = 40.0;
    private double thumbs_SlapPlacement_threshold = 60.0;
    private double thumbs_SlapPressHeavy_threshold = 30.0;
    private double thumbs_SlapPressLight_threshold = 50.5;
    private double thumbs_SlapCentering_threshold = 50.0;
    private double thumbs_SlapWetness_threshold = 40.0;
    private double thumbs_SlapDryness_threshold = 50.0;
    private double fourfinger_SlapPlacement_threshold = 60.0;
    private double fourfinger_SlapPressHeavy_threshold = 30.0;
    private double fourfinger_SlapPressLight_threshold = 50.0;
    private double fourfinger_SlapCentering_threshold = 50.0;
    private double fourfinger_SlapWetness_threshold = 40.0;
    private double fourfinger_SlapDryness_threshold = 40.0;
    private String finger_NFIQ_message = "NFIQ failed, try again";
    private String finger_GoodArea_message = "Clean the finger and retry";
    private String finger_ContactArea_message = "Less contact area, make sure finger is placed properly";
    private String finger_MinutiaCount_message = "Clean finger or try another finger";
    private String finger_L2mQuality_message = "Poor overall quality and score. Please try again.";
    private String finger_SlapPlacement_message = "Finger not positioned correctly";
    private String finger_SlapPressHeavy_message = "Too much Pressure (duty cycle)";
    private String finger_SlapPressLight_message = "Too little pressure";
    private String finger_SlapCentering_message = "Central region missing";
    private String finger_SlapWetness_message = "Excessive moisture (wetness)";
    private String finger_SlapDryness_message = "Excessive dryness";
    private String thumbs_SlapPlacement_message = "Finger not positioned correctly";
    private String thumbs_SlapPressHeavy_message = "Too much Pressure (duty cycle)";
    private String thumbs_SlapPressLight_message = "Too little pressure";
    private String thumbs_SlapCentering_message = "Central region missing";
    private String thumbs_SlapWetness_message = "Excessive moisture (wetness)";
    private String thumbs_SlapDryness_message = "Excessive dryness";
    private String fourfinger_SlapPlacement_message = "Finger not positioned correctly";
    private String fourfinger_SlapPressHeavy_message = "Too much Pressure (duty cycle)";
    private String fourfinger_SlapPressLight_message = "Too little pressure";
    private String fourfinger_SlapCentering_message = "Central region missing";
    private String fourfinger_SlapWetness_message = "Excessive moisture (wetness)";
    private String fourfinger_SlapDryness_message = "Excessive dryness";
    private double iris_Irisness_threshold = 20.0;
    private double iris_Fidelity_threshold = 50.0;
    private double iris_Character_threshold = 35.0;
    private double iris_Constriction_threshold = 40.0;
    private double iris_HorizontalMargin_threshold = 0.6;
    private double iris_VerticalMargin_threshold = 0.2;
    private double iris_GazeAlignment_threshold = 35.0;
    private String iris_Irisness_message = "Align the iris and retry";
    private String iris_Fidelity_message = "Iris not in focus";
    private String iris_Character_message = "Occlusion";
    private String iris_Constriction_message = "Look away from bright light source and capture again";
    private String iris_HorizontalMargin_message = "Iris is not centered";
    private String iris_VerticalMargin_message = "Iris is not centered";
    private String iris_GazeAlignment_message = "Gaze incorrect";
    private L1QAModule faceQaModule;
    private L1QAModule fingerQaModule;
    private L1QAModule irisQaModule;
    private HashMap<Integer, Double> faceQualityThresholdMap;
    private HashMap<Integer, String> faceQualityMessageMap;
    private HashMap<FingerprintQualityAttribute, Double> fingerprintQualityThresholdMap;
    private HashMap<FingerprintQualityAttribute, String> fingerprintQualityMessageMap;
    private HashMap<FingerprintQualityAttribute, Double> thumbsQualityThresholdMap;
    private HashMap<FingerprintQualityAttribute, String> thumbsQualityMessageMap;
    private HashMap<FingerprintQualityAttribute, Double> fourfingerQualityThresholdMap;
    private HashMap<FingerprintQualityAttribute, String> fourfingerQualityMessageMap;
    private HashMap<Integer, Double> irisQualityThresholdMap;
    private HashMap<Integer, String> irisQualityMessageMap;
    private boolean faceSupport;
    private boolean fingerSupport;
    private boolean irisSupport;
    private ReentrantLock FACE_QA_LOCK = new ReentrantLock(true);
    private ReentrantLock FINGER_QA_LOCK = new ReentrantLock(true);
    private ReentrantLock IRIS_QA_LOCK = new ReentrantLock(true);
    static final String newLine = System.getProperty("line.separator");

    public L1QSSEngine() {
        this(true, true, true);
    }

    public L1QSSEngine(boolean face, boolean finger, boolean iris) {
        this.faceSupport = face;
        this.fingerSupport = finger;
        this.irisSupport = iris;
        this.loadConfig(L1ITVEngine.getHomeFolder() + CONFIG_FILE_NAME);
        this.loadQAModules();
    }

    private void loadQAModules() {
        if (this.faceSupport) {
            this.faceQaModule = new L1QAModule(Types.Modality.Face, Types.QualityProfile.MinChecks, L1_LOGGER, instanceCounterM);
            this.faceQualityThresholdMap = new HashMap();
            this.faceQualityThresholdMap.put(FaceQualityAttribute.FACE_GRAY_VALUES.getvalue(), this.face_FaceGrayValues_threshold);
            this.faceQualityThresholdMap.put(FaceQualityAttribute.FACENESS.getvalue(), this.face_Faceness_threshold);
            this.faceQualityThresholdMap.put(FaceQualityAttribute.ROLL_ANGLE.getvalue(), this.face_PoseRoll_threshold);
            this.faceQualityThresholdMap.put(FaceQualityAttribute.POSE_YAW.getvalue(), this.face_PoseYaw_threshold);
            this.faceQualityThresholdMap.put(FaceQualityAttribute.EYE_DISTANCE.getvalue(), this.face_EyeDistance_threshold);
            this.faceQualityThresholdMap.put(FaceQualityAttribute.EYE_DISTANCE_RATIO.getvalue(), this.face_EyeDistanceRatio_threshold);
            this.faceQualityThresholdMap.put(FaceQualityAttribute.ILLUMINATION.getvalue(), this.face_Illumination_threshold);
            this.faceQualityThresholdMap.put(FaceQualityAttribute.PADDING.getvalue(), this.face_Padding_threshold);
            this.faceQualityThresholdMap.put(FaceQualityAttribute.SCALING.getvalue(), this.face_Scaling_threshold);
            this.faceQualityThresholdMap.put(FaceQualityAttribute.FACIAL_AREA_SHADOW.getvalue(), this.face_FacialAreaShadow_threshold);
            this.faceQualityThresholdMap.put(FaceQualityAttribute.BACKGROUND_TEXTURE.getvalue(), this.face_BackgroundTexture_threshold);
            this.faceQualityThresholdMap.put(FaceQualityAttribute.HORIZONTALLY_CENTERED.getvalue(), this.face_HorizontallyCentered_threshold);
            this.faceQualityThresholdMap.put(FaceQualityAttribute.HEAD_POSITION_VERTICAL.getvalue(), this.face_HeadPositionVertical_threshold);
            this.faceQualityThresholdMap.put(FaceQualityAttribute.IMAGE_RATIO.getvalue(), this.face_WidthToHeightRatio_threshold);
            this.faceQualityThresholdMap.put(FaceQualityAttribute.GLASSES_HEAVY_FRAME.getvalue(), this.face_GlassesHeavyFrame_threshold);
            this.faceQualityThresholdMap.put(FaceQualityAttribute.GLASSES_REFLECTION.getvalue(), this.face_GlassesReflection_threshold);
            this.faceQualityMessageMap = new HashMap();
            this.faceQualityMessageMap.put(FaceQualityAttribute.FACE_GRAY_VALUES.getvalue(), this.face_FaceGrayValues_message);
            this.faceQualityMessageMap.put(FaceQualityAttribute.FACENESS.getvalue(), this.face_Faceness_message);
            this.faceQualityMessageMap.put(FaceQualityAttribute.ROLL_ANGLE.getvalue(), this.face_PoseRoll_message);
            this.faceQualityMessageMap.put(FaceQualityAttribute.POSE_YAW.getvalue(), this.face_PoseYaw_message);
            this.faceQualityMessageMap.put(FaceQualityAttribute.EYE_DISTANCE.getvalue(), this.face_EyeDistance_message);
            this.faceQualityMessageMap.put(FaceQualityAttribute.EYE_DISTANCE_RATIO.getvalue(), this.face_EyeDistanceRatio_message);
            this.faceQualityMessageMap.put(FaceQualityAttribute.ILLUMINATION.getvalue(), this.face_Illumination_message);
            this.faceQualityMessageMap.put(FaceQualityAttribute.PADDING.getvalue(), this.face_Padding_message);
            this.faceQualityMessageMap.put(FaceQualityAttribute.SCALING.getvalue(), this.face_Scaling_message);
            this.faceQualityMessageMap.put(FaceQualityAttribute.FACIAL_AREA_SHADOW.getvalue(), this.face_FacialAreaShadow_message);
            this.faceQualityMessageMap.put(FaceQualityAttribute.BACKGROUND_TEXTURE.getvalue(), this.face_BackgroundTexture_message);
            this.faceQualityMessageMap.put(FaceQualityAttribute.HORIZONTALLY_CENTERED.getvalue(), this.face_HorizontallyCentered_message);
            this.faceQualityMessageMap.put(FaceQualityAttribute.HEAD_POSITION_VERTICAL.getvalue(), this.face_HeadPositionVertical_message);
            this.faceQualityMessageMap.put(FaceQualityAttribute.IMAGE_RATIO.getvalue(), this.face_WidthToHeightRatio_message);
            this.faceQualityMessageMap.put(FaceQualityAttribute.GLASSES_HEAVY_FRAME.getvalue(), this.face_GlassesHeavyFrame_message);
            this.faceQualityMessageMap.put(FaceQualityAttribute.GLASSES_REFLECTION.getvalue(), this.face_GlassesReflection_message);
            this.faceQualityMessageMap.put(FaceQualityAttribute.GLASSES_SUNGLASSES.getvalue(), this.face_GlassesSunGlasses_message);
        }
        if (this.fingerSupport) {
            this.fingerQaModule = new L1QAModule(Types.Modality.Fingerprint, Types.QualityProfile.BestPracticeChecks, L1_LOGGER, instanceCounterM);
            this.fingerprintQualityThresholdMap = new HashMap();
            this.fingerprintQualityThresholdMap.put(FingerprintQualityAttribute.SLAP_PLACEMENT, this.finger_SlapPlacement_threshold);
            this.fingerprintQualityThresholdMap.put(FingerprintQualityAttribute.SLAP_PRESS_HEAVY, this.finger_SlapPressHeavy_threshold);
            this.fingerprintQualityThresholdMap.put(FingerprintQualityAttribute.SLAP_PRESS_LIGHT, this.finger_SlapPressLight_threshold);
            this.fingerprintQualityThresholdMap.put(FingerprintQualityAttribute.SLAP_CENTERING, this.finger_SlapCentering_threshold);
            this.fingerprintQualityThresholdMap.put(FingerprintQualityAttribute.SLAP_WETNESS, this.finger_SlapWetness_threshold);
            this.fingerprintQualityThresholdMap.put(FingerprintQualityAttribute.SLAP_DRYNESS, this.finger_SlapDryness_threshold);
            this.fingerprintQualityThresholdMap.put(FingerprintQualityAttribute.FINGER_GOOD_AREA, this.finger_GoodArea_threshold);
            this.fingerprintQualityThresholdMap.put(FingerprintQualityAttribute.FINGER_CONTACT_AREA, this.finger_ContactArea_threshold);
            this.fingerprintQualityThresholdMap.put(FingerprintQualityAttribute.FINGER_MINUTIA_COUNT, this.finger_MinutiaCount_threshold);
            this.fingerprintQualityThresholdMap.put(FingerprintQualityAttribute.FINGER_PROPREIETARY_QUALITY, this.finger_L2mQuality_threshold);
            this.fingerprintQualityThresholdMap.put(FingerprintQualityAttribute.FINGER_MISMATCH, this.finger_FingerMissmatch_threshold);
            this.fingerprintQualityMessageMap = new HashMap();
            this.fingerprintQualityMessageMap.put(FingerprintQualityAttribute.SLAP_PLACEMENT, this.finger_SlapPlacement_message);
            this.fingerprintQualityMessageMap.put(FingerprintQualityAttribute.SLAP_PRESS_HEAVY, this.finger_SlapPressHeavy_message);
            this.fingerprintQualityMessageMap.put(FingerprintQualityAttribute.SLAP_PRESS_LIGHT, this.finger_SlapPressLight_message);
            this.fingerprintQualityMessageMap.put(FingerprintQualityAttribute.SLAP_CENTERING, this.finger_SlapCentering_message);
            this.fingerprintQualityMessageMap.put(FingerprintQualityAttribute.SLAP_WETNESS, this.finger_SlapWetness_message);
            this.fingerprintQualityMessageMap.put(FingerprintQualityAttribute.SLAP_DRYNESS, this.finger_SlapDryness_message);
            this.fingerprintQualityMessageMap.put(FingerprintQualityAttribute.FINGER_GOOD_AREA, this.finger_GoodArea_message);
            this.fingerprintQualityMessageMap.put(FingerprintQualityAttribute.FINGER_CONTACT_AREA, this.finger_ContactArea_message);
            this.fingerprintQualityMessageMap.put(FingerprintQualityAttribute.FINGER_MINUTIA_COUNT, this.finger_MinutiaCount_message);
            this.fingerprintQualityMessageMap.put(FingerprintQualityAttribute.FINGER_PROPREIETARY_QUALITY, this.finger_L2mQuality_message);
            this.thumbsQualityThresholdMap = new HashMap();
            this.thumbsQualityThresholdMap.put(FingerprintQualityAttribute.SLAP_PLACEMENT, this.thumbs_SlapPlacement_threshold);
            this.thumbsQualityThresholdMap.put(FingerprintQualityAttribute.SLAP_PRESS_HEAVY, this.thumbs_SlapPressHeavy_threshold);
            this.thumbsQualityThresholdMap.put(FingerprintQualityAttribute.SLAP_PRESS_LIGHT, this.thumbs_SlapPressLight_threshold);
            this.thumbsQualityThresholdMap.put(FingerprintQualityAttribute.SLAP_CENTERING, this.thumbs_SlapCentering_threshold);
            this.thumbsQualityThresholdMap.put(FingerprintQualityAttribute.SLAP_WETNESS, this.thumbs_SlapWetness_threshold);
            this.thumbsQualityThresholdMap.put(FingerprintQualityAttribute.SLAP_DRYNESS, this.thumbs_SlapDryness_threshold);
            this.thumbsQualityThresholdMap.put(FingerprintQualityAttribute.FINGER_GOOD_AREA, this.finger_GoodArea_threshold);
            this.thumbsQualityThresholdMap.put(FingerprintQualityAttribute.FINGER_CONTACT_AREA, this.finger_ContactArea_threshold);
            this.thumbsQualityThresholdMap.put(FingerprintQualityAttribute.FINGER_MINUTIA_COUNT, this.finger_MinutiaCount_threshold);
            this.thumbsQualityThresholdMap.put(FingerprintQualityAttribute.FINGER_PROPREIETARY_QUALITY, this.finger_L2mQuality_threshold);
            this.thumbsQualityThresholdMap.put(FingerprintQualityAttribute.FINGER_MISMATCH, this.finger_FingerMissmatch_threshold);
            this.thumbsQualityMessageMap = new HashMap();
            this.thumbsQualityMessageMap.put(FingerprintQualityAttribute.SLAP_PLACEMENT, this.thumbs_SlapPlacement_message);
            this.thumbsQualityMessageMap.put(FingerprintQualityAttribute.SLAP_PRESS_HEAVY, this.thumbs_SlapPressHeavy_message);
            this.thumbsQualityMessageMap.put(FingerprintQualityAttribute.SLAP_PRESS_LIGHT, this.thumbs_SlapPressLight_message);
            this.thumbsQualityMessageMap.put(FingerprintQualityAttribute.SLAP_CENTERING, this.thumbs_SlapCentering_message);
            this.thumbsQualityMessageMap.put(FingerprintQualityAttribute.SLAP_WETNESS, this.thumbs_SlapWetness_message);
            this.thumbsQualityMessageMap.put(FingerprintQualityAttribute.SLAP_DRYNESS, this.thumbs_SlapDryness_message);
            this.thumbsQualityMessageMap.put(FingerprintQualityAttribute.FINGER_GOOD_AREA, this.finger_GoodArea_message);
            this.thumbsQualityMessageMap.put(FingerprintQualityAttribute.FINGER_CONTACT_AREA, this.finger_ContactArea_message);
            this.thumbsQualityMessageMap.put(FingerprintQualityAttribute.FINGER_MINUTIA_COUNT, this.finger_MinutiaCount_message);
            this.thumbsQualityMessageMap.put(FingerprintQualityAttribute.FINGER_PROPREIETARY_QUALITY, this.finger_L2mQuality_message);
            this.fourfingerQualityThresholdMap = new HashMap();
            this.fourfingerQualityThresholdMap.put(FingerprintQualityAttribute.SLAP_PLACEMENT, this.fourfinger_SlapPlacement_threshold);
            this.fourfingerQualityThresholdMap.put(FingerprintQualityAttribute.SLAP_PRESS_HEAVY, this.fourfinger_SlapPressHeavy_threshold);
            this.fourfingerQualityThresholdMap.put(FingerprintQualityAttribute.SLAP_PRESS_LIGHT, this.fourfinger_SlapPressLight_threshold);
            this.fourfingerQualityThresholdMap.put(FingerprintQualityAttribute.SLAP_CENTERING, this.fourfinger_SlapCentering_threshold);
            this.fourfingerQualityThresholdMap.put(FingerprintQualityAttribute.SLAP_WETNESS, this.fourfinger_SlapWetness_threshold);
            this.fourfingerQualityThresholdMap.put(FingerprintQualityAttribute.SLAP_DRYNESS, this.fourfinger_SlapDryness_threshold);
            this.fourfingerQualityThresholdMap.put(FingerprintQualityAttribute.FINGER_GOOD_AREA, this.finger_GoodArea_threshold);
            this.fourfingerQualityThresholdMap.put(FingerprintQualityAttribute.FINGER_CONTACT_AREA, this.finger_ContactArea_threshold);
            this.fourfingerQualityThresholdMap.put(FingerprintQualityAttribute.FINGER_MINUTIA_COUNT, this.finger_MinutiaCount_threshold);
            this.fourfingerQualityThresholdMap.put(FingerprintQualityAttribute.FINGER_PROPREIETARY_QUALITY, this.finger_L2mQuality_threshold);
            this.fourfingerQualityThresholdMap.put(FingerprintQualityAttribute.FINGER_MISMATCH, this.finger_FingerMissmatch_threshold);
            this.fourfingerQualityMessageMap = new HashMap();
            this.fourfingerQualityMessageMap.put(FingerprintQualityAttribute.SLAP_PLACEMENT, this.fourfinger_SlapPlacement_message);
            this.fourfingerQualityMessageMap.put(FingerprintQualityAttribute.SLAP_PRESS_HEAVY, this.fourfinger_SlapPressHeavy_message);
            this.fourfingerQualityMessageMap.put(FingerprintQualityAttribute.SLAP_PRESS_LIGHT, this.fourfinger_SlapPressLight_message);
            this.fourfingerQualityMessageMap.put(FingerprintQualityAttribute.SLAP_CENTERING, this.fourfinger_SlapCentering_message);
            this.fourfingerQualityMessageMap.put(FingerprintQualityAttribute.SLAP_WETNESS, this.fourfinger_SlapWetness_message);
            this.fourfingerQualityMessageMap.put(FingerprintQualityAttribute.SLAP_DRYNESS, this.fourfinger_SlapDryness_message);
            this.fourfingerQualityMessageMap.put(FingerprintQualityAttribute.FINGER_GOOD_AREA, this.finger_GoodArea_message);
            this.fourfingerQualityMessageMap.put(FingerprintQualityAttribute.FINGER_CONTACT_AREA, this.finger_ContactArea_message);
            this.fourfingerQualityMessageMap.put(FingerprintQualityAttribute.FINGER_MINUTIA_COUNT, this.finger_MinutiaCount_message);
            this.fourfingerQualityMessageMap.put(FingerprintQualityAttribute.FINGER_PROPREIETARY_QUALITY, this.finger_L2mQuality_message);
        }
        if (this.irisSupport) {
            this.irisQaModule = new L1QAModule(Types.Modality.Iris, Types.QualityProfile.BestPracticeChecks, L1_LOGGER, instanceCounterM);
            this.irisQualityThresholdMap = new HashMap();
            this.irisQualityThresholdMap.put(IrisQualityAttribute.IRISNESS.getvalue(), this.iris_Irisness_threshold);
            this.irisQualityThresholdMap.put(IrisQualityAttribute.IRIS_FIDELITY.getvalue(), this.iris_Fidelity_threshold);
            this.irisQualityThresholdMap.put(IrisQualityAttribute.IRIS_CHARACTER.getvalue(), this.iris_Character_threshold);
            this.irisQualityThresholdMap.put(IrisQualityAttribute.PUPIL_CONSTRICTION.getvalue(), this.iris_Constriction_threshold);
            this.irisQualityThresholdMap.put(IrisQualityAttribute.HORIZONTAL_MARGIN.getvalue(), this.iris_HorizontalMargin_threshold);
            this.irisQualityThresholdMap.put(IrisQualityAttribute.VERTICAL_MARGIN.getvalue(), this.iris_VerticalMargin_threshold);
            this.irisQualityThresholdMap.put(IrisQualityAttribute.IRIS_GAZE_ALIGNMENT.getvalue(), this.iris_GazeAlignment_threshold);
            this.irisQualityMessageMap = new HashMap();
            this.irisQualityMessageMap.put(IrisQualityAttribute.IRISNESS.getvalue(), this.iris_Irisness_message);
            this.irisQualityMessageMap.put(IrisQualityAttribute.IRIS_FIDELITY.getvalue(), this.iris_Fidelity_message);
            this.irisQualityMessageMap.put(IrisQualityAttribute.IRIS_CHARACTER.getvalue(), this.iris_Character_message);
            this.irisQualityMessageMap.put(IrisQualityAttribute.PUPIL_CONSTRICTION.getvalue(), this.iris_Constriction_message);
            this.irisQualityMessageMap.put(IrisQualityAttribute.HORIZONTAL_MARGIN.getvalue(), this.iris_HorizontalMargin_message);
            this.irisQualityMessageMap.put(IrisQualityAttribute.VERTICAL_MARGIN.getvalue(), this.iris_VerticalMargin_message);
            this.irisQualityMessageMap.put(IrisQualityAttribute.IRIS_GAZE_ALIGNMENT.getvalue(), this.iris_GazeAlignment_message);
        }
    }

    public static String getVersion() {
        return Version.version;
    }

    public boolean supportsFace() {
        return this.faceSupport;
    }

    public boolean supportsFinger() {
        return this.fingerSupport;
    }

    public boolean supportsIris() {
        return this.irisSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FaceQSS getQSSDataForFace(byte[] input, List<LandMark> landmarks) {
        if (!this.faceSupport) {
            L1_LOGGER.warn((Object)"QSSEngine is not initialized for faces - check your config");
            return null;
        }
        Image l1Image = null;
        Image l1Image2 = null;
        Image fullfrontalImage = null;
        ImageDescriptor faceRes = null;
        ImageDescriptor inputImageDescriptor = null;
        ImageDescriptor outputImageDescriptor = null;
        Quality quality = null;
        Quality outputQuality = null;
        Quality inputQuality = null;
        LandmarkList manualLandmarkList = null;
        LandmarkList landmarkList = null;
        WriteImageDescriptor writeImgDesc = new WriteImageDescriptor();
        Blob fullFrontalImageBlob = null;
        String executionStepL = "getQSSDataForFace start.";
        try {
            executionStepL = "Get FACE_QA_LOCK.";
            this.FACE_QA_LOCK.lock();
            StringBuilder overallFailureCommentL = new StringBuilder();
            ArrayList<FaceQSS> faceQualityList = new ArrayList<FaceQSS>();
            L1_LOGGER.debug((Object)(this.instanceIdentifierM + ", in getQSSDataForFace"));
            executionStepL = "Get face images from FAC.";
            Vector dataVec = null;
            try {
                dataVec = FacialISO.getImagesFromPackage((byte[])input, (boolean)this.iso_parsing_strict);
            }
            catch (Exception ex) {
                L1_LOGGER.error((Object)(this.instanceIdentifierM + ", ExecutionStep: '" + executionStepL + "': Face ISO Parsing Failed: " + ex));
                FaceQSS faceQuality = new FaceQSS();
                faceQuality.setOverallCompliance(Compliance.ERROR);
                faceQuality.setOverallComments("Not a Valid ISO Image");
                faceQuality.setOverallScore(0.0);
                FaceQSS faceQSS = faceQuality;
                this.FACE_QA_LOCK.unlock();
                if (l1Image != null) {
                    l1Image.dispose();
                }
                if (l1Image2 != null) {
                    l1Image2.dispose();
                }
                if (fullfrontalImage != null) {
                    fullfrontalImage.dispose();
                }
                if (faceRes != null) {
                    faceRes.dispose();
                }
                if (inputImageDescriptor != null) {
                    inputImageDescriptor.dispose();
                }
                if (outputImageDescriptor != null) {
                    outputImageDescriptor.dispose();
                }
                if (quality != null) {
                    quality.dispose();
                }
                if (outputQuality != null) {
                    outputQuality.dispose();
                }
                if (inputQuality != null) {
                    inputQuality.dispose();
                }
                if (landmarkList != null) {
                    landmarkList.dispose();
                }
                if (manualLandmarkList != null) {
                    manualLandmarkList.dispose();
                }
                if (writeImgDesc != null) {
                    writeImgDesc.dispose();
                }
                if (fullFrontalImageBlob != null) {
                    fullFrontalImageBlob.dispose();
                }
                return faceQSS;
            }
            int i = 0;
            if (i < dataVec.size()) {
                executionStepL = "Decompress face image.";
                FaceQSS faceQuality = new FaceQSS();
                l1Image = L1QAModule.createFoundationImage(L1_LOGGER, (ImageStruct)dataVec.get(i), Types.Modality.Face);
                if (l1Image == null) {
                    L1_LOGGER.error((Object)(this.instanceIdentifierM + ", ExecutionStep: '" + executionStepL + "': Face ISO Parsing Failed: no image data present."));
                    faceQuality.setOverallCompliance(Compliance.ERROR);
                    faceQuality.setOverallComments("Not a Valid ISO Image");
                    faceQuality.setOverallScore(0.0);
                    FaceQSS faceQSS = faceQuality;
                    return faceQSS;
                }
                l1Image2 = l1Image.clone();
                executionStepL = "Process incoming landmarks.";
                if (landmarks != null && landmarks.size() > 0) {
                    manualLandmarkList = new LandmarkList();
                    for (LandMark lMark : landmarks) {
                        Point p = new Point();
                        p.setX(Integer.valueOf(lMark.getX()));
                        p.setY(Integer.valueOf(lMark.getY()));
                        if (lMark.getLandMarkType() == LandMarkType.LEFT_EYE) {
                            manualLandmarkList.addFaceLandmark(p, Types.LandmarkType.LeftEye);
                            continue;
                        }
                        if (lMark.getLandMarkType() != LandMarkType.RIGHT_EYE) continue;
                        manualLandmarkList.addFaceLandmark(p, Types.LandmarkType.RightEye);
                    }
                }
                executionStepL = "Process face image.";
                faceRes = this.faceQaModule.processImage(l1Image, Types.Instance.FaceFrontal, manualLandmarkList, Types.QualityProfile.MinChecks);
                L1_LOGGER.debug((Object)(this.instanceIdentifierM + ", Done Processing Facial Image, evaluating Quality"));
                executionStepL = "Check quality results of face image.";
                if (faceRes != null) {
                    quality = faceRes.getQuality();
                    boolean importantCheckFailed = false;
                    if (this.evaluateFaceQuality(quality, Types.QualityCheckType.FaceGrayValues, FaceQualityAttribute.FACE_GRAY_VALUES, faceQuality, overallFailureCommentL)) {
                        importantCheckFailed = true;
                    }
                    if (this.evaluateFaceEyeDistance(l1Image2.getWidth(), faceRes, faceQuality, overallFailureCommentL)) {
                        importantCheckFailed = true;
                    }
                    L1_LOGGER.debug((Object)(this.instanceIdentifierM + ", Facial Landmarks"));
                    inputImageDescriptor = new ImageDescriptor(Types.Modality.Face);
                    outputImageDescriptor = new ImageDescriptor(Types.Modality.Face);
                    executionStepL = "Process landmarks.";
                    landmarkList = manualLandmarkList != null ? manualLandmarkList : faceRes.getAutoLandmarkList();
                    inputImageDescriptor.setManualLandmarkList(landmarkList);
                    if (landmarkList != null && landmarkList.length() > 0) {
                        for (int k = 0; k < landmarkList.length(); ++k) {
                            LandMark lMark = new LandMark();
                            Types.LandmarkType type = landmarkList.getType(k);
                            if (type == Types.LandmarkType.LeftEye) {
                                lMark.setLandMarkType(LandMarkType.LEFT_EYE);
                                lMark.setX(landmarkList.getPosition(k).getX().intValue());
                                lMark.setY(landmarkList.getPosition(k).getY().intValue());
                                faceQuality.addLandMark(lMark);
                                continue;
                            }
                            if (type != Types.LandmarkType.RightEye) continue;
                            lMark.setLandMarkType(LandMarkType.RIGHT_EYE);
                            lMark.setX(landmarkList.getPosition(k).getX().intValue());
                            lMark.setY(landmarkList.getPosition(k).getY().intValue());
                            faceQuality.addLandMark(lMark);
                        }
                    }
                    L1_LOGGER.debug((Object)(this.instanceIdentifierM + ", Done Retrieving LandMarks"));
                    executionStepL = "Create fullfrontal image.";
                    fullfrontalImage = this.faceQaModule.createFullFrontalImage(l1Image2, inputImageDescriptor, outputImageDescriptor);
                    executionStepL = "Check quality results of fullfrontal image.";
                    outputQuality = outputImageDescriptor.getQuality();
                    inputQuality = inputImageDescriptor.getQuality();
                    this.evaluateFaceQuality(outputQuality, Types.QualityCheckType.HorizontallyCentered, FaceQualityAttribute.HORIZONTALLY_CENTERED, faceQuality, overallFailureCommentL);
                    this.evaluateFaceQuality(outputQuality, Types.QualityCheckType.VerticalEyePosition, FaceQualityAttribute.HEAD_POSITION_VERTICAL, faceQuality, overallFailureCommentL);
                    this.evaluateFaceQuality(outputQuality, Types.QualityCheckType.WidthToHeightRatio, FaceQualityAttribute.IMAGE_RATIO, faceQuality, overallFailureCommentL);
                    if (this.evaluateFaceQuality(inputQuality, Types.QualityCheckType.Illumination, FaceQualityAttribute.ILLUMINATION, faceQuality, overallFailureCommentL)) {
                        importantCheckFailed = true;
                    }
                    if (this.evaluateFaceQuality(outputQuality, Types.QualityCheckType.Padding, FaceQualityAttribute.PADDING, faceQuality, overallFailureCommentL)) {
                        importantCheckFailed = true;
                    }
                    if (this.evaluateFaceQuality(outputQuality, Types.QualityCheckType.Scaling, FaceQualityAttribute.SCALING, faceQuality, overallFailureCommentL)) {
                        importantCheckFailed = true;
                    }
                    if (this.evaluateFaceQuality(inputQuality, Types.QualityCheckType.FacialAreaShadow, FaceQualityAttribute.FACIAL_AREA_SHADOW, faceQuality, overallFailureCommentL)) {
                        importantCheckFailed = true;
                    }
                    if (this.evaluateFaceQuality(inputQuality, Types.QualityCheckType.BackgroundTexture, FaceQualityAttribute.BACKGROUND_TEXTURE, faceQuality, overallFailureCommentL)) {
                        importantCheckFailed = true;
                    }
                    if (this.evaluateFaceQuality(inputQuality, Types.QualityCheckType.PoseYaw, FaceQualityAttribute.POSE_YAW, faceQuality, overallFailureCommentL)) {
                        importantCheckFailed = true;
                    }
                    if (this.evaluateFaceQuality(inputQuality, Types.QualityCheckType.Glasses, FaceQualityAttribute.GLASSES_HEAVY_FRAME, faceQuality, overallFailureCommentL)) {
                        importantCheckFailed = true;
                    }
                    if (this.evaluateFaceQuality(inputQuality, Types.QualityCheckType.GlassesNoGlare, FaceQualityAttribute.GLASSES_REFLECTION, faceQuality, overallFailureCommentL)) {
                        importantCheckFailed = true;
                    }
                    if (this.evaluateFaceQuality(outputQuality, Types.QualityCheckType.Faceness, FaceQualityAttribute.FACENESS, faceQuality, overallFailureCommentL)) {
                        importantCheckFailed = true;
                    }
                    FaceQualityFeedback redEyesFaceQualityFeedback = new FaceQualityFeedback();
                    redEyesFaceQualityFeedback.setQualityAttribute(FaceQualityAttribute.RED_EYES);
                    redEyesFaceQualityFeedback.setCompliance(Compliance.NOT_APPLIED);
                    redEyesFaceQualityFeedback.setScore(0.0);
                    redEyesFaceQualityFeedback.setComments("Not supported.");
                    faceQuality.getQualityFeedback().add(redEyesFaceQualityFeedback);
                    executionStepL = "Calculate overall score.";
                    float overallScore = outputQuality.getQualityValue(Types.QualityCheckType.Faceness) * 10.0f;
                    if (!importantCheckFailed) {
                        faceQuality.setOverallComments("");
                        faceQuality.setOverallCompliance(Compliance.OK);
                        faceQuality.setOverallScore((double)overallScore);
                    } else {
                        double minScaledQualityValueL = 1000.0;
                        List qualListL = faceQuality.getQualityFeedback();
                        for (FaceQualityFeedback qf : qualListL) {
                            if (qf.getCompliance() == Compliance.ERROR) {
                                minScaledQualityValueL = 0.0;
                                break;
                            }
                            if (qf.getCompliance() != Compliance.BELOW_THRESHOLD) continue;
                            double scaledQualityValueL = qf.getScore();
                            double thresholdL = this.faceQualityThresholdMap.get(qf.getQualityAttribute().getvalue());
                            scaledQualityValueL = qf.getQualityAttribute() == FaceQualityAttribute.ROLL_ANGLE ? thresholdL / Math.abs(scaledQualityValueL) * 40.0 : (qf.getQualityAttribute() == FaceQualityAttribute.PADDING ? 20.0 : scaledQualityValueL / thresholdL * 40.0);
                            if (!(scaledQualityValueL < minScaledQualityValueL)) continue;
                            minScaledQualityValueL = scaledQualityValueL;
                        }
                        if (minScaledQualityValueL > 999.0) {
                            minScaledQualityValueL = 0.0;
                        }
                        faceQuality.setOverallCompliance(Compliance.ERROR);
                        faceQuality.setOverallComments(overallFailureCommentL.toString());
                        faceQuality.setOverallScore(minScaledQualityValueL);
                    }
                    L1_LOGGER.debug((Object)(this.instanceIdentifierM + ", Sending Cropped Image"));
                    executionStepL = "Set ISO facial images.";
                    fullFrontalImageBlob = fullfrontalImage.writeToBlob(Types.ImageFormat.Jpeg2000, writeImgDesc);
                    byte[] CroppedImage = fullFrontalImageBlob.getData();
                    byte[] ISOCroppedImage = FacialISO.packageImage((byte[])CroppedImage, (int)0, (int)fullfrontalImage.getWidth(), (int)fullfrontalImage.getHeight());
                    faceQuality.setFullFrontalFace(ISOCroppedImage);
                    faceQuality.setFullFrontalFaceForDisplay(CroppedImage);
                    L1_LOGGER.debug((Object)(this.instanceIdentifierM + ", Cleaning Up "));
                    executionStepL = "Clean up.";
                    fullFrontalImageBlob.dispose();
                    fullFrontalImageBlob = null;
                    inputImageDescriptor.dispose();
                    inputImageDescriptor = null;
                    outputImageDescriptor.dispose();
                    outputImageDescriptor = null;
                    outputQuality.dispose();
                    outputQuality = null;
                    inputQuality.dispose();
                    inputQuality = null;
                    quality.dispose();
                    quality = null;
                    fullfrontalImage.dispose();
                    fullfrontalImage = null;
                    landmarkList.dispose();
                    landmarkList = null;
                } else {
                    L1_LOGGER.error((Object)(this.instanceIdentifierM + " Quality checking could not be performed."));
                    faceQuality.setOverallCompliance(Compliance.ERROR);
                    faceQuality.setOverallComments("quality check not applied");
                    faceQuality.setOverallScore(0.0);
                }
                faceQualityList.add(faceQuality);
                if (l1Image != null) {
                    l1Image.dispose();
                }
                if (l1Image2 != null) {
                    l1Image2.dispose();
                }
                if (faceRes != null) {
                    faceRes.dispose();
                }
            }
            if (faceQualityList.size() > 0) {
                FaceQSS faceQualityL = (FaceQSS)faceQualityList.get(0);
                FaceQualityFeedback feedbackL = new FaceQualityFeedback();
                feedbackL.setQualityAttribute(FaceQualityAttribute.NUMBER_OF_FACES);
                feedbackL.setScore(1.0);
                feedbackL.setComments("");
                feedbackL.setCompliance(Compliance.OK);
                faceQualityL.getQualityFeedback().add(feedbackL);
                FaceQSS faceQSS = faceQualityL;
                return faceQSS;
            }
            FaceQSS faceQSS = null;
            return faceQSS;
        }
        catch (Exception ex) {
            String errorMessageL = this.instanceIdentifierM + ", Execution step: " + executionStepL + ": Exception caught: " + ex;
            L1_LOGGER.error((Object)errorMessageL, (Throwable)ex);
            FaceQSS faceQuality = new FaceQSS();
            faceQuality.setOverallCompliance(Compliance.ERROR);
            faceQuality.setOverallComments(errorMessageL);
            faceQuality.setOverallScore(0.0);
            FaceQSS faceQSS = faceQuality;
            return faceQSS;
        }
        finally {
            this.FACE_QA_LOCK.unlock();
            if (l1Image != null) {
                l1Image.dispose();
            }
            if (l1Image2 != null) {
                l1Image2.dispose();
            }
            if (fullfrontalImage != null) {
                fullfrontalImage.dispose();
            }
            if (faceRes != null) {
                faceRes.dispose();
            }
            if (inputImageDescriptor != null) {
                inputImageDescriptor.dispose();
            }
            if (outputImageDescriptor != null) {
                outputImageDescriptor.dispose();
            }
            if (quality != null) {
                quality.dispose();
            }
            if (outputQuality != null) {
                outputQuality.dispose();
            }
            if (inputQuality != null) {
                inputQuality.dispose();
            }
            if (landmarkList != null) {
                landmarkList.dispose();
            }
            if (manualLandmarkList != null) {
                manualLandmarkList.dispose();
            }
            if (writeImgDesc != null) {
                writeImgDesc.dispose();
            }
            if (fullFrontalImageBlob != null) {
                fullFrontalImageBlob.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BiometricTemplate> getTemplatesForFace(byte[] input, boolean copyGalleryToProbe) {
        ArrayList<BiometricTemplate> templates = new ArrayList<BiometricTemplate>();
        Image l1Image = null;
        Image l1Image2 = null;
        try {
            L1_LOGGER.debug((Object)(this.instanceIdentifierM + ", in getTemplatesForFace"));
            Vector dataVec = FacialISO.getImagesFromPackage((byte[])input, (boolean)this.iso_parsing_strict);
            for (int i = 0; i < dataVec.size(); ++i) {
                l1Image = L1QAModule.createFoundationImage(L1_LOGGER, (ImageStruct)dataVec.get(i), Types.Modality.Face);
                if (l1Image == null) {
                    L1_LOGGER.error((Object)(this.instanceIdentifierM + ": Face ISO Parsing Failed: no image data present."));
                    List<BiometricTemplate> list = null;
                    return list;
                }
                byte[] faceGalleryTemplate = this.faceQaModule.createTemplates(l1Image, Types.Instance.FaceFrontal, Types.TemplateCreationType.Gallery);
                L1_LOGGER.debug((Object)(this.instanceIdentifierM + ", Created Gallery Templates for Face of size : " + faceGalleryTemplate.length));
                byte[] faceProbeTemplate = null;
                if (copyGalleryToProbe) {
                    faceProbeTemplate = faceGalleryTemplate;
                } else {
                    l1Image2 = L1QAModule.createFoundationImage(L1_LOGGER, (ImageStruct)dataVec.get(i), Types.Modality.Face);
                    if (l1Image2 == null) {
                        L1_LOGGER.error((Object)(this.instanceIdentifierM + ": Face ISO Parsing Failed: no image data present."));
                        List<BiometricTemplate> list = null;
                        return list;
                    }
                    faceProbeTemplate = this.faceQaModule.createTemplates(l1Image2, Types.Instance.FaceFrontal, Types.TemplateCreationType.Probe);
                }
                L1_LOGGER.debug((Object)(this.instanceIdentifierM + ", Created Probe Templates for Face of size : " + faceProbeTemplate.length));
                BiometricTemplate bTemplate = new BiometricTemplate();
                bTemplate.setBiometricPosition(BiometricPosition.FACE);
                bTemplate.setGalleryTemplate(faceGalleryTemplate);
                bTemplate.setProbeTemplate(faceProbeTemplate);
                L1_LOGGER.debug((Object)(this.instanceIdentifierM + ", Done Creating Templates for Facial Image Cleaning up"));
                templates.add(bTemplate);
            }
        }
        catch (Exception ex) {
            L1_LOGGER.error(null, (Throwable)ex);
            List<BiometricTemplate> list = null;
            return list;
        }
        finally {
            if (l1Image != null) {
                l1Image.dispose();
            }
            if (l1Image2 != null) {
                l1Image2.dispose();
            }
        }
        return templates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BiometricTemplate> getTemplatesForIris(byte[] input) {
        ArrayList<BiometricTemplate> templates = new ArrayList<BiometricTemplate>();
        Vector<IrisImageStruct> dataVec = null;
        Image l1Image = null;
        Image l1Image2 = null;
        boolean isIris2011 = false;
        try {
            L1_LOGGER.debug((Object)(this.instanceIdentifierM + ", in getTemplatesForIris"));
            char ii = UtilHelper.byteToChar(input[4]);
            char j = UtilHelper.byteToChar(input[5]);
            char k = UtilHelper.byteToChar(input[6]);
            char l = UtilHelper.byteToChar(input[7]);
            if (ii == '0' && j == '2' && k == '0' && l == '\u0000') {
                isIris2011 = true;
                L1_LOGGER.info((Object)"Input records is a IRIS 2011 image record.");
                ByteArrayInputStream is = new ByteArrayInputStream(input);
                IIR_2011 iir = IIR_2011.readFromStream(is, this.iso_parsing_strict);
                L1_LOGGER.info((Object)"Basic header check in place for IRIS 2011 image record.");
                ValidateHeaders.basicCheck(iir, input.length);
                if (this.iso_parsing_strict) {
                    L1_LOGGER.info((Object)"More rigorous header check in place for IRIS 2011 image record.");
                    ValidateHeaders.validateIrisHeaders(iir);
                }
                dataVec = L1QAModule.getImagesFromPackage(iir);
            } else {
                dataVec = IrisISO.getImagesFromPackage((byte[])input, (boolean)this.iso_parsing_strict);
            }
            for (int i = 0; i < dataVec.size(); ++i) {
                IrisImageStruct irisImageStructL = (IrisImageStruct)dataVec.get(i);
                int imageType = !isIris2011 ? L1QAModule.getImageFormatFromIIR(L1_LOGGER, input) : ((IrisImageStruct)dataVec.get(i)).getImageType();
                l1Image = L1QAModule.createFoundationImage(L1_LOGGER, irisImageStructL.getImage(), irisImageStructL.getWidth(), irisImageStructL.getHeight(), imageType, Types.Modality.Iris);
                if (l1Image == null) {
                    L1_LOGGER.error((Object)(this.instanceIdentifierM + ": Iris ISO Parsing Failed: no image data present."));
                    List<BiometricTemplate> list = null;
                    return list;
                }
                l1Image2 = l1Image.clone();
                Types.Instance irisType = Types.Instance.Unknown;
                BiometricPosition position = BiometricPosition.UNKNOWN;
                int irisPosition = dataVec.get(i).getPosition();
                switch (irisPosition) {
                    case 2: {
                        irisType = Types.Instance.IrisLeft;
                        position = BiometricPosition.LEFT_IRIS;
                        break;
                    }
                    case 1: {
                        irisType = Types.Instance.IrisRight;
                        position = BiometricPosition.RIGHT_IRIS;
                    }
                }
                Types.Instance irisTypeForTC = irisType;
                if (irisType == Types.Instance.Unknown) {
                    irisTypeForTC = Types.Instance.IrisLeft;
                }
                byte[] irisGalleryTemplate = this.irisQaModule.createTemplates(l1Image, irisTypeForTC, Types.TemplateCreationType.Gallery);
                L1_LOGGER.debug((Object)(this.instanceIdentifierM + ", Created Gallery Templates for Iris of size : " + irisGalleryTemplate.length));
                byte[] irisProbeTemplate = this.irisQaModule.createTemplates(l1Image2, irisTypeForTC, Types.TemplateCreationType.Probe);
                L1_LOGGER.debug((Object)(this.instanceIdentifierM + ", Created Probe Templates for Iris of size : " + irisProbeTemplate.length));
                BiometricTemplate bTemplate = new BiometricTemplate();
                bTemplate.setBiometricPosition(position);
                bTemplate.setGalleryTemplate(irisGalleryTemplate);
                bTemplate.setProbeTemplate(irisProbeTemplate);
                L1_LOGGER.debug((Object)(this.instanceIdentifierM + ", Done Creating Templates for Iris Image Cleaning up"));
                templates.add(bTemplate);
            }
        }
        catch (Exception ex) {
            L1_LOGGER.error((Object)(this.instanceIdentifierM + "Exception caught: "), (Throwable)ex);
            List<BiometricTemplate> list = null;
            return list;
        }
        finally {
            if (l1Image != null) {
                l1Image.dispose();
            }
            if (l1Image2 != null) {
                l1Image2.dispose();
            }
        }
        return templates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<BiometricTemplate> getTemplatesForFinger(byte[] input, List<BiometricPosition> missingFingers, boolean copyGalleryToProbe) {
        ArrayList<BiometricTemplate> templates = new ArrayList<BiometricTemplate>();
        try {
            Vector dataVec = null;
            try {
                dataVec = FingerISO.getImagesFromPackage((byte[])input, (boolean)this.iso_parsing_strict);
            }
            catch (Exception et) {
                L1_LOGGER.error((Object)(this.instanceIdentifierM + ", Finger ISO Parsing Failed"), (Throwable)et);
                return null;
            }
            int i = 0;
            while (i < dataVec.size()) {
                block43: {
                    Image l1Image = null;
                    Image l1Image2 = null;
                    Image segGalleryImage = null;
                    Image segProbeImage = null;
                    try {
                        l1Image = L1QAModule.createFoundationImage(L1_LOGGER, (ImageStruct)dataVec.get(i), Types.Modality.Fingerprint);
                        if (l1Image == null) {
                            L1_LOGGER.error((Object)(this.instanceIdentifierM + ": Fingerprint ISO Parsing Failed: no image data present."));
                            List<BiometricTemplate> list = null;
                            return list;
                        }
                        Types.Instance fingerType = Types.Instance.Unknown;
                        BiometricPosition position = BiometricPosition.UNKNOWN;
                        int fingerPosition = ((ImageStruct)dataVec.get(i)).getPosition();
                        switch (fingerPosition) {
                            case 0: {
                                fingerType = Types.Instance.FingerUnknown;
                                position = BiometricPosition.UNKNOWN;
                                break;
                            }
                            case 1: {
                                fingerType = Types.Instance.FingerRightThumb;
                                position = BiometricPosition.RIGHT_THUMB;
                                break;
                            }
                            case 2: {
                                fingerType = Types.Instance.FingerRightIndex;
                                position = BiometricPosition.RIGHT_INDEX;
                                break;
                            }
                            case 3: {
                                fingerType = Types.Instance.FingerRightMiddle;
                                position = BiometricPosition.RIGHT_MIDDLE;
                                break;
                            }
                            case 4: {
                                fingerType = Types.Instance.FingerRightRing;
                                position = BiometricPosition.RIGHT_RING;
                                break;
                            }
                            case 5: {
                                fingerType = Types.Instance.FingerRightLittle;
                                position = BiometricPosition.RIGHT_LITTLE;
                                break;
                            }
                            case 6: {
                                fingerType = Types.Instance.FingerLeftThumb;
                                position = BiometricPosition.LEFT_THUMB;
                                break;
                            }
                            case 7: {
                                fingerType = Types.Instance.FingerLeftIndex;
                                position = BiometricPosition.LEFT_INDEX;
                                break;
                            }
                            case 8: {
                                fingerType = Types.Instance.FingerLeftMiddle;
                                position = BiometricPosition.LEFT_MIDDLE;
                                break;
                            }
                            case 9: {
                                fingerType = Types.Instance.FingerLeftRing;
                                position = BiometricPosition.LEFT_RING;
                                break;
                            }
                            case 10: {
                                fingerType = Types.Instance.FingerLeftLittle;
                                position = BiometricPosition.LEFT_LITTLE;
                                break;
                            }
                            case 11: {
                                fingerType = Types.Instance.FingerPlainRightThumb;
                                position = BiometricPosition.RIGHT_THUMB;
                                break;
                            }
                            case 12: {
                                fingerType = Types.Instance.FingerPlainLeftThumb;
                                position = BiometricPosition.LEFT_THUMB;
                                break;
                            }
                            case 13: {
                                fingerType = Types.Instance.FingerPlainRightSlap;
                                position = BiometricPosition.RIGHT_SLAP;
                                break;
                            }
                            case 14: {
                                fingerType = Types.Instance.FingerPlainLeftSlap;
                                position = BiometricPosition.LEFT_SLAP;
                                break;
                            }
                            case 15: {
                                fingerType = Types.Instance.FingerPlainThumbs;
                                position = BiometricPosition.BOTH_THUMBS;
                                break;
                            }
                        }
                        L1_LOGGER.debug((Object)(this.instanceIdentifierM + ", fingerType : " + fingerType));
                        if (fingerType != Types.Instance.FingerPlainRightSlap && fingerType != Types.Instance.FingerPlainLeftSlap && fingerType != Types.Instance.FingerPlainThumbs) {
                            byte[] fingerGalleryTemplate = this.fingerQaModule.createTemplates(l1Image, fingerType, Types.TemplateCreationType.Gallery);
                            L1_LOGGER.debug((Object)(this.instanceIdentifierM + ", Created Gallery Templates for Finger of size : " + fingerGalleryTemplate.length));
                            byte[] fingerProbeTemplate = null;
                            if (copyGalleryToProbe) {
                                fingerProbeTemplate = fingerGalleryTemplate;
                                L1_LOGGER.debug((Object)(this.instanceIdentifierM + ", Copy Gallery Template to Probe"));
                            } else {
                                l1Image2 = L1QAModule.createFoundationImage(L1_LOGGER, (ImageStruct)dataVec.get(i), Types.Modality.Fingerprint);
                                if (l1Image2 == null) {
                                    L1_LOGGER.error((Object)(this.instanceIdentifierM + ": Fingerprint ISO Parsing Failed: no image data present."));
                                    List<BiometricTemplate> list = null;
                                    return list;
                                }
                                fingerProbeTemplate = this.fingerQaModule.createTemplates(l1Image2, fingerType, Types.TemplateCreationType.Probe);
                                L1_LOGGER.debug((Object)(this.instanceIdentifierM + ", Created Probe Templates for Finger of size : " + fingerProbeTemplate.length));
                            }
                            BiometricTemplate bTemplate = new BiometricTemplate();
                            bTemplate.setBiometricPosition(position);
                            bTemplate.setGalleryTemplate(fingerGalleryTemplate);
                            bTemplate.setProbeTemplate(fingerProbeTemplate);
                            templates.add(bTemplate);
                            break block43;
                        }
                        if (fingerType != Types.Instance.FingerPlainThumbs && fingerType != Types.Instance.FingerPlainLeftSlap && fingerType != Types.Instance.FingerPlainRightSlap) break block43;
                        L1_LOGGER.debug((Object)(this.instanceIdentifierM + ", Processing Slap"));
                        Map<Types.Instance, byte[]> segmentedImages = this.fingerQaModule.segmentImage(l1Image, fingerType, missingFingers);
                        if (segmentedImages != null) {
                            for (Types.Instance instance : segmentedImages.keySet()) {
                                segGalleryImage = new Image();
                                segGalleryImage.readBlob(segmentedImages.get(instance), 0L);
                                byte[] fingerGalleryTemplate = this.fingerQaModule.createTemplates(segGalleryImage, instance, Types.TemplateCreationType.Gallery);
                                segGalleryImage.dispose();
                                if (fingerGalleryTemplate == null) {
                                    L1_LOGGER.trace((Object)(this.instanceIdentifierM + ", FTE: Created Template for Finger is null."));
                                    continue;
                                }
                                L1_LOGGER.debug((Object)(this.instanceIdentifierM + ", Created Gallery Templates for Finger of size : " + fingerGalleryTemplate.length));
                                byte[] fingerProbeTemplate = null;
                                if (copyGalleryToProbe) {
                                    fingerProbeTemplate = fingerGalleryTemplate;
                                } else {
                                    segProbeImage = new Image();
                                    segProbeImage.readBlob(segmentedImages.get(instance), 0L);
                                    fingerProbeTemplate = this.fingerQaModule.createTemplates(segProbeImage, instance, Types.TemplateCreationType.Probe);
                                    segProbeImage.dispose();
                                }
                                if (fingerProbeTemplate == null) {
                                    L1_LOGGER.trace((Object)(this.instanceIdentifierM + ", FTE: Created Template for Finger is null."));
                                    continue;
                                }
                                L1_LOGGER.debug((Object)(this.instanceIdentifierM + ", Created Probe Templates for Finger of size : " + fingerProbeTemplate.length));
                                BiometricPosition segFingerPosition = L1QAModule.convertToBiometricPosition(instance);
                                BiometricTemplate bTemplate = new BiometricTemplate();
                                bTemplate.setBiometricPosition(segFingerPosition);
                                bTemplate.setGalleryTemplate(fingerGalleryTemplate);
                                bTemplate.setProbeTemplate(fingerProbeTemplate);
                                templates.add(bTemplate);
                            }
                        }
                    }
                    finally {
                        if (l1Image != null) {
                            l1Image.dispose();
                        }
                        if (l1Image2 != null) {
                            l1Image2.dispose();
                        }
                        if (segProbeImage != null) {
                            segProbeImage.dispose();
                        }
                        if (segGalleryImage != null) {
                            segGalleryImage.dispose();
                        }
                    }
                }
                ++i;
            }
            return templates;
        }
        catch (Exception ex) {
            L1_LOGGER.error((Object)(this.instanceIdentifierM + ""), (Throwable)ex);
            return null;
        }
    }

    public List<BiometricTemplate> convertProprietaryTemplateToISO(List<BiometricTemplate> proprietaryTemplates, boolean copyGalleryToProbe) {
        if (proprietaryTemplates != null && proprietaryTemplates.size() > 0) {
            ArrayList<BiometricTemplate> isoTemplates = new ArrayList<BiometricTemplate>();
            for (BiometricTemplate template : proprietaryTemplates) {
                Types.Instance fingerInstance = L1QAModule.convertToFingerInstance(L1_LOGGER, template.getBiometricPosition());
                BiometricTemplate bTemplate = new BiometricTemplate();
                if (template.getBiometricPosition() != null) {
                    bTemplate.setBiometricPosition(template.getBiometricPosition());
                } else {
                    bTemplate.setBiometricPosition(BiometricPosition.UNKNOWN);
                }
                bTemplate.setGalleryTemplate(this.fingerQaModule.convertProprietaryTemplateToISO(template.getGalleryTemplate(), fingerInstance));
                if (copyGalleryToProbe) {
                    bTemplate.setProbeTemplate(bTemplate.getGalleryTemplate());
                } else {
                    bTemplate.setProbeTemplate(this.fingerQaModule.convertProprietaryTemplateToISO(template.getProbeTemplate(), fingerInstance));
                }
                isoTemplates.add(bTemplate);
            }
            return isoTemplates;
        }
        return null;
    }

    public boolean isISOTemplate(byte[] template) {
        return (char)template[0] != 'T' || (char)template[1] != 'P';
    }

    public boolean containsISOHeader(byte[] template) {
        return (char)template[0] != 'F' || (char)template[1] != 'M' || (char)template[2] != 'R';
    }

    public byte[] appendISOHeader(byte[] template) {
        return L1QSSEngine.concat(ISOHeader, template);
    }

    public byte[] convertIsoToProprietaryTemplate(byte[] isoTemplate, Types.Instance fingerInstance, Types.TemplateCreationType TCMode) {
        L1_LOGGER.trace((Object)(this.instanceIdentifierM + ", ISO Length : " + isoTemplate.length));
        if (!this.containsISOHeader(isoTemplate)) {
            isoTemplate = this.appendISOHeader(isoTemplate);
        }
        L1_LOGGER.trace((Object)(this.instanceIdentifierM + ", ISO Length : " + isoTemplate.length));
        return this.fingerQaModule.convertIsoToProprietaryTemplate(isoTemplate, fingerInstance, TCMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FingerprintQSS getQSSDataForFingerprint(byte[] input, List<BiometricPosition> missingFingers) {
        FingerprintQSS j10;
        List<ImageDescriptor> fingerResList;
        Quality quality;
        Object fingerRes2;
        ImageDescriptor fingerRes;
        Image l1Image;
        block164: {
            FingerprintQSS i$;
            block163: {
                FingerprintQSS l2mQualityValueL2;
                block162: {
                    FingerprintQSS fingerprintQSS;
                    block160: {
                        block161: {
                            if (!this.fingerSupport) {
                                L1_LOGGER.warn((Object)"QSSEngine is not initialized for fingers - check your config");
                                return null;
                            }
                            l1Image = null;
                            fingerRes = null;
                            fingerRes2 = null;
                            quality = null;
                            fingerResList = null;
                            if (missingFingers == null) {
                                missingFingers = new ArrayList<BiometricPosition>();
                            }
                            String executionStepL = "getQSSDataForFingerprint start.";
                            try {
                                executionStepL = "Get FINGER_QA_LOCK.";
                                this.FINGER_QA_LOCK.lock();
                                StringBuilder overallFailureCommentL = new StringBuilder();
                                ArrayList<FingerprintQSS> fingerprintQualityList = new ArrayList<FingerprintQSS>();
                                L1_LOGGER.info((Object)(this.instanceIdentifierM + ", In getQssDataForFingerprint"));
                                Vector dataVec = null;
                                try {
                                    dataVec = FingerISO.getImagesFromPackage((byte[])input, (boolean)this.iso_parsing_strict);
                                }
                                catch (Exception ex) {
                                    L1_LOGGER.error((Object)(this.instanceIdentifierM + ", ExecutionStep: '" + executionStepL + "': Finger ISO Parsing Failed: " + ex));
                                    FingerprintQSS fingerprintQuality = new FingerprintQSS();
                                    fingerprintQuality.setOverallCompliance(Compliance.ERROR);
                                    fingerprintQuality.setOverallComments("Not a Valid ISO Image");
                                    fingerprintQuality.setOverallScore(0.0);
                                    FingerprintQSS fingerprintQSS2 = fingerprintQuality;
                                    this.FINGER_QA_LOCK.unlock();
                                    if (l1Image != null) {
                                        l1Image.dispose();
                                    }
                                    if (fingerResList != null) {
                                        for (int j2 = 0; j2 < fingerResList.size(); ++j2) {
                                            ((ImageDescriptor)fingerResList.get(j2)).dispose();
                                        }
                                    }
                                    if (fingerRes != null) {
                                        fingerRes.dispose();
                                    }
                                    if (fingerRes2 != null) {
                                        fingerRes2.dispose();
                                    }
                                    if (quality == null) return fingerprintQSS2;
                                    quality.dispose();
                                    return fingerprintQSS2;
                                }
                                for (int i = 0; i < dataVec.size(); ++i) {
                                    block172: {
                                        HashMap<Types.QualityCheckType, Float> overallQualityCountMap;
                                        HashMap<Types.QualityCheckType, Float> overallQualityMap;
                                        StringBuilder missingFingersCommentL;
                                        FingerprintQualityFeedback fingerMissmatchQualityFeedback;
                                        int expectedNumberOfFingers;
                                        boolean fingerMissmatchL;
                                        HashMap<FingerprintQualityAttribute, String> qualityMessageMap;
                                        HashMap<FingerprintQualityAttribute, Double> qualityThresholdMap;
                                        Types.Instance fingerType;
                                        FingerprintQSS fingerprintQuality;
                                        block175: {
                                            block173: {
                                                block174: {
                                                    block167: {
                                                        block171: {
                                                            block169: {
                                                                float overallQuality;
                                                                block170: {
                                                                    block168: {
                                                                        int nistMappedValueL;
                                                                        executionStepL = "Decompress fingerprint image.";
                                                                        fingerprintQuality = new FingerprintQSS();
                                                                        l1Image = L1QAModule.createFoundationImage(L1_LOGGER, (ImageStruct)dataVec.get(i), Types.Modality.Fingerprint);
                                                                        if (l1Image == null) {
                                                                            L1_LOGGER.error((Object)(this.instanceIdentifierM + ", ExecutionStep: '" + executionStepL + "': Fingerprint ISO Parsing Failed: no image data present."));
                                                                            fingerprintQuality.setOverallCompliance(Compliance.ERROR);
                                                                            fingerprintQuality.setOverallComments("Not a Valid ISO Image");
                                                                            fingerprintQuality.setOverallScore(0.0);
                                                                            FingerprintQSS fingerprintQSS3 = fingerprintQuality;
                                                                            return fingerprintQSS3;
                                                                        }
                                                                        fingerType = Types.Instance.Unknown;
                                                                        int fingerPosition = ((ImageStruct)dataVec.get(i)).getPosition();
                                                                        switch (fingerPosition) {
                                                                            case 0: {
                                                                                fingerType = Types.Instance.FingerUnknown;
                                                                                break;
                                                                            }
                                                                            case 1: {
                                                                                fingerType = Types.Instance.FingerRightThumb;
                                                                                break;
                                                                            }
                                                                            case 2: {
                                                                                fingerType = Types.Instance.FingerRightIndex;
                                                                                break;
                                                                            }
                                                                            case 3: {
                                                                                fingerType = Types.Instance.FingerRightMiddle;
                                                                                break;
                                                                            }
                                                                            case 4: {
                                                                                fingerType = Types.Instance.FingerRightRing;
                                                                                break;
                                                                            }
                                                                            case 5: {
                                                                                fingerType = Types.Instance.FingerRightLittle;
                                                                                break;
                                                                            }
                                                                            case 6: {
                                                                                fingerType = Types.Instance.FingerLeftThumb;
                                                                                break;
                                                                            }
                                                                            case 7: {
                                                                                fingerType = Types.Instance.FingerLeftIndex;
                                                                                break;
                                                                            }
                                                                            case 8: {
                                                                                fingerType = Types.Instance.FingerLeftMiddle;
                                                                                break;
                                                                            }
                                                                            case 9: {
                                                                                fingerType = Types.Instance.FingerLeftRing;
                                                                                break;
                                                                            }
                                                                            case 10: {
                                                                                fingerType = Types.Instance.FingerLeftLittle;
                                                                                break;
                                                                            }
                                                                            case 11: {
                                                                                fingerType = Types.Instance.FingerPlainRightThumb;
                                                                                break;
                                                                            }
                                                                            case 12: {
                                                                                fingerType = Types.Instance.FingerPlainLeftThumb;
                                                                                break;
                                                                            }
                                                                            case 13: {
                                                                                fingerType = Types.Instance.FingerPlainRightSlap;
                                                                                break;
                                                                            }
                                                                            case 14: {
                                                                                fingerType = Types.Instance.FingerPlainLeftSlap;
                                                                                break;
                                                                            }
                                                                            case 15: {
                                                                                fingerType = Types.Instance.FingerPlainThumbs;
                                                                                break;
                                                                            }
                                                                        }
                                                                        qualityThresholdMap = null;
                                                                        qualityMessageMap = null;
                                                                        L1_LOGGER.debug((Object)(this.instanceIdentifierM + ", fingerType : " + fingerType));
                                                                        executionStepL = "Process fingerprint image.";
                                                                        if (fingerType == Types.Instance.FingerPlainRightSlap || fingerType == Types.Instance.FingerPlainLeftSlap || fingerType == Types.Instance.FingerPlainThumbs) break block167;
                                                                        qualityThresholdMap = this.fingerprintQualityThresholdMap;
                                                                        qualityMessageMap = this.fingerprintQualityMessageMap;
                                                                        executionStepL = "Process single fingerprint image. Check for finger missmatch.";
                                                                        FingerprintQualityFeedback fingerMissmatchQualityFeedback2 = new FingerprintQualityFeedback();
                                                                        fingerMissmatchQualityFeedback2.setQualityAttribute(FingerprintQualityAttribute.FINGER_MISMATCH);
                                                                        if (!missingFingers.isEmpty()) {
                                                                            fingerMissmatchQualityFeedback2.setComments("Missing fingers argument is expected to be empty for single fingerprint images.");
                                                                            fingerMissmatchQualityFeedback2.setCompliance(Compliance.BELOW_THRESHOLD);
                                                                            fingerMissmatchQualityFeedback2.setScore(0.0);
                                                                        } else {
                                                                            fingerMissmatchQualityFeedback2.setComments("");
                                                                            fingerMissmatchQualityFeedback2.setCompliance(Compliance.OK);
                                                                            fingerMissmatchQualityFeedback2.setScore(100.0);
                                                                        }
                                                                        fingerprintQuality.getQualityFeedback().add(fingerMissmatchQualityFeedback2);
                                                                        executionStepL = "Process single fingerprint image. Do segmentation and quality checking.";
                                                                        ArrayList<Integer> nistQualityValueL = new ArrayList<Integer>();
                                                                        fingerResList = this.fingerQaModule.processSingleFingerImage(l1Image, fingerType, nistQualityValueL, fingerprintQuality);
                                                                        if (fingerResList == null || fingerResList.size() < 2) {
                                                                            L1_LOGGER.info((Object)(this.instanceIdentifierM + ", No Fingers Detected"));
                                                                            fingerprintQuality.setOverallCompliance(Compliance.ERROR);
                                                                            fingerprintQuality.setOverallComments("No Fingers Detected");
                                                                            fingerprintQuality.setOverallScore(0.0);
                                                                            fingerprintQSS = fingerprintQuality;
                                                                            this.FINGER_QA_LOCK.unlock();
                                                                            if (l1Image == null) break block160;
                                                                            break block161;
                                                                        }
                                                                        executionStepL = "Process single finger quality check results.";
                                                                        boolean importantCheckFailed = false;
                                                                        fingerRes = fingerResList.get(1);
                                                                        if (fingerRes == null) break block168;
                                                                        quality = fingerRes.getQuality();
                                                                        L1_LOGGER.debug((Object)(this.instanceIdentifierM + ", Process single finger quality check results."));
                                                                        if (this.evaluateFingerprintQuality(quality, Types.QualityCheckType.FingerGoodArea, FingerprintQualityAttribute.FINGER_GOOD_AREA, fingerprintQuality, qualityThresholdMap, qualityMessageMap, overallFailureCommentL)) {
                                                                            importantCheckFailed = true;
                                                                        }
                                                                        if (this.evaluateFingerprintQuality(quality, Types.QualityCheckType.FingerContactArea, FingerprintQualityAttribute.FINGER_CONTACT_AREA, fingerprintQuality, qualityThresholdMap, qualityMessageMap, overallFailureCommentL)) {
                                                                            importantCheckFailed = true;
                                                                        }
                                                                        if (this.evaluateFingerprintQuality(quality, Types.QualityCheckType.FingerMinutiaCount, FingerprintQualityAttribute.FINGER_MINUTIA_COUNT, fingerprintQuality, qualityThresholdMap, qualityMessageMap, overallFailureCommentL)) {
                                                                            importantCheckFailed = true;
                                                                        }
                                                                        if ((nistMappedValueL = 100 - ((Integer)nistQualityValueL.get(0) - 1) * 20) < 40) {
                                                                            double l2mQualityValueL2 = (double)quality.getQualityValue(Types.QualityCheckType.FingerL2mQuality) * 10.0;
                                                                            if (this.evaluateFingerprintQuality(l2mQualityValueL2 = Math.min(l2mQualityValueL2, (double)nistMappedValueL), FingerprintQualityAttribute.FINGER_PROPREIETARY_QUALITY, fingerprintQuality, qualityThresholdMap, qualityMessageMap, overallFailureCommentL)) {
                                                                                importantCheckFailed = true;
                                                                            }
                                                                        } else if (this.evaluateFingerprintQuality(quality, Types.QualityCheckType.FingerL2mQuality, FingerprintQualityAttribute.FINGER_PROPREIETARY_QUALITY, fingerprintQuality, qualityThresholdMap, qualityMessageMap, overallFailureCommentL)) {
                                                                            importantCheckFailed = true;
                                                                        }
                                                                        quality.dispose();
                                                                        quality = null;
                                                                        fingerRes.dispose();
                                                                        fingerRes = null;
                                                                        overallQuality = 0.0f;
                                                                        overallQuality = 100 - ((Integer)nistQualityValueL.get(0) - 1) * 20;
                                                                        if (importantCheckFailed) break block169;
                                                                        break block170;
                                                                    }
                                                                    L1_LOGGER.error((Object)(this.instanceIdentifierM + "Quality checks at single fingerprint image could not be performed."));
                                                                    FingerprintQSS tmpFingerprintQuality = new FingerprintQSS();
                                                                    tmpFingerprintQuality.setOverallCompliance(Compliance.ERROR);
                                                                    tmpFingerprintQuality.setOverallComments("Quality checks at single fingerprint image could not be performed.");
                                                                    tmpFingerprintQuality.setOverallScore(0.0);
                                                                    l2mQualityValueL2 = tmpFingerprintQuality;
                                                                    this.FINGER_QA_LOCK.unlock();
                                                                    break block162;
                                                                }
                                                                fingerprintQuality.setOverallComments(overallFailureCommentL.toString());
                                                                fingerprintQuality.setOverallCompliance(Compliance.OK);
                                                                fingerprintQuality.setOverallScore((double)overallQuality);
                                                                break block171;
                                                            }
                                                            double minScaledQualityValueL = 1000.0;
                                                            List qualListL = fingerprintQuality.getQualityFeedback();
                                                            for (FingerprintQualityFeedback qf : qualListL) {
                                                                if (qf.getCompliance() == Compliance.ERROR) {
                                                                    minScaledQualityValueL = 0.0;
                                                                    break;
                                                                }
                                                                if (qf.getCompliance() != Compliance.BELOW_THRESHOLD) continue;
                                                                double scaledQualityValueL = qf.getScore();
                                                                double thresholdL = qualityThresholdMap.get(qf.getQualityAttribute());
                                                                if ((scaledQualityValueL = scaledQualityValueL / thresholdL * 40.0) > 40.0) {
                                                                    System.out.println("huh?");
                                                                }
                                                                if (!(scaledQualityValueL < minScaledQualityValueL)) continue;
                                                                minScaledQualityValueL = scaledQualityValueL;
                                                            }
                                                            if (minScaledQualityValueL > 999.0) {
                                                                minScaledQualityValueL = 0.0;
                                                            }
                                                            fingerprintQuality.setOverallCompliance(Compliance.ERROR);
                                                            fingerprintQuality.setOverallComments(overallFailureCommentL.toString());
                                                            fingerprintQuality.setOverallScore(minScaledQualityValueL);
                                                        }
                                                        fingerprintQualityList.add(fingerprintQuality);
                                                        break block172;
                                                    }
                                                    executionStepL = "Process slap fingerprint image.";
                                                    fingerMissmatchL = false;
                                                    expectedNumberOfFingers = 0;
                                                    if (fingerType == Types.Instance.FingerPlainThumbs) {
                                                        expectedNumberOfFingers = 2;
                                                        qualityThresholdMap = this.thumbsQualityThresholdMap;
                                                        qualityMessageMap = this.thumbsQualityMessageMap;
                                                    } else {
                                                        expectedNumberOfFingers = 4;
                                                        qualityThresholdMap = this.fourfingerQualityThresholdMap;
                                                        qualityMessageMap = this.fourfingerQualityMessageMap;
                                                    }
                                                    executionStepL = "Process slap fingerprint image: check missingfingers argument for plausibility.";
                                                    fingerMissmatchQualityFeedback = new FingerprintQualityFeedback();
                                                    fingerMissmatchQualityFeedback.setQualityAttribute(FingerprintQualityAttribute.FINGER_MISMATCH);
                                                    missingFingersCommentL = new StringBuilder();
                                                    if (missingFingers.isEmpty()) break block173;
                                                    if (missingFingers.size() < expectedNumberOfFingers) break block174;
                                                    fingerMissmatchL = true;
                                                    missingFingersCommentL.append("Missing fingers argument invalid. Number of missing fingers is expected to be less than " + expectedNumberOfFingers + ".");
                                                    break block175;
                                                }
                                                block30 : switch (fingerType) {
                                                    case FingerPlainThumbs: {
                                                        for (BiometricPosition posL : missingFingers) {
                                                            if (posL == BiometricPosition.RIGHT_THUMB || posL == BiometricPosition.LEFT_THUMB) continue;
                                                            fingerMissmatchL = true;
                                                            missingFingersCommentL.append("Missing fingers argument invalid. Finger position " + posL + " is not expected in a " + fingerType + " image.");
                                                            break block30;
                                                        }
                                                        break;
                                                    }
                                                    case FingerPlainRightSlap: {
                                                        for (BiometricPosition posL : missingFingers) {
                                                            if (posL == BiometricPosition.RIGHT_INDEX || posL == BiometricPosition.RIGHT_MIDDLE || posL == BiometricPosition.RIGHT_RING || posL == BiometricPosition.RIGHT_LITTLE) continue;
                                                            fingerMissmatchL = true;
                                                            missingFingersCommentL.append("Missing fingers argument invalid. Finger position " + posL + " is not expected in a " + fingerType + " image.");
                                                            break block30;
                                                        }
                                                        break;
                                                    }
                                                    case FingerPlainLeftSlap: {
                                                        for (BiometricPosition posL : missingFingers) {
                                                            if (posL == BiometricPosition.LEFT_INDEX || posL == BiometricPosition.LEFT_MIDDLE || posL == BiometricPosition.LEFT_RING || posL == BiometricPosition.LEFT_LITTLE) continue;
                                                            fingerMissmatchL = true;
                                                            missingFingersCommentL.append("Missing fingers argument invalid. Finger position " + posL + " is not expected in a " + fingerType + " image.");
                                                            break block30;
                                                        }
                                                        break block175;
                                                    }
                                                }
                                                break block175;
                                            }
                                            fingerMissmatchQualityFeedback.setComments("");
                                            fingerMissmatchQualityFeedback.setCompliance(Compliance.OK);
                                            fingerMissmatchQualityFeedback.setScore(100.0);
                                        }
                                        if (fingerMissmatchL) {
                                            fingerMissmatchQualityFeedback.setComments(missingFingersCommentL.toString());
                                            if (overallFailureCommentL.length() > 0) {
                                                overallFailureCommentL.append(", ");
                                            }
                                            overallFailureCommentL.append((CharSequence)missingFingersCommentL);
                                            fingerMissmatchQualityFeedback.setCompliance(Compliance.ERROR);
                                            fingerMissmatchQualityFeedback.setScore(0.0);
                                            fingerprintQuality.getQualityFeedback().add(fingerMissmatchQualityFeedback);
                                            fingerprintQuality.setOverallScore(0.0);
                                            fingerprintQuality.setOverallComments(overallFailureCommentL.toString());
                                            fingerprintQuality.setOverallCompliance(Compliance.ERROR);
                                            i$ = fingerprintQuality;
                                            this.FINGER_QA_LOCK.unlock();
                                            break block163;
                                        }
                                        Vector<Integer> nistQualityValues = new Vector<Integer>();
                                        executionStepL = "Process slap fingerprint image without given missing fingers.";
                                        fingerResList = this.fingerQaModule.processMultiImage(l1Image, fingerType, nistQualityValues, fingerprintQuality, missingFingers);
                                        executionStepL = "Process slap fingerprint quality results.";
                                        if (fingerResList == null || fingerResList.isEmpty()) {
                                            L1_LOGGER.info((Object)(this.instanceIdentifierM + ", No Fingers Detected"));
                                            fingerprintQuality.setOverallCompliance(Compliance.ERROR);
                                            fingerprintQuality.setOverallComments("No Fingers Detected");
                                            fingerprintQuality.setOverallScore(0.0);
                                            j10 = fingerprintQuality;
                                            this.FINGER_QA_LOCK.unlock();
                                            break block164;
                                        }
                                        int numberOfSegmentedFingersL = fingerResList.size() - 1;
                                        executionStepL = "Check segmented fingers for finger missmatch.";
                                        if (missingFingers.isEmpty()) {
                                            if (numberOfSegmentedFingersL != expectedNumberOfFingers) {
                                                if (missingFingersCommentL.length() > 0) {
                                                    missingFingersCommentL.append(", ");
                                                }
                                                missingFingersCommentL.append("Missing finger detected.");
                                                fingerMissmatchL = true;
                                            }
                                        } else {
                                            boolean retrySegmentationWithMissingFingersL = false;
                                            int numberOfMissingFingersL = missingFingers.size();
                                            if (numberOfSegmentedFingersL + numberOfMissingFingersL == expectedNumberOfFingers) {
                                                for (int r = 0; r < fingerResList.size(); ++r) {
                                                    if (!missingFingers.contains(L1QAModule.convertToBiometricPosition(fingerResList.get(r).getInstance()))) continue;
                                                    retrySegmentationWithMissingFingersL = true;
                                                    break;
                                                }
                                            } else if (numberOfSegmentedFingersL + numberOfMissingFingersL > expectedNumberOfFingers) {
                                                if (missingFingersCommentL.length() > 0) {
                                                    missingFingersCommentL.append(", ");
                                                }
                                                missingFingersCommentL.append("More fingers detected than expected.");
                                                fingerMissmatchL = true;
                                            } else {
                                                retrySegmentationWithMissingFingersL = true;
                                            }
                                            if (retrySegmentationWithMissingFingersL) {
                                                executionStepL = "Retry segmentation with missing fingers.";
                                                fingerprintQuality = new FingerprintQSS();
                                                for (int j3 = 0; j3 < fingerResList.size(); ++j3) {
                                                    fingerResList.get(j3).dispose();
                                                }
                                                fingerResList = this.fingerQaModule.processMultiImage(l1Image, fingerType, nistQualityValues, fingerprintQuality, missingFingers);
                                                if (fingerResList == null || fingerResList.isEmpty()) {
                                                    L1_LOGGER.info((Object)(this.instanceIdentifierM + ", No Fingers Detected"));
                                                    fingerprintQuality.setOverallCompliance(Compliance.ERROR);
                                                    fingerprintQuality.setOverallComments("No Fingers Detected");
                                                    fingerprintQuality.setOverallScore(0.0);
                                                    FingerprintQSS j3 = fingerprintQuality;
                                                    this.FINGER_QA_LOCK.unlock();
                                                    if (l1Image != null) {
                                                        l1Image.dispose();
                                                    }
                                                    if (fingerResList != null) {
                                                        for (int j4 = 0; j4 < fingerResList.size(); ++j4) {
                                                            fingerResList.get(j4).dispose();
                                                        }
                                                    }
                                                    if (fingerRes != null) {
                                                        fingerRes.dispose();
                                                    }
                                                    if (fingerRes2 != null) {
                                                        fingerRes2.dispose();
                                                    }
                                                    if (quality == null) return j3;
                                                    quality.dispose();
                                                    return j3;
                                                }
                                                numberOfSegmentedFingersL = fingerResList.size();
                                                if (numberOfSegmentedFingersL + numberOfMissingFingersL == expectedNumberOfFingers) {
                                                    for (int r = 0; r < fingerResList.size(); ++r) {
                                                        if (!missingFingers.contains(L1QAModule.convertToBiometricPosition(fingerResList.get(r).getInstance()))) continue;
                                                        if (missingFingersCommentL.length() > 0) {
                                                            missingFingersCommentL.append(", ");
                                                        }
                                                        missingFingersCommentL.append("Other fingers detected than expected.");
                                                        fingerMissmatchL = true;
                                                        break;
                                                    }
                                                } else if (numberOfSegmentedFingersL + numberOfMissingFingersL > expectedNumberOfFingers) {
                                                    if (missingFingersCommentL.length() > 0) {
                                                        missingFingersCommentL.append(", ");
                                                    }
                                                    missingFingersCommentL.append("More fingers detected than expected.");
                                                    fingerMissmatchL = true;
                                                } else {
                                                    if (missingFingersCommentL.length() > 0) {
                                                        missingFingersCommentL.append(", ");
                                                    }
                                                    missingFingersCommentL.append("Less fingers detected than expected.");
                                                    fingerMissmatchL = true;
                                                }
                                            }
                                        }
                                        boolean importantCheckFailed = false;
                                        executionStepL = "Process slap quality check results.";
                                        ImageDescriptor slapResultDescriptorL = fingerResList.get(0);
                                        if (slapResultDescriptorL != null) {
                                            quality = slapResultDescriptorL.getQuality();
                                            L1_LOGGER.debug((Object)(this.instanceIdentifierM + ", Process slap quality check results."));
                                            if (this.evaluateFingerprintQuality(quality, Types.QualityCheckType.SlapPressHeavy, FingerprintQualityAttribute.SLAP_PRESS_HEAVY, fingerprintQuality, qualityThresholdMap, qualityMessageMap, overallFailureCommentL, expectedNumberOfFingers, numberOfSegmentedFingersL)) {
                                                importantCheckFailed = true;
                                            }
                                            if (this.evaluateFingerprintQuality(quality, Types.QualityCheckType.SlapPressLight, FingerprintQualityAttribute.SLAP_PRESS_LIGHT, fingerprintQuality, qualityThresholdMap, qualityMessageMap, overallFailureCommentL, expectedNumberOfFingers, numberOfSegmentedFingersL)) {
                                                importantCheckFailed = true;
                                            }
                                            if (this.evaluateFingerprintQuality(quality, Types.QualityCheckType.SlapCentering, FingerprintQualityAttribute.SLAP_CENTERING, fingerprintQuality, qualityThresholdMap, qualityMessageMap, overallFailureCommentL)) {
                                                importantCheckFailed = true;
                                            }
                                            if (this.evaluateFingerprintQuality(quality, Types.QualityCheckType.SlapWetness, FingerprintQualityAttribute.SLAP_WETNESS, fingerprintQuality, qualityThresholdMap, qualityMessageMap, overallFailureCommentL, expectedNumberOfFingers, numberOfSegmentedFingersL)) {
                                                importantCheckFailed = true;
                                            }
                                            if (this.evaluateFingerprintQuality(quality, Types.QualityCheckType.SlapDryness, FingerprintQualityAttribute.SLAP_DRYNESS, fingerprintQuality, qualityThresholdMap, qualityMessageMap, overallFailureCommentL, expectedNumberOfFingers, numberOfSegmentedFingersL)) {
                                                importantCheckFailed = true;
                                            }
                                            if (this.evaluateFingerprintQuality(quality, Types.QualityCheckType.SlapPlacement, FingerprintQualityAttribute.SLAP_PLACEMENT, fingerprintQuality, qualityThresholdMap, qualityMessageMap, overallFailureCommentL, expectedNumberOfFingers, numberOfSegmentedFingersL)) {
                                                importantCheckFailed = true;
                                            }
                                            quality.dispose();
                                            quality = null;
                                            executionStepL = "Get single finger quality results.";
                                            overallQualityMap = new HashMap<Types.QualityCheckType, Float>();
                                            overallQualityCountMap = new HashMap<Types.QualityCheckType, Float>();
                                        } else {
                                            L1_LOGGER.error((Object)(this.instanceIdentifierM + "Slap quality checks are not available."));
                                            FingerprintQSS tmpFingerprintQuality = new FingerprintQSS();
                                            tmpFingerprintQuality.setOverallCompliance(Compliance.ERROR);
                                            tmpFingerprintQuality.setOverallComments("Slap quality checks are not available.");
                                            tmpFingerprintQuality.setOverallScore(0.0);
                                            FingerprintQSS j4 = tmpFingerprintQuality;
                                            this.FINGER_QA_LOCK.unlock();
                                            if (l1Image != null) {
                                                l1Image.dispose();
                                            }
                                            if (fingerResList != null) {
                                                for (int j5 = 0; j5 < fingerResList.size(); ++j5) {
                                                    fingerResList.get(j5).dispose();
                                                }
                                            }
                                            if (fingerRes != null) {
                                                fingerRes.dispose();
                                            }
                                            if (fingerRes2 != null) {
                                                fingerRes2.dispose();
                                            }
                                            if (quality == null) return j4;
                                            quality.dispose();
                                            return j4;
                                        }
                                        for (int j6 = 1; j6 < fingerResList.size(); ++j6) {
                                            fingerRes = fingerResList.get(j6);
                                            if (fingerRes != null) {
                                                quality = fingerRes.getQuality();
                                                for (int k = 0; k < quality.getNumberOfAppliedQualityChecks(); ++k) {
                                                    Types.QualityCheckType typeL = quality.getQualityCheckType(k);
                                                    float qualityVal = quality.getQualityValue(typeL) * 10.0f;
                                                    float countL = 1.0f;
                                                    if (overallQualityMap.containsKey(typeL)) {
                                                        qualityVal += ((Float)overallQualityMap.get(typeL)).floatValue();
                                                        countL = ((Float)overallQualityCountMap.get(typeL)).floatValue() + 1.0f;
                                                    }
                                                    overallQualityMap.put(typeL, Float.valueOf(qualityVal));
                                                    overallQualityCountMap.put(typeL, Float.valueOf(countL));
                                                }
                                                quality.dispose();
                                                quality = null;
                                            }
                                            Types.QualityCheckType typeL = Types.QualityCheckType.FingerQualityClass;
                                            float qualityVal = nistQualityValues.get(j6 - 1).intValue();
                                            float countL = 1.0f;
                                            if (overallQualityMap.containsKey(typeL)) {
                                                if (!(qualityVal > ((Float)overallQualityMap.get(typeL)).floatValue())) continue;
                                                overallQualityMap.put(typeL, Float.valueOf(qualityVal));
                                                continue;
                                            }
                                            overallQualityMap.put(typeL, Float.valueOf(qualityVal));
                                            overallQualityCountMap.put(typeL, Float.valueOf(countL));
                                        }
                                        executionStepL = "Averaging single finger quality results.";
                                        List<Types.QualityCheckType> singleFingerCheckTypesL = Arrays.asList(Types.QualityCheckType.FingerGoodArea, Types.QualityCheckType.FingerContactArea, Types.QualityCheckType.FingerMinutiaCount, Types.QualityCheckType.FingerL2mQuality);
                                        List<FingerprintQualityAttribute> singleFingerAttsL = Arrays.asList(FingerprintQualityAttribute.FINGER_GOOD_AREA, FingerprintQualityAttribute.FINGER_CONTACT_AREA, FingerprintQualityAttribute.FINGER_MINUTIA_COUNT, FingerprintQualityAttribute.FINGER_PROPREIETARY_QUALITY);
                                        for (int idxL = 0; idxL < singleFingerCheckTypesL.size(); ++idxL) {
                                            Types.QualityCheckType typeL = singleFingerCheckTypesL.get(idxL);
                                            FingerprintQualityAttribute attL = singleFingerAttsL.get(idxL);
                                            if (overallQualityMap.containsKey(typeL)) {
                                                float nfiqQualVal;
                                                float nistMappedValueL;
                                                float qualityVal = ((Float)overallQualityMap.get(typeL)).floatValue() / ((Float)overallQualityCountMap.get(typeL)).floatValue();
                                                if (typeL == Types.QualityCheckType.FingerL2mQuality && (nistMappedValueL = 100.0f - ((nfiqQualVal = ((Float)overallQualityMap.get(Types.QualityCheckType.FingerQualityClass)).floatValue() / ((Float)overallQualityCountMap.get(Types.QualityCheckType.FingerQualityClass)).floatValue()) - 1.0f) * 20.0f) < 40.0f) {
                                                    qualityVal = Math.min(qualityVal, nistMappedValueL);
                                                }
                                                if (!this.evaluateFingerprintQuality(qualityVal, attL, fingerprintQuality, qualityThresholdMap, qualityMessageMap, overallFailureCommentL)) continue;
                                                importantCheckFailed = true;
                                                continue;
                                            }
                                            FingerprintQualityFeedback fingerprintQualityFeedback = new FingerprintQualityFeedback();
                                            fingerprintQualityFeedback.setComments("Quality check not applied.");
                                            fingerprintQualityFeedback.setCompliance(Compliance.ERROR);
                                            fingerprintQualityFeedback.setScore(0.0);
                                            fingerprintQualityFeedback.setQualityAttribute(attL);
                                            fingerprintQuality.getQualityFeedback().add(fingerprintQualityFeedback);
                                            importantCheckFailed = true;
                                        }
                                        executionStepL = "Calculate overall quality.";
                                        float overallQuality = 0.0f;
                                        if (overallQualityMap.containsKey(Types.QualityCheckType.FingerQualityClass)) {
                                            float qualityVal = ((Float)overallQualityMap.get(Types.QualityCheckType.FingerQualityClass)).floatValue() / ((Float)overallQualityCountMap.get(Types.QualityCheckType.FingerQualityClass)).floatValue();
                                            overallQuality = 100.0f - (qualityVal - 1.0f) * 20.0f;
                                        }
                                        executionStepL = "Check handedness.";
                                        int handednessL = fingerprintQuality.getHandedness();
                                        switch (fingerType) {
                                            case FingerPlainRightSlap: {
                                                if (handednessL >= -5) break;
                                                if (missingFingersCommentL.length() > 0) {
                                                    missingFingersCommentL.append(", ");
                                                }
                                                missingFingersCommentL.append("Handedness check failed");
                                                fingerMissmatchL = true;
                                                break;
                                            }
                                            case FingerPlainLeftSlap: {
                                                if (handednessL <= 5) break;
                                                if (missingFingersCommentL.length() > 0) {
                                                    missingFingersCommentL.append(", ");
                                                }
                                                missingFingersCommentL.append("Handedness check failed");
                                                fingerMissmatchL = true;
                                                break;
                                            }
                                        }
                                        if (fingerMissmatchL) {
                                            fingerMissmatchQualityFeedback.setComments(missingFingersCommentL.toString());
                                            fingerMissmatchQualityFeedback.setCompliance(Compliance.BELOW_THRESHOLD);
                                            fingerMissmatchQualityFeedback.setScore(0.0);
                                            if (overallFailureCommentL.length() > 0) {
                                                overallFailureCommentL.append(", ");
                                            }
                                            overallFailureCommentL.append(missingFingersCommentL.toString());
                                            importantCheckFailed = true;
                                        }
                                        fingerprintQuality.getQualityFeedback().add(fingerMissmatchQualityFeedback);
                                        fingerprintQuality.setOverallComments(overallFailureCommentL.toString());
                                        if (importantCheckFailed) {
                                            double minScaledQualityValueL = 1000.0;
                                            List qualListL = fingerprintQuality.getQualityFeedback();
                                            for (FingerprintQualityFeedback qf : qualListL) {
                                                if (qf.getCompliance() == Compliance.ERROR) {
                                                    minScaledQualityValueL = 0.0;
                                                    break;
                                                }
                                                if (qf.getCompliance() != Compliance.BELOW_THRESHOLD) continue;
                                                double scaledQualityValueL = qf.getScore();
                                                double thresholdL = qualityThresholdMap.get(qf.getQualityAttribute());
                                                if ((scaledQualityValueL = scaledQualityValueL / thresholdL * 40.0) > 40.0) {
                                                    System.out.println("huh?");
                                                }
                                                if (!(scaledQualityValueL < minScaledQualityValueL)) continue;
                                                minScaledQualityValueL = scaledQualityValueL;
                                            }
                                            if (minScaledQualityValueL > 999.0) {
                                                minScaledQualityValueL = 0.0;
                                            }
                                            fingerprintQuality.setOverallCompliance(Compliance.ERROR);
                                            fingerprintQuality.setOverallComments(overallFailureCommentL.toString());
                                            fingerprintQuality.setOverallScore(minScaledQualityValueL);
                                        } else {
                                            fingerprintQuality.setOverallCompliance(Compliance.OK);
                                            fingerprintQuality.setOverallScore((double)overallQuality);
                                        }
                                        fingerprintQualityList.add(fingerprintQuality);
                                        if (fingerResList != null) {
                                            for (int j7 = 0; j7 < fingerResList.size(); ++j7) {
                                                fingerResList.get(j7).dispose();
                                            }
                                        }
                                    }
                                    l1Image.dispose();
                                    l1Image = null;
                                }
                                if (fingerprintQualityList.size() > 0) {
                                    FingerprintQSS fingerprintQSS4 = (FingerprintQSS)fingerprintQualityList.get(0);
                                    return fingerprintQSS4;
                                }
                                FingerprintQSS fingerprintQSS5 = null;
                                return fingerprintQSS5;
                            }
                            catch (Exception ex) {
                                L1_LOGGER.error((Object)(this.instanceIdentifierM + ", Exception caught: " + ex));
                                FingerprintQSS fingerprintQSS6 = null;
                                return fingerprintQSS6;
                            }
                        }
                        l1Image.dispose();
                    }
                    if (fingerResList != null) {
                        for (int j8 = 0; j8 < fingerResList.size(); ++j8) {
                            fingerResList.get(j8).dispose();
                        }
                    }
                    if (fingerRes != null) {
                        fingerRes.dispose();
                    }
                    if (fingerRes2 != null) {
                        fingerRes2.dispose();
                    }
                    if (quality == null) return fingerprintQSS;
                    quality.dispose();
                    return fingerprintQSS;
                }
                if (l1Image != null) {
                    l1Image.dispose();
                }
                if (fingerResList != null) {
                    for (int j9 = 0; j9 < fingerResList.size(); ++j9) {
                        fingerResList.get(j9).dispose();
                    }
                }
                if (fingerRes != null) {
                    fingerRes.dispose();
                }
                if (fingerRes2 != null) {
                    fingerRes2.dispose();
                }
                if (quality == null) return l2mQualityValueL2;
                quality.dispose();
                return l2mQualityValueL2;
            }
            if (l1Image != null) {
                l1Image.dispose();
            }
            if (fingerResList != null) {
                for (int j10 = 0; j10 < fingerResList.size(); ++j10) {
                    fingerResList.get(j10).dispose();
                }
            }
            if (fingerRes != null) {
                fingerRes.dispose();
            }
            if (fingerRes2 != null) {
                fingerRes2.dispose();
            }
            if (quality == null) return i$;
            quality.dispose();
            return i$;
        }
        if (l1Image != null) {
            l1Image.dispose();
        }
        if (fingerResList != null) {
            for (int j11 = 0; j11 < fingerResList.size(); ++j11) {
                fingerResList.get(j11).dispose();
            }
        }
        if (fingerRes != null) {
            fingerRes.dispose();
        }
        if (fingerRes2 != null) {
            fingerRes2.dispose();
        }
        if (quality == null) return j10;
        quality.dispose();
        return j10;
        finally {
            this.FINGER_QA_LOCK.unlock();
            if (l1Image != null) {
                l1Image.dispose();
            }
            if (fingerResList != null) {
                for (int j12 = 0; j12 < fingerResList.size(); ++j12) {
                    ((ImageDescriptor)fingerResList.get(j12)).dispose();
                }
            }
            if (fingerRes != null) {
                fingerRes.dispose();
            }
            if (fingerRes2 != null) {
                fingerRes2.dispose();
            }
            if (quality != null) {
                quality.dispose();
            }
        }
    }

    private IrisQSS getQSSDataForIris(byte[] imageData, int width, int height, int imageFormat, int irisPosition, String executionStepL) {
        Image l1Image = null;
        ImageDescriptor irisRes = null;
        executionStepL = "Decompress iris image.";
        IrisQSS irisQuality = new IrisQSS();
        Quality quality = null;
        StringBuilder overallFailureCommentL = new StringBuilder();
        try {
            l1Image = L1QAModule.createFoundationImage(L1_LOGGER, imageData, width, height, imageFormat, Types.Modality.Iris);
            if (l1Image == null) {
                L1_LOGGER.error((Object)(this.instanceIdentifierM + ", ExecutionStep: '" + executionStepL + "': Iris ISO Parsing Failed: no image data present."));
                irisQuality.setOverallCompliance(Compliance.ERROR);
                irisQuality.setOverallComments("Not a Valid ISO Image");
                irisQuality.setOverallScore(0.0);
                return irisQuality;
            }
            Types.Instance irisType = Types.Instance.Unknown;
            switch (irisPosition) {
                case 0: {
                    irisType = Types.Instance.Unknown;
                    irisQuality.setEyePosition(BiometricPosition.UNKNOWN);
                    break;
                }
                case 1: {
                    irisType = Types.Instance.IrisRight;
                    irisQuality.setEyePosition(BiometricPosition.RIGHT_IRIS);
                    break;
                }
                case 2: {
                    irisType = Types.Instance.IrisLeft;
                    irisQuality.setEyePosition(BiometricPosition.LEFT_IRIS);
                    break;
                }
            }
            L1_LOGGER.info((Object)(this.instanceIdentifierM + ", irisType : " + irisType));
            executionStepL = "Process iris image.";
            int imageHeight = l1Image.getHeight();
            int imageWidth = l1Image.getWidth();
            irisRes = this.irisQaModule.processImage(l1Image, irisType, null, null);
            boolean importantCheckFailed = false;
            L1_LOGGER.info((Object)(this.instanceIdentifierM + ", Done Processing Iris Image"));
            executionStepL = "Check quality results of iris image.";
            if (irisRes != null) {
                quality = irisRes.getQuality();
                if (this.evaluateIrisQuality(quality, Types.QualityCheckType.Irisness, IrisQualityAttribute.IRISNESS, irisQuality, overallFailureCommentL)) {
                    importantCheckFailed = true;
                }
                if (this.evaluateIrisQuality(quality, Types.QualityCheckType.Fidelity, IrisQualityAttribute.IRIS_FIDELITY, irisQuality, overallFailureCommentL)) {
                    importantCheckFailed = true;
                }
                if (this.evaluateIrisQuality(quality, Types.QualityCheckType.Character, IrisQualityAttribute.IRIS_CHARACTER, irisQuality, overallFailureCommentL)) {
                    importantCheckFailed = true;
                }
                if (this.evaluateIrisQuality(quality, Types.QualityCheckType.PupilConstriction, IrisQualityAttribute.PUPIL_CONSTRICTION, irisQuality, overallFailureCommentL)) {
                    importantCheckFailed = true;
                }
                if (this.evaluateIrisMargin(imageWidth, imageHeight, irisRes, irisQuality, overallFailureCommentL)) {
                    importantCheckFailed = true;
                }
                this.evaluateIrisQuality(quality, Types.QualityCheckType.IrisGazeAlignment, IrisQualityAttribute.IRIS_GAZE_ALIGNMENT, irisQuality, overallFailureCommentL);
                executionStepL = "Set overall quality.";
                float overallScore = quality.getOverallQualityValue() * 10.0f;
                irisQuality.setOverallComments(overallFailureCommentL.toString());
                if (!importantCheckFailed) {
                    irisQuality.setOverallCompliance(Compliance.OK);
                    if (overallScore < 50.0f) {
                        irisQuality.setOverallScore(50.0);
                    } else {
                        irisQuality.setOverallScore((double)overallScore);
                    }
                } else {
                    double minScaledQualityValueL = 1000.0;
                    List qualListL = irisQuality.getQualityFeedback();
                    for (IrisQualityFeedback qf : qualListL) {
                        if (qf.getCompliance() == Compliance.ERROR) {
                            minScaledQualityValueL = 0.0;
                            break;
                        }
                        if (qf.getCompliance() != Compliance.BELOW_THRESHOLD) continue;
                        double scaledQualityValueL = qf.getScore();
                        double thresholdL = this.irisQualityThresholdMap.get(qf.getQualityAttribute().getvalue());
                        if ((scaledQualityValueL = scaledQualityValueL / thresholdL * 40.0) > 40.0) {
                            System.out.println("huh?");
                        }
                        if (!(scaledQualityValueL < minScaledQualityValueL)) continue;
                        minScaledQualityValueL = scaledQualityValueL;
                    }
                    if (minScaledQualityValueL > 999.0) {
                        minScaledQualityValueL = 0.0;
                    }
                    irisQuality.setOverallCompliance(Compliance.ERROR);
                    irisQuality.setOverallScore(minScaledQualityValueL);
                }
                L1_LOGGER.info((Object)(this.instanceIdentifierM + ", Evaluating Iris Quality"));
                executionStepL = "Set feedback which is not supported dynamically.";
                ArrayList<IrisQualityFeedback> missingFeedbackListL = new ArrayList<IrisQualityFeedback>();
                for (IrisQualityAttribute checkIrisQualityAttributeL : IrisQualityAttribute.values()) {
                    boolean found = false;
                    for (IrisQualityFeedback irisQualityFeedback : irisQuality.getQualityFeedback()) {
                        if (checkIrisQualityAttributeL != irisQualityFeedback.getQualityAttribute()) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    IrisQualityFeedback iqfL = new IrisQualityFeedback();
                    iqfL.setCompliance(Compliance.NOT_APPLIED);
                    iqfL.setQualityAttribute(checkIrisQualityAttributeL);
                    iqfL.setComments("Quality check not supported.");
                    iqfL.setScore(0.0);
                    missingFeedbackListL.add(iqfL);
                }
                if (!missingFeedbackListL.isEmpty()) {
                    irisQuality.getQualityFeedback().addAll(missingFeedbackListL);
                }
            } else {
                L1_LOGGER.error((Object)(this.instanceIdentifierM + "Quality checking could not be performed."));
                irisQuality.setOverallCompliance(Compliance.ERROR);
                irisQuality.setOverallComments("Quality checks not applied.");
                irisQuality.setOverallScore(0.0);
            }
            if (l1Image != null) {
                l1Image.dispose();
            }
            l1Image = null;
            if (irisRes != null) {
                irisRes.dispose();
            }
            irisRes = null;
            if (quality != null) {
                quality.dispose();
            }
            quality = null;
        }
        catch (Exception ex) {
            String errorMessageL = this.instanceIdentifierM + ", Execution step: " + executionStepL + ": Exception caught: " + ex;
            L1_LOGGER.error((Object)errorMessageL, (Throwable)ex);
            irisQuality.setOverallCompliance(Compliance.ERROR);
            irisQuality.setOverallComments(errorMessageL);
            irisQuality.setOverallScore(0.0);
            return irisQuality;
        }
        return irisQuality;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IrisQSS> getQSSDataForIris(byte[] input) {
        if (!this.irisSupport) {
            L1_LOGGER.warn((Object)"QSSEngine is not initialized for iris - check your config");
            return null;
        }
        Vector<IrisImageStruct> dataVec = null;
        Object l1Image = null;
        Object irisRes = null;
        Object quality = null;
        boolean isIris2011 = false;
        String executionStepL = "getQSSDataForIris start.";
        ArrayList<IrisQSS> irisQualityList = new ArrayList<IrisQSS>();
        try {
            executionStepL = "Get IRIS_QA_LOCK.";
            this.IRIS_QA_LOCK.lock();
            char ii = UtilHelper.byteToChar(input[4]);
            char j = UtilHelper.byteToChar(input[5]);
            char k = UtilHelper.byteToChar(input[6]);
            char l = UtilHelper.byteToChar(input[7]);
            if (ii == '0' && j == '2' && k == '0' && l == '\u0000') {
                isIris2011 = true;
                L1_LOGGER.info((Object)"Input records is a IRIS 2011 image record.");
                ByteArrayInputStream is = new ByteArrayInputStream(input);
                IIR_2011 iir = IIR_2011.readFromStream(is, this.iso_parsing_strict);
                L1_LOGGER.info((Object)"Basic header check in place for IRIS 2011 image record.");
                ValidateHeaders.basicCheck(iir, input.length);
                if (this.iso_parsing_strict) {
                    L1_LOGGER.info((Object)"More rigorous header check in place for IRIS 2011 image record.");
                    ValidateHeaders.validateIrisHeaders(iir);
                }
                dataVec = L1QAModule.getImagesFromPackage(iir);
            } else {
                try {
                    dataVec = IrisISO.getImagesFromPackage((byte[])input, (boolean)this.iso_parsing_strict);
                }
                catch (Exception ex) {
                    L1_LOGGER.error((Object)(this.instanceIdentifierM + ", ExecutionStep: '" + executionStepL + "': Iris ISO Parsing Failed: " + ex));
                    IrisQSS irisQuality = new IrisQSS();
                    irisQuality.setOverallCompliance(Compliance.ERROR);
                    irisQuality.setOverallComments("Not a Valid ISO Image");
                    irisQuality.setOverallScore(0.0);
                    irisQualityList.add(irisQuality);
                    ArrayList<IrisQSS> arrayList = irisQualityList;
                    this.IRIS_QA_LOCK.unlock();
                    if (l1Image != null) {
                        l1Image.dispose();
                    }
                    if (irisRes != null) {
                        irisRes.dispose();
                    }
                    if (quality != null) {
                        quality.dispose();
                    }
                    return arrayList;
                }
            }
            for (int i = 0; i < dataVec.size(); ++i) {
                IrisImageStruct irisImageStructL = (IrisImageStruct)dataVec.get(i);
                int imageType = !isIris2011 ? L1QAModule.getImageFormatFromIIR(L1_LOGGER, input) : ((IrisImageStruct)dataVec.get(i)).getImageType();
                IrisQSS irisQss = this.getQSSDataForIris(irisImageStructL.getImage(), irisImageStructL.getWidth(), irisImageStructL.getHeight(), imageType, dataVec.get(i).getPosition(), executionStepL);
                irisQualityList.add(irisQss);
            }
            ArrayList<IrisQSS> arrayList = irisQualityList;
            return arrayList;
        }
        catch (Exception ex) {
            String errorMessageL = this.instanceIdentifierM + ", Execution step: " + executionStepL + ": Exception caught: " + ex;
            L1_LOGGER.error((Object)errorMessageL, (Throwable)ex);
            IrisQSS irisQuality = new IrisQSS();
            irisQuality.setOverallCompliance(Compliance.ERROR);
            irisQuality.setOverallComments(errorMessageL);
            irisQuality.setOverallScore(0.0);
            irisQualityList.add(irisQuality);
            ArrayList<IrisQSS> arrayList = irisQualityList;
            return arrayList;
        }
        finally {
            this.IRIS_QA_LOCK.unlock();
            if (l1Image != null) {
                l1Image.dispose();
            }
            if (irisRes != null) {
                irisRes.dispose();
            }
            if (quality != null) {
                quality.dispose();
            }
        }
    }

    public byte[] convertISO(byte[] input, FormatType type) {
        char ii = UtilHelper.byteToChar(input[4]);
        char j = UtilHelper.byteToChar(input[5]);
        char k = UtilHelper.byteToChar(input[6]);
        char l = UtilHelper.byteToChar(input[7]);
        if (ii == '0' && j == '2' && k == '0' && l == '\u0000') {
            L1_LOGGER.info((Object)"Input records is a IRIS 2011 image record.");
            return ImageConverter.convertTo(L1_LOGGER, input, type, this.iso_parsing_strict);
        }
        return ImageConverter.convertTo(L1_LOGGER, input, type, this.iso_parsing_strict);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfig(String configFileName) {
        Properties pro = new Properties();
        try {
            pro.load(new FileInputStream(configFileName));
        }
        catch (IOException e) {
            L1_LOGGER.error((Object)(this.instanceIdentifierM + ", unable to read config file : " + configFileName), (Throwable)e);
        }
        try {
            this.iso_parsing_strict = Boolean.parseBoolean(pro.getProperty("iso_parsing_strict", "true"));
            if (this.faceSupport) {
                this.face_FaceGrayValues_threshold = Double.parseDouble(pro.getProperty("FaceGrayValues_threshold", "" + this.face_FaceGrayValues_threshold));
                this.face_Faceness_threshold = Double.parseDouble(pro.getProperty("Faceness_threshold", "" + this.face_Faceness_threshold));
                this.face_PoseYaw_threshold = Double.parseDouble(pro.getProperty("PoseYaw_threshold", "" + this.face_PoseYaw_threshold));
                this.face_PoseRoll_threshold = Double.parseDouble(pro.getProperty("PoseRoll_threshold", "" + this.face_PoseRoll_threshold));
                this.face_EyeDistance_threshold = Double.parseDouble(pro.getProperty("EyeDistance_threshold", "" + this.face_EyeDistance_threshold));
                this.face_EyeDistanceRatio_threshold = Double.parseDouble(pro.getProperty("EyeDistanceRatio_threshold", "" + this.face_EyeDistanceRatio_threshold));
                this.face_Illumination_threshold = Double.parseDouble(pro.getProperty("Illumination_threshold", "" + this.face_Illumination_threshold));
                this.face_Padding_threshold = Double.parseDouble(pro.getProperty("Padding_threshold", "" + this.face_Padding_threshold));
                this.face_Scaling_threshold = Double.parseDouble(pro.getProperty("Scaling_threshold", "" + this.face_Scaling_threshold));
                this.face_FacialAreaShadow_threshold = Double.parseDouble(pro.getProperty("FacialAreaShadow_threshold", "" + this.face_FacialAreaShadow_threshold));
                this.face_BackgroundTexture_threshold = Double.parseDouble(pro.getProperty("BackgroundTexture_threshold", "" + this.face_BackgroundTexture_threshold));
                this.face_GlassesHeavyFrame_threshold = Double.parseDouble(pro.getProperty("GlassesHeavyFrame_threshold", "" + this.face_GlassesHeavyFrame_threshold));
                this.face_GlassesReflection_threshold = Double.parseDouble(pro.getProperty("GlassesReflection_threshold", "" + this.face_GlassesReflection_threshold));
            }
            if (this.fingerSupport) {
                this.finger_NFIQ_threshold = Double.parseDouble(pro.getProperty("finger_NFIQ_threshold", "" + this.finger_NFIQ_threshold));
                this.finger_GoodArea_threshold = Double.parseDouble(pro.getProperty("finger_GoodArea_threshold", "" + this.finger_GoodArea_threshold));
                this.finger_ContactArea_threshold = Double.parseDouble(pro.getProperty("finger_ContactArea_threshold", "" + this.finger_ContactArea_threshold));
                this.finger_MinutiaCount_threshold = Double.parseDouble(pro.getProperty("finger_MinutiaCount_threshold", "" + this.finger_MinutiaCount_threshold));
                this.finger_L2mQuality_threshold = Double.parseDouble(pro.getProperty("finger_L2mQuality_threshold", "" + this.finger_L2mQuality_threshold));
                this.finger_SlapPlacement_threshold = Double.parseDouble(pro.getProperty("finger_SlapPlacement_threshold", "" + this.finger_SlapPlacement_threshold));
                this.finger_SlapPressHeavy_threshold = Double.parseDouble(pro.getProperty("finger_SlapPressHeavy_threshold", "" + this.finger_SlapPressHeavy_threshold));
                this.finger_SlapPressLight_threshold = Double.parseDouble(pro.getProperty("finger_SlapPressLight_threshold", "" + this.finger_SlapPressLight_threshold));
                this.finger_SlapCentering_threshold = Double.parseDouble(pro.getProperty("finger_SlapCentering_threshold", "" + this.finger_SlapCentering_threshold));
                this.finger_SlapWetness_threshold = Double.parseDouble(pro.getProperty("finger_SlapWetness_threshold", "" + this.finger_SlapWetness_threshold));
                this.finger_SlapDryness_threshold = Double.parseDouble(pro.getProperty("finger_SlapDryness_threshold", "" + this.finger_SlapDryness_threshold));
                this.thumbs_SlapPlacement_threshold = Double.parseDouble(pro.getProperty("thumbs_SlapPlacement_threshold", "" + this.thumbs_SlapPlacement_threshold));
                this.thumbs_SlapPressHeavy_threshold = Double.parseDouble(pro.getProperty("thumbs_SlapPressHeavy_threshold", "" + this.thumbs_SlapPressHeavy_threshold));
                this.thumbs_SlapPressLight_threshold = Double.parseDouble(pro.getProperty("thumbs_SlapPressLight_threshold", "" + this.thumbs_SlapPressLight_threshold));
                this.thumbs_SlapCentering_threshold = Double.parseDouble(pro.getProperty("thumbs_SlapCentering_threshold", "" + this.thumbs_SlapCentering_threshold));
                this.thumbs_SlapWetness_threshold = Double.parseDouble(pro.getProperty("thumbs_SlapWetness_threshold", "" + this.thumbs_SlapWetness_threshold));
                this.thumbs_SlapDryness_threshold = Double.parseDouble(pro.getProperty("thumbs_SlapDryness_threshold", "" + this.thumbs_SlapDryness_threshold));
                this.fourfinger_SlapPlacement_threshold = Double.parseDouble(pro.getProperty("fourfinger_SlapPlacement_threshold", "" + this.fourfinger_SlapPlacement_threshold));
                this.fourfinger_SlapPressHeavy_threshold = Double.parseDouble(pro.getProperty("fourfinger_SlapPressHeavy_threshold", "" + this.fourfinger_SlapPressHeavy_threshold));
                this.fourfinger_SlapPressLight_threshold = Double.parseDouble(pro.getProperty("fourfinger_SlapPressLight_threshold", "" + this.fourfinger_SlapPressLight_threshold));
                this.fourfinger_SlapCentering_threshold = Double.parseDouble(pro.getProperty("fourfinger_SlapCentering_threshold", "" + this.fourfinger_SlapCentering_threshold));
                this.fourfinger_SlapWetness_threshold = Double.parseDouble(pro.getProperty("fourfinger_SlapWetness_threshold", "" + this.fourfinger_SlapWetness_threshold));
                this.fourfinger_SlapDryness_threshold = Double.parseDouble(pro.getProperty("fourfinger_SlapDryness_threshold", "" + this.fourfinger_SlapDryness_threshold));
            }
            if (this.irisSupport) {
                this.iris_Irisness_threshold = Double.parseDouble(pro.getProperty("Irisness_threshold", "" + this.iris_Irisness_threshold));
                this.iris_Fidelity_threshold = Double.parseDouble(pro.getProperty("Fidelity_threshold", "" + this.iris_Fidelity_threshold));
                this.iris_Character_threshold = Double.parseDouble(pro.getProperty("Character_threshold", "" + this.iris_Character_threshold));
                this.iris_Constriction_threshold = Double.parseDouble(pro.getProperty("Constriction_threshold", "" + this.iris_Constriction_threshold));
                this.iris_HorizontalMargin_threshold = Double.parseDouble(pro.getProperty("HorizontalMargin_threshold", "" + this.iris_HorizontalMargin_threshold));
                this.iris_VerticalMargin_threshold = Double.parseDouble(pro.getProperty("VerticalMargin_threshold", "" + this.iris_VerticalMargin_threshold));
                this.iris_GazeAlignment_threshold = Double.parseDouble(pro.getProperty("GazeAlignment_threshold", "" + this.iris_GazeAlignment_threshold));
            }
        }
        catch (Exception ex) {
            L1_LOGGER.error((Object)(this.instanceIdentifierM + ", error during parsing the file : " + configFileName), (Throwable)ex);
        }
        finally {
            StringBuilder sbL = new StringBuilder();
            sbL.append(newLine);
            sbL.append("L1QSSEngine-Configuration, instance ");
            sbL.append(instanceCounterM);
            sbL.append(" :");
            sbL.append(newLine);
            sbL.append(newLine);
            sbL.append("General parameters : ");
            sbL.append(newLine);
            sbL.append("iso_parsing_strict : ");
            sbL.append(this.iso_parsing_strict);
            sbL.append(newLine);
            sbL.append(newLine);
            if (this.faceSupport) {
                sbL.append("Face parameters : ");
                sbL.append(newLine);
                sbL.append("FaceGrayValues_threshold : ");
                sbL.append(this.face_FaceGrayValues_threshold);
                sbL.append(newLine);
                sbL.append("Faceness_threshold : ");
                sbL.append(this.face_Faceness_threshold);
                sbL.append(newLine);
                sbL.append("PoseYaw_threshold : ");
                sbL.append(this.face_PoseYaw_threshold);
                sbL.append(newLine);
                sbL.append("PoseRoll_threshold : ");
                sbL.append(this.face_PoseRoll_threshold);
                sbL.append(newLine);
                sbL.append("EyeDistance_threshold : ");
                sbL.append(this.face_EyeDistance_threshold);
                sbL.append(newLine);
                sbL.append("EyeDistanceRatio_threshold : ");
                sbL.append(this.face_EyeDistanceRatio_threshold);
                sbL.append(newLine);
                sbL.append("Illumination_threshold : ");
                sbL.append(this.face_Illumination_threshold);
                sbL.append(newLine);
                sbL.append("Padding_threshold : ");
                sbL.append(this.face_Padding_threshold);
                sbL.append(newLine);
                sbL.append("Scaling_threshold : ");
                sbL.append(this.face_Scaling_threshold);
                sbL.append(newLine);
                sbL.append("FacialAreaShadow_threshold : ");
                sbL.append(this.face_FacialAreaShadow_threshold);
                sbL.append(newLine);
                sbL.append("BackgroundTexture_threshold : ");
                sbL.append(this.face_BackgroundTexture_threshold);
                sbL.append(newLine);
            } else {
                sbL.append("- no face support for this engine -");
                sbL.append(newLine);
            }
            sbL.append(newLine);
            if (this.fingerSupport) {
                sbL.append("Finger parameters : ");
                sbL.append(newLine);
                sbL.append("finger_GoodArea_threshold : ");
                sbL.append(this.finger_GoodArea_threshold);
                sbL.append(newLine);
                sbL.append("finger_ContactArea_threshold : ");
                sbL.append(this.finger_ContactArea_threshold);
                sbL.append(newLine);
                sbL.append("finger_MinutiaCount_threshold : ");
                sbL.append(this.finger_MinutiaCount_threshold);
                sbL.append(newLine);
                sbL.append("finger_L2mQuality_threshold : ");
                sbL.append(this.finger_L2mQuality_threshold);
                sbL.append(newLine);
                sbL.append(newLine);
                sbL.append("finger_NFIQ_threshold : ");
                sbL.append(this.finger_NFIQ_threshold);
                sbL.append(newLine);
                sbL.append("finger_SlapPlacement_threshold : ");
                sbL.append(this.finger_SlapPlacement_threshold);
                sbL.append(newLine);
                sbL.append("finger_SlapPressHeavy_threshold : ");
                sbL.append(this.finger_SlapPressHeavy_threshold);
                sbL.append(newLine);
                sbL.append("finger_SlapPressLight_threshold : ");
                sbL.append(this.finger_SlapPressLight_threshold);
                sbL.append(newLine);
                sbL.append("finger_SlapCentering_threshold : ");
                sbL.append(this.finger_SlapCentering_threshold);
                sbL.append(newLine);
                sbL.append("finger_SlapWetness_threshold : ");
                sbL.append(this.finger_SlapWetness_threshold);
                sbL.append(newLine);
                sbL.append("finger_SlapDryness_threshold : ");
                sbL.append(this.finger_SlapDryness_threshold);
                sbL.append(newLine);
                sbL.append(newLine);
                sbL.append("thumbs_SlapPlacement_threshold : ");
                sbL.append(this.thumbs_SlapPlacement_threshold);
                sbL.append(newLine);
                sbL.append("thumbs_SlapPressHeavy_threshold : ");
                sbL.append(this.thumbs_SlapPressHeavy_threshold);
                sbL.append(newLine);
                sbL.append("thumbs_SlapPressLight_threshold : ");
                sbL.append(this.thumbs_SlapPressLight_threshold);
                sbL.append(newLine);
                sbL.append("thumbs_SlapCentering_threshold : ");
                sbL.append(this.thumbs_SlapCentering_threshold);
                sbL.append(newLine);
                sbL.append("thumbs_SlapWetness_threshold : ");
                sbL.append(this.thumbs_SlapWetness_threshold);
                sbL.append(newLine);
                sbL.append("thumbs_SlapDryness_threshold : ");
                sbL.append(this.thumbs_SlapDryness_threshold);
                sbL.append(newLine);
                sbL.append(newLine);
                sbL.append("fourfinger_SlapPlacement_threshold : ");
                sbL.append(this.fourfinger_SlapPlacement_threshold);
                sbL.append(newLine);
                sbL.append("fourfinger_SlapPressHeavy_threshold : ");
                sbL.append(this.fourfinger_SlapPressHeavy_threshold);
                sbL.append(newLine);
                sbL.append("fourfinger_SlapPressLight_threshold : ");
                sbL.append(this.fourfinger_SlapPressLight_threshold);
                sbL.append(newLine);
                sbL.append("fourfinger_SlapCentering_threshold : ");
                sbL.append(this.fourfinger_SlapCentering_threshold);
                sbL.append(newLine);
                sbL.append("fourfinger_SlapWetness_threshold : ");
                sbL.append(this.fourfinger_SlapWetness_threshold);
                sbL.append(newLine);
                sbL.append("fourfinger_SlapDryness_threshold : ");
                sbL.append(this.fourfinger_SlapDryness_threshold);
                sbL.append(newLine);
            } else {
                sbL.append("- no finger support for this engine -");
                sbL.append(newLine);
            }
            sbL.append(newLine);
            if (this.irisSupport) {
                sbL.append("Iris parameters : ");
                sbL.append(newLine);
                sbL.append("Irisness_threshold : ");
                sbL.append(this.iris_Irisness_threshold);
                sbL.append(newLine);
                sbL.append("Fidelity_threshold : ");
                sbL.append(this.iris_Fidelity_threshold);
                sbL.append(newLine);
                sbL.append("Character_threshold : ");
                sbL.append(this.iris_Character_threshold);
                sbL.append(newLine);
                sbL.append("Constriction_threshold : ");
                sbL.append(this.iris_Constriction_threshold);
                sbL.append(newLine);
                sbL.append("HorizontalMargin_threshold : ");
                sbL.append(this.iris_HorizontalMargin_threshold);
                sbL.append(newLine);
                sbL.append("VerticalMargin_threshold : ");
                sbL.append(this.iris_VerticalMargin_threshold);
                sbL.append(newLine);
                sbL.append("GazeAlignment_threshold : ");
                sbL.append(this.iris_GazeAlignment_threshold);
                sbL.append(newLine);
            } else {
                sbL.append("- no iris support for this engine -");
                sbL.append(newLine);
            }
            sbL.append(newLine);
            L1_LOGGER.info((Object)sbL.toString());
        }
    }

    private boolean evaluateFaceQuality(Quality quality, Types.QualityCheckType foundationQualityCheckType, FaceQualityAttribute faceQualityAttribute, FaceQSS faceQuality, StringBuilder overallFailureCommentA) {
        boolean importantCheckFailed = false;
        try {
            FaceQualityFeedback faceQualityFeedback = new FaceQualityFeedback();
            if (quality.isQualityMetricAvailable(foundationQualityCheckType)) {
                double threshold;
                double qualityValue = (double)quality.getQualityValue(foundationQualityCheckType) * 10.0;
                if (qualityValue >= (threshold = this.faceQualityThresholdMap.get(faceQualityAttribute.getvalue()).doubleValue())) {
                    faceQualityFeedback.setComments("");
                    faceQualityFeedback.setCompliance(Compliance.OK);
                    faceQualityFeedback.setScore(qualityValue);
                    faceQualityFeedback.setQualityAttribute(faceQualityAttribute);
                    importantCheckFailed = false;
                } else {
                    String comment = this.faceQualityMessageMap.get(faceQualityAttribute.getvalue());
                    if (overallFailureCommentA.length() > 0) {
                        overallFailureCommentA.append(", ");
                    }
                    overallFailureCommentA.append(comment);
                    faceQualityFeedback.setComments(comment);
                    faceQualityFeedback.setCompliance(Compliance.BELOW_THRESHOLD);
                    faceQualityFeedback.setScore(qualityValue);
                    faceQualityFeedback.setQualityAttribute(faceQualityAttribute);
                    importantCheckFailed = true;
                }
            } else {
                faceQualityFeedback.setComments("Quality check not applied.");
                faceQualityFeedback.setCompliance(Compliance.ERROR);
                faceQualityFeedback.setScore(0.0);
                faceQualityFeedback.setQualityAttribute(faceQualityAttribute);
                importantCheckFailed = true;
            }
            faceQuality.getQualityFeedback().add(faceQualityFeedback);
            return importantCheckFailed;
        }
        catch (Exception ex) {
            L1_LOGGER.error((Object)(this.instanceIdentifierM + ", Exception caught: " + ex));
            importantCheckFailed = true;
            return importantCheckFailed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean evaluateFaceEyeDistance(int imageWidth, ImageDescriptor faceRes, FaceQSS faceQuality, StringBuilder overallFailureCommentA) {
        importantCheckFailed = false;
        landmarkList = null;
        try {
            faceQualityFeedbackEyeDistance = new FaceQualityFeedback();
            faceQualityFeedbackEyeDistanceRatio = new FaceQualityFeedback();
            faceQualityFeedbackRollAngle = new FaceQualityFeedback();
            landmarkList = faceRes.getAutoLandmarkList();
            eyeDistance = 0.0f;
            if (landmarkList == null) ** GOTO lbl-1000
            eyeDistance = landmarkList.getEyeDistance();
            if (v0 > 0.0f) {
                thresholdEyeDistance = this.faceQualityThresholdMap.get(FaceQualityAttribute.EYE_DISTANCE.getvalue());
                thresholdEyeDistanceRatio = this.faceQualityThresholdMap.get(FaceQualityAttribute.EYE_DISTANCE_RATIO.getvalue());
                thresholdRollAngle = this.faceQualityThresholdMap.get(FaceQualityAttribute.ROLL_ANGLE.getvalue());
                rollAngle = landmarkList.getRollAngle();
                absRollAngle = Math.abs(rollAngle);
                eyeDistanceRatio = eyeDistance / (float)imageWidth;
                if ((double)eyeDistance >= thresholdEyeDistance) {
                    faceQualityFeedbackEyeDistance.setComments("");
                    faceQualityFeedbackEyeDistance.setCompliance(Compliance.OK);
                    faceQualityFeedbackEyeDistance.setScore((double)eyeDistance);
                    faceQualityFeedbackEyeDistance.setQualityAttribute(FaceQualityAttribute.EYE_DISTANCE);
                } else {
                    comment = this.faceQualityMessageMap.get(FaceQualityAttribute.EYE_DISTANCE.getvalue());
                    if (overallFailureCommentA.length() > 0) {
                        overallFailureCommentA.append(", ");
                    }
                    overallFailureCommentA.append(comment);
                    faceQualityFeedbackEyeDistance.setComments(comment);
                    faceQualityFeedbackEyeDistance.setCompliance(Compliance.BELOW_THRESHOLD);
                    faceQualityFeedbackEyeDistance.setScore((double)eyeDistance);
                    faceQualityFeedbackEyeDistance.setQualityAttribute(FaceQualityAttribute.EYE_DISTANCE);
                    importantCheckFailed = true;
                }
                if ((double)eyeDistanceRatio <= thresholdEyeDistanceRatio) {
                    faceQualityFeedbackEyeDistanceRatio.setComments("");
                    faceQualityFeedbackEyeDistanceRatio.setCompliance(Compliance.OK);
                    faceQualityFeedbackEyeDistanceRatio.setScore((double)eyeDistanceRatio);
                    faceQualityFeedbackEyeDistanceRatio.setQualityAttribute(FaceQualityAttribute.EYE_DISTANCE_RATIO);
                } else {
                    comment = this.faceQualityMessageMap.get(FaceQualityAttribute.EYE_DISTANCE_RATIO.getvalue());
                    if (overallFailureCommentA.length() > 0) {
                        overallFailureCommentA.append(", ");
                    }
                    overallFailureCommentA.append(comment);
                    faceQualityFeedbackEyeDistanceRatio.setComments(comment);
                    faceQualityFeedbackEyeDistanceRatio.setCompliance(Compliance.BELOW_THRESHOLD);
                    faceQualityFeedbackEyeDistanceRatio.setScore((double)eyeDistanceRatio);
                    faceQualityFeedbackEyeDistanceRatio.setQualityAttribute(FaceQualityAttribute.EYE_DISTANCE_RATIO);
                    importantCheckFailed = true;
                }
                if ((double)absRollAngle <= thresholdRollAngle) {
                    faceQualityFeedbackRollAngle.setComments("");
                    faceQualityFeedbackRollAngle.setCompliance(Compliance.OK);
                    faceQualityFeedbackRollAngle.setScore((double)rollAngle);
                    faceQualityFeedbackRollAngle.setQualityAttribute(FaceQualityAttribute.ROLL_ANGLE);
                } else {
                    comment = this.faceQualityMessageMap.get(FaceQualityAttribute.ROLL_ANGLE.getvalue());
                    if (overallFailureCommentA.length() > 0) {
                        overallFailureCommentA.append(", ");
                    }
                    overallFailureCommentA.append(comment);
                    faceQualityFeedbackRollAngle.setComments(comment);
                    faceQualityFeedbackRollAngle.setCompliance(Compliance.BELOW_THRESHOLD);
                    faceQualityFeedbackRollAngle.setScore((double)rollAngle);
                    faceQualityFeedbackRollAngle.setQualityAttribute(FaceQualityAttribute.ROLL_ANGLE);
                    importantCheckFailed = true;
                }
            } else lbl-1000:
            // 2 sources

            {
                faceQualityFeedbackEyeDistance.setComments("quality check not applied");
                faceQualityFeedbackEyeDistance.setCompliance(Compliance.ERROR);
                faceQualityFeedbackEyeDistance.setScore(0.0);
                faceQualityFeedbackEyeDistance.setQualityAttribute(FaceQualityAttribute.EYE_DISTANCE);
                faceQualityFeedbackEyeDistanceRatio.setComments("quality check not applied");
                faceQualityFeedbackEyeDistanceRatio.setCompliance(Compliance.ERROR);
                faceQualityFeedbackEyeDistanceRatio.setScore(0.0);
                faceQualityFeedbackEyeDistanceRatio.setQualityAttribute(FaceQualityAttribute.EYE_DISTANCE);
                faceQualityFeedbackRollAngle.setComments("quality check not applied");
                faceQualityFeedbackRollAngle.setCompliance(Compliance.ERROR);
                faceQualityFeedbackRollAngle.setScore(0.0);
                faceQualityFeedbackRollAngle.setQualityAttribute(FaceQualityAttribute.EYE_DISTANCE);
                importantCheckFailed = true;
            }
            faceQuality.getQualityFeedback().add(faceQualityFeedbackEyeDistance);
            faceQuality.getQualityFeedback().add(faceQualityFeedbackEyeDistanceRatio);
            faceQuality.getQualityFeedback().add(faceQualityFeedbackRollAngle);
            var11_14 = importantCheckFailed;
            return var11_14;
        }
        catch (Exception ex) {
            L1QSSEngine.L1_LOGGER.error((Object)(this.instanceIdentifierM + ", Exception caught: " + ex));
            var8_10 = importantCheckFailed = true;
            return var8_10;
        }
        finally {
            if (landmarkList != null) {
                landmarkList.dispose();
            }
        }
    }

    private boolean evaluateFingerprintQuality(Quality quality, Types.QualityCheckType foundationQualityCheckType, FingerprintQualityAttribute fingerprintQualityAttribute, FingerprintQSS fingerprintQuality, HashMap<FingerprintQualityAttribute, Double> qualityThresholdMap, HashMap<FingerprintQualityAttribute, String> qualityMessageMap, StringBuilder overallFailureCommentA) {
        return this.evaluateFingerprintQuality(quality, foundationQualityCheckType, fingerprintQualityAttribute, fingerprintQuality, qualityThresholdMap, qualityMessageMap, overallFailureCommentA, 0, 0);
    }

    private boolean evaluateFingerprintQuality(Quality quality, Types.QualityCheckType foundationQualityCheckType, FingerprintQualityAttribute fingerprintQualityAttribute, FingerprintQSS fingerprintQuality, HashMap<FingerprintQualityAttribute, Double> qualityThresholdMap, HashMap<FingerprintQualityAttribute, String> qualityMessageMap, StringBuilder overallFailureCommentA, int numberOfExpectedFingersA, int numberOfSegmentedFingersA) {
        try {
            if (quality.isQualityMetricAvailable(foundationQualityCheckType)) {
                double qualityValue = foundationQualityCheckType == Types.QualityCheckType.FingerContactArea || foundationQualityCheckType == Types.QualityCheckType.FingerGoodArea ? (double)quality.getQualityRawValue(foundationQualityCheckType) : (foundationQualityCheckType == Types.QualityCheckType.FingerMinutiaCount ? (double)Math.min(255.0f, quality.getQualityRawValue(foundationQualityCheckType)) : (double)quality.getQualityValue(foundationQualityCheckType) * 10.0);
                if (numberOfSegmentedFingersA != numberOfExpectedFingersA) {
                    switch (foundationQualityCheckType) {
                        case SlapPressHeavy: 
                        case SlapPressLight: 
                        case SlapWetness: 
                        case SlapDryness: {
                            qualityValue = Math.min(100.0, qualityValue * (double)numberOfExpectedFingersA / (double)numberOfSegmentedFingersA);
                            break;
                        }
                        case SlapPlacement: {
                            double threshold = qualityThresholdMap.get(fingerprintQualityAttribute);
                            if (!(qualityValue < threshold)) break;
                            qualityValue = threshold + 0.4711;
                        }
                    }
                }
                return this.evaluateFingerprintQuality(qualityValue, fingerprintQualityAttribute, fingerprintQuality, qualityThresholdMap, qualityMessageMap, overallFailureCommentA);
            }
            FingerprintQualityFeedback fingerprintQualityFeedback = new FingerprintQualityFeedback();
            fingerprintQualityFeedback.setComments("Quality check not applied.");
            fingerprintQualityFeedback.setCompliance(Compliance.ERROR);
            fingerprintQualityFeedback.setScore(0.0);
            fingerprintQualityFeedback.setQualityAttribute(fingerprintQualityAttribute);
            fingerprintQuality.getQualityFeedback().add(fingerprintQualityFeedback);
            return true;
        }
        catch (Exception ex) {
            L1_LOGGER.error((Object)(this.instanceIdentifierM + ", Exception caught: " + ex));
            return true;
        }
    }

    private boolean evaluateFingerprintQuality(double qualityValue, FingerprintQualityAttribute fingerprintQualityAttribute, FingerprintQSS fingerprintQuality, HashMap<FingerprintQualityAttribute, Double> qualityThresholdMap, HashMap<FingerprintQualityAttribute, String> qualityMessageMap, StringBuilder overallFailureCommentA) {
        boolean importantCheckFailed = false;
        try {
            FingerprintQualityFeedback fingerprintQualityFeedback = new FingerprintQualityFeedback();
            double threshold = qualityThresholdMap.get(fingerprintQualityAttribute);
            if (qualityValue >= threshold) {
                fingerprintQualityFeedback.setComments("");
                fingerprintQualityFeedback.setCompliance(Compliance.OK);
                fingerprintQualityFeedback.setScore(qualityValue);
                fingerprintQualityFeedback.setQualityAttribute(fingerprintQualityAttribute);
                importantCheckFailed = false;
            } else {
                String comment = qualityMessageMap.get(fingerprintQualityAttribute);
                if (overallFailureCommentA.length() > 0) {
                    overallFailureCommentA.append(", ");
                }
                overallFailureCommentA.append(comment);
                fingerprintQualityFeedback.setComments(comment);
                fingerprintQualityFeedback.setCompliance(Compliance.BELOW_THRESHOLD);
                fingerprintQualityFeedback.setScore(qualityValue);
                fingerprintQualityFeedback.setQualityAttribute(fingerprintQualityAttribute);
                importantCheckFailed = true;
            }
            fingerprintQuality.getQualityFeedback().add(fingerprintQualityFeedback);
            return importantCheckFailed;
        }
        catch (Exception ex) {
            L1_LOGGER.error((Object)(this.instanceIdentifierM + ", Exception caught: " + ex));
            return true;
        }
    }

    private boolean evaluateSlapQuality(float qualityValue, FingerprintQualityAttribute fingerprintQualityAttribute, FingerprintQSS fingerprintQuality, HashMap<FingerprintQualityAttribute, Double> qualityThresholdMap, HashMap<FingerprintQualityAttribute, String> qualityMessageMap, StringBuilder overallFailureCommentA, boolean sendFeeback) {
        boolean importantCheckFailed = false;
        try {
            FingerprintQualityFeedback fingerprintQualityFeedback = new FingerprintQualityFeedback();
            double threshold = qualityThresholdMap.get(fingerprintQualityAttribute);
            if ((double)qualityValue >= threshold) {
                fingerprintQualityFeedback.setComments("");
                fingerprintQualityFeedback.setCompliance(Compliance.OK);
                fingerprintQualityFeedback.setScore((double)(qualityValue * 10.0f));
                fingerprintQualityFeedback.setQualityAttribute(fingerprintQualityAttribute);
            } else {
                String comment = qualityMessageMap.get(fingerprintQualityAttribute);
                if (overallFailureCommentA.length() > 0) {
                    overallFailureCommentA.append(", ");
                }
                overallFailureCommentA.append(comment);
                fingerprintQualityFeedback.setComments(comment);
                fingerprintQualityFeedback.setCompliance(Compliance.BELOW_THRESHOLD);
                fingerprintQualityFeedback.setScore((double)(qualityValue * 10.0f));
                fingerprintQualityFeedback.setQualityAttribute(fingerprintQualityAttribute);
                importantCheckFailed = true;
            }
            if (sendFeeback) {
                fingerprintQuality.getQualityFeedback().add(fingerprintQualityFeedback);
            }
            return importantCheckFailed;
        }
        catch (Exception ex) {
            L1_LOGGER.error((Object)(this.instanceIdentifierM + ", evaluateSlapQuality failed :"), (Throwable)ex);
            importantCheckFailed = true;
            return importantCheckFailed;
        }
    }

    private boolean evaluateIrisQuality(Quality quality, Types.QualityCheckType foundationQualityCheckType, IrisQualityAttribute irisQualityAttribute, IrisQSS irisQuality, StringBuilder overallFailureCommentA) {
        boolean importantCheckFailed = false;
        try {
            IrisQualityFeedback irisQualityFeedback = new IrisQualityFeedback();
            if (quality.isQualityMetricAvailable(foundationQualityCheckType)) {
                double threshold;
                double qualityValue = quality.getQualityValue(foundationQualityCheckType) * 10.0f;
                if (qualityValue >= (threshold = this.irisQualityThresholdMap.get(irisQualityAttribute.getvalue()).doubleValue())) {
                    irisQualityFeedback.setComments("");
                    irisQualityFeedback.setCompliance(Compliance.OK);
                    irisQualityFeedback.setScore(qualityValue);
                    irisQualityFeedback.setQualityAttribute(irisQualityAttribute);
                    importantCheckFailed = false;
                } else {
                    String comment = this.irisQualityMessageMap.get(irisQualityAttribute.getvalue());
                    if (overallFailureCommentA.length() > 0) {
                        overallFailureCommentA.append(", ");
                    }
                    overallFailureCommentA.append(comment);
                    irisQualityFeedback.setComments(comment);
                    irisQualityFeedback.setCompliance(Compliance.BELOW_THRESHOLD);
                    irisQualityFeedback.setScore(qualityValue);
                    irisQualityFeedback.setQualityAttribute(irisQualityAttribute);
                    importantCheckFailed = true;
                }
            } else {
                irisQualityFeedback.setComments("quality check not applied");
                irisQualityFeedback.setCompliance(Compliance.ERROR);
                irisQualityFeedback.setScore(0.0);
                irisQualityFeedback.setQualityAttribute(irisQualityAttribute);
                importantCheckFailed = true;
            }
            irisQuality.getQualityFeedback().add(irisQualityFeedback);
            return importantCheckFailed;
        }
        catch (Exception ex) {
            L1_LOGGER.error((Object)(this.instanceIdentifierM + ", Exception caught: " + ex));
            importantCheckFailed = true;
            return importantCheckFailed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean evaluateIrisMargin(int imageWidth, int imageHeight, ImageDescriptor irisRes, IrisQSS irisQuality, StringBuilder overallFailureCommentA) {
        boolean importantCheckFailed = false;
        LandmarkList landmarkList = null;
        try {
            landmarkList = irisRes.getAutoLandmarkList();
            int irisRadius = 0;
            Integer irisX = 0;
            Integer irisY = 0;
            if (landmarkList.length() >= 1) {
                float topVerticalMargin;
                float rightHorizontalMargin;
                irisRadius = landmarkList.getIrisRadius(0);
                Point point = landmarkList.getPosition(0);
                irisX = point.getX();
                irisY = point.getY();
                LandMark radius = new LandMark();
                radius.setLandMarkType(LandMarkType.IRIS_RADIUS);
                radius.setValue(irisRadius);
                irisQuality.addLandMark(radius);
                LandMark irisCentre = new LandMark();
                irisCentre.setLandMarkType(LandMarkType.IRIS_CENTER);
                irisCentre.setX(irisX.intValue());
                irisCentre.setY(irisY.intValue());
                irisQuality.addLandMark(irisCentre);
                float leftHorizontalMargin = irisX - irisRadius;
                if (leftHorizontalMargin < 0.0f) {
                    leftHorizontalMargin = 0.0f;
                }
                if ((rightHorizontalMargin = (float)(imageWidth - irisX - irisRadius)) < 0.0f) {
                    rightHorizontalMargin = 0.0f;
                }
                double horizontalThreshold = this.irisQualityThresholdMap.get(IrisQualityAttribute.HORIZONTAL_MARGIN.getvalue());
                horizontalThreshold *= (double)irisRadius;
                IrisQualityFeedback irisQualityFeedbackHM = new IrisQualityFeedback();
                if ((double)leftHorizontalMargin >= horizontalThreshold && (double)rightHorizontalMargin >= horizontalThreshold) {
                    irisQualityFeedbackHM.setComments("");
                    irisQualityFeedbackHM.setCompliance(Compliance.OK);
                    irisQualityFeedbackHM.setScore((double)Math.min(leftHorizontalMargin / (float)irisRadius, rightHorizontalMargin / (float)irisRadius));
                    irisQualityFeedbackHM.setQualityAttribute(IrisQualityAttribute.HORIZONTAL_MARGIN);
                } else {
                    String comment = this.irisQualityMessageMap.get(IrisQualityAttribute.HORIZONTAL_MARGIN.getvalue());
                    if (overallFailureCommentA.length() > 0) {
                        overallFailureCommentA.append(", ");
                    }
                    overallFailureCommentA.append(comment);
                    if (leftHorizontalMargin > rightHorizontalMargin) {
                        irisQualityFeedbackHM.setScore((double)(rightHorizontalMargin / (float)irisRadius));
                        comment = comment + ", expected at least right margin " + horizontalThreshold + " px, got " + rightHorizontalMargin + " px";
                    } else {
                        irisQualityFeedbackHM.setScore((double)(leftHorizontalMargin / (float)irisRadius));
                        comment = comment + ", expected at least left margin " + horizontalThreshold + " px, got " + leftHorizontalMargin + " px";
                    }
                    irisQualityFeedbackHM.setComments(comment);
                    irisQualityFeedbackHM.setCompliance(Compliance.BELOW_THRESHOLD);
                    irisQualityFeedbackHM.setQualityAttribute(IrisQualityAttribute.HORIZONTAL_MARGIN);
                    importantCheckFailed = true;
                }
                irisQuality.getQualityFeedback().add(irisQualityFeedbackHM);
                float bottomVerticalMargin = imageHeight - irisY - irisRadius;
                if (bottomVerticalMargin < 0.0f) {
                    bottomVerticalMargin = 0.0f;
                }
                if ((topVerticalMargin = (float)(irisY - irisRadius)) < 0.0f) {
                    topVerticalMargin = 0.0f;
                }
                double verticalThreshold = this.irisQualityThresholdMap.get(IrisQualityAttribute.VERTICAL_MARGIN.getvalue());
                verticalThreshold *= (double)irisRadius;
                IrisQualityFeedback irisQualityFeedbackVM = new IrisQualityFeedback();
                if ((double)bottomVerticalMargin >= verticalThreshold && (double)topVerticalMargin >= verticalThreshold) {
                    irisQualityFeedbackVM.setComments("");
                    irisQualityFeedbackVM.setCompliance(Compliance.OK);
                    irisQualityFeedbackVM.setScore((double)Math.min(bottomVerticalMargin / (float)irisRadius, topVerticalMargin / (float)irisRadius));
                    irisQualityFeedbackVM.setQualityAttribute(IrisQualityAttribute.VERTICAL_MARGIN);
                } else {
                    String comment = this.irisQualityMessageMap.get(IrisQualityAttribute.VERTICAL_MARGIN.getvalue());
                    if (overallFailureCommentA.length() > 0) {
                        overallFailureCommentA.append(", ");
                    }
                    overallFailureCommentA.append(comment);
                    if (bottomVerticalMargin > topVerticalMargin) {
                        irisQualityFeedbackVM.setScore((double)(topVerticalMargin / (float)irisRadius));
                        comment = comment + ", expected at least top margin " + verticalThreshold + " px, got " + topVerticalMargin + " px";
                    } else {
                        irisQualityFeedbackVM.setScore((double)(bottomVerticalMargin / (float)irisRadius));
                        comment = comment + ", expected at least bottom margin " + verticalThreshold + " px, got " + bottomVerticalMargin + " px";
                    }
                    irisQualityFeedbackVM.setComments(comment);
                    irisQualityFeedbackVM.setCompliance(Compliance.BELOW_THRESHOLD);
                    irisQualityFeedbackVM.setQualityAttribute(IrisQualityAttribute.VERTICAL_MARGIN);
                    importantCheckFailed = true;
                }
                irisQuality.getQualityFeedback().add(irisQualityFeedbackVM);
            } else {
                IrisQualityFeedback irisQualityFeedbackHM = new IrisQualityFeedback();
                irisQualityFeedbackHM.setComments("quality check not applied");
                irisQualityFeedbackHM.setCompliance(Compliance.ERROR);
                irisQualityFeedbackHM.setScore(0.0);
                irisQualityFeedbackHM.setQualityAttribute(IrisQualityAttribute.HORIZONTAL_MARGIN);
                irisQuality.getQualityFeedback().add(irisQualityFeedbackHM);
                IrisQualityFeedback irisQualityFeedbackVM = new IrisQualityFeedback();
                irisQualityFeedbackVM.setComments("quality check not applied");
                irisQualityFeedbackVM.setCompliance(Compliance.ERROR);
                irisQualityFeedbackVM.setScore(0.0);
                irisQualityFeedbackVM.setQualityAttribute(IrisQualityAttribute.VERTICAL_MARGIN);
                irisQuality.getQualityFeedback().add(irisQualityFeedbackVM);
                importantCheckFailed = true;
            }
            boolean bl = importantCheckFailed;
            return bl;
        }
        catch (Exception ex) {
            L1_LOGGER.error((Object)(this.instanceIdentifierM + ", Exception caught: " + ex));
            boolean bl = importantCheckFailed = true;
            return bl;
        }
        finally {
            if (landmarkList != null) {
                landmarkList.dispose();
            }
        }
    }

    private static byte[] concat(byte[] A, byte[] B) {
        byte[] C = new byte[A.length + B.length];
        System.arraycopy(A, 0, C, 0, A.length);
        System.arraycopy(B, 0, C, A.length, B.length);
        return C;
    }

    public byte[] convertIrisImageFormat(byte[] inputImage, IrisImageFormat targetImageType, int targetSize) {
        boolean isIris2011 = false;
        boolean isIris2005 = false;
        byte[] targetRecord = null;
        Vector<IrisImageStruct> dataVec = null;
        List<IIR_2011.RepresentationHeader> representationHeaders = new ArrayList<IIR_2011.RepresentationHeader>();
        IIR_2011.Header rootHeader = null;
        if (inputImage == null || targetImageType == null) {
            return null;
        }
        char ii = UtilHelper.byteToChar(inputImage[4]);
        char j = UtilHelper.byteToChar(inputImage[5]);
        char k = UtilHelper.byteToChar(inputImage[6]);
        char l = UtilHelper.byteToChar(inputImage[7]);
        if (ii == '0' && j == '2' && k == '0' && l == '\u0000') {
            isIris2011 = true;
        }
        if (ii == '0' && j == '1' && k == '0' && l == '\u0000') {
            isIris2005 = true;
        }
        try {
            if (isIris2005) {
                L1_LOGGER.info((Object)"Input records is a IRIS 2005 image record.");
                dataVec = IrisISO.getImagesFromPackage((byte[])inputImage, (boolean)this.iso_parsing_strict);
            }
            if (isIris2011) {
                L1_LOGGER.info((Object)"Input records is a IRIS 2011 image record.");
                ByteArrayInputStream is = new ByteArrayInputStream(inputImage);
                IIR_2011 iir = IIR_2011.readFromStream(is, this.iso_parsing_strict);
                L1_LOGGER.info((Object)"Basic header check in place for IRIS 2011 image record.");
                ValidateHeaders.basicCheck(iir, inputImage.length);
                if (this.iso_parsing_strict) {
                    L1_LOGGER.info((Object)"More rigorous header check in place for IRIS 2011 image record.");
                    ValidateHeaders.validateIrisHeaders(iir);
                }
                representationHeaders = iir.irisList;
                rootHeader = iir.header;
                dataVec = L1QAModule.getImagesFromPackage(iir);
                for (IIR_2011.RepresentationHeader representationHeader : representationHeaders) {
                    if (representationHeader.imageType == 1) continue;
                    L1_LOGGER.error((Object)"Input iris image record should be kind 1");
                    return null;
                }
            }
            List<Image> images = this.getKindImageForIris(inputImage, dataVec, isIris2005, targetImageType, targetSize);
            if (isIris2005) {
                targetRecord = this.irisQaModule.add2011HeaderTo2005IIRImage(images, dataVec, targetImageType, targetSize);
            }
            if (isIris2011) {
                targetRecord = this.irisQaModule.add2011HeaderTo2011IIRImage(images, inputImage, representationHeaders, targetImageType, targetSize, dataVec);
            }
        }
        catch (Exception e) {
            L1_LOGGER.error((Object)"Error in converting the input iris record");
            return null;
        }
        return targetRecord;
    }

    public List<Image> getKindImageForIris(byte[] input, Vector<IrisImageStruct> dataVec, boolean isIris2005, IrisImageFormat targetImageType, int targetSize) throws CustomException {
        Image l1Image = null;
        ArrayList<Image> blobs = new ArrayList<Image>();
        for (int i = 0; i < dataVec.size(); ++i) {
            int imageType;
            IrisImageStruct irisImageStructL = dataVec.get(i);
            if (isIris2005) {
                imageType = L1QAModule.getImageFormatFromIIR(L1_LOGGER, input);
                if (imageType != 0 && imageType != 1 && imageType != 8 && imageType != 9) {
                    L1_LOGGER.error((Object)"Unsupported input image format type for target iris 2011 record");
                    return null;
                }
            } else {
                imageType = dataVec.get(i).getImageType();
            }
            l1Image = new Image();
            byte[] imageData = dataVec.get(i).getImage();
            int sourceImageSize = imageData.length;
            int width = dataVec.get(i).getWidth();
            int height = dataVec.get(i).getHeight();
            if (imageType == 8 || imageType == 9) {
                l1Image.loadRaw(imageData, width, height, Types.ImageChannelSequence.Gray, Types.ImageDataOrder.Pixel);
            } else {
                l1Image.readBlob(imageData, 0L);
            }
            if (l1Image == null) {
                L1_LOGGER.error((Object)(this.instanceIdentifierM + ": Iris ISO Parsing Failed: no image data present."));
                return null;
            }
            Types.Instance irisType = Types.Instance.Unknown;
            BiometricPosition position = BiometricPosition.UNKNOWN;
            int irisPosition = dataVec.get(i).getPosition();
            switch (irisPosition) {
                case 2: {
                    irisType = Types.Instance.IrisLeft;
                    position = BiometricPosition.LEFT_IRIS;
                    break;
                }
                case 1: {
                    irisType = Types.Instance.IrisRight;
                    position = BiometricPosition.RIGHT_IRIS;
                }
            }
            Types.Instance irisTypeForTC = irisType;
            if (irisType == Types.Instance.Unknown) {
                irisTypeForTC = Types.Instance.IrisLeft;
            }
            Image image = this.irisQaModule.createKindImages(l1Image, targetImageType, targetSize, irisTypeForTC, sourceImageSize, imageType);
            blobs.add(image);
            if (l1Image == null) continue;
            l1Image.dispose();
        }
        return blobs;
    }

    static {
        L1_LOGGER.info((Object)("Loading : " + Version.version));
        L1QSSEngine.ISOHeader[0] = 1;
        L1QSSEngine.ISOHeader[1] = 1;
        L1QSSEngine.ISOHeader[2] = 0;
        L1QSSEngine.ISOHeader[3] = 2;
        L1QSSEngine.ISOHeader[4] = 8;
        L1QSSEngine.ISOHeader[5] = 0;
        L1QSSEngine.ISOHeader[6] = 0;
        L1QSSEngine.ISOHeader[7] = 3;
        L1QSSEngine.ISOHeader[8] = 0;
        L1QSSEngine.ISOHeader[9] = 10;
        L1QSSEngine.ISOHeader[10] = 12;
        L1QSSEngine.ISOHeader[11] = 51;
    }
}

