/*
 * Decompiled with CFR 0.152.
 */
package com.l1id.uid.qssitv.util;

import com.l1id.sdk.foundation.Common;
import in.gov.uidai.qssitv.model.BiometricError;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.qssitv.model.BiometricTemplate;
import in.gov.uidai.qssitv.model.Compliance;
import in.gov.uidai.qssitv.model.FaceQSS;
import in.gov.uidai.qssitv.model.FaceQualityAttribute;
import in.gov.uidai.qssitv.model.FaceQualityFeedback;
import in.gov.uidai.qssitv.model.FingerSegment;
import in.gov.uidai.qssitv.model.FingerprintQSS;
import in.gov.uidai.qssitv.model.FingerprintQualityAttribute;
import in.gov.uidai.qssitv.model.FingerprintQualityFeedback;
import in.gov.uidai.qssitv.model.FormatType;
import in.gov.uidai.qssitv.model.IrisQSS;
import in.gov.uidai.qssitv.model.IrisQualityAttribute;
import in.gov.uidai.qssitv.model.IrisQualityFeedback;
import in.gov.uidai.qssitv.model.LandMark;
import in.gov.uidai.qssitv.model.LandMarkType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;

public class Util {
    static final String HEXES = "0123456789ABCDEF";
    static final String newLine = System.getProperty("line.separator");
    static final String spaceLine = "                                            ";

    public static byte[] getBytesFromFile(String filenameA) throws IOException {
        int offset;
        File file = new File(filenameA);
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            throw new RuntimeException("file to large");
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    public static void saveBytesToFile(String filenameA, byte[] dataA) throws FileNotFoundException, IOException {
        FileOutputStream fosL = new FileOutputStream(filenameA);
        fosL.write(dataA);
        fosL.close();
    }

    public static byte[] int2byte(int numberA, int positionsA) {
        byte[] retL = new byte[positionsA];
        for (int i = 0; i < positionsA; ++i) {
            retL[i] = (byte)(numberA >>> i * 8);
        }
        return retL;
    }

    public static int byte2int(byte[] dataA) {
        int retL = 0;
        for (int i = 0; i < dataA.length; ++i) {
            retL |= (dataA[i] & 0xFF) << i * 8;
        }
        return retL;
    }

    public static byte[] concat(byte[] first, byte[] second) {
        byte[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static String getHex(byte[] raw) {
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (byte b : raw) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return hex.toString();
    }

    public static String getHexPrintable(byte[] raw) {
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (byte b : raw) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
            hex.append(" ");
        }
        return hex.toString();
    }

    public static int hex2int(String hexA) {
        return Integer.parseInt(hexA, 16);
    }

    public static String getNumberOfFoundationHandles() {
        return new Common().getObjectInformation(0);
    }

    private static String getIndent(int indentA) {
        return spaceLine.substring(0, indentA * 2);
    }

    public static String getDebugToString(Object objA) {
        if (objA instanceof List) {
            return Util._getDebugToString(objA, 0);
        }
        return Util._getDebugToString(objA, 0).trim();
    }

    private static String _getDebugToString(Object objA, int depthA) {
        if (objA instanceof byte[]) {
            return (objA == null ? 0 : ((byte[])objA).length) + " bytes";
        }
        if (objA == null) {
            return "<null>";
        }
        StringBuilder sbL = new StringBuilder();
        if (objA instanceof List) {
            if (!((List)objA).isEmpty()) {
                sbL.append(Util.getIndent(depthA));
                sbL.append(((List)objA).get(0).getClass().getSimpleName());
                sbL.append("-list (");
                sbL.append(((List)objA).size());
                sbL.append("):");
                for (Object objL : (List)objA) {
                    sbL.append(Util._getDebugToString(objL, depthA + 1));
                }
            }
        } else if (objA instanceof BiometricError) {
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA));
            sbL.append("BiometricError : ");
            sbL.append(((BiometricError)objA).getErrorMessage());
        } else if (objA instanceof BiometricPosition) {
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA));
            sbL.append("BiometricPosition : ");
            sbL.append(((BiometricPosition)objA).toString());
        } else if (objA instanceof BiometricTemplate) {
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA));
            sbL.append("[ BiometricTemplate:");
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA + 1));
            sbL.append("BiometricPosition : ");
            sbL.append(((BiometricTemplate)objA).getBiometricPosition());
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA + 1));
            sbL.append("ProbeTemplate : ");
            sbL.append(Util._getDebugToString(((BiometricTemplate)objA).getProbeTemplate(), 0));
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA + 1));
            sbL.append("GalleryTemplate : ");
            sbL.append(Util._getDebugToString(((BiometricTemplate)objA).getGalleryTemplate(), 0));
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA));
            sbL.append("]");
        } else if (objA instanceof Compliance) {
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA));
            sbL.append("Compliance : ");
            sbL.append(((Compliance)objA).toString());
            sbL.append(", ");
            sbL.append(((Compliance)objA).getvalue());
        } else if (objA instanceof FaceQSS) {
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA));
            sbL.append("[ FaceQSS:");
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA + 1));
            sbL.append("OverallScore : ");
            sbL.append(((FaceQSS)objA).getOverallScore());
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA + 1));
            sbL.append("OverallComments : ");
            sbL.append(((FaceQSS)objA).getOverallComments());
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA + 1));
            sbL.append("FullFrontalFace : ");
            sbL.append(Util._getDebugToString(((FaceQSS)objA).getFullFrontalFace(), 0));
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA + 1));
            sbL.append("FullFrontalFaceForDisplay : ");
            sbL.append(Util._getDebugToString(((FaceQSS)objA).getFullFrontalFaceForDisplay(), 0));
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA + 1));
            sbL.append("OverallCompliance : ");
            sbL.append(((FaceQSS)objA).getOverallCompliance());
            sbL.append(newLine);
            sbL.append(Util._getDebugToString(((FaceQSS)objA).getLandMarkList(), depthA + 1));
            sbL.append(newLine);
            sbL.append(Util._getDebugToString(((FaceQSS)objA).getQualityFeedback(), depthA + 1));
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA));
            sbL.append("]");
        } else if (objA instanceof FaceQualityAttribute) {
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA));
            sbL.append("FaceQualityAttribute : ");
            sbL.append(((FaceQualityAttribute)objA).toString());
            sbL.append(", ");
            sbL.append(((FaceQualityAttribute)objA).getvalue());
        } else if (objA instanceof FaceQualityFeedback) {
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA));
            sbL.append("FaceQualityFeedback : ");
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA + 1));
            sbL.append("QualityAttribute : ");
            sbL.append(((FaceQualityFeedback)objA).getQualityAttribute());
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA + 1));
            sbL.append("Score : ");
            sbL.append(((FaceQualityFeedback)objA).getScore());
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA + 1));
            sbL.append("Comments : ");
            sbL.append(((FaceQualityFeedback)objA).getComments());
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA + 1));
            sbL.append("Compliance : ");
            sbL.append(((FaceQualityFeedback)objA).getCompliance());
        } else if (objA instanceof FingerSegment) {
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA));
            sbL.append("[ FingerSegment:");
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA + 1));
            sbL.append("BiometricPosition : ");
            sbL.append(((FingerSegment)objA).getFingerPosition());
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA + 1));
            sbL.append("Quality : ");
            sbL.append(((FingerSegment)objA).getQuality());
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA + 1));
            sbL.append("Image : ");
            sbL.append(Util._getDebugToString(((FingerSegment)objA).getImage(), 0));
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA + 1));
            sbL.append("Top-Left     : ");
            sbL.append(((FingerSegment)objA).getTopLeft().getX());
            sbL.append(", ");
            sbL.append(((FingerSegment)objA).getTopLeft().getY());
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA + 1));
            sbL.append("Top-Right :    ");
            sbL.append(((FingerSegment)objA).getTopRight().getX());
            sbL.append(", ");
            sbL.append(((FingerSegment)objA).getTopRight().getY());
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA + 1));
            sbL.append("Bottom-Left  : ");
            sbL.append(((FingerSegment)objA).getBottomLeft().getX());
            sbL.append(", ");
            sbL.append(((FingerSegment)objA).getBottomLeft().getY());
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA + 1));
            sbL.append("Bottom-Right : ");
            sbL.append(((FingerSegment)objA).getBottomRight().getX());
            sbL.append(", ");
            sbL.append(((FingerSegment)objA).getBottomRight().getY());
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA));
            sbL.append("]");
        } else if (objA instanceof FingerprintQSS) {
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA));
            sbL.append("[ FingerprintQSS:");
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA + 1));
            sbL.append("OverallScore : ");
            sbL.append(((FingerprintQSS)objA).getOverallScore());
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA + 1));
            sbL.append("OverallComments : ");
            sbL.append(((FingerprintQSS)objA).getOverallComments());
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA + 1));
            sbL.append("OverallConfidence : ");
            sbL.append(((FingerprintQSS)objA).getOverallConfidence());
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA + 1));
            sbL.append("OverallCompliance : ");
            sbL.append(((FingerprintQSS)objA).getOverallCompliance());
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA + 1));
            sbL.append("Handedness : ");
            sbL.append(((FingerprintQSS)objA).getHandedness());
            sbL.append(newLine);
            sbL.append(Util._getDebugToString(((FingerprintQSS)objA).getFingerSegments(), depthA + 1));
            sbL.append(newLine);
            sbL.append(Util._getDebugToString(((FingerprintQSS)objA).getQualityFeedback(), depthA + 1));
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA));
            sbL.append("]");
        } else if (objA instanceof FingerprintQualityAttribute) {
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA));
            sbL.append("FingerprintQualityAttribute : ");
            sbL.append(((FingerprintQualityAttribute)objA).toString());
            sbL.append(", ");
            sbL.append(((FingerprintQualityAttribute)objA).getvalue());
        } else if (objA instanceof FingerprintQualityFeedback) {
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA));
            sbL.append("FingerprintQualityFeedback : ");
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA + 1));
            sbL.append("QualityAttribute : ");
            sbL.append(((FingerprintQualityFeedback)objA).getQualityAttribute());
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA + 1));
            sbL.append("Score : ");
            sbL.append(((FingerprintQualityFeedback)objA).getScore());
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA + 1));
            sbL.append("Comments : ");
            sbL.append(((FingerprintQualityFeedback)objA).getComments());
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA + 1));
            sbL.append("Compliance : ");
            sbL.append(((FingerprintQualityFeedback)objA).getCompliance());
        } else if (objA instanceof FormatType) {
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA));
            sbL.append("FormatType : ");
            sbL.append(((FormatType)objA).toString());
            sbL.append(", ");
            sbL.append(((FormatType)objA).getvalue());
        } else if (objA instanceof IrisQSS) {
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA));
            sbL.append("[ IrisQSS:");
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA + 1));
            sbL.append("OverallScore : ");
            sbL.append(((IrisQSS)objA).getOverallScore());
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA + 1));
            sbL.append("OverallComments : ");
            sbL.append(((IrisQSS)objA).getOverallComments());
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA + 1));
            sbL.append("OverallCompliance : ");
            sbL.append(((IrisQSS)objA).getOverallCompliance());
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA + 1));
            sbL.append("EyePosition : ");
            sbL.append(((IrisQSS)objA).getEyePosition());
            sbL.append(newLine);
            sbL.append(Util._getDebugToString(((IrisQSS)objA).getLandMarkList(), depthA + 1));
            sbL.append(newLine);
            sbL.append(Util._getDebugToString(((IrisQSS)objA).getQualityFeedback(), depthA + 1));
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA));
            sbL.append("]");
        } else if (objA instanceof IrisQualityAttribute) {
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA));
            sbL.append("IrisQualityAttribute : ");
            sbL.append(((IrisQualityAttribute)objA).toString());
            sbL.append(", ");
            sbL.append(((IrisQualityAttribute)objA).getvalue());
        } else if (objA instanceof IrisQualityFeedback) {
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA));
            sbL.append("IrisQualityFeedback : [");
            IrisQualityFeedback iqfL = (IrisQualityFeedback)objA;
            sbL.append("QualityAttribute : ");
            sbL.append(iqfL.getQualityAttribute());
            sbL.append(", Compliance : ");
            sbL.append(iqfL.getCompliance());
            sbL.append(", Score : ");
            sbL.append(iqfL.getScore());
            sbL.append(", Comments : ");
            sbL.append(iqfL.getComments());
            sbL.append("]");
        } else if (objA instanceof LandMark) {
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA));
            sbL.append("LandMark : [");
            sbL.append(((LandMark)objA).toString());
            sbL.append("]");
        } else if (objA instanceof LandMarkType) {
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA));
            sbL.append("LandMarkType : ");
            sbL.append(((LandMarkType)objA).toString());
        } else {
            sbL.append(newLine);
            sbL.append(Util.getIndent(depthA));
            sbL.append(objA.toString());
        }
        return sbL.toString();
    }
}

