/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.j2se;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.client.j2se.Config;
import com.google.zxing.client.j2se.DecodeThread;
import com.google.zxing.client.j2se.Inputs;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;

public final class CommandLineRunner {
    private CommandLineRunner() {
    }

    public static void main(String[] args) throws Exception {
        String arg;
        if (args.length == 0) {
            CommandLineRunner.printUsage();
            return;
        }
        Config config = new Config();
        Inputs inputs = new Inputs();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            arg = stringArray[n2];
            if ("--try_harder".equals(arg)) {
                config.setTryHarder(true);
            } else if ("--pure_barcode".equals(arg)) {
                config.setPureBarcode(true);
            } else if ("--products_only".equals(arg)) {
                config.setProductsOnly(true);
            } else if ("--dump_results".equals(arg)) {
                config.setDumpResults(true);
            } else if ("--dump_black_point".equals(arg)) {
                config.setDumpBlackPoint(true);
            } else if ("--multi".equals(arg)) {
                config.setMulti(true);
            } else if ("--brief".equals(arg)) {
                config.setBrief(true);
            } else if ("--recursive".equals(arg)) {
                config.setRecursive(true);
            } else if (arg.startsWith("--crop")) {
                int[] crop = new int[4];
                String[] tokens = arg.substring(7).split(",");
                int i = 0;
                while (i < crop.length) {
                    crop[i] = Integer.parseInt(tokens[i]);
                    ++i;
                }
                config.setCrop(crop);
            } else if (arg.startsWith("--threads") && arg.length() >= 10) {
                int threads = Integer.parseInt(arg.substring(10));
                if (threads > 1) {
                    config.setThreads(threads);
                }
            } else if (arg.startsWith("-")) {
                System.err.println("Unknown command line option " + arg);
                CommandLineRunner.printUsage();
                return;
            }
            ++n2;
        }
        config.setHints(CommandLineRunner.buildHints(config));
        stringArray = args;
        n = args.length;
        n2 = 0;
        while (n2 < n) {
            arg = stringArray[n2];
            if (!arg.startsWith("--")) {
                CommandLineRunner.addArgumentToInputs(arg, config, inputs);
            }
            ++n2;
        }
        ArrayList<DecodeThread> threads = new ArrayList<DecodeThread>(config.getThreads());
        int x = 0;
        while (x < config.getThreads()) {
            DecodeThread thread = new DecodeThread(config, inputs);
            threads.add(thread);
            thread.start();
            ++x;
        }
        int successful = 0;
        int x2 = 0;
        while (x2 < config.getThreads()) {
            ((DecodeThread)threads.get(x2)).join();
            successful += ((DecodeThread)threads.get(x2)).getSuccessful();
            ++x2;
        }
        int total = inputs.getInputCount();
        if (total > 1) {
            System.out.println("\nDecoded " + successful + " files out of " + total + " successfully (" + successful * 100 / total + "%)\n");
        }
    }

    private static void addArgumentToInputs(String argument, Config config, Inputs inputs) throws IOException {
        File inputFile = new File(argument);
        if (inputFile.exists()) {
            if (inputFile.isDirectory()) {
                File[] fileArray = inputFile.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File singleFile = fileArray[n2];
                    String filename = singleFile.getName().toLowerCase(Locale.ENGLISH);
                    if (!filename.startsWith(".")) {
                        if (singleFile.isDirectory()) {
                            if (config.isRecursive()) {
                                CommandLineRunner.addArgumentToInputs(singleFile.getAbsolutePath(), config, inputs);
                            }
                        } else if (!filename.endsWith(".txt") && !filename.contains(".mono.png")) {
                            inputs.addInput(singleFile.getCanonicalPath());
                        }
                    }
                    ++n2;
                }
            } else {
                inputs.addInput(inputFile.getCanonicalPath());
            }
        } else {
            inputs.addInput(argument);
        }
    }

    private static Map<DecodeHintType, ?> buildHints(Config config) {
        EnumMap<DecodeHintType, Serializable> hints = new EnumMap<DecodeHintType, Serializable>(DecodeHintType.class);
        ArrayList<BarcodeFormat> vector = new ArrayList<BarcodeFormat>(8);
        vector.add(BarcodeFormat.UPC_A);
        vector.add(BarcodeFormat.UPC_E);
        vector.add(BarcodeFormat.EAN_13);
        vector.add(BarcodeFormat.EAN_8);
        vector.add(BarcodeFormat.RSS_14);
        vector.add(BarcodeFormat.RSS_EXPANDED);
        if (!config.isProductsOnly()) {
            vector.add(BarcodeFormat.CODE_39);
            vector.add(BarcodeFormat.CODE_93);
            vector.add(BarcodeFormat.CODE_128);
            vector.add(BarcodeFormat.ITF);
            vector.add(BarcodeFormat.QR_CODE);
            vector.add(BarcodeFormat.DATA_MATRIX);
            vector.add(BarcodeFormat.AZTEC);
            vector.add(BarcodeFormat.PDF_417);
            vector.add(BarcodeFormat.CODABAR);
            vector.add(BarcodeFormat.MAXICODE);
        }
        hints.put(DecodeHintType.POSSIBLE_FORMATS, vector);
        if (config.isTryHarder()) {
            hints.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
        }
        if (config.isPureBarcode()) {
            hints.put(DecodeHintType.PURE_BARCODE, Boolean.TRUE);
        }
        return hints;
    }

    private static void printUsage() {
        System.err.println("Decode barcode images using the ZXing library\n");
        System.err.println("usage: CommandLineRunner { file | dir | url } [ options ]");
        System.err.println("  --try_harder: Use the TRY_HARDER hint, default is normal (mobile) mode");
        System.err.println("  --pure_barcode: Input image is a pure monochrome barcode image, not a photo");
        System.err.println("  --products_only: Only decode the UPC and EAN families of barcodes");
        System.err.println("  --dump_results: Write the decoded contents to input.txt");
        System.err.println("  --dump_black_point: Compare black point algorithms as input.mono.png");
        System.err.println("  --multi: Scans image for multiple barcodes");
        System.err.println("  --brief: Only output one line per file, omitting the contents");
        System.err.println("  --recursive: Descend into subdirectories");
        System.err.println("  --crop=left,top,width,height: Only examine cropped region of input image(s)");
        System.err.println("  --threads=n: The number of threads to use while decoding");
    }
}

