/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.qssitv.server;

import in.gov.uidai.ec.ecmpapi.EcmpApiService;
import in.gov.uidai.ec.ecmpapi.xml.api.PositionHintType;
import in.gov.uidai.ec.ecmpapi.xml.bioverify.BioVerify;
import in.gov.uidai.ec.ecmpapi.xml.bioverify.xml.BioVerifyResponse;
import in.gov.uidai.ec.ecmpapi.xml.bioverify.xml.PidType;
import in.gov.uidai.ec.ecmpapi.xml.bioverify.xml.Result;
import in.gov.uidai.ec.ecmpapi.xml.qssitv.TokenRequest;
import in.gov.uidai.ec.ecmpapi.xml.qssitv.TokenResponse;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.qssitv.model.BiometricTemplate;
import in.gov.uidai.qssitv.server.shared.AuthOutput;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class AuthClientForCIS
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthClientForCIS.class);
    private EcmpApiService ecmpApiService;

    public void setEcmpApiService(EcmpApiService ecmpApiService) {
        this.ecmpApiService = ecmpApiService;
    }

    public void afterPropertiesSet() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public List<AuthOutput> authenticate(String uid, String pidType, List<BiometricTemplate> templates) {
        LOGGER.debug("AuthClient authenticate...");
        ArrayList<AuthOutput> outList = new ArrayList<AuthOutput>();
        for (BiometricTemplate bt : templates) {
            AuthOutput output;
            block12: {
                String biometricPositionString;
                output = new AuthOutput();
                output.setBiometricPosition(bt.getBiometricPosition());
                if (outList.size() == 0) {
                    TokenRequest request = new TokenRequest();
                    request.setBiometrics(bt.getProbeTemplate());
                    biometricPositionString = BiometricPosition.getBiometricsPositionString((String)bt.getBiometricPosition().toString());
                    request.setPositionHintType(PositionHintType.fromValue((String)biometricPositionString));
                    request.setUid(uid);
                    try {
                        TokenResponse response = this.ecmpApiService.syncToken(request);
                        if (this.processTokenResponse(response)) {
                            output.setSuccessFlag(true);
                            LOGGER.info("Sync Token Request Passed for: " + bt.getBiometricPosition().toString());
                            break block12;
                        }
                        LOGGER.info("Sync Token Request Failed for: " + bt.getBiometricPosition().toString());
                    }
                    catch (IOException e) {
                        LOGGER.error("Failed to authenticate due to network error", (Throwable)e);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error while authenticate", (Throwable)e);
                    }
                } else {
                    BioVerify bioVerify = new BioVerify();
                    biometricPositionString = BiometricPosition.getBiometricsPositionString((String)bt.getBiometricPosition().toString());
                    bioVerify.addPidDetails(uid, bt.getProbeTemplate(), PidType.valueOf((String)pidType), PositionHintType.fromValue((String)biometricPositionString));
                    try {
                        BioVerifyResponse bioVerifyResponse = this.ecmpApiService.verifyBiometrics(bioVerify.getBioVerifyRequest(), false);
                        if (this.processBioVerifyResponse(bioVerifyResponse)) {
                            output.setSuccessFlag(true);
                            LOGGER.info("Biometric verification Passed for: " + bt.getBiometricPosition().toString());
                        } else {
                            LOGGER.info("Biometric verification Failed for: " + bt.getBiometricPosition().toString());
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("Connecting to the Server failed.", (Throwable)e);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error during authentication during onboard", (Throwable)e);
                    }
                }
            }
            outList.add(output);
        }
        return outList;
    }

    private boolean processBioVerifyResponse(BioVerifyResponse bioVerifyResponse) {
        if (bioVerifyResponse.getResult() == Result.SUCCESS) {
            return true;
        }
        LOGGER.error(bioVerifyResponse.getErrorMessage() + " " + bioVerifyResponse.getErrorCodeType().toString() + ":" + bioVerifyResponse.getErrorCode());
        return false;
    }

    private boolean processTokenResponse(TokenResponse tokenResponse) {
        if (tokenResponse.getResult() == in.gov.uidai.ec.ecmpapi.xml.qssitv.Result.SUCCESS) {
            return true;
        }
        LOGGER.error(tokenResponse.getErrorMessage() + " " + tokenResponse.getErrorCodeType().toString() + ":" + tokenResponse.getErrorCode());
        return false;
    }
}

