/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.qssitv.server;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import in.gov.uidai.qssitv.Qssitv;
import in.gov.uidai.qssitv.server.QSSITVSpringConfig;
import in.gov.uidai.qssitv.spi.IITVEngine;
import in.gov.uidai.qssitv.spi.IQSSEngine;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public final class ServiceMain {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceMain.class);

    private ServiceMain() {
    }

    public static void main(String[] args) {
        JoranConfigurator joranConfig = new JoranConfigurator();
        ClassLoader cldr = ServiceMain.class.getClassLoader();
        try {
            LoggerContext logCtxt = (LoggerContext)LoggerFactory.getILoggerFactory();
            joranConfig.setContext((Context)logCtxt);
            logCtxt.reset();
            joranConfig.doConfigure(cldr.getResource("res/qssitvs/conf/qssitvs.logback.xml"));
        }
        catch (Exception exep) {
            LOGGER.error("Error initializing logging context" + exep.getMessage());
        }
        LOGGER.debug("preloading the QSS engine");
        try {
            IQSSEngine qss = (IQSSEngine)Class.forName("com.l1id.uid.qssitv.L1QSSEngine").newInstance();
            Qssitv.getInst().register(qss);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        try {
            IITVEngine itv = (IITVEngine)Class.forName("com.l1id.uid.qssitv.L1ITVEngine").newInstance();
            Qssitv.getInst().register(itv);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext(new Class[]{QSSITVSpringConfig.class});
        context.registerShutdownHook();
        LOGGER.info("ready");
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                System.gc();
            }
        };
        Timer timer = new Timer(true);
        timer.scheduleAtFixedRate(task, 0L, 10000L);
        try {
            Thread.currentThread().join();
        }
        catch (InterruptedException e) {
            LOGGER.warn("", (Throwable)e);
        }
        System.runFinalization();
    }
}

