/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.qssitv.server.endpoints;

import in.gov.uidai.ec.icas.hrmi.IHrmiService;
import in.gov.uidai.qssitv.Qssitv;
import in.gov.uidai.qssitv.model.BiometricError;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.qssitv.model.BiometricTemplate;
import in.gov.uidai.qssitv.spi.IITVEngine;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITVHrmiService
implements IITVEngine,
IHrmiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ITVHrmiService.class);

    public boolean supportsFace() {
        return true;
    }

    public boolean supportsFinger() {
        return true;
    }

    public boolean supportsIris() {
        return true;
    }

    public List<BiometricTemplate> getFingerTemplate(byte[] input, List<BiometricPosition> missingfingers, int age, boolean iso) {
        this.debugDigest(input);
        return Qssitv.getInst().getFingerTemplate(input, missingfingers, age, iso);
    }

    public List<BiometricTemplate> getFaceTemplate(byte[] input, boolean iso) {
        this.debugDigest(input);
        return Qssitv.getInst().getFaceTemplate(input, iso);
    }

    public List<BiometricTemplate> getIrisTemplate(byte[] input, boolean iso) {
        this.debugDigest(input);
        return Qssitv.getInst().getIrisTemplate(input, iso);
    }

    public BiometricError insertFingerRecord(String encounterId, List<BiometricTemplate> fingerRecords) {
        return Qssitv.getInst().insertFingerRecord(encounterId, fingerRecords);
    }

    public BiometricError insertFaceRecord(String encounterId, List<BiometricTemplate> faceRecords) {
        return Qssitv.getInst().insertFaceRecord(encounterId, faceRecords);
    }

    public BiometricError insertIrisRecord(String encounterId, List<BiometricTemplate> irisRecords) {
        return Qssitv.getInst().insertIrisRecord(encounterId, irisRecords);
    }

    public void clearRecords() {
        Qssitv.getInst().clearRecords();
    }

    public Map<String, Double> identifyIris(List<BiometricTemplate> irisRecords, double threshold) {
        return Qssitv.getInst().identifyIris(irisRecords, threshold);
    }

    public Map<String, Double> identifyFace(List<BiometricTemplate> faceRecords, double threshold) {
        return Qssitv.getInst().identifyFace(faceRecords, threshold);
    }

    public Map<String, Double> identifyFinger(List<BiometricTemplate> fingerRecords, int age, double threshold) {
        return Qssitv.getInst().identifyFinger(fingerRecords, age, threshold);
    }

    public double verifyFinger(List<BiometricTemplate> probeRecord, List<BiometricTemplate> galleryRecord) {
        return Qssitv.getInst().verifyFinger(probeRecord, galleryRecord);
    }

    public double verifyIris(List<BiometricTemplate> probeRecord, List<BiometricTemplate> galleryRecord) {
        return Qssitv.getInst().verifyIris(probeRecord, galleryRecord);
    }

    public double verifyFace(List<BiometricTemplate> probeRecord, List<BiometricTemplate> galleryRecord) {
        return Qssitv.getInst().verifyFace(probeRecord, galleryRecord);
    }

    private void debugDigest(byte[] input) {
        if (LOGGER.isDebugEnabled()) {
            try {
                byte[] digest = MessageDigest.getInstance("SHA-256").digest(input);
                LOGGER.debug("digest for data received");
                LOGGER.debug(new BigInteger(digest).toString(36).toUpperCase(Locale.getDefault()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

