/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.qssitv.server.endpoints;

import in.gov.uidai.lvs.model.OnBoardingStatus;
import in.gov.uidai.lvs.model.RegistrationResult;
import in.gov.uidai.qssitv.model.BiometricTemplate;
import in.gov.uidai.qssitv.server.shared.ILVSDataStore;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import jdbm.PrimaryHashMap;
import jdbm.RecordManager;
import jdbm.recman.BaseRecordManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class LVSDataStore
implements InitializingBean,
ILVSDataStore {
    private static final String MAS_REG_RESULT = "RegResultMaster";
    private static final String MAS_ONBRD_STAT = "OnbrdStatMaster";
    private static final String TPL_PFX = "TPL_";
    private static final String ISO_TPL_PFX = "ISOTPL_";
    private RecordManager recMan;
    private String storePath;
    private static final Logger LOGGER = LoggerFactory.getLogger(LVSDataStore.class);

    public void setStorePath(String path) {
        this.storePath = path;
    }

    public void afterPropertiesSet() throws IOException {
        File storeFldr = new File(this.storePath);
        if (storeFldr.mkdirs()) {
            LOGGER.info("Directory created");
        } else {
            LOGGER.info("Directory not created");
        }
        String storeFile = new File(storeFldr, "lvsds.ecmp").getAbsolutePath();
        this.recMan = new BaseRecordManager(storeFile);
    }

    @Override
    public List<String> listUsers() {
        HashSet userList = new HashSet();
        PrimaryHashMap rrsMap = this.recMan.hashMap(MAS_REG_RESULT);
        userList.addAll(rrsMap.keySet());
        PrimaryHashMap obsMap = this.recMan.hashMap(MAS_ONBRD_STAT);
        userList.addAll(obsMap.keySet());
        return new ArrayList<String>(userList);
    }

    @Override
    public boolean isUserDataAvailable(String uid) {
        PrimaryHashMap rrsMap = this.recMan.hashMap(MAS_REG_RESULT);
        if (rrsMap.containsKey((Object)uid)) {
            return true;
        }
        PrimaryHashMap obMap = this.recMan.hashMap(MAS_ONBRD_STAT);
        return obMap.containsKey((Object)uid);
    }

    @Override
    public void addupRegResult(String uid, RegistrationResult rrs) throws IOException {
        this.addupRegResultImpl(uid, rrs, MAS_REG_RESULT);
    }

    @Override
    public RegistrationResult getRegResult(String uid) throws IOException {
        PrimaryHashMap rrsMap = this.recMan.hashMap(MAS_REG_RESULT);
        Long recId = (Long)rrsMap.get((Object)uid);
        if (recId != null && recId > 0L) {
            return (RegistrationResult)this.recMan.fetch(recId.longValue());
        }
        return null;
    }

    @Override
    public void clearRegResult(String uid) throws IOException {
        PrimaryHashMap rrsMap = this.recMan.hashMap(MAS_REG_RESULT);
        Long recId = (Long)rrsMap.get((Object)uid);
        try {
            if (recId != null && recId > 0L) {
                this.recMan.delete(recId.longValue());
            }
            rrsMap.remove((Object)uid);
            this.recMan.commit();
        }
        catch (Exception exep) {
            this.recMan.rollback();
        }
    }

    @Override
    public void addupOBStatus(String uid, OnBoardingStatus obs) throws IOException {
        PrimaryHashMap obsMap = this.recMan.hashMap(MAS_ONBRD_STAT);
        Long recId = (Long)obsMap.get((Object)uid);
        try {
            if (recId != null && recId > 0L) {
                this.recMan.update(recId.longValue(), (Object)obs);
            } else {
                recId = this.recMan.insert((Object)obs);
                obsMap.put((Object)uid, (Object)recId);
            }
            this.recMan.commit();
        }
        catch (Exception exep) {
            this.recMan.rollback();
        }
    }

    @Override
    public OnBoardingStatus getOBStatus(String uid) throws IOException {
        PrimaryHashMap obsMap = this.recMan.hashMap(MAS_ONBRD_STAT);
        Long recId = (Long)obsMap.get((Object)uid);
        if (recId != null && recId > 0L) {
            return (OnBoardingStatus)this.recMan.fetch(recId.longValue());
        }
        return null;
    }

    @Override
    public void clearOBStatus(String uid) throws IOException {
        PrimaryHashMap obsMap = this.recMan.hashMap(MAS_ONBRD_STAT);
        Long recId = (Long)obsMap.get((Object)uid);
        try {
            if (recId != null && recId > 0L) {
                this.recMan.delete(recId.longValue());
            }
            obsMap.remove((Object)uid);
            this.recMan.commit();
        }
        catch (Exception exep) {
            this.recMan.rollback();
        }
    }

    @Override
    public void addupBioTemplate(String uid, BiometricTemplate tpl, boolean iso) throws IOException {
        if (iso) {
            this.addupBioTemplateImpl(uid, tpl, ISO_TPL_PFX);
        } else {
            this.addupBioTemplateImpl(uid, tpl, TPL_PFX);
        }
    }

    @Override
    public void clearBioTemplates(String uid) throws IOException {
        this.clearBioTemplatesImpl(uid, TPL_PFX);
        this.clearBioTemplatesImpl(uid, ISO_TPL_PFX);
    }

    @Override
    public List<BiometricTemplate> listBioTemplates(String uid, boolean iso) throws IOException {
        if (iso) {
            return this.listBioTemplatesImpl(uid, ISO_TPL_PFX);
        }
        return this.listBioTemplatesImpl(uid, TPL_PFX);
    }

    private void addupRegResultImpl(String uid, RegistrationResult rrs, String mapName) throws IOException {
        String luid = uid.toLowerCase(Locale.getDefault());
        PrimaryHashMap rrsMap = this.recMan.hashMap(mapName);
        Long recId = (Long)rrsMap.get((Object)luid);
        try {
            if (recId != null && recId > 0L) {
                this.recMan.update(recId.longValue(), (Object)rrs);
            } else {
                recId = this.recMan.insert((Object)rrs);
                rrsMap.put((Object)luid, (Object)recId);
            }
            this.recMan.commit();
        }
        catch (IOException exep) {
            this.recMan.rollback();
        }
    }

    private void addupBioTemplateImpl(String uid, BiometricTemplate tpl, String prefix) throws IOException {
        String luid = uid.toLowerCase(Locale.getDefault());
        PrimaryHashMap tplMap = this.recMan.hashMap(prefix + luid);
        String biopos = tpl.getBiometricPosition().toString();
        try {
            Long recId = (Long)tplMap.get((Object)biopos);
            if (recId != null && recId > 0L) {
                this.recMan.update(recId.longValue(), (Object)tpl);
            } else {
                recId = this.recMan.insert((Object)tpl);
                tplMap.put((Object)biopos, (Object)recId);
            }
            this.recMan.commit();
        }
        catch (Exception exep) {
            this.recMan.rollback();
        }
    }

    private void clearBioTemplatesImpl(String uid, String prefix) throws IOException {
        String luid = uid.toLowerCase(Locale.getDefault());
        PrimaryHashMap tplMap = this.recMan.hashMap(prefix + luid);
        try {
            tplMap.clear();
            this.recMan.commit();
        }
        catch (Exception exep) {
            this.recMan.rollback();
        }
    }

    private List<BiometricTemplate> listBioTemplatesImpl(String uid, String prefix) throws IOException {
        String luid = uid.toLowerCase(Locale.getDefault());
        PrimaryHashMap tplMap = this.recMan.hashMap(prefix + luid);
        Collection valueList = tplMap.values();
        ArrayList<BiometricTemplate> tplList = new ArrayList<BiometricTemplate>();
        for (Long recId : valueList) {
            BiometricTemplate tpl;
            if (recId == null || recId <= 0L || (tpl = (BiometricTemplate)this.recMan.fetch(recId.longValue())) == null) continue;
            tplList.add(tpl);
        }
        return tplList;
    }
}

