/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.qssitv.server.endpoints;

import in.gov.uidai.ec.ecmpapi.ClientInformation;
import in.gov.uidai.ec.icas.hrmi.IHrmiService;
import in.gov.uidai.lvs.model.FingerprintSample;
import in.gov.uidai.lvs.model.OnBoardingStatus;
import in.gov.uidai.lvs.model.RegistrationResult;
import in.gov.uidai.lvs.model.RegistrationStatus;
import in.gov.uidai.lvs.spi.ILocalVerificationService;
import in.gov.uidai.qssitv.Qssitv;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.qssitv.model.BiometricTemplate;
import in.gov.uidai.qssitv.server.AuthClientForCIS;
import in.gov.uidai.qssitv.server.shared.AuthOutput;
import in.gov.uidai.qssitv.server.shared.ILVSDataStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LVSHrmiService
implements ILocalVerificationService,
IHrmiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LVSHrmiService.class);
    private static final int VERIFY_THRESHOLD = 40;
    private ILVSDataStore lvsds;
    private AuthClientForCIS authClientForCIS;
    private ClientInformation clientInformation;

    public void setClientInformation(ClientInformation clientInformation) {
        this.clientInformation = clientInformation;
    }

    public void setDataStore(ILVSDataStore lds) {
        this.lvsds = lds;
    }

    public void setAuthClientForCIS(AuthClientForCIS client) {
        this.authClientForCIS = client;
    }

    public void ping() {
        LOGGER.debug("ping received");
    }

    public RegistrationResult addBiometrics(String uid, List<BiometricTemplate> templates, List<BiometricTemplate> isoTemplates) {
        LOGGER.debug("add biometrics for uid: " + uid);
        RegistrationResult regres = new RegistrationResult();
        regres.setStatus(RegistrationStatus.PENDING_AUTH);
        if (templates == null || templates.isEmpty()) {
            LOGGER.warn("finger templates not provided");
            regres.setStatus(RegistrationStatus.INTERNAL_ERROR);
            return regres;
        }
        LOGGER.debug("number of templates: " + templates.size());
        try {
            if (this.lvsds.isUserDataAvailable(uid)) {
                regres.setStatus(RegistrationStatus.DUP_USERID);
                return regres;
            }
        }
        catch (Exception e) {
            LOGGER.error("duplicate check failed", (Throwable)e);
            regres.setStatus(RegistrationStatus.INTERNAL_ERROR);
            return regres;
        }
        try {
            String matchingUid = this.identifyUserImpl(templates);
            if (StringUtils.isNotBlank((String)matchingUid)) {
                LOGGER.debug("local dedup failed");
                regres.setStatus(RegistrationStatus.LOCAL_DEDUP_FAILED);
                return regres;
            }
        }
        catch (Exception e) {
            LOGGER.error("template identification failed", (Throwable)e);
            regres.setStatus(RegistrationStatus.INTERNAL_ERROR);
            return regres;
        }
        try {
            for (BiometricTemplate biometricTemplate : templates) {
                this.lvsds.addupBioTemplate(uid, biometricTemplate, false);
            }
            for (BiometricTemplate biometricTemplate : isoTemplates) {
                this.lvsds.addupBioTemplate(uid, biometricTemplate, true);
            }
            LOGGER.debug("templates saved to local data store");
        }
        catch (Exception e) {
            LOGGER.error("template store failed", (Throwable)e);
            regres.setStatus(RegistrationStatus.INTERNAL_ERROR);
            return regres;
        }
        ArrayList<BiometricPosition> allPositions = new ArrayList<BiometricPosition>();
        for (BiometricTemplate tpl : templates) {
            allPositions.add(tpl.getBiometricPosition());
        }
        regres.getAllPositions().addAll(allPositions);
        try {
            this.lvsds.addupRegResult(uid, regres);
            this.lvsds.addupOBStatus(uid, OnBoardingStatus.PARTIALLY_BOARDED);
        }
        catch (Exception exception) {
            LOGGER.error("result and status store failed", (Throwable)exception);
            regres.setStatus(RegistrationStatus.INTERNAL_ERROR);
        }
        return regres;
    }

    public RegistrationResult authenticate(String uid, String pidType) {
        List<BiometricTemplate> isoTemplates;
        RegistrationResult regres = new RegistrationResult();
        regres.setStatus(RegistrationStatus.USER_NOT_FOUND);
        if (!this.lvsds.isUserDataAvailable(uid)) {
            return regres;
        }
        try {
            isoTemplates = this.lvsds.listBioTemplates(uid, true);
        }
        catch (Exception e) {
            LOGGER.error("error retrieving biometric templates", (Throwable)e);
            return regres;
        }
        try {
            regres = this.lvsds.getRegResult(uid);
        }
        catch (Exception e) {
            LOGGER.error("error retrieving previous registration result", (Throwable)e);
            return regres;
        }
        List<AuthOutput> outList = this.authClientForCIS.authenticate(uid, pidType, isoTemplates);
        this.updateRegResult(regres, outList);
        try {
            if (regres.getStatus().equals((Object)RegistrationStatus.SUCCESS)) {
                this.lvsds.addupOBStatus(uid, OnBoardingStatus.ONBOARD);
                LOGGER.debug("auth success - onboard complete");
            } else {
                this.lvsds.addupOBStatus(uid, OnBoardingStatus.PARTIALLY_BOARDED);
                LOGGER.debug("auth failure - partially onboarded");
            }
            LOGGER.debug("on-boarding status saved");
            this.lvsds.addupRegResult(uid, regres);
            LOGGER.debug("registration result saved");
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            regres.setStatus(RegistrationStatus.INTERNAL_ERROR);
            return regres;
        }
        return regres;
    }

    public Map<String, OnBoardingStatus> listUsers() {
        HashMap<String, OnBoardingStatus> userMap = new HashMap<String, OnBoardingStatus>();
        List<String> idList = this.lvsds.listUsers();
        for (String uid : idList) {
            try {
                OnBoardingStatus obs = this.lvsds.getOBStatus(uid);
                if (obs == null) continue;
                userMap.put(uid, obs);
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        LOGGER.debug("returning: " + userMap);
        return userMap;
    }

    public OnBoardingStatus getStatus(String uid) {
        LOGGER.debug("Getting status");
        try {
            return this.lvsds.getOBStatus(uid);
        }
        catch (Exception exep) {
            return OnBoardingStatus.NOT_BOARDED;
        }
    }

    public RegistrationResult getRegistrationResult(String uid) {
        try {
            return this.lvsds.getRegResult(uid);
        }
        catch (Exception exep) {
            return null;
        }
    }

    public boolean deleteUser(String uid) {
        LOGGER.debug("called for uid: ");
        String luid = uid.toLowerCase(Locale.getDefault());
        try {
            this.lvsds.clearBioTemplates(luid);
            this.lvsds.clearOBStatus(luid);
            this.lvsds.clearRegResult(luid);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            return false;
        }
        return true;
    }

    public String identifyUser(List<BiometricTemplate> templates) {
        return this.identifyUserImpl(templates);
    }

    public boolean verifyUser(String uid, List<FingerprintSample> fingerSample, boolean authenticated, String authtype) {
        LOGGER.debug("Verification called for uid: " + uid);
        try {
            return this.verifyUserImpl(uid, fingerSample, authenticated, authtype);
        }
        catch (Exception e) {
            LOGGER.error("during verification", (Throwable)e);
            return false;
        }
    }

    private List<BiometricTemplate> extract(List<FingerprintSample> fingerSample, boolean iso, String authtype) {
        ArrayList<BiometricTemplate> tplFullList = new ArrayList<BiometricTemplate>();
        for (FingerprintSample sample : fingerSample) {
            LOGGER.debug("templating for biopos: " + sample.getBioPos());
            if (sample.getSampleData() == null) {
                LOGGER.debug("no sample");
            } else {
                LOGGER.debug("sample size is: " + sample.getSampleData().length);
            }
            try {
                List tplList;
                if (authtype.equalsIgnoreCase("iris")) {
                    tplList = Qssitv.getInst().getIrisTemplate(sample.getSampleData(), iso);
                    if (tplList == null) continue;
                    tplFullList.addAll(tplList);
                    continue;
                }
                tplList = Qssitv.getInst().getFingerTemplate(sample.getSampleData(), sample.getMissingFingers(), 0, iso);
                if (tplList == null) continue;
                tplFullList.addAll(tplList);
            }
            catch (Exception e) {
                LOGGER.warn("template extraction failed", (Throwable)e);
            }
        }
        LOGGER.debug("template extraction complete");
        return tplFullList;
    }

    private void updateRegResult(RegistrationResult result, List<AuthOutput> outList) {
        if (outList.size() <= 0) {
            result.setStatus(RegistrationStatus.INTERNAL_ERROR);
            result.getFailedPositions().addAll(result.getAllPositions());
            LOGGER.debug("UPDATE REG RESULT FAILED : NO RESPONSE LIST");
        } else {
            BiometricPosition bioPos;
            ArrayList<BiometricPosition> rightPassList = new ArrayList<BiometricPosition>();
            ArrayList<BiometricPosition> leftPassList = new ArrayList<BiometricPosition>();
            ArrayList<BiometricPosition> rightEyePassList = new ArrayList<BiometricPosition>();
            ArrayList<BiometricPosition> leftEyePassList = new ArrayList<BiometricPosition>();
            boolean isRightHandAvail = false;
            boolean isLeftHandAvail = false;
            boolean isLeftEyeAvail = false;
            boolean isRightEyeAvail = false;
            List allPositions = result.getAllPositions();
            if (allPositions.contains(BiometricPosition.RIGHT_INDEX) || allPositions.contains(BiometricPosition.RIGHT_LITTLE) || allPositions.contains(BiometricPosition.RIGHT_MIDDLE) || allPositions.contains(BiometricPosition.RIGHT_RING) || allPositions.contains(BiometricPosition.RIGHT_THUMB)) {
                isRightHandAvail = true;
            }
            if (allPositions.contains(BiometricPosition.LEFT_INDEX) || allPositions.contains(BiometricPosition.LEFT_LITTLE) || allPositions.contains(BiometricPosition.LEFT_MIDDLE) || allPositions.contains(BiometricPosition.LEFT_RING) || allPositions.contains(BiometricPosition.LEFT_THUMB)) {
                isLeftHandAvail = true;
            }
            if (allPositions.contains(BiometricPosition.LEFT_IRIS)) {
                isLeftEyeAvail = true;
            }
            if (allPositions.contains(BiometricPosition.RIGHT_IRIS)) {
                isRightEyeAvail = true;
            }
            for (AuthOutput out : outList) {
                if (out.isSuccessFlag()) continue;
                bioPos = out.getBiometricPosition();
                result.getFailedPositions().add(bioPos);
            }
            for (AuthOutput out : outList) {
                bioPos = out.getBiometricPosition();
                if ((bioPos == BiometricPosition.RIGHT_INDEX || bioPos == BiometricPosition.RIGHT_LITTLE || bioPos == BiometricPosition.RIGHT_MIDDLE || bioPos == BiometricPosition.RIGHT_RING || bioPos == BiometricPosition.RIGHT_THUMB) && out.isSuccessFlag()) {
                    rightPassList.add(bioPos);
                }
                if ((bioPos == BiometricPosition.LEFT_INDEX || bioPos == BiometricPosition.LEFT_LITTLE || bioPos == BiometricPosition.LEFT_MIDDLE || bioPos == BiometricPosition.LEFT_RING || bioPos == BiometricPosition.LEFT_THUMB) && out.isSuccessFlag()) {
                    leftPassList.add(bioPos);
                }
                if (bioPos == BiometricPosition.LEFT_IRIS && out.isSuccessFlag()) {
                    leftEyePassList.add(bioPos);
                }
                if (bioPos != BiometricPosition.RIGHT_IRIS || !out.isSuccessFlag()) continue;
                rightEyePassList.add(bioPos);
            }
            result.setStatus(RegistrationStatus.AUTH_FAILED);
            if (isRightHandAvail && isLeftHandAvail && isRightEyeAvail && isLeftEyeAvail) {
                if (rightPassList.size() >= 1 && leftPassList.size() >= 1 && rightEyePassList.size() == 1 && leftEyePassList.size() == 1) {
                    result.setStatus(RegistrationStatus.SUCCESS);
                }
            } else if (rightPassList.size() + leftPassList.size() >= 2 && rightEyePassList.size() == 1 && leftEyePassList.size() == 1) {
                result.setStatus(RegistrationStatus.SUCCESS);
            }
        }
    }

    private boolean verifyUserImpl(String uid, List<FingerprintSample> fingerSample, boolean authenticated, String authtype) throws Exception {
        if (fingerSample == null || fingerSample.isEmpty()) {
            LOGGER.warn("finger samples not provided");
            return false;
        }
        List<BiometricTemplate> tplFullList = this.extract(fingerSample, false, authtype);
        LOGGER.debug("templates extracted: " + tplFullList.size());
        String luid = uid.toLowerCase(Locale.getDefault());
        List<BiometricTemplate> refTplList = this.lvsds.listBioTemplates(luid, false);
        LOGGER.debug("templates available on store: " + refTplList.size());
        HashMap<BiometricPosition, BiometricTemplate> refTplMap = new HashMap<BiometricPosition, BiometricTemplate>();
        if (authenticated) {
            LOGGER.debug("auth positions only");
            RegistrationResult regres = this.lvsds.getRegResult(luid);
            List list = regres.getVerifiedPositions();
            LOGGER.debug("verified positions are: " + list);
            for (BiometricTemplate tpl : refTplList) {
                if (!list.contains(tpl.getBiometricPosition())) continue;
                refTplMap.put(tpl.getBiometricPosition(), tpl);
            }
        } else {
            for (BiometricTemplate biometricTemplate : refTplList) {
                refTplMap.put(biometricTemplate.getBiometricPosition(), biometricTemplate);
            }
        }
        refTplList.clear();
        boolean unknownSample = false;
        for (FingerprintSample sample : fingerSample) {
            if (sample.getBioPos() == null) {
                unknownSample = true;
                break;
            }
            if (!sample.getBioPos().equals((Object)BiometricPosition.UNKNOWN)) continue;
            unknownSample = true;
            break;
        }
        if (unknownSample) {
            refTplList.addAll(refTplMap.values());
            for (BiometricTemplate tpl : tplFullList) {
                tpl.setBiometricPosition(BiometricPosition.UNKNOWN);
            }
        } else {
            for (BiometricTemplate tpl : tplFullList) {
                BiometricPosition bpos = tpl.getBiometricPosition();
                if (refTplMap.containsKey(bpos)) {
                    refTplList.add((BiometricTemplate)refTplMap.get(bpos));
                }
                tpl.setBiometricPosition(BiometricPosition.UNKNOWN);
            }
        }
        LOGGER.debug("final ref templates count: " + refTplList.size());
        double d = authtype.equalsIgnoreCase("iris") ? Qssitv.getInst().verifyIris(tplFullList, refTplList).doubleValue() : Qssitv.getInst().verifyFinger(tplFullList, refTplList).doubleValue();
        LOGGER.debug("Verify User Match " + d);
        return d > 40.0;
    }

    private String identifyUserImpl(List<BiometricTemplate> templates) {
        Set<String> uidList = this.listUsers().keySet();
        for (String uid : uidList) {
            try {
                if (!this.identifyOneUser(uid, templates)) continue;
                return uid;
            }
            catch (Exception e) {
                LOGGER.warn("", (Throwable)e);
            }
        }
        return null;
    }

    private boolean identifyOneUser(String uid, List<BiometricTemplate> inTplList) throws Exception {
        if (inTplList == null || inTplList.isEmpty()) {
            LOGGER.warn("finger templates not provided");
            return false;
        }
        String luid = uid.toLowerCase(Locale.getDefault());
        ArrayList<BiometricTemplate> clonedList = new ArrayList<BiometricTemplate>();
        for (BiometricTemplate tpl : inTplList) {
            BiometricTemplate ctpl = new BiometricTemplate();
            ctpl.setProbeTemplate(tpl.getProbeTemplate());
            ctpl.setGalleryTemplate(tpl.getGalleryTemplate());
            ctpl.setBiometricPosition(BiometricPosition.UNKNOWN);
            clonedList.add(ctpl);
        }
        List<BiometricTemplate> refTplList = this.lvsds.listBioTemplates(luid, false);
        LOGGER.debug("templates available on store: " + refTplList.size());
        double match = Qssitv.getInst().verifyFinger(clonedList, refTplList);
        LOGGER.debug("Verify User Match " + match);
        return match > 40.0;
    }

    public List<BiometricTemplate> getBioTemplatesForLoggedinUser(String uid) {
        List<BiometricTemplate> isoTemplates = null;
        try {
            isoTemplates = this.lvsds.listBioTemplates(uid, true);
        }
        catch (Exception e) {
            LOGGER.error("error retrieving biometric templates", (Throwable)e);
        }
        return isoTemplates;
    }

    public void setClientInformation(String registrarId, String agencyId, String stationId, String machineCode, String version) {
        this.clientInformation.setRegistrarId(registrarId);
        this.clientInformation.setAgencyId(agencyId);
        this.clientInformation.setStationId(stationId);
        this.clientInformation.setMachineCode(machineCode);
        this.clientInformation.setVersion(version);
    }
}

