/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.qssitv.server.endpoints;

import in.gov.uidai.ec.icas.hrmi.IHrmiService;
import in.gov.uidai.qssitv.Qssitv;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.qssitv.model.FaceQSS;
import in.gov.uidai.qssitv.model.FingerSegment;
import in.gov.uidai.qssitv.model.FingerprintQSS;
import in.gov.uidai.qssitv.model.FormatType;
import in.gov.uidai.qssitv.model.IrisQSS;
import in.gov.uidai.qssitv.model.LandMark;
import in.gov.uidai.qssitv.spi.IQSSEngine;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QSSHrmiService
implements IQSSEngine,
IHrmiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(QSSHrmiService.class);

    public boolean supportsFace() {
        return true;
    }

    public boolean supportsFinger() {
        return true;
    }

    public boolean supportsIris() {
        return true;
    }

    public FaceQSS getQSSDataForFace(byte[] input, List<LandMark> landmarks) {
        this.debugDigest(input);
        FaceQSS result = Qssitv.getInst().getQSSDataForFace(input, landmarks);
        if (LOGGER.isDebugEnabled() && result != null) {
            FaceQSS qss = new FaceQSS();
            qss.setOverallComments(result.getOverallComments());
            qss.setOverallCompliance(result.getOverallCompliance());
            qss.setOverallScore(result.getOverallScore());
            qss.setQualityFeedback(result.getQualityFeedback());
            LOGGER.debug(ReflectionToStringBuilder.toString((Object)qss));
        }
        return result;
    }

    public FingerprintQSS getQSSDataForFingerprint(byte[] input, List<BiometricPosition> missingFingers) {
        this.debugDigest(input);
        FingerprintQSS result = Qssitv.getInst().getQSSDataForFingerprint(input, missingFingers);
        if (LOGGER.isDebugEnabled() && result != null) {
            FingerprintQSS qss = new FingerprintQSS();
            qss.setHandedness(result.getHandedness());
            qss.setOverallComments(result.getOverallComments());
            qss.setOverallConfidence(result.getOverallConfidence());
            qss.setOverallCompliance(result.getOverallCompliance());
            qss.setOverallScore(result.getOverallScore());
            qss.setQualityFeedback(result.getQualityFeedback());
            ArrayList<FingerSegment> segList = new ArrayList<FingerSegment>();
            for (FingerSegment segment : result.getFingerSegments()) {
                FingerSegment copySeg = new FingerSegment();
                copySeg.setBottomLeft(segment.getBottomLeft());
                copySeg.setBottomRight(segment.getBottomRight());
                copySeg.setFingerPosition(segment.getFingerPosition());
                copySeg.setQuality(segment.getQuality());
                copySeg.setTopLeft(segment.getTopLeft());
                copySeg.setTopRight(segment.getTopRight());
                segList.add(copySeg);
            }
            qss.setFingerSegments(segList);
            LOGGER.debug(ReflectionToStringBuilder.toString((Object)qss));
        }
        return result;
    }

    public List<IrisQSS> getQSSDataForIris(byte[] input) {
        this.debugDigest(input);
        List result = Qssitv.getInst().getQSSDataForIris(input);
        if (LOGGER.isDebugEnabled()) {
            for (IrisQSS qss : result) {
                LOGGER.debug(ReflectionToStringBuilder.toString((Object)qss));
            }
        }
        return result;
    }

    public byte[] convertISO(byte[] input, FormatType type) {
        this.debugDigest(input);
        return Qssitv.getInst().convertISO(input, type);
    }

    private void debugDigest(byte[] input) {
        if (LOGGER.isDebugEnabled()) {
            try {
                byte[] digest = MessageDigest.getInstance("SHA-256").digest(input);
                LOGGER.debug("digest for data received: " + new BigInteger(digest).toString(36).toUpperCase(Locale.getDefault()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

