/*
 * Decompiled with CFR 0.152.
 */
package boofcv.concurrency;

import boofcv.concurrency.IntOperatorTask;
import boofcv.concurrency.IntProducerNumber;
import boofcv.concurrency.IntRangeConsumer;
import boofcv.concurrency.IntRangeTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;

public class BoofConcurrency {
    public static boolean USE_CONCURRENT = true;
    private static ForkJoinPool pool = new ForkJoinPool();

    public static void setMaxThreads(int maxThreads) {
        pool = new ForkJoinPool(maxThreads);
    }

    public static int getMaxThreads() {
        return pool.getParallelism();
    }

    public static void loopFor(int start, int endExclusive, IntConsumer consumer) {
        try {
            ((ForkJoinTask)pool.submit(() -> IntStream.range(start, endExclusive).parallel().forEach(consumer))).get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }

    public static void loopBlocks(int start, int endExclusive, int minBlock, IntRangeConsumer consumer) {
        ForkJoinPool pool = BoofConcurrency.pool;
        int numThreads = pool.getParallelism();
        int range = endExclusive - start;
        if (range == 0) {
            return;
        }
        if (range < 0) {
            throw new IllegalArgumentException("end must be more than start. " + start + " -> " + endExclusive);
        }
        int block = BoofConcurrency.selectBlockSize(range, minBlock, numThreads);
        try {
            pool.submit(new IntRangeTask(start, endExclusive, block, consumer)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }

    static int selectBlockSize(int range, int minBlock, int numThreads) {
        int block = Math.max(minBlock, range / numThreads);
        int N = Math.max(1, range / block);
        return range / N;
    }

    public static void loopBlocks(int start, int endExclusive, IntRangeConsumer consumer) {
        ForkJoinPool pool = BoofConcurrency.pool;
        int numThreads = pool.getParallelism();
        int range = endExclusive - start;
        if (range == 0) {
            return;
        }
        if (range < 0) {
            throw new IllegalArgumentException("end must be more than start. " + start + " -> " + endExclusive);
        }
        int blockSize = Math.max(1, range / numThreads);
        try {
            pool.submit(new IntRangeTask(start, endExclusive, blockSize, consumer)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static Number sum(int start, int endExclusive, Class type, IntProducerNumber producer) {
        try {
            return pool.submit(new IntOperatorTask.Sum(start, endExclusive, type, producer)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static Number max(int start, int endExclusive, Class type, IntProducerNumber producer) {
        try {
            return pool.submit(new IntOperatorTask.Max(start, endExclusive, type, producer)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static Number min(int start, int endExclusive, Class type, IntProducerNumber producer) {
        try {
            return pool.submit(new IntOperatorTask.Min(start, endExclusive, type, producer)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

