/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.image;

import boofcv.core.image.FactoryGImageGray;
import boofcv.core.image.GImageGray;
import boofcv.core.image.GImageMultiBand;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.border.ImageBorder_IL_F32;
import boofcv.struct.border.ImageBorder_IL_F64;
import boofcv.struct.border.ImageBorder_IL_S32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedS16;
import boofcv.struct.image.InterleavedS32;
import boofcv.struct.image.InterleavedS64;
import boofcv.struct.image.InterleavedS8;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;

public class FactoryGImageMultiBand {
    public static GImageMultiBand wrap(ImageBase image) {
        if (image instanceof ImageGray) {
            return FactoryGImageMultiBand.wrap((ImageGray)image);
        }
        if (image instanceof Planar) {
            return FactoryGImageMultiBand.wrap((Planar)image);
        }
        if (image instanceof ImageInterleaved) {
            return FactoryGImageMultiBand.wrap((ImageInterleaved)image);
        }
        throw new RuntimeException("Unknown image type");
    }

    public static GImageMultiBand wrap(ImageGray image) {
        return new GSingleToMB(FactoryGImageGray.wrap(image));
    }

    public static GImageMultiBand create(ImageType imageType) {
        if (imageType.getFamily() == ImageType.Family.GRAY) {
            return new GSingleToMB(FactoryGImageGray.create(imageType.getImageClass()));
        }
        if (imageType.getFamily() == ImageType.Family.PLANAR) {
            return new PL();
        }
        if (imageType.getFamily() == ImageType.Family.INTERLEAVED) {
            switch (imageType.getDataType()) {
                case U8: {
                    return new IL_U8();
                }
                case S8: {
                    return new IL_S8();
                }
                case F32: {
                    return new IL_F32();
                }
            }
            throw new IllegalArgumentException("Need to support more data types");
        }
        throw new RuntimeException("Add support for more families");
    }

    public static GImageMultiBand wrap(Planar image) {
        return new PL(image);
    }

    public static GImageMultiBand wrap(ImageInterleaved image) {
        switch (image.getDataType()) {
            case U8: {
                return new IL_U8((InterleavedU8)image);
            }
            case S8: {
                return new IL_S8((InterleavedS8)image);
            }
            case U16: {
                return new IL_U16((InterleavedU16)image);
            }
            case S16: {
                return new IL_S16((InterleavedS16)image);
            }
            case S32: {
                return new IL_S32((InterleavedS32)image);
            }
            case S64: {
                return new IL_S64((InterleavedS64)image);
            }
            case F32: {
                return new IL_F32((InterleavedF32)image);
            }
            case F64: {
                return new IL_F64((InterleavedF64)image);
            }
        }
        throw new IllegalArgumentException("Need to support more data types: " + (Object)((Object)image.getDataType()));
    }

    public static GImageMultiBand wrap(ImageBorder image) {
        if (image instanceof ImageBorder_IL_S32) {
            return new Border_IL_S32((ImageBorder_IL_S32)image);
        }
        if (image instanceof ImageBorder_IL_F32) {
            return new Border_IL_F32((ImageBorder_IL_F32)image);
        }
        if (image instanceof ImageBorder_IL_F64) {
            return new Border_IL_F64((ImageBorder_IL_F64)image);
        }
        throw new IllegalArgumentException("Not supported yet?");
    }

    public static abstract class GMultiBorder<T extends ImageBorder>
    implements GImageMultiBand {
        protected T image;

        public GMultiBorder(T image) {
            this.image = image;
        }

        @Override
        public void wrap(ImageBase image) {
            ((ImageBorder)((Object)this.image)).setImage((ImageBase)image);
        }

        @Override
        public int getWidth() {
            return ((ImageBase)((ImageBorder)this.image).getImage()).getWidth();
        }

        @Override
        public int getHeight() {
            return ((ImageBase)((ImageBorder)this.image).getImage()).getHeight();
        }

        public ImageMultiBand getImage() {
            return (ImageMultiBand)((ImageBorder)this.image).getImage();
        }

        @Override
        public int getPixelStride() {
            throw new RuntimeException("Not supported");
        }

        @Override
        public int getIndex(int x, int y) {
            throw new RuntimeException("Not supported");
        }

        @Override
        public void setF(int index, float[] value) {
            throw new RuntimeException("Not supported");
        }

        @Override
        public void getF(int index, float[] value) {
            throw new RuntimeException("Not supported");
        }

        @Override
        public float getF(int index) {
            throw new RuntimeException("Not supported");
        }
    }

    public static class Border_IL_F64
    extends GMultiBorder<ImageBorder_IL_F64> {
        public Border_IL_F64(ImageBorder_IL_F64 image) {
            super(image);
        }

        @Override
        public int getNumberOfBands() {
            return ((ImageMultiBand)((ImageBorder_IL_F64)this.image).getImage()).getNumBands();
        }

        @Override
        public void set(int x, int y, float[] value) {
            double[] value_d = BoofMiscOps.convertArray(value, (double[])null);
            ((ImageBorder_IL_F64)this.image).set(x, y, value_d);
        }

        @Override
        public void get(int x, int y, float[] value) {
            double[] value_d = new double[value.length];
            ((ImageBorder_IL_F64)this.image).get(x, y, value_d);
            BoofMiscOps.convertArray(value_d, value);
        }

        @Override
        public Number get(int x, int y, int band) {
            double[] value_d = new double[((InterleavedF64)((ImageBorder_IL_F64)this.image).getImage()).getImageType().numBands];
            ((ImageBorder_IL_F64)this.image).get(x, y, value_d);
            return value_d[band];
        }
    }

    public static class Border_IL_F32
    extends GMultiBorder<ImageBorder_IL_F32> {
        public Border_IL_F32(ImageBorder_IL_F32 image) {
            super(image);
        }

        @Override
        public int getNumberOfBands() {
            return ((ImageMultiBand)((ImageBorder_IL_F32)this.image).getImage()).getNumBands();
        }

        @Override
        public void set(int x, int y, float[] value) {
            ((ImageBorder_IL_F32)this.image).set(x, y, value);
        }

        @Override
        public void get(int x, int y, float[] value) {
            ((ImageBorder_IL_F32)this.image).get(x, y, value);
        }

        @Override
        public Number get(int x, int y, int band) {
            float[] value_d = new float[((InterleavedF32)((ImageBorder_IL_F32)this.image).getImage()).getImageType().numBands];
            ((ImageBorder_IL_F32)this.image).get(x, y, value_d);
            return Float.valueOf(value_d[band]);
        }
    }

    public static class Border_IL_S32
    extends GMultiBorder<ImageBorder_IL_S32> {
        public Border_IL_S32(ImageBorder_IL_S32 image) {
            super(image);
        }

        @Override
        public int getNumberOfBands() {
            return ((ImageMultiBand)((ImageBorder_IL_S32)this.image).getImage()).getNumBands();
        }

        @Override
        public void set(int x, int y, float[] value) {
            int[] value_d = BoofMiscOps.convertArray(value, (int[])null);
            ((ImageBorder_IL_S32)this.image).set(x, y, value_d);
        }

        @Override
        public void get(int x, int y, float[] value) {
            int[] value_d = new int[value.length];
            ((ImageBorder_IL_S32)this.image).get(x, y, value_d);
            BoofMiscOps.convertArray(value_d, value);
        }

        @Override
        public Number get(int x, int y, int band) {
            int[] value_d = new int[((ImageBase)((ImageBorder_IL_S32)this.image).getImage()).getImageType().numBands];
            ((ImageBorder_IL_S32)this.image).get(x, y, value_d);
            return value_d[band];
        }
    }

    public static class IL_F64
    extends IL<InterleavedF64> {
        public IL_F64(InterleavedF64 image) {
            this.wrap(image);
        }

        public IL_F64() {
        }

        @Override
        public void set(int x, int y, float[] value) {
            this.setF(((InterleavedF64)this.image).getIndex(x, y), value);
        }

        @Override
        public void get(int x, int y, float[] value) {
            this.getF(((InterleavedF64)this.image).getIndex(x, y), value);
        }

        @Override
        public Number get(int x, int y, int band) {
            return ((InterleavedF64)this.image).data[((InterleavedF64)this.image).getIndex(x, y, band)];
        }

        @Override
        public void setF(int index, float[] value) {
            for (int i = 0; i < ((InterleavedF64)this.image).getNumBands(); ++i) {
                ((InterleavedF64)this.image).data[index++] = value[i];
            }
        }

        @Override
        public void getF(int index, float[] value) {
            for (int i = 0; i < ((InterleavedF64)this.image).getNumBands(); ++i) {
                value[i] = (float)((InterleavedF64)this.image).data[index++];
            }
        }

        @Override
        public float getF(int index) {
            return (float)((InterleavedF64)this.image).data[index];
        }
    }

    public static class IL_F32
    extends IL<InterleavedF32> {
        public IL_F32(InterleavedF32 image) {
            this.wrap(image);
        }

        public IL_F32() {
        }

        @Override
        public void set(int x, int y, float[] value) {
            this.setF(((InterleavedF32)this.image).getIndex(x, y), value);
        }

        @Override
        public void get(int x, int y, float[] value) {
            this.getF(((InterleavedF32)this.image).getIndex(x, y), value);
        }

        @Override
        public Number get(int x, int y, int band) {
            return Float.valueOf(((InterleavedF32)this.image).data[((InterleavedF32)this.image).getIndex(x, y, band)]);
        }

        @Override
        public void setF(int index, float[] value) {
            for (int i = 0; i < ((InterleavedF32)this.image).getNumBands(); ++i) {
                ((InterleavedF32)this.image).data[index++] = value[i];
            }
        }

        @Override
        public void getF(int index, float[] value) {
            for (int i = 0; i < ((InterleavedF32)this.image).getNumBands(); ++i) {
                value[i] = ((InterleavedF32)this.image).data[index++];
            }
        }

        @Override
        public float getF(int index) {
            return ((InterleavedF32)this.image).data[index];
        }
    }

    public static class IL_S64
    extends IL<InterleavedS64> {
        public IL_S64(InterleavedS64 image) {
            this.wrap(image);
        }

        public IL_S64() {
        }

        @Override
        public void set(int x, int y, float[] value) {
            this.setF(((InterleavedS64)this.image).getIndex(x, y), value);
        }

        @Override
        public void get(int x, int y, float[] value) {
            this.getF(((InterleavedS64)this.image).getIndex(x, y), value);
        }

        @Override
        public Number get(int x, int y, int band) {
            return ((InterleavedS64)this.image).data[((InterleavedS64)this.image).getIndex(x, y, band)];
        }

        @Override
        public void setF(int index, float[] value) {
            for (int i = 0; i < ((InterleavedS64)this.image).getNumBands(); ++i) {
                ((InterleavedS64)this.image).data[index++] = (long)value[i];
            }
        }

        @Override
        public void getF(int index, float[] value) {
            for (int i = 0; i < ((InterleavedS64)this.image).getNumBands(); ++i) {
                value[i] = ((InterleavedS64)this.image).data[index++];
            }
        }

        @Override
        public float getF(int index) {
            return ((InterleavedS64)this.image).data[index];
        }
    }

    public static class IL_S32
    extends IL<InterleavedS32> {
        public IL_S32(InterleavedS32 image) {
            this.wrap(image);
        }

        public IL_S32() {
        }

        @Override
        public void set(int x, int y, float[] value) {
            this.setF(((InterleavedS32)this.image).getIndex(x, y), value);
        }

        @Override
        public void get(int x, int y, float[] value) {
            this.getF(((InterleavedS32)this.image).getIndex(x, y), value);
        }

        @Override
        public Number get(int x, int y, int band) {
            return ((InterleavedS32)this.image).data[((InterleavedS32)this.image).getIndex(x, y, band)];
        }

        @Override
        public void setF(int index, float[] value) {
            for (int i = 0; i < ((InterleavedS32)this.image).getNumBands(); ++i) {
                ((InterleavedS32)this.image).data[index++] = (int)value[i];
            }
        }

        @Override
        public void getF(int index, float[] value) {
            for (int i = 0; i < ((InterleavedS32)this.image).getNumBands(); ++i) {
                value[i] = ((InterleavedS32)this.image).data[index++];
            }
        }

        @Override
        public float getF(int index) {
            return ((InterleavedS32)this.image).data[index];
        }
    }

    public static class IL_S16
    extends IL<InterleavedS16> {
        public IL_S16(InterleavedS16 image) {
            this.wrap(image);
        }

        public IL_S16() {
        }

        @Override
        public void set(int x, int y, float[] value) {
            this.setF(((InterleavedS16)this.image).getIndex(x, y), value);
        }

        @Override
        public void get(int x, int y, float[] value) {
            this.getF(((InterleavedS16)this.image).getIndex(x, y), value);
        }

        @Override
        public Number get(int x, int y, int band) {
            return ((InterleavedS16)this.image).data[((InterleavedS16)this.image).getIndex(x, y, band)];
        }

        @Override
        public void setF(int index, float[] value) {
            for (int i = 0; i < ((InterleavedS16)this.image).getNumBands(); ++i) {
                ((InterleavedS16)this.image).data[index++] = (short)value[i];
            }
        }

        @Override
        public void getF(int index, float[] value) {
            for (int i = 0; i < ((InterleavedS16)this.image).getNumBands(); ++i) {
                value[i] = ((InterleavedS16)this.image).data[index++];
            }
        }

        @Override
        public float getF(int index) {
            return ((InterleavedS16)this.image).data[index];
        }
    }

    public static class IL_U16
    extends IL<InterleavedU16> {
        public IL_U16(InterleavedU16 image) {
            this.wrap(image);
        }

        public IL_U16() {
        }

        @Override
        public void set(int x, int y, float[] value) {
            this.setF(((InterleavedU16)this.image).getIndex(x, y), value);
        }

        @Override
        public void get(int x, int y, float[] value) {
            this.getF(((InterleavedU16)this.image).getIndex(x, y), value);
        }

        @Override
        public Number get(int x, int y, int band) {
            return ((InterleavedU16)this.image).data[((InterleavedU16)this.image).getIndex(x, y, band)] & 0xFFFF;
        }

        @Override
        public void setF(int index, float[] value) {
            for (int i = 0; i < ((InterleavedU16)this.image).getNumBands(); ++i) {
                ((InterleavedU16)this.image).data[index++] = (short)value[i];
            }
        }

        @Override
        public void getF(int index, float[] value) {
            for (int i = 0; i < ((InterleavedU16)this.image).getNumBands(); ++i) {
                value[i] = ((InterleavedU16)this.image).data[index++] & 0xFFFF;
            }
        }

        @Override
        public float getF(int index) {
            return ((InterleavedU16)this.image).data[index] & 0xFF;
        }
    }

    public static class IL_S8
    extends IL<InterleavedS8> {
        public IL_S8(InterleavedS8 image) {
            this.wrap(image);
        }

        public IL_S8() {
        }

        @Override
        public void set(int x, int y, float[] value) {
            this.setF(((InterleavedS8)this.image).getIndex(x, y), value);
        }

        @Override
        public void get(int x, int y, float[] value) {
            this.getF(((InterleavedS8)this.image).getIndex(x, y), value);
        }

        @Override
        public Number get(int x, int y, int band) {
            return ((InterleavedS8)this.image).data[((InterleavedS8)this.image).getIndex(x, y, band)];
        }

        @Override
        public void setF(int index, float[] value) {
            for (int i = 0; i < ((InterleavedS8)this.image).getNumBands(); ++i) {
                ((InterleavedS8)this.image).data[index++] = (byte)value[i];
            }
        }

        @Override
        public void getF(int index, float[] value) {
            for (int i = 0; i < ((InterleavedS8)this.image).getNumBands(); ++i) {
                value[i] = ((InterleavedS8)this.image).data[index++];
            }
        }

        @Override
        public float getF(int index) {
            return ((InterleavedS8)this.image).data[index];
        }
    }

    public static class IL_U8
    extends IL<InterleavedU8> {
        public IL_U8(InterleavedU8 image) {
            this.wrap(image);
        }

        public IL_U8() {
        }

        @Override
        public void set(int x, int y, float[] value) {
            this.setF(((InterleavedU8)this.image).getIndex(x, y), value);
        }

        @Override
        public void get(int x, int y, float[] value) {
            this.getF(((InterleavedU8)this.image).getIndex(x, y), value);
        }

        @Override
        public Number get(int x, int y, int band) {
            return ((InterleavedU8)this.image).data[((InterleavedU8)this.image).getIndex(x, y, band)] & 0xFF;
        }

        @Override
        public void setF(int index, float[] value) {
            for (int i = 0; i < ((InterleavedU8)this.image).getNumBands(); ++i) {
                ((InterleavedU8)this.image).data[index++] = (byte)value[i];
            }
        }

        @Override
        public void getF(int index, float[] value) {
            for (int i = 0; i < ((InterleavedU8)this.image).getNumBands(); ++i) {
                value[i] = ((InterleavedU8)this.image).data[index++] & 0xFF;
            }
        }

        @Override
        public float getF(int index) {
            return ((InterleavedU8)this.image).data[index] & 0xFF;
        }
    }

    public static abstract class IL<T extends ImageInterleaved<T>>
    implements GImageMultiBand {
        T image;

        @Override
        public void wrap(ImageBase image) {
            this.image = (ImageInterleaved)image;
        }

        @Override
        public int getWidth() {
            return ((ImageBase)this.image).getWidth();
        }

        @Override
        public int getHeight() {
            return ((ImageBase)this.image).getHeight();
        }

        @Override
        public int getNumberOfBands() {
            return ((ImageInterleaved)this.image).getNumBands();
        }

        @Override
        public int getPixelStride() {
            return ((ImageInterleaved)this.image).getNumBands();
        }

        @Override
        public int getIndex(int x, int y) {
            return ((ImageInterleaved)this.image).getIndex(x, y);
        }

        @Override
        public <T extends ImageBase<T>> T getImage() {
            return this.image;
        }
    }

    public static class GSingleToMB
    implements GImageMultiBand {
        GImageGray sb;

        public GSingleToMB(GImageGray sb) {
            this.sb = sb;
        }

        @Override
        public void wrap(ImageBase image) {
            if (this.sb == null) {
                this.sb = FactoryGImageGray.wrap((ImageGray)image);
            } else {
                this.sb.wrap((ImageGray)image);
            }
        }

        @Override
        public int getWidth() {
            return this.sb.getWidth();
        }

        @Override
        public int getHeight() {
            return this.sb.getHeight();
        }

        @Override
        public int getNumberOfBands() {
            return 1;
        }

        @Override
        public int getPixelStride() {
            return 1;
        }

        @Override
        public int getIndex(int x, int y) {
            return this.sb.getImage().getIndex(x, y);
        }

        @Override
        public void set(int x, int y, float[] value) {
            this.sb.set(x, y, Float.valueOf(value[0]));
        }

        @Override
        public void get(int x, int y, float[] value) {
            value[0] = this.sb.unsafe_getF(x, y);
        }

        @Override
        public Number get(int x, int y, int band) {
            if (band != 0) {
                throw new IllegalArgumentException("Must be band 0");
            }
            return this.sb.get(x, y);
        }

        @Override
        public void setF(int index, float[] value) {
            this.sb.set(index, value[0]);
        }

        @Override
        public void getF(int index, float[] value) {
            value[0] = this.sb.getF(index);
        }

        @Override
        public float getF(int index) {
            return this.sb.getF(index);
        }

        @Override
        public <T extends ImageBase<T>> T getImage() {
            return (T)this.sb.getImage();
        }
    }

    public static class PL
    implements GImageMultiBand {
        Planar image;
        GImageGray[] bandWrappers;

        public PL(Planar image) {
            this.wrap(image);
        }

        public PL() {
        }

        @Override
        public void wrap(ImageBase image) {
            if (this.image == null) {
                this.image = (Planar)image;
                this.bandWrappers = new GImageGray[this.image.getNumBands()];
                for (int i = 0; i < this.bandWrappers.length; ++i) {
                    this.bandWrappers[i] = FactoryGImageGray.wrap(this.image.getBand(i));
                }
            } else {
                this.image = (Planar)image;
                for (int i = 0; i < this.bandWrappers.length; ++i) {
                    this.bandWrappers[i].wrap((ImageGray)this.image.getBand(i));
                }
            }
        }

        @Override
        public int getWidth() {
            return this.image.getWidth();
        }

        @Override
        public int getHeight() {
            return this.image.getHeight();
        }

        @Override
        public int getNumberOfBands() {
            return this.image.getNumBands();
        }

        @Override
        public int getPixelStride() {
            return 1;
        }

        @Override
        public int getIndex(int x, int y) {
            return this.image.getIndex(x, y);
        }

        @Override
        public void set(int x, int y, float[] value) {
            int index = this.image.getIndex(x, y);
            this.setF(index, value);
        }

        @Override
        public void get(int x, int y, float[] value) {
            int index = this.image.getIndex(x, y);
            this.getF(index, value);
        }

        @Override
        public Number get(int x, int y, int band) {
            return this.bandWrappers[band].get(x, y);
        }

        @Override
        public void setF(int index, float[] value) {
            for (int i = 0; i < this.image.getNumBands(); ++i) {
                this.bandWrappers[i].set(index, value[i]);
            }
        }

        @Override
        public void getF(int index, float[] value) {
            for (int i = 0; i < this.image.getNumBands(); ++i) {
                value[i] = this.bandWrappers[i].getF(index);
            }
        }

        @Override
        public float getF(int index) {
            throw new RuntimeException("Not supported for Planar images.  Would be slow.");
        }

        @Override
        public <T extends ImageBase<T>> T getImage() {
            return (T)this.image;
        }
    }
}

