/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.struct.image.ImageAccessException;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.InterleavedI8;

public class InterleavedU8
extends InterleavedI8<InterleavedU8> {
    public InterleavedU8(int width, int height, int numBands) {
        super(width, height, numBands);
    }

    public InterleavedU8() {
    }

    @Override
    public ImageDataType getDataType() {
        return ImageDataType.U8;
    }

    public int get32(int x, int y) {
        int i = this.startIndex + y * this.stride + x * 4;
        return (this.data[i] & 0xFF) << 24 | (this.data[i + 1] & 0xFF) << 16 | (this.data[i + 2] & 0xFF) << 8 | this.data[i + 3] & 0xFF;
    }

    public int get24(int x, int y) {
        int i = this.startIndex + y * this.stride + x * 3;
        return (this.data[i] & 0xFF) << 16 | (this.data[i + 1] & 0xFF) << 8 | this.data[i + 2] & 0xFF;
    }

    public void set24(int x, int y, int value) {
        int i = this.startIndex + y * this.stride + x * 3;
        this.data[i++] = (byte)(value >>> 16);
        this.data[i++] = (byte)(value >>> 8);
        this.data[i] = (byte)value;
    }

    public void set32(int x, int y, int value) {
        int i = this.startIndex + y * this.stride + x * 4;
        this.data[i++] = (byte)(value >>> 24);
        this.data[i++] = (byte)(value >>> 16);
        this.data[i++] = (byte)(value >>> 8);
        this.data[i] = (byte)value;
    }

    @Override
    public int getBand(int x, int y, int band) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds.");
        }
        if (band < 0 || band >= this.numBands) {
            throw new ImageAccessException("Invalid band requested.");
        }
        return this.data[this.getIndex(x, y, band)] & 0xFF;
    }

    @Override
    public void unsafe_get(int x, int y, int[] storage) {
        int index = this.getIndex(x, y, 0);
        int i = 0;
        while (i < this.numBands) {
            storage[i] = this.data[index] & 0xFF;
            ++i;
            ++index;
        }
    }

    @Override
    public InterleavedU8 createNew(int imgWidth, int imgHeight) {
        if (imgWidth == -1 || imgHeight == -1) {
            return new InterleavedU8();
        }
        return new InterleavedU8(imgWidth, imgHeight, this.numBands);
    }
}

