/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.describe;

import boofcv.abst.feature.describe.ConvertTupleDesc;
import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class DescribeRegionPointConvert<T extends ImageGray<T>, In extends TupleDesc, Out extends TupleDesc>
implements DescribeRegionPoint<T, Out> {
    DescribeRegionPoint<T, In> original;
    ConvertTupleDesc<In, Out> converter;
    In storage;

    public DescribeRegionPointConvert(DescribeRegionPoint<T, In> original, ConvertTupleDesc<In, Out> converter) {
        this.original = original;
        this.converter = converter;
        this.storage = original.createDescription();
    }

    @Override
    public void setImage(T image) {
        this.original.setImage(image);
    }

    @Override
    public Out createDescription() {
        return this.converter.createOutput();
    }

    @Override
    public boolean process(double x, double y, double orientation, double radius, Out storage) {
        if (!this.original.process(x, y, orientation, radius, this.storage)) {
            return false;
        }
        this.converter.convert(this.storage, storage);
        return true;
    }

    @Override
    public boolean requiresRadius() {
        return this.original.requiresRadius();
    }

    @Override
    public boolean requiresOrientation() {
        return this.original.requiresOrientation();
    }

    @Override
    public ImageType<T> getImageType() {
        return this.original.getImageType();
    }

    @Override
    public double getCanonicalWidth() {
        return this.original.getCanonicalWidth();
    }

    @Override
    public Class<Out> getDescriptionType() {
        return this.converter.getOutputType();
    }
}

