/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detect.line;

import boofcv.abst.feature.detect.extract.ConfigExtract;
import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.abst.feature.detect.line.DetectLine;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.feature.detect.edge.GGradientToEdgeFeatures;
import boofcv.alg.feature.detect.line.HoughTransformLinePolar;
import boofcv.alg.feature.detect.line.ImageLinePruneMerge;
import boofcv.alg.filter.binary.ThresholdImageOps;
import boofcv.factory.feature.detect.extract.FactoryFeatureExtractor;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import georegression.struct.line.LineParametric2D_F32;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;

public class DetectLineHoughPolar<I extends ImageGray<I>, D extends ImageGray<D>>
implements DetectLine<I> {
    HoughTransformLinePolar alg;
    NonMaxSuppression extractor;
    ImageGradient<I, D> gradient;
    float thresholdEdge;
    D derivX;
    D derivY;
    GrayF32 intensity = new GrayF32(1, 1);
    GrayU8 binary = new GrayU8(1, 1);
    GrayF32 suppressed = new GrayF32(1, 1);
    float pruneAngleTol;
    float pruneRangeTol;
    double resolutionRange;
    double resolutionAngle;
    int localMaxRadius;
    int maxLines;
    ImageLinePruneMerge post = new ImageLinePruneMerge();

    public DetectLineHoughPolar(int localMaxRadius, int minCounts, double resolutionRange, double resolutionAngle, float thresholdEdge, int maxLines, ImageGradient<I, D> gradient) {
        this.pruneAngleTol = (float)((double)(localMaxRadius + 1) * resolutionAngle);
        this.pruneRangeTol = (float)((double)(localMaxRadius + 1) * resolutionRange);
        this.localMaxRadius = localMaxRadius;
        this.gradient = gradient;
        this.thresholdEdge = thresholdEdge;
        this.resolutionRange = resolutionRange;
        this.resolutionAngle = resolutionAngle;
        this.maxLines = maxLines <= 0 ? Integer.MAX_VALUE : maxLines;
        this.extractor = FactoryFeatureExtractor.nonmax(new ConfigExtract(localMaxRadius, minCounts, 0, false));
        this.derivX = (ImageGray)gradient.getDerivativeType().createImage(1, 1);
        this.derivY = (ImageGray)gradient.getDerivativeType().createImage(1, 1);
    }

    @Override
    public List<LineParametric2D_F32> detect(I input) {
        if (((ImageGray)this.derivX).width != ((ImageGray)input).width || ((ImageGray)this.derivY).height != ((ImageGray)input).height) {
            double r = Math.sqrt(((ImageGray)input).width * ((ImageGray)input).width + ((ImageGray)input).height * ((ImageGray)input).height);
            int numBinsRange = (int)Math.ceil(r / this.resolutionRange);
            int numBinsAngle = (int)Math.ceil(Math.PI / this.resolutionAngle);
            this.alg = new HoughTransformLinePolar(this.extractor, numBinsRange, numBinsAngle);
            this.derivX.reshape(((ImageGray)input).width, ((ImageGray)input).height);
            this.derivY.reshape(((ImageGray)input).width, ((ImageGray)input).height);
            this.intensity.reshape(((ImageGray)input).width, ((ImageGray)input).height);
            this.binary.reshape(((ImageGray)input).width, ((ImageGray)input).height);
            this.suppressed.reshape(((ImageGray)input).width, ((ImageGray)input).height);
        }
        this.gradient.process(input, this.derivX, this.derivY);
        GGradientToEdgeFeatures.intensityAbs(this.derivX, this.derivY, this.intensity);
        GGradientToEdgeFeatures.nonMaxSuppressionCrude4(this.intensity, this.derivX, this.derivY, this.suppressed);
        ThresholdImageOps.threshold((GrayF32)this.suppressed, (GrayU8)this.binary, (float)this.thresholdEdge, (boolean)false);
        this.alg.transform(this.binary);
        FastQueue<LineParametric2D_F32> lines = this.alg.extractLines();
        List<LineParametric2D_F32> ret = new ArrayList<LineParametric2D_F32>();
        for (int i = 0; i < lines.size; ++i) {
            ret.add((LineParametric2D_F32)lines.get(i));
        }
        ret = this.pruneLines(input, ret);
        return ret;
    }

    private List<LineParametric2D_F32> pruneLines(I input, List<LineParametric2D_F32> ret) {
        float[] intensity = this.alg.getFoundIntensity();
        this.post.reset();
        for (int i = 0; i < ret.size(); ++i) {
            this.post.add(ret.get(i), intensity[i]);
        }
        this.post.pruneSimilar(this.pruneAngleTol, this.pruneRangeTol, ((ImageGray)input).width, ((ImageGray)input).height);
        this.post.pruneNBest(this.maxLines);
        return this.post.createList();
    }

    public HoughTransformLinePolar getTransform() {
        return this.alg;
    }

    public D getDerivX() {
        return this.derivX;
    }

    public D getDerivY() {
        return this.derivY;
    }

    public GrayF32 getEdgeIntensity() {
        return this.intensity;
    }

    public GrayU8 getBinary() {
        return this.binary;
    }
}

