/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background.moving;

import boofcv.alg.background.moving.BackgroundMovingGaussian;
import boofcv.alg.interpolate.InterpolatePixelMB;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.core.image.FactoryGImageGray;
import boofcv.core.image.GImageGray;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.border.BorderType;
import boofcv.struct.distort.Point2Transform2Model_F32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import georegression.struct.InvertibleTransform;

public class BackgroundMovingGaussian_SB<T extends ImageGray<T>, Motion extends InvertibleTransform<Motion>>
extends BackgroundMovingGaussian<T, Motion> {
    protected InterpolatePixelS<T> interpolateInput;
    protected InterpolatePixelMB<Planar<GrayF32>> interpolationBG;
    protected GImageGray inputWrapper;
    protected float[] pixelBG = new float[2];
    Planar<GrayF32> background = new Planar(GrayF32.class, 1, 1, 2);

    public BackgroundMovingGaussian_SB(float learnRate, float threshold, Point2Transform2Model_F32<Motion> transform, InterpolationType interpType, Class<T> imageType) {
        super(learnRate, threshold, transform, ImageType.single(imageType));
        this.interpolateInput = FactoryInterpolation.bilinearPixelS(imageType, (BorderType)BorderType.EXTENDED);
        this.interpolationBG = FactoryInterpolation.createPixelMB((double)0.0, (double)255.0, (InterpolationType)interpType, (BorderType)BorderType.EXTENDED, (ImageType)ImageType.pl((int)2, GrayF32.class));
        this.interpolationBG.setImage(this.background);
        this.inputWrapper = FactoryGImageGray.create(imageType);
    }

    @Override
    public void initialize(int backgroundWidth, int backgroundHeight, Motion homeToWorld) {
        this.background.reshape(backgroundWidth, backgroundHeight);
        GImageMiscOps.fill((ImageBase)this.background.getBand(0), (double)0.0);
        GImageMiscOps.fill((ImageBase)this.background.getBand(1), (double)-1.0);
        this.homeToWorld.set(homeToWorld);
        this.homeToWorld.invert(this.worldToHome);
        this.backgroundWidth = backgroundWidth;
        this.backgroundHeight = backgroundHeight;
    }

    @Override
    public void reset() {
        GImageMiscOps.fill((ImageBase)this.background.getBand(0), (double)0.0);
        GImageMiscOps.fill((ImageBase)this.background.getBand(1), (double)-1.0);
    }

    @Override
    protected void updateBackground(int x0, int y0, int x1, int y1, T frame) {
        this.transform.setModel((Object)this.worldToCurrent);
        this.interpolateInput.setImage(frame);
        float minusLearn = 1.0f - this.learnRate;
        GrayF32 backgroundMean = (GrayF32)this.background.getBand(0);
        GrayF32 backgroundVar = (GrayF32)this.background.getBand(1);
        for (int y = y0; y < y1; ++y) {
            int indexBG = this.background.startIndex + y * this.background.stride + x0;
            int x = x0;
            while (x < x1) {
                this.transform.compute((float)x, (float)y, this.work);
                if (this.work.x >= 0.0f && this.work.x < (float)((ImageGray)frame).width && this.work.y >= 0.0f && this.work.y < (float)((ImageGray)frame).height) {
                    float inputValue = this.interpolateInput.get(this.work.x, this.work.y);
                    float meanBG = backgroundMean.data[indexBG];
                    float varianceBG = backgroundVar.data[indexBG];
                    if (varianceBG < 0.0f) {
                        backgroundMean.data[indexBG] = inputValue;
                        backgroundVar.data[indexBG] = this.initialVariance;
                    } else {
                        float diff = meanBG - inputValue;
                        backgroundMean.data[indexBG] = minusLearn * meanBG + this.learnRate * inputValue;
                        backgroundVar.data[indexBG] = minusLearn * varianceBG + this.learnRate * diff * diff;
                    }
                }
                ++x;
                ++indexBG;
            }
        }
    }

    @Override
    protected void _segment(Motion currentToWorld, T frame, GrayU8 segmented) {
        this.transform.setModel(currentToWorld);
        this.inputWrapper.wrap(frame);
        for (int y = 0; y < ((ImageGray)frame).height; ++y) {
            int indexFrame = ((ImageGray)frame).startIndex + y * ((ImageGray)frame).stride;
            int indexSegmented = segmented.startIndex + y * segmented.stride;
            int x = 0;
            while (x < ((ImageGray)frame).width) {
                this.transform.compute((float)x, (float)y, this.work);
                if (this.work.x >= 0.0f && this.work.x < (float)this.background.width && this.work.y >= 0.0f && this.work.y < (float)this.background.height) {
                    float diff;
                    float chisq;
                    this.interpolationBG.get(this.work.x, this.work.y, this.pixelBG);
                    float pixelFrame = this.inputWrapper.getF(indexFrame);
                    float meanBG = this.pixelBG[0];
                    float varBG = this.pixelBG[1];
                    segmented.data[indexSegmented] = varBG < 0.0f ? this.unknownValue : ((chisq = (diff = meanBG - pixelFrame) * diff / varBG) <= this.threshold ? (byte)0 : (diff > this.minimumDifference || -diff > this.minimumDifference ? (byte)1 : 0));
                } else {
                    segmented.data[indexSegmented] = this.unknownValue;
                }
                ++x;
                ++indexFrame;
                ++indexSegmented;
            }
        }
    }
}

