/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.associate;

import boofcv.abst.feature.associate.AssociateDescription;
import boofcv.abst.feature.associate.AssociateThreeDescription;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.AssociatedTripleIndex;
import boofcv.struct.feature.MatchScoreType;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;

public class AssociateThreeByPairs<Desc>
implements AssociateThreeDescription<Desc> {
    protected AssociateDescription<Desc> associator;
    protected FastQueue<Desc> featuresA;
    protected FastQueue<Desc> featuresB;
    protected FastQueue<Desc> featuresC;
    protected FastQueue<Desc> tmpB;
    protected FastQueue<Desc> tmpA;
    protected FastQueue<AssociatedTripleIndex> matches = new FastQueue(AssociatedTripleIndex.class, true);
    protected GrowQueue_I32 srcToC = new GrowQueue_I32();

    public AssociateThreeByPairs(AssociateDescription<Desc> associator, Class<Desc> type) {
        if (!associator.uniqueDestination() || !associator.uniqueSource()) {
            throw new IllegalArgumentException("Both source and destination need to be unique");
        }
        this.associator = associator;
        this.tmpB = new FastQueue(type, false);
        this.tmpA = new FastQueue(type, false);
    }

    @Override
    public void setFeaturesA(FastQueue<Desc> features) {
        this.featuresA = features;
    }

    @Override
    public void setFeaturesB(FastQueue<Desc> features) {
        this.featuresB = features;
    }

    @Override
    public void setFeaturesC(FastQueue<Desc> features) {
        this.featuresC = features;
    }

    @Override
    public void associate() {
        int i;
        this.matches.reset();
        this.associator.setSource(this.featuresA);
        this.associator.setDestination(this.featuresB);
        this.associator.associate();
        FastQueue<AssociatedIndex> pairs = this.associator.getMatches();
        this.tmpB.reset();
        this.tmpA.reset();
        for (int i2 = 0; i2 < pairs.size; ++i2) {
            AssociatedIndex p = (AssociatedIndex)pairs.get(i2);
            ((AssociatedTripleIndex)this.matches.grow()).set(p.src, p.dst, -1);
            this.tmpA.add(this.featuresA.data[p.src]);
            this.tmpB.add(this.featuresB.data[p.dst]);
        }
        this.associator.setSource(this.tmpB);
        this.associator.setDestination(this.featuresC);
        this.associator.associate();
        pairs = this.associator.getMatches();
        this.tmpB.reset();
        this.srcToC.resize(pairs.size);
        FastQueue<Desc> tmpC = this.tmpB;
        for (int i3 = 0; i3 < pairs.size; ++i3) {
            AssociatedIndex p = (AssociatedIndex)pairs.get(i3);
            ((AssociatedTripleIndex)this.matches.get((int)p.src)).c = p.dst;
            tmpC.add(this.featuresC.data[p.dst]);
            this.srcToC.data[i3] = p.dst;
        }
        GrowQueue_I32 unsrc = this.associator.getUnassociatedSource();
        for (i = 0; i < unsrc.size; ++i) {
            int idx = unsrc.get(i);
            ((AssociatedTripleIndex)this.matches.get((int)idx)).c = -1;
        }
        this.associator.setSource(tmpC);
        this.associator.setDestination(this.tmpA);
        this.associator.associate();
        pairs = this.associator.getMatches();
        for (i = 0; i < pairs.size; ++i) {
            AssociatedIndex p = (AssociatedIndex)pairs.get(i);
            AssociatedTripleIndex t = (AssociatedTripleIndex)this.matches.get(p.dst);
            if (((AssociatedTripleIndex)this.matches.get((int)p.dst)).c == this.srcToC.data[p.src]) continue;
            t.c = -1;
        }
        GrowQueue_I32 undst = this.associator.getUnassociatedDestination();
        for (int i4 = 0; i4 < undst.size; ++i4) {
            int idx = undst.get(i4);
            ((AssociatedTripleIndex)this.matches.get((int)idx)).c = -1;
        }
        this.pruneMatches();
    }

    private void pruneMatches() {
        int index = 0;
        while (index < this.matches.size) {
            AssociatedTripleIndex a = (AssociatedTripleIndex)this.matches.get(index);
            if (a.c == -1) {
                a.set((AssociatedTripleIndex)this.matches.get(this.matches.size - 1));
                --this.matches.size;
                continue;
            }
            ++index;
        }
    }

    @Override
    public FastQueue<AssociatedTripleIndex> getMatches() {
        return this.matches;
    }

    @Override
    public void setMaxScoreThreshold(double score) {
        this.associator.setMaxScoreThreshold(score);
    }

    @Override
    public MatchScoreType getScoreType() {
        return this.associator.getScoreType();
    }

    @Override
    public boolean isEachFeatureAssociatedOnlyOnce() {
        return true;
    }
}

