/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.associate;

import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.abst.feature.associate.ScoreAssociation;
import boofcv.alg.feature.associate.FindUnassociated;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.MatchScoreType;
import georegression.struct.point.Point2D_F64;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;

public abstract class BaseAssociateLocation2DFilter<D>
implements AssociateDescription2D<D> {
    private ScoreAssociation<D> scoreAssociation;
    protected double maxDistance = Double.MAX_VALUE;
    protected double maxError = Double.MAX_VALUE;
    private FastQueue<Point2D_F64> locationSrc;
    private FastQueue<D> descSrc;
    private FastQueue<Point2D_F64> locationDst;
    private FastQueue<D> descDst;
    private GrowQueue_I32 unassociatedSrc = new GrowQueue_I32();
    private FastQueue<AssociatedIndex> matched = new FastQueue(10, AssociatedIndex.class, true);
    private FindUnassociated unassociated = new FindUnassociated();
    private boolean backwardsValidation = true;

    protected BaseAssociateLocation2DFilter(ScoreAssociation<D> scoreAssociation, boolean backwardsValidation, double maxError) {
        this.scoreAssociation = scoreAssociation;
        this.backwardsValidation = backwardsValidation;
        this.maxError = maxError;
    }

    public double getMaxDistance() {
        return this.maxDistance;
    }

    public void setMaxDistance(double maxDistance) {
        this.maxDistance = maxDistance;
    }

    @Override
    public void setSource(FastQueue<Point2D_F64> location, FastQueue<D> descriptions) {
        if (location.size() != descriptions.size()) {
            throw new IllegalArgumentException("The two lists must be the same size");
        }
        this.locationSrc = location;
        this.descSrc = descriptions;
    }

    @Override
    public void setDestination(FastQueue<Point2D_F64> location, FastQueue<D> descriptions) {
        if (location.size() != descriptions.size()) {
            throw new IllegalArgumentException("The two lists must be the same size");
        }
        this.locationDst = location;
        this.descDst = descriptions;
    }

    protected abstract void setActiveSource(Point2D_F64 var1);

    protected abstract double computeDistanceToSource(Point2D_F64 var1);

    @Override
    public void associate() {
        this.unassociatedSrc.reset();
        this.matched.reset();
        for (int i = 0; i < this.locationSrc.size(); ++i) {
            Point2D_F64 p_s = (Point2D_F64)this.locationSrc.get(i);
            Object d_s = this.descSrc.get(i);
            this.setActiveSource(p_s);
            double bestScore = this.maxError;
            int bestIndex = -1;
            for (int j = 0; j < this.locationDst.size(); ++j) {
                double score;
                Object d_d = this.descDst.get(j);
                double distance = this.computeDistanceToSource((Point2D_F64)this.locationDst.get(j));
                if (distance > this.maxDistance || !((score = this.scoreAssociation.score(d_s, d_d)) < bestScore)) continue;
                bestScore = score;
                bestIndex = j;
            }
            if (bestIndex == -1) {
                this.unassociatedSrc.add(i);
                continue;
            }
            if (this.backwardsValidation && !this.backwardsValidation(i, bestIndex)) {
                this.unassociatedSrc.add(i);
                continue;
            }
            AssociatedIndex m = (AssociatedIndex)this.matched.grow();
            m.src = i;
            m.dst = bestIndex;
            m.fitScore = bestScore;
        }
    }

    private boolean backwardsValidation(int indexSrc, int bestIndex) {
        double bestScoreV = this.maxError;
        int bestIndexV = -1;
        Object d_forward = this.descDst.get(bestIndex);
        this.setActiveSource((Point2D_F64)this.locationDst.get(bestIndex));
        for (int j = 0; j < this.locationSrc.size(); ++j) {
            Object d_v;
            double score;
            double distance = this.computeDistanceToSource((Point2D_F64)this.locationSrc.get(j));
            if (distance > this.maxDistance || !((score = this.scoreAssociation.score(d_forward, d_v = this.descSrc.get(j))) < bestScoreV)) continue;
            bestScoreV = score;
            bestIndexV = j;
        }
        return bestIndexV == indexSrc;
    }

    @Override
    public FastQueue<AssociatedIndex> getMatches() {
        return this.matched;
    }

    @Override
    public GrowQueue_I32 getUnassociatedSource() {
        return this.unassociatedSrc;
    }

    @Override
    public GrowQueue_I32 getUnassociatedDestination() {
        return this.unassociated.checkDestination(this.matched, this.locationDst.size());
    }

    @Override
    public void setMaxScoreThreshold(double score) {
        this.maxError = score;
    }

    @Override
    public MatchScoreType getScoreType() {
        return this.scoreAssociation.getScoreType();
    }

    @Override
    public boolean uniqueSource() {
        return true;
    }

    @Override
    public boolean uniqueDestination() {
        return false;
    }
}

