/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.extract;

import boofcv.alg.feature.detect.extract.NonMaxCandidate;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.QueueCorner;
import boofcv.struct.image.GrayF32;
import georegression.struct.point.Point2D_I16;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;

public class NonMaxCandidate_MT
extends NonMaxCandidate {
    final Object lock = new Object();
    final List<NonMaxCandidate.Search> searches = new ArrayList<NonMaxCandidate.Search>();
    final List<QueueCorner> cornerLists = new ArrayList<QueueCorner>();

    public NonMaxCandidate_MT(NonMaxCandidate.Search search) {
        super(search);
    }

    @Override
    protected void examineMinimum(GrayF32 intensityImage, QueueCorner candidates, QueueCorner found) {
        int stride = intensityImage.stride;
        float[] inten = intensityImage.data;
        BoofConcurrency.loopBlocks((int)0, (int)candidates.size, (idx0, idx1) -> {
            QueueCorner threadCorners;
            NonMaxCandidate.Search search;
            Object object = this.lock;
            synchronized (object) {
                search = this.searches.isEmpty() ? this.search.newInstance() : this.searches.remove(this.searches.size() - 1);
                threadCorners = this.cornerLists.isEmpty() ? new QueueCorner() : this.cornerLists.remove(this.cornerLists.size() - 1);
                threadCorners.reset();
            }
            search.initialize(intensityImage);
            for (int iter = idx0; iter < idx1; ++iter) {
                int y1;
                int x1;
                int y0;
                int x0;
                int center;
                float val;
                Point2D_I16 pt = ((Point2D_I16[])candidates.data)[iter];
                if (pt.x < this.ignoreBorder || pt.y < this.ignoreBorder || pt.x >= this.endBorderX || pt.y >= this.endBorderY || (val = inten[center = intensityImage.startIndex + pt.y * stride + pt.x]) > this.thresholdMin || val == -3.4028235E38f || !search.searchMin(x0 = Math.max(0, pt.x - this.radius), y0 = Math.max(0, pt.y - this.radius), x1 = Math.min(intensityImage.width, pt.x + this.radius + 1), y1 = Math.min(intensityImage.height, pt.y + this.radius + 1), center, val)) continue;
                threadCorners.add((int)pt.x, (int)pt.y);
            }
            Object object2 = this.lock;
            synchronized (object2) {
                found.addAll((FastQueue)threadCorners);
                this.searches.add(search);
                this.cornerLists.add(threadCorners);
            }
        });
    }

    @Override
    protected void examineMaximum(GrayF32 intensityImage, QueueCorner candidates, QueueCorner found) {
        int stride = intensityImage.stride;
        float[] inten = intensityImage.data;
        BoofConcurrency.loopBlocks((int)0, (int)candidates.size, (idx0, idx1) -> {
            QueueCorner threadCorners;
            NonMaxCandidate.Search search;
            Object object = this.lock;
            synchronized (object) {
                search = this.searches.isEmpty() ? this.search.newInstance() : this.searches.remove(this.searches.size() - 1);
                threadCorners = this.cornerLists.isEmpty() ? new QueueCorner() : this.cornerLists.remove(this.cornerLists.size() - 1);
                threadCorners.reset();
            }
            search.initialize(intensityImage);
            for (int iter = idx0; iter < idx1; ++iter) {
                int y1;
                int x1;
                int y0;
                int x0;
                int center;
                float val;
                Point2D_I16 pt = ((Point2D_I16[])candidates.data)[iter];
                if (pt.x < this.ignoreBorder || pt.y < this.ignoreBorder || pt.x >= this.endBorderX || pt.y >= this.endBorderY || (val = inten[center = intensityImage.startIndex + pt.y * stride + pt.x]) < this.thresholdMax || val == Float.MAX_VALUE || !search.searchMax(x0 = Math.max(0, pt.x - this.radius), y0 = Math.max(0, pt.y - this.radius), x1 = Math.min(intensityImage.width, pt.x + this.radius + 1), y1 = Math.min(intensityImage.height, pt.y + this.radius + 1), center, val)) continue;
                threadCorners.add((int)pt.x, (int)pt.y);
            }
            Object object2 = this.lock;
            synchronized (object2) {
                found.addAll((FastQueue)threadCorners);
                this.searches.add(search);
                this.cornerLists.add(threadCorners);
            }
        });
    }
}

