/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.disparity.impl;

import boofcv.alg.feature.disparity.DisparityScoreSadRect;
import boofcv.alg.feature.disparity.DisparitySelect;
import boofcv.alg.feature.disparity.impl.UtilDisparityScore;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;

public class ImplDisparityScoreSadRect_U8<DI extends ImageGray<DI>>
extends DisparityScoreSadRect<GrayU8, DI> {
    DisparitySelect<int[], DI> computeDisparity;
    int[] elementScore;
    int[][] horizontalScore;
    int[] verticalScore;

    public ImplDisparityScoreSadRect_U8(int minDisparity, int maxDisparity, int regionRadiusX, int regionRadiusY, DisparitySelect<int[], DI> computeDisparity) {
        super(minDisparity, maxDisparity, regionRadiusX, regionRadiusY);
        this.computeDisparity = computeDisparity;
    }

    @Override
    public void _process(GrayU8 left, GrayU8 right, DI disparity) {
        if (this.horizontalScore == null || this.verticalScore.length < this.lengthHorizontal) {
            this.horizontalScore = new int[this.regionHeight][this.lengthHorizontal];
            this.verticalScore = new int[this.lengthHorizontal];
            this.elementScore = new int[left.width];
        }
        this.computeDisparity.configure(disparity, this.minDisparity, this.maxDisparity, this.radiusX);
        this.computeFirstRow(left, right);
        this.computeRemainingRows(left, right);
    }

    private void computeFirstRow(GrayU8 left, GrayU8 right) {
        for (int row = 0; row < this.regionHeight; ++row) {
            int[] scores = this.horizontalScore[row];
            UtilDisparityScore.computeScoreRow(left, right, row, scores, this.minDisparity, this.maxDisparity, this.regionWidth, this.elementScore);
        }
        for (int i = 0; i < this.lengthHorizontal; ++i) {
            int sum = 0;
            for (int row = 0; row < this.regionHeight; ++row) {
                sum += this.horizontalScore[row][i];
            }
            this.verticalScore[i] = sum;
        }
        this.computeDisparity.process(this.radiusY, this.verticalScore);
    }

    private void computeRemainingRows(GrayU8 left, GrayU8 right) {
        for (int row = this.regionHeight; row < left.height; ++row) {
            int i;
            int oldRow = row % this.regionHeight;
            int[] scores = this.horizontalScore[oldRow];
            for (i = 0; i < this.lengthHorizontal; ++i) {
                int n = i;
                this.verticalScore[n] = this.verticalScore[n] - scores[i];
            }
            UtilDisparityScore.computeScoreRow(left, right, row, scores, this.minDisparity, this.maxDisparity, this.regionWidth, this.elementScore);
            for (i = 0; i < this.lengthHorizontal; ++i) {
                int n = i;
                this.verticalScore[n] = this.verticalScore[n] + scores[i];
            }
            this.computeDisparity.process(row - this.regionHeight + 1 + this.radiusY, this.verticalScore);
        }
    }

    @Override
    public Class<GrayU8> getInputType() {
        return GrayU8.class;
    }

    @Override
    public Class<DI> getDisparityType() {
        return this.computeDisparity.getDisparityType();
    }
}

