/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.segmentation.ms;

import boofcv.alg.segmentation.ComputeRegionMeanColor;
import boofcv.alg.segmentation.ms.RegionMergeTree;
import boofcv.alg.segmentation.ms.SegmentMeanShiftSearch;
import boofcv.struct.ConnectRule;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.ImageBase;
import georegression.struct.point.Point2D_I32;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_B;
import org.ddogleg.struct.GrowQueue_I32;

public class MergeSmallRegions<T extends ImageBase<T>>
extends RegionMergeTree {
    protected int minimumSize;
    protected ComputeRegionMeanColor<T> computeColor;
    protected GrowQueue_B segmentPruneFlag = new GrowQueue_B();
    protected GrowQueue_I32 segmentToPruneID = new GrowQueue_I32();
    protected FastQueue<Node> pruneGraph = new FastQueue(Node.class, true);
    protected Point2D_I32[] connect;

    public MergeSmallRegions(int minimumSize, ConnectRule rule, ComputeRegionMeanColor<T> computeColor) {
        this.minimumSize = minimumSize;
        this.computeColor = computeColor;
        if (rule == ConnectRule.FOUR) {
            this.connect = new Point2D_I32[4];
            this.connect[0] = new Point2D_I32(1, 0);
            this.connect[1] = new Point2D_I32(0, 1);
            this.connect[2] = new Point2D_I32(-1, 0);
            this.connect[3] = new Point2D_I32(0, -1);
        } else if (rule == ConnectRule.EIGHT) {
            this.connect = new Point2D_I32[8];
            this.connect[0] = new Point2D_I32(1, 0);
            this.connect[1] = new Point2D_I32(0, 1);
            this.connect[2] = new Point2D_I32(-1, 0);
            this.connect[3] = new Point2D_I32(0, -1);
            this.connect[4] = new Point2D_I32(1, 1);
            this.connect[5] = new Point2D_I32(-1, 1);
            this.connect[6] = new Point2D_I32(-1, -1);
            this.connect[7] = new Point2D_I32(1, -1);
        } else {
            throw new IllegalArgumentException("Unknown connect rule " + rule);
        }
    }

    public void setMinimumSize(int minimumSize) {
        this.minimumSize = minimumSize;
    }

    public void process(T image, GrayS32 pixelToRegion, GrowQueue_I32 regionMemberCount, FastQueue<float[]> regionColor) {
        this.stopRequested = false;
        while (!this.stopRequested) {
            regionColor.resize(regionMemberCount.size);
            this.computeColor.process(image, pixelToRegion, regionMemberCount, regionColor);
            this.initializeMerge(regionMemberCount.size);
            if (!this.setupPruneList(regionMemberCount)) break;
            this.findAdjacentRegions(pixelToRegion);
            for (int i = 0; i < this.pruneGraph.size; ++i) {
                this.selectMerge(i, regionColor);
            }
            this.performMerge(pixelToRegion, regionMemberCount);
        }
    }

    protected boolean setupPruneList(GrowQueue_I32 regionMemberCount) {
        this.segmentPruneFlag.resize(regionMemberCount.size);
        this.pruneGraph.reset();
        this.segmentToPruneID.resize(regionMemberCount.size);
        for (int i = 0; i < regionMemberCount.size; ++i) {
            if (regionMemberCount.get(i) < this.minimumSize) {
                this.segmentToPruneID.set(i, this.pruneGraph.size());
                Node n = (Node)this.pruneGraph.grow();
                n.init(i);
                this.segmentPruneFlag.set(i, true);
                continue;
            }
            this.segmentPruneFlag.set(i, false);
        }
        return this.pruneGraph.size() != 0;
    }

    protected void findAdjacentRegions(GrayS32 pixelToRegion) {
        if (this.connect.length == 4) {
            this.adjacentInner4(pixelToRegion);
        } else if (this.connect.length == 8) {
            this.adjacentInner8(pixelToRegion);
        }
        this.adjacentBorder(pixelToRegion);
    }

    protected void adjacentInner4(GrayS32 pixelToRegion) {
        for (int y = 0; y < pixelToRegion.height - 1; ++y) {
            int indexImg = pixelToRegion.startIndex + pixelToRegion.stride * y;
            int x = 0;
            while (x < pixelToRegion.width - 1) {
                Node n;
                int regionA = pixelToRegion.data[indexImg];
                int regionB = pixelToRegion.data[indexImg + 1];
                int regionC = pixelToRegion.data[indexImg + pixelToRegion.stride];
                boolean pruneA = this.segmentPruneFlag.data[regionA];
                if (regionA != regionB) {
                    boolean pruneB = this.segmentPruneFlag.data[regionB];
                    if (pruneA) {
                        n = (Node)this.pruneGraph.get(this.segmentToPruneID.get(regionA));
                        n.connect(regionB);
                    }
                    if (pruneB) {
                        n = (Node)this.pruneGraph.get(this.segmentToPruneID.get(regionB));
                        n.connect(regionA);
                    }
                }
                if (regionA != regionC) {
                    boolean pruneC = this.segmentPruneFlag.data[regionC];
                    if (pruneA) {
                        n = (Node)this.pruneGraph.get(this.segmentToPruneID.get(regionA));
                        n.connect(regionC);
                    }
                    if (pruneC) {
                        n = (Node)this.pruneGraph.get(this.segmentToPruneID.get(regionC));
                        n.connect(regionA);
                    }
                }
                ++x;
                ++indexImg;
            }
        }
    }

    protected void adjacentInner8(GrayS32 pixelToRegion) {
        for (int y = 0; y < pixelToRegion.height - 1; ++y) {
            int indexImg = pixelToRegion.startIndex + pixelToRegion.stride * y + 1;
            int x = 1;
            while (x < pixelToRegion.width - 1) {
                Node n;
                int regionA = pixelToRegion.data[indexImg];
                int regionB = pixelToRegion.data[indexImg + 1];
                int regionC = pixelToRegion.data[indexImg + pixelToRegion.stride];
                int regionD = pixelToRegion.data[indexImg + 1 + pixelToRegion.stride];
                int regionE = pixelToRegion.data[indexImg - 1 + pixelToRegion.stride];
                boolean pruneA = this.segmentPruneFlag.data[regionA];
                if (regionA != regionB) {
                    boolean pruneB = this.segmentPruneFlag.data[regionB];
                    if (pruneA) {
                        n = (Node)this.pruneGraph.get(this.segmentToPruneID.get(regionA));
                        n.connect(regionB);
                    }
                    if (pruneB) {
                        n = (Node)this.pruneGraph.get(this.segmentToPruneID.get(regionB));
                        n.connect(regionA);
                    }
                }
                if (regionA != regionC) {
                    boolean pruneC = this.segmentPruneFlag.data[regionC];
                    if (pruneA) {
                        n = (Node)this.pruneGraph.get(this.segmentToPruneID.get(regionA));
                        n.connect(regionC);
                    }
                    if (pruneC) {
                        n = (Node)this.pruneGraph.get(this.segmentToPruneID.get(regionC));
                        n.connect(regionA);
                    }
                }
                if (regionA != regionD) {
                    boolean pruneD = this.segmentPruneFlag.data[regionD];
                    if (pruneA) {
                        n = (Node)this.pruneGraph.get(this.segmentToPruneID.get(regionA));
                        n.connect(regionD);
                    }
                    if (pruneD) {
                        n = (Node)this.pruneGraph.get(this.segmentToPruneID.get(regionD));
                        n.connect(regionA);
                    }
                }
                if (regionA != regionE) {
                    boolean pruneE = this.segmentPruneFlag.data[regionE];
                    if (pruneA) {
                        n = (Node)this.pruneGraph.get(this.segmentToPruneID.get(regionA));
                        n.connect(regionE);
                    }
                    if (pruneE) {
                        n = (Node)this.pruneGraph.get(this.segmentToPruneID.get(regionE));
                        n.connect(regionA);
                    }
                }
                ++x;
                ++indexImg;
            }
        }
    }

    protected void adjacentBorder(GrayS32 pixelToRegion) {
        int indexImg;
        for (int y = 0; y < pixelToRegion.height - 1; ++y) {
            int x = pixelToRegion.width - 1;
            indexImg = pixelToRegion.startIndex + pixelToRegion.stride * y + x;
            this.checkAdjacentAround(x, y, indexImg, pixelToRegion);
            if (this.connect.length != 8) continue;
            x = 0;
            indexImg = pixelToRegion.startIndex + pixelToRegion.stride * y + x;
            this.checkAdjacentAround(x, y, indexImg, pixelToRegion);
        }
        for (int x = 0; x < pixelToRegion.width; ++x) {
            int y = pixelToRegion.height - 1;
            indexImg = pixelToRegion.startIndex + pixelToRegion.stride * y + x;
            this.checkAdjacentAround(x, y, indexImg, pixelToRegion);
        }
    }

    private void checkAdjacentAround(int x, int y, int indexImg, GrayS32 pixelToRegion) {
        int regionA = pixelToRegion.data[indexImg];
        for (int i = 0; i < this.connect.length; ++i) {
            Node n;
            int regionB;
            Point2D_I32 p = this.connect[i];
            if (!pixelToRegion.isInBounds(x + p.x, y + p.y) || regionA == (regionB = pixelToRegion.data[indexImg + p.y * pixelToRegion.stride + p.x])) continue;
            boolean pruneA = this.segmentPruneFlag.data[regionA];
            boolean pruneB = this.segmentPruneFlag.data[regionB];
            if (pruneA) {
                n = (Node)this.pruneGraph.get(this.segmentToPruneID.get(regionA));
                n.connect(regionB);
            }
            if (!pruneB) continue;
            n = (Node)this.pruneGraph.get(this.segmentToPruneID.get(regionB));
            n.connect(regionA);
        }
    }

    protected void selectMerge(int pruneId, FastQueue<float[]> regionColor) {
        Node n = (Node)this.pruneGraph.get(pruneId);
        float[] targetColor = (float[])regionColor.get(n.segment);
        int bestId = -1;
        float bestDistance = Float.MAX_VALUE;
        for (int i = 0; i < n.edges.size; ++i) {
            int segment = n.edges.get(i);
            float[] neighborColor = (float[])regionColor.get(segment);
            float d = SegmentMeanShiftSearch.distanceSq(targetColor, neighborColor);
            if (!(d < bestDistance)) continue;
            bestDistance = d;
            bestId = segment;
        }
        if (bestId == -1) {
            throw new RuntimeException("No neighbors?  Something went really wrong.");
        }
        this.markMerge(n.segment, bestId);
    }

    public static class Node {
        public int segment;
        public GrowQueue_I32 edges = new GrowQueue_I32();

        public void init(int segment) {
            this.segment = segment;
            this.edges.reset();
        }

        public void connect(int segment) {
            if (this.isConnected(segment)) {
                return;
            }
            this.edges.add(segment);
        }

        public boolean isConnected(int segment) {
            for (int i = 0; i < this.edges.size; ++i) {
                if (this.edges.data[i] != segment) continue;
                return true;
            }
            return false;
        }
    }
}

