/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.disparity;

import boofcv.abst.feature.disparity.StereoDisparity;
import boofcv.abst.feature.disparity.StereoDisparitySparse;
import boofcv.abst.feature.disparity.WrapDisparitySadRect;
import boofcv.abst.feature.disparity.WrapDisparitySparseSadRect;
import boofcv.alg.feature.disparity.DisparityScoreRowFormat;
import boofcv.alg.feature.disparity.DisparitySelect;
import boofcv.alg.feature.disparity.DisparitySparseScoreSadRect;
import boofcv.alg.feature.disparity.DisparitySparseSelect;
import boofcv.factory.feature.disparity.DisparityAlgorithms;
import boofcv.factory.feature.disparity.FactoryStereoDisparityAlgs;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;

public class FactoryStereoDisparity {
    public static <T extends ImageGray<T>> StereoDisparity<T, GrayU8> regionWta(DisparityAlgorithms whichAlg, int minDisparity, int maxDisparity, int regionRadiusX, int regionRadiusY, double maxPerPixelError, int validateRtoL, double texture, Class<T> imageType) {
        DisparitySelect<int[], GrayU8> select;
        double maxError = (double)((regionRadiusX * 2 + 1) * (regionRadiusY * 2 + 1)) * maxPerPixelError;
        if (whichAlg == DisparityAlgorithms.RECT_FIVE) {
            maxError *= 3.0;
        }
        if (imageType == GrayU8.class || imageType == GrayS16.class) {
            select = FactoryStereoDisparityAlgs.selectDisparity_S32((int)maxError, validateRtoL, texture);
        } else if (imageType == GrayF32.class) {
            select = FactoryStereoDisparityAlgs.selectDisparity_F32((int)maxError, validateRtoL, texture);
        } else {
            throw new IllegalArgumentException("Unknown image type");
        }
        DisparityScoreRowFormat alg = null;
        switch (whichAlg) {
            case RECT: {
                if (imageType == GrayU8.class) {
                    alg = FactoryStereoDisparityAlgs.scoreDisparitySadRect_U8(minDisparity, maxDisparity, regionRadiusX, regionRadiusY, select);
                    break;
                }
                if (imageType == GrayS16.class) {
                    alg = FactoryStereoDisparityAlgs.scoreDisparitySadRect_S16(minDisparity, maxDisparity, regionRadiusX, regionRadiusY, select);
                    break;
                }
                if (imageType != GrayF32.class) break;
                alg = FactoryStereoDisparityAlgs.scoreDisparitySadRect_F32(minDisparity, maxDisparity, regionRadiusX, regionRadiusY, select);
                break;
            }
            case RECT_FIVE: {
                if (imageType == GrayU8.class) {
                    alg = FactoryStereoDisparityAlgs.scoreDisparitySadRectFive_U8(minDisparity, maxDisparity, regionRadiusX, regionRadiusY, select);
                    break;
                }
                if (imageType == GrayS16.class) {
                    alg = FactoryStereoDisparityAlgs.scoreDisparitySadRectFive_S16(minDisparity, maxDisparity, regionRadiusX, regionRadiusY, select);
                    break;
                }
                if (imageType != GrayF32.class) break;
                alg = FactoryStereoDisparityAlgs.scoreDisparitySadRectFive_F32(minDisparity, maxDisparity, regionRadiusX, regionRadiusY, select);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithms " + (Object)((Object)whichAlg));
            }
        }
        if (alg == null) {
            throw new RuntimeException("Image type not supported: " + imageType.getSimpleName());
        }
        return new WrapDisparitySadRect<GrayU8, GrayU8>(alg);
    }

    public static <T extends ImageGray<T>> StereoDisparity<T, GrayF32> regionSubpixelWta(DisparityAlgorithms whichAlg, int minDisparity, int maxDisparity, int regionRadiusX, int regionRadiusY, double maxPerPixelError, int validateRtoL, double texture, Class<T> imageType) {
        DisparitySelect<int[], GrayF32> select;
        double maxError = (double)((regionRadiusX * 2 + 1) * (regionRadiusY * 2 + 1)) * maxPerPixelError;
        if (whichAlg == DisparityAlgorithms.RECT_FIVE) {
            maxError *= 3.0;
        }
        if (imageType == GrayU8.class || imageType == GrayS16.class) {
            select = FactoryStereoDisparityAlgs.selectDisparitySubpixel_S32((int)maxError, validateRtoL, texture);
        } else if (imageType == GrayF32.class) {
            select = FactoryStereoDisparityAlgs.selectDisparitySubpixel_F32((int)maxError, validateRtoL, texture);
        } else {
            throw new IllegalArgumentException("Unknown image type");
        }
        DisparityScoreRowFormat alg = null;
        switch (whichAlg) {
            case RECT: {
                if (imageType == GrayU8.class) {
                    alg = FactoryStereoDisparityAlgs.scoreDisparitySadRect_U8(minDisparity, maxDisparity, regionRadiusX, regionRadiusY, select);
                    break;
                }
                if (imageType == GrayS16.class) {
                    alg = FactoryStereoDisparityAlgs.scoreDisparitySadRect_S16(minDisparity, maxDisparity, regionRadiusX, regionRadiusY, select);
                    break;
                }
                if (imageType != GrayF32.class) break;
                alg = FactoryStereoDisparityAlgs.scoreDisparitySadRect_F32(minDisparity, maxDisparity, regionRadiusX, regionRadiusY, select);
                break;
            }
            case RECT_FIVE: {
                if (imageType == GrayU8.class) {
                    alg = FactoryStereoDisparityAlgs.scoreDisparitySadRectFive_U8(minDisparity, maxDisparity, regionRadiusX, regionRadiusY, select);
                    break;
                }
                if (imageType == GrayS16.class) {
                    alg = FactoryStereoDisparityAlgs.scoreDisparitySadRectFive_S16(minDisparity, maxDisparity, regionRadiusX, regionRadiusY, select);
                    break;
                }
                if (imageType != GrayF32.class) break;
                alg = FactoryStereoDisparityAlgs.scoreDisparitySadRectFive_F32(minDisparity, maxDisparity, regionRadiusX, regionRadiusY, select);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithms " + (Object)((Object)whichAlg));
            }
        }
        if (alg == null) {
            throw new RuntimeException("Image type not supported: " + imageType.getSimpleName());
        }
        return new WrapDisparitySadRect<GrayU8, GrayF32>(alg);
    }

    public static <T extends ImageGray<T>> StereoDisparitySparse<T> regionSparseWta(int minDisparity, int maxDisparity, int regionRadiusX, int regionRadiusY, double maxPerPixelError, double texture, boolean subpixelInterpolation, Class<T> imageType) {
        double maxError = (double)((regionRadiusX * 2 + 1) * (regionRadiusY * 2 + 1)) * maxPerPixelError;
        if (imageType == GrayU8.class) {
            DisparitySparseSelect<int[]> select = subpixelInterpolation ? FactoryStereoDisparityAlgs.selectDisparitySparseSubpixel_S32((int)maxError, texture) : FactoryStereoDisparityAlgs.selectDisparitySparse_S32((int)maxError, texture);
            DisparitySparseScoreSadRect<int[], GrayU8> score = FactoryStereoDisparityAlgs.scoreDisparitySparseSadRect_U8(minDisparity, maxDisparity, regionRadiusX, regionRadiusY);
            return new WrapDisparitySparseSadRect<int[], GrayU8>(score, select);
        }
        if (imageType == GrayF32.class) {
            DisparitySparseSelect<float[]> select = subpixelInterpolation ? FactoryStereoDisparityAlgs.selectDisparitySparseSubpixel_F32((int)maxError, texture) : FactoryStereoDisparityAlgs.selectDisparitySparse_F32((int)maxError, texture);
            DisparitySparseScoreSadRect<float[], GrayF32> score = FactoryStereoDisparityAlgs.scoreDisparitySparseSadRect_F32(minDisparity, maxDisparity, regionRadiusX, regionRadiusY);
            return new WrapDisparitySparseSadRect<float[], GrayF32>(score, select);
        }
        throw new RuntimeException("Image type not supported: " + imageType.getSimpleName());
    }
}

