/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.security.impl;

import in.gov.uidai.ec.security.impl.EncryptionException;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AesEncryptionUtil {
    private static final int GCM_NONCE_LENGTH = 12;
    private static final int GCM_TAG_LENGTH = 16;
    private static final boolean isLinux = "lin".equals(System.getProperty("os.name").toLowerCase().substring(0, 3));

    public static byte[] encrypt(byte[] data, byte[] key, String associatedData) throws EncryptionException {
        try {
            SecureRandom random = isLinux ? SecureRandom.getInstance("NativePRNGNonBlocking") : SecureRandom.getInstanceStrong();
            SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding", "SunJCE");
            byte[] iv = new byte[12];
            random.nextBytes(iv);
            GCMParameterSpec spec = new GCMParameterSpec(128, iv);
            cipher.init(1, (Key)secretKey, spec);
            byte[] aad = associatedData.getBytes();
            cipher.updateAAD(aad);
            byte[] cipherText = cipher.doFinal(data);
            ByteBuffer byteBuffer = ByteBuffer.allocate(iv.length + cipherText.length);
            byteBuffer.put(iv);
            byteBuffer.put(cipherText);
            return byteBuffer.array();
        }
        catch (Exception e) {
            throw new EncryptionException("error while encrypting data", e);
        }
    }

    public static byte[] decrypt(byte[] cipherMessage, byte[] key, String associatedData) throws EncryptionException {
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(cipherMessage);
            byte[] iv = new byte[12];
            byteBuffer.get(iv);
            byte[] cipherText = new byte[byteBuffer.remaining()];
            byteBuffer.get(cipherText);
            SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding", "SunJCE");
            GCMParameterSpec spec = new GCMParameterSpec(128, iv);
            cipher.init(2, (Key)secretKey, spec);
            byte[] aad = associatedData.getBytes();
            cipher.updateAAD(aad);
            return cipher.doFinal(cipherText);
        }
        catch (Exception e) {
            throw new EncryptionException("error while decrypting data", e);
        }
    }
}

